/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf;

import com.KGitextpdf.text.DocumentException;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.PdfStamper;
import com.kinggrid.authorization.AuthorizationType;
import com.kinggrid.authorization.KGLicense;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class KGExecute {
    protected static final int PAGEN_TYPE_ARRAY = 1;
    protected static final int PAGEN_TYPE_DEFAULT = -1;
    protected int pagenType = -1;
    private int pagen;
    protected int[] pagens;
    private int index = 0;

    protected abstract void execute(PdfReader var1, PdfStamper var2, int var3) throws DocumentException, IOException;

    protected void before(PdfReader pdfReader, PdfStamper pdfStamper) throws DocumentException, IOException {
    }

    protected void after(PdfReader pdfReader, PdfStamper pdfStamper) throws DocumentException, IOException {
    }

    protected void doExecute(PdfReader pdfReader, PdfStamper pdfStamper, int pagen) throws DocumentException, IOException {
        Class<?> clazz = this.getClass();
        String clazzName = clazz.getName();
        AuthorizationType authorization = clazz.getAnnotation(AuthorizationType.class);
        if (authorization != null) {
            if (!authorization.hasAuth()) {
                KGLicense.authorization(clazzName, "doExecute");
            }
        } else if (clazzName.indexOf(".customize.") == -1) {
            KGLicense.authorization(clazzName, "doExecute");
        }
        if (this.pagenType == -1) {
            if (this.getPagen() == 0) {
                this.execute(pdfReader, pdfStamper, pagen);
            } else if (this.getPagen() == pagen) {
                this.execute(pdfReader, pdfStamper, pagen);
            }
        } else if (this.pagenType == 1) {
            if (this.pagens != null && this.index < this.pagens.length) {
                while (this.index < this.pagens.length) {
                    if (this.pagens[this.index] >= pagen) break;
                    ++this.index;
                }
                if (this.pagens[this.index] == pagen) {
                    ++this.index;
                    this.execute(pdfReader, pdfStamper, pagen);
                }
            }
        } else {
            throw new IllegalArgumentException("pagenType \u53c2\u6570\u6709\u8bef\uff01");
        }
    }

    public void setKGHummderExecutes(List<KGExecute> exes) {
    }

    public int getPagen() {
        return this.pagen;
    }

    public int getPagenType() {
        return this.pagenType;
    }

    public int[] getPagens() {
        return this.pagens;
    }

    public void setPagen(int pagen) {
        this.pagenType = -1;
        this.pagen = pagen;
    }

    public void setPagen(int[] pagens) {
        this.pagenType = 1;
        Arrays.sort(pagens);
        this.pagens = pagens;
    }

    public void setPagen(String pagenExp) {
        this.pagenType = 1;
        if (pagenExp != null) {
            String[] parts;
            Pattern pattern = Pattern.compile("[[\\d\\-\\d,]*[\\d,]*[\\d\\-\\d,]*[\\d,]*]*[\\d\\-\\d]*[\\d]+");
            Matcher matcher = pattern.matcher(pagenExp);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("\u8bbe\u7f6e\u9875\u7801\u8868\u8fbe\u5f0f\u4e0d\u6b63\u786e\uff1a" + pagenExp);
            }
            ArrayList<Integer> list = new ArrayList<Integer>();
            String[] stringArray = parts = pagenExp.split(",");
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String sub = stringArray[n2];
                int index = -1;
                index = sub.indexOf(45);
                if (index == -1) {
                    int page = Integer.parseInt(sub);
                    list.add(page);
                } else {
                    int end;
                    int start = Integer.parseInt(sub.substring(0, index));
                    if (start > (end = Integer.parseInt(sub.substring(index + 1)))) {
                        int tmp = start;
                        start = end;
                        end = tmp;
                    }
                    int i = start;
                    while (i <= end) {
                        list.add(i);
                        ++i;
                    }
                }
                ++n2;
            }
            this.pagens = new int[list.size()];
            int i = 0;
            while (i < list.size()) {
                this.pagens[i] = (Integer)list.get(i);
                ++i;
            }
            Arrays.sort(this.pagens);
        }
    }
}

