/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.pdf;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kinggrid.encrypt.KGBase64;
import com.kinggrid.pdf.SignatureInter;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;

public class DigitalSignatureByKeySM2
implements SignatureInter {
    private String hash;
    private long contentsPostion;
    private int sealVersion;

    public long getContentsPostion() {
        return this.contentsPostion;
    }

    public void setContentsPostion(long contentsPostion) {
        this.contentsPostion = contentsPostion;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public int getSealVersion() {
        return this.sealVersion;
    }

    public void setSealVersion(int sealVersion) {
        this.sealVersion = sealVersion;
    }

    @Override
    public String getHashAlgorithm() {
        return "SM3";
    }

    @Override
    public String getEncryptionAlgorithm() {
        return "SM2";
    }

    @Override
    public byte[] sign(byte[] message) throws GeneralSecurityException {
        KGBase64 base64 = new KGBase64();
        this.hash = base64.encode(message);
        return null;
    }

    public void write(String fileName, byte[] encodedSig) throws IOException {
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(new File(fileName), "rw");
            raf.seek(this.contentsPostion + 1L);
            raf.write(encodedSig, 0, encodedSig.length);
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
    }

    public String getSigKeepData() {
        JSONObject obj = new JSONObject();
        obj.put("contentsPostion", (Object)this.contentsPostion);
        obj.put("sealVersion", (Object)this.sealVersion);
        KGBase64 base64 = new KGBase64();
        String ret = null;
        try {
            ret = base64.encode(obj.toJSONString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return ret;
    }

    public void setSigKeepData(String sigKeepData) {
        KGBase64 base64 = new KGBase64();
        try {
            String str = new String(base64.decode(sigKeepData), "UTF-8");
            JSONObject obj = JSON.parseObject((String)str);
            this.contentsPostion = obj.getLongValue("contentsPostion");
            this.sealVersion = obj.getIntValue("sealVersion");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }
}

