/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.kgcore.gm;

import com.kinggrid.kgcore.gm.SealGM;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.kg.bouncycastle.asn1.ASN1GeneralizedTime;
import org.kg.bouncycastle.asn1.ASN1Primitive;
import org.kg.bouncycastle.asn1.ASN1Sequence;
import org.kg.bouncycastle.asn1.DERBitString;
import org.kg.bouncycastle.asn1.DERIA5String;
import org.kg.bouncycastle.asn1.DERInteger;
import org.kg.bouncycastle.asn1.DERObjectIdentifier;
import org.kg.bouncycastle.asn1.DEROctetString;
import org.kg.bouncycastle.asn1.DERUTCTime;
import org.kg.bouncycastle.asn1.DERUTF8String;
import org.kg.bouncycastle.asn1.DLSequence;

public class SealUtil {
    public static SealGM getSealInfo(byte[] seal) {
        SealGM sealInfo = null;
        try {
            DERUTCTime validEnd;
            DERUTCTime validStart;
            DERUTCTime createDate;
            ASN1Sequence sealSeq = (ASN1Sequence)ASN1Primitive.fromByteArray((byte[])seal);
            ASN1Sequence esealInfo = (ASN1Sequence)sealSeq.getObjectAt(0);
            ASN1Sequence header = (ASN1Sequence)esealInfo.getObjectAt(0);
            DERIA5String esID = (DERIA5String)esealInfo.getObjectAt(1);
            ASN1Sequence property = (ASN1Sequence)esealInfo.getObjectAt(2);
            ASN1Sequence picture = (ASN1Sequence)esealInfo.getObjectAt(3);
            DERIA5String id = (DERIA5String)header.getObjectAt(0);
            DERInteger version = (DERInteger)header.getObjectAt(1);
            DERIA5String vid = (DERIA5String)header.getObjectAt(2);
            int ver = version.getValue().intValue();
            DERInteger type = (DERInteger)property.getObjectAt(0);
            DERUTF8String name = (DERUTF8String)property.getObjectAt(1);
            DLSequence certList = null;
            DERInteger certListType = null;
            Date dcreateDate = null;
            Date dvalidStart = null;
            Date dvalidEnd = null;
            SimpleDateFormat dateF = null;
            if (ver == 4) {
                dateF = new SimpleDateFormat("yyyyMMddHHmmss");
                dateF.setTimeZone(TimeZone.getTimeZone("GMT+8"));
                certListType = (DERInteger)property.getObjectAt(2);
                certList = (DLSequence)property.getObjectAt(3);
                createDate = (ASN1GeneralizedTime)property.getObjectAt(4);
                validStart = (ASN1GeneralizedTime)property.getObjectAt(5);
                validEnd = (ASN1GeneralizedTime)property.getObjectAt(6);
                dcreateDate = dateF.parse(createDate.getTime());
                dvalidStart = dateF.parse(validStart.getTime());
                dvalidEnd = dateF.parse(validEnd.getTime());
            } else {
                dateF = new SimpleDateFormat("yyMMddHHmmss");
                dateF.setTimeZone(TimeZone.getTimeZone("GMT+8"));
                certList = (DLSequence)property.getObjectAt(2);
                createDate = (DERUTCTime)property.getObjectAt(3);
                validStart = (DERUTCTime)property.getObjectAt(4);
                validEnd = (DERUTCTime)property.getObjectAt(5);
                dcreateDate = dateF.parse(createDate.toString());
                dvalidStart = dateF.parse(validStart.toString());
                dvalidEnd = dateF.parse(validEnd.toString());
            }
            DERIA5String picType = (DERIA5String)picture.getObjectAt(0);
            DEROctetString picData = (DEROctetString)picture.getObjectAt(1);
            DERInteger width = (DERInteger)picture.getObjectAt(2);
            DERInteger height = (DERInteger)picture.getObjectAt(3);
            DEROctetString cert = null;
            DERObjectIdentifier signatureAlgorithm = null;
            DERBitString signData = null;
            if (ver == 4) {
                cert = (DEROctetString)sealSeq.getObjectAt(1);
                signatureAlgorithm = (DERObjectIdentifier)sealSeq.getObjectAt(2);
                signData = (DERBitString)sealSeq.getObjectAt(3);
            } else {
                ASN1Sequence signInfo = (ASN1Sequence)sealSeq.getObjectAt(1);
                cert = (DEROctetString)signInfo.getObjectAt(0);
                signatureAlgorithm = (DERObjectIdentifier)signInfo.getObjectAt(1);
                signData = (DERBitString)signInfo.getObjectAt(2);
            }
            sealInfo = new SealGM();
            sealInfo.setSesSealInfo(esealInfo);
            sealInfo.setId(id.getString());
            sealInfo.setVersion(version.getValue().intValue());
            sealInfo.setVid(vid.toString());
            sealInfo.setEsID(esID.getString());
            sealInfo.setType(type.getValue().intValue());
            sealInfo.setName(name.getString());
            sealInfo.setCertList(certList);
            if (certListType != null) {
                sealInfo.setCertListType(certListType.getValue().intValue());
            }
            sealInfo.setCreateDate(dcreateDate);
            sealInfo.setValidStart(dvalidStart);
            sealInfo.setValidEnd(dvalidEnd);
            sealInfo.setPicType(picType.getString());
            sealInfo.setPicData(picData.getOctets());
            sealInfo.setWidth(width.getValue().intValue());
            sealInfo.setHeight(height.getValue().intValue());
            sealInfo.setCert(cert.getOctets());
            sealInfo.setSignatureAlgorithm(signatureAlgorithm.getId());
            sealInfo.setSignData(signData.getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (ParseException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return sealInfo;
    }
}

