/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.kgcore.gm;

import com.kinggrid.kgcore.gm.SM3;
import com.kinggrid.kgcore.gm.Util;
import java.math.BigInteger;

public class SM3Digest {
    private static final int BYTE_LENGTH = 32;
    private static final int BLOCK_LENGTH = 64;
    private static final int BUFFER_LENGTH = 64;
    private byte[] xBuf = new byte[64];
    private int xBufOff;
    private byte[] V = (byte[])SM3.iv.clone();
    private int cntBlock = 0;

    public int doFinal(byte[] out, int outOff) {
        byte[] tmp = this.doFinal();
        System.arraycopy(tmp, 0, out, 0, tmp.length);
        return 32;
    }

    public void reset() {
        this.xBufOff = 0;
        this.cntBlock = 0;
        this.V = (byte[])SM3.iv.clone();
    }

    public void update(byte[] in, int inOff, int len) {
        int partLen = 64 - this.xBufOff;
        int inputLen = len;
        int dPos = inOff;
        if (partLen < inputLen) {
            System.arraycopy(in, dPos, this.xBuf, this.xBufOff, partLen);
            inputLen -= partLen;
            dPos += partLen;
            this.doUpdate();
            while (inputLen > 64) {
                System.arraycopy(in, dPos, this.xBuf, 0, 64);
                inputLen -= 64;
                dPos += 64;
                this.doUpdate();
            }
        }
        System.arraycopy(in, dPos, this.xBuf, this.xBufOff, inputLen);
        this.xBufOff += inputLen;
    }

    private void doUpdate() {
        byte[] B = new byte[64];
        int i = 0;
        while (i < 64) {
            System.arraycopy(this.xBuf, i, B, 0, B.length);
            this.doHash(B);
            i += 64;
        }
        this.xBufOff = 0;
    }

    private void doHash(byte[] B) {
        byte[] tmp = SM3.CF(this.V, B);
        System.arraycopy(tmp, 0, this.V, 0, this.V.length);
        ++this.cntBlock;
    }

    private byte[] doFinal() {
        byte[] B = new byte[64];
        byte[] buffer = new byte[this.xBufOff];
        System.arraycopy(this.xBuf, 0, buffer, 0, buffer.length);
        byte[] tmp = SM3.padding(buffer, this.cntBlock);
        int i = 0;
        while (i < tmp.length) {
            System.arraycopy(tmp, i, B, 0, B.length);
            this.doHash(B);
            i += 64;
        }
        return this.V;
    }

    public byte[] getSM2Za(byte[] x, byte[] y, byte[] id) {
        byte[] tmp = Util.IntToByte(id.length * 8);
        byte[] buffer = new byte[194 + id.length];
        buffer[0] = tmp[1];
        buffer[1] = tmp[0];
        byte[] a = Util.getA();
        byte[] b = Util.getB();
        byte[] gx = Util.getGx();
        byte[] gy = Util.getGy();
        int dPos = 2;
        System.arraycopy(id, 0, buffer, dPos, id.length);
        System.arraycopy(a, 0, buffer, dPos += id.length, 32);
        System.arraycopy(b, 0, buffer, dPos += 32, 32);
        System.arraycopy(gx, 0, buffer, dPos += 32, 32);
        System.arraycopy(gy, 0, buffer, dPos += 32, 32);
        System.arraycopy(x, 0, buffer, dPos += 32, 32);
        System.arraycopy(y, 0, buffer, dPos += 32, 32);
        dPos += 32;
        SM3Digest digest = new SM3Digest();
        digest.update(buffer, 0, buffer.length);
        byte[] out = new byte[32];
        digest.doFinal(out, 0);
        return out;
    }

    public void addId(BigInteger affineX, BigInteger affineY, byte[] id) {
        byte[] x = Util.asUnsigned32ByteArray(affineX);
        byte[] y = Util.asUnsigned32ByteArray(affineY);
        byte[] tmp = this.getSM2Za(x, y, id);
        this.reset();
        System.arraycopy(tmp, 0, this.xBuf, this.xBufOff, 32);
        this.xBufOff = 32;
    }

    public String getAlgorithmName() {
        return "SM3";
    }

    public int getDigestSize() {
        return 32;
    }

    public void update(byte in) {
        byte[] buffer = new byte[]{in};
        this.update(buffer, 0, 1);
    }
}

