/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.img.seal;

import com.kinggrid.img.seal.TextInfo;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public class TextInfoCreator {
    private int imageWidth = 400;
    private int imageHeight = 400;
    private Color color = Color.black;
    private int maxRowNum = 39;
    private Font textDefaultFont = new Font("\u5b8b\u4f53", 0, 12);
    private List<TextInfo> textInfoList = new ArrayList<TextInfo>();
    private int textInfoPadding = 5;
    private int textInfoPaddingLeft = 10;
    private BufferedImage bufferedImage = null;
    private Graphics2D g2 = null;

    public void init() {
        this.bufferedImage = new BufferedImage(this.imageWidth, this.imageHeight, 1);
        this.g2 = (Graphics2D)this.bufferedImage.getGraphics();
        this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.g2.setColor(Color.white);
        this.g2.fillRect(0, 0, this.imageWidth, this.imageHeight);
    }

    public BufferedImage create() {
        this.init();
        Font font = null;
        float xCoordinate = 0.0f + (float)this.textInfoPaddingLeft;
        float yCoordinate = 0.0f;
        int i = 0;
        while (i < this.textInfoList.size()) {
            TextInfo textInfo = this.textInfoList.get(i);
            font = textInfo.getFont() == null ? this.textDefaultFont : textInfo.getFont();
            String text = textInfo.getText();
            if (!text.startsWith("\u3000\u3000")) {
                text = "\u3000\u3000" + text;
            }
            Color _color = textInfo.getColor() == null ? this.color : textInfo.getColor();
            this.g2.setFont(font);
            this.g2.setColor(_color);
            FontMetrics fontMetrics = this.g2.getFontMetrics();
            int ascent = fontMetrics.getAscent();
            int leading = fontMetrics.getLeading();
            yCoordinate = yCoordinate + (float)this.textInfoPadding + (float)ascent + (float)leading;
            String[] texts = text.split("\r\n");
            int j = 0;
            while (j < texts.length) {
                String[] textss = this.splitLength(texts[j], this.maxRowNum);
                int k = 0;
                while (k < textss.length) {
                    yCoordinate = yCoordinate + (float)ascent + (float)leading;
                    this.g2.drawString(textss[k], xCoordinate, yCoordinate);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return this.bufferedImage;
    }

    private String[] splitLength(String text, int splitLen) {
        int count = text.length() / splitLen + (text.length() % splitLen == 0 ? 0 : 1);
        String[] texts = new String[count];
        int i = 0;
        while (i < count) {
            if (text.length() <= splitLen) {
                texts[i] = text;
            } else {
                texts[i] = text.substring(0, splitLen);
                text = text.substring(splitLen);
            }
            ++i;
        }
        return texts;
    }

    public void drawString(String text, float x, float y) {
        this.g2.drawString(text, x, y);
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public void setImageWidth(int imageWidth) {
        this.imageWidth = imageWidth;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public void setImageHeight(int imageHeight) {
        this.imageHeight = imageHeight;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public List<TextInfo> getTextInfoList() {
        return this.textInfoList;
    }

    public void setTextInfoList(List<TextInfo> textInfoList) {
        this.textInfoList = textInfoList;
    }

    public int getTextInfoPadding() {
        return this.textInfoPadding;
    }

    public void setTextInfoPadding(int textInfoPadding) {
        this.textInfoPadding = textInfoPadding;
    }

    public int getMaxRowNum() {
        return this.maxRowNum;
    }

    public void setMaxRowNum(int maxRowNum) {
        this.maxRowNum = maxRowNum;
    }

    public int getTextInfoPaddingLeft() {
        return this.textInfoPaddingLeft;
    }

    public void setTextInfoPaddingLeft(int textInfoPaddingLeft) {
        this.textInfoPaddingLeft = textInfoPaddingLeft;
    }

    public Font getTextDefaultFont() {
        return this.textDefaultFont;
    }

    public void setTextDefaultFont(Font textDefaultFont) {
        this.textDefaultFont = textDefaultFont;
    }
}

