/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.img.seal;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kinggrid.authorization.AuthorizationMethod;
import com.kinggrid.authorization.KGFacadeCglib;
import com.kinggrid.pdf.utils.JSONHelper;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;

public class SquarepictureCreator {
    private int imageWidth = 100;
    private int imageHigth = 105;
    private int imagePadding = 0;
    private String text;
    private List<Map<String, Object>> textList;
    private Font textFont = new Font("\u5b8b\u4f53", 1, 40);
    private Color textColor = Color.red;
    private int cols = 2;
    private boolean vertical = true;
    private int border = 10;
    private int padding;
    private int rows;
    private char[][] charArray;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private int fontDistanceX = 0;
    private int fontDistanceY = 0;
    private boolean fontDirection = true;
    private boolean transparent = false;

    protected SquarepictureCreator() {
    }

    public static SquarepictureCreator getInstance() {
        return (SquarepictureCreator)KGFacadeCglib.getInstance(SquarepictureCreator.class);
    }

    public void load(String json) {
        try {
            JSONObject obj = JSONObject.parseObject((String)json);
            this.imageWidth = JSONHelper.getDefault(obj, "width", 100);
            this.imageHigth = JSONHelper.getDefault(obj, "height", 105);
            this.imagePadding = JSONHelper.getDefault(obj, "imagePadding", 0);
            this.border = JSONHelper.getDefault(obj, "border", 10);
            this.padding = JSONHelper.getDefault(obj, "padding", 0);
            this.textColor = new Color(JSONHelper.getDefault(obj, "color", Color.RED.getRGB()));
            if (obj.getString("fontPath") != null) {
                Font font = Font.createFont(0, new File(obj.getString("fontPath")));
                this.textFont = font.deriveFont((int)JSONHelper.getDefault(obj, "fontStyle", 1), JSONHelper.getDefault(obj, "fontSize", 40).intValue());
            } else {
                this.textFont = new Font(JSONHelper.getDefault(obj, "fontName", "\u5b8b\u4f53"), (int)JSONHelper.getDefault(obj, "fontStyle", 1), JSONHelper.getDefault(obj, "fontSize", 40));
            }
            this.cols = JSONHelper.getDefault(obj, "cols", 2);
            this.vertical = JSONHelper.getDefault(obj, "vertical", true);
            this.fontDistanceX = JSONHelper.getDefault(obj, "fontDistanceX", 0);
            this.fontDistanceY = JSONHelper.getDefault(obj, "fontDistanceY", 0);
            this.fontDirection = JSONHelper.getDefault(obj, "fontDirection", true);
            this.scaleX = JSONHelper.getDefault(obj, "scaleX", Float.valueOf(1.0f)).floatValue();
            this.scaleY = JSONHelper.getDefault(obj, "scaleY", Float.valueOf(1.0f)).floatValue();
            this.transparent = JSONHelper.getDefault(obj, "transparent", false);
            if (obj.containsKey((Object)"text")) {
                this.text = JSONHelper.getDefault(obj, "text", "");
            }
            if (obj.containsKey((Object)"textList")) {
                this.textList = new ArrayList<Map<String, Object>>();
                JSONArray array = obj.getJSONArray("textList");
                int i = 0;
                while (i < array.size()) {
                    JSONObject o = array.getJSONObject(i);
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("text", JSONHelper.getDefault(o, "text", ""));
                    map.put("cols", JSONHelper.getDefault(o, "cols", this.cols));
                    map.put("fontDistanceX", JSONHelper.getDefault(o, "fontDistanceX", this.fontDistanceX));
                    map.put("fontDistanceY", JSONHelper.getDefault(o, "fontDistanceY", this.fontDistanceY));
                    map.put("fontDirection", JSONHelper.getDefault(o, "fontDirection", this.fontDirection));
                    map.put("scaleX", JSONHelper.getDefault(o, "scaleX", Float.valueOf(this.scaleX)));
                    map.put("scaleY", JSONHelper.getDefault(o, "scaleY", Float.valueOf(this.scaleY)));
                    if (o.containsKey((Object)"fontPath")) {
                        Font font = Font.createFont(0, new File(o.getString("fontPath")));
                        font = font.deriveFont((int)JSONHelper.getDefault(o, "fontStyle", 1), JSONHelper.getDefault(o, "fontSize", 40).intValue());
                        map.put("textFont", font);
                    } else if (o.containsKey((Object)"fontName")) {
                        map.put("textFont", new Font(JSONHelper.getDefault(o, "fontName", "\u5b8b\u4f53"), (int)JSONHelper.getDefault(o, "fontStyle", 1), JSONHelper.getDefault(o, "fontSize", 40)));
                    } else {
                        map.put("textFont", this.textFont);
                    }
                    this.textList.add(map);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u53c2\u6570\u5f02\u5e38:" + e);
        }
    }

    @AuthorizationMethod(authEx=true)
    public BufferedImage create() {
        BufferedImage image = new BufferedImage(this.imageWidth, this.imageHigth, 1);
        Graphics2D g2 = image.createGraphics();
        if (this.transparent) {
            image = g2.getDeviceConfiguration().createCompatibleImage(this.imageWidth, this.imageHigth, 3);
            g2.dispose();
            g2 = image.createGraphics();
        } else {
            g2.setColor(Color.white);
            g2.fillRect(0, 0, this.imageWidth, this.imageHigth);
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(this.textColor);
        g2.setStroke(new BasicStroke(this.border));
        g2.drawRect(this.imagePadding, this.imagePadding, this.imageWidth - this.imagePadding * 2, this.imageHigth - this.imagePadding * 2);
        if (this.text != null && !"".equals(this.text)) {
            String _text = this.convertText(this.text);
            this.wirteText(g2, _text);
        } else {
            this.wirteText(g2);
        }
        return image;
    }

    public byte[] squarePng() throws IOException {
        BufferedImage image = this.create();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "PNG", byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private void wirteText(Graphics2D g2, String text) {
        if (text != null && !"".equals(text)) {
            g2.setColor(this.textColor);
            AffineTransform rotateTransform = AffineTransform.getRotateInstance(0.0);
            rotateTransform.scale(this.scaleX, this.scaleY);
            g2.setFont(this.textFont.deriveFont(rotateTransform));
            int i = 0;
            while (i < this.rows) {
                int j = 0;
                while (j < this.cols) {
                    int fontX = this.imagePadding + this.textFont.getSize() * j + this.padding + this.border + this.fontDistanceX * (j + 1);
                    int fontY = this.imagePadding + this.textFont.getSize() * i + this.textFont.getSize() + this.padding / 4 + this.border - this.textFont.getSize() / 40 + this.fontDistanceY * (i + 1);
                    g2.drawString(String.valueOf(this.charArray[i][j]), fontX, fontY);
                    ++j;
                }
                ++i;
            }
        }
    }

    private void wirteText(Graphics2D g2) {
        int k = 0;
        while (k < this.textList.size()) {
            Map<String, Object> map = this.textList.get(k);
            String _text = this.convertText((String)map.get("text"));
            int _fontDistanceX = (Integer)map.get("fontDistanceX");
            int _fontDistanceY = (Integer)map.get("fontDistanceY");
            if (_text != null && !"".equals(_text)) {
                g2.setColor(this.textColor);
                Font _font = (Font)map.get("textFont");
                float _scaleX = ((Float)map.get("scaleX")).floatValue();
                float _scaleY = ((Float)map.get("scaleY")).floatValue();
                AffineTransform rotateTransform = AffineTransform.getRotateInstance(0.0);
                rotateTransform.scale(_scaleX, _scaleY);
                g2.setFont(_font.deriveFont(rotateTransform));
                int i = 0;
                while (i < this.rows) {
                    int j = 0;
                    while (j < this.cols) {
                        int fontX = this.imagePadding + _font.getSize() * j + this.padding + this.border + _fontDistanceX * (j + 1) + _font.getSize() * k;
                        int fontY = this.imagePadding + _font.getSize() * i + _font.getSize() + this.padding / 4 + this.border - _font.getSize() / 40 + _fontDistanceY * (i + 1);
                        g2.drawString(String.valueOf(this.charArray[i][j]), fontX, fontY);
                        ++j;
                    }
                    ++i;
                }
            }
            ++k;
        }
    }

    private String convertText(String text) {
        block12: {
            if (text == "" || "".equals(text)) break block12;
            this.rows = (text.length() + this.cols - 1) / this.cols;
            this.charArray = new char[this.rows][this.cols];
            int n = 0;
            if (this.vertical) {
                int i = 0;
                while (i < this.cols) {
                    int j;
                    if (this.fontDirection) {
                        j = 0;
                        while (j < this.rows) {
                            if (n < text.length()) {
                                this.charArray[j][i] = text.charAt(n);
                            }
                            ++n;
                            ++j;
                        }
                    } else {
                        j = 0;
                        while (j < this.rows) {
                            if (n < text.length()) {
                                this.charArray[j][this.cols - 1 - i] = text.charAt(n);
                            }
                            ++n;
                            ++j;
                        }
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.rows) {
                    int j = 0;
                    while (j < this.cols) {
                        if (n < text.length()) {
                            this.charArray[i][j] = text.charAt(n);
                        }
                        ++n;
                        ++j;
                    }
                    ++i;
                }
            }
        }
        return text;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public void setImageWidth(int imageWidth) {
        this.imageWidth = imageWidth;
    }

    public int getImageHigth() {
        return this.imageHigth;
    }

    public void setImageHigth(int imageHigth) {
        this.imageHigth = imageHigth;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setText(String text, Font font) {
        this.text = text;
        this.textFont = font;
    }

    public int getCols() {
        return this.cols;
    }

    public void setCols(int cols) {
        this.cols = cols;
    }

    public int getPadding() {
        return this.padding;
    }

    public void setPadding(int padding) {
        this.padding = padding;
    }

    public int getBorder() {
        return this.border;
    }

    public void setBorder(int border) {
        this.border = border;
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public void setTextFont(Font textFont) {
        this.textFont = textFont;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }
}

