/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.img.seal;

import com.alibaba.fastjson.JSONObject;
import com.kinggrid.authorization.AuthorizationMethod;
import com.kinggrid.authorization.KGFacadeCglib;
import com.kinggrid.pdf.utils.JSONHelper;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class CircleSignCreator {
    private static final int FONT_MIN_SIZE = 26;
    private String text = null;
    private Font textFont = new Font("\u5b8b\u4f53", 1, 50);
    private String centerImage = "\u2605";
    private String attachOne = null;
    private String attachTwo = null;
    private String attachThree;
    private double stretchX = 0.6;
    private double stretchY = 1.0;
    private String businessLicenseNo;
    private Font businessLicenseNoFont = new Font("\u9ed1\u4f53", 600, 10);
    private double businessLicAngle = 80.0;
    private int blnOffsetOfCircleBorder = 12;
    private double businessLicenseScaleX = 1.5;
    private double businessLicenseScaleY = 2.0;
    private int imageSideLength = 400;
    private int imageSideHeight = 400;
    private int imagePadding = 0;
    private int circleBorder = 4;
    private int circlePadding = 5;
    private Color color = Color.red;
    private double scale = 1.0;
    private Font centerImageFont = new Font("\u5b8b\u4f53", 1, 100);
    private double textAngle = 240.0;
    private Font attachOneFont = new Font("\u5b8b\u4f53", 1, 20);
    private Font attachTwoFont = new Font("\u5b8b\u4f53", 1, 20);
    private double attachOneStretchX = 0.06;
    private double attachOneStretchY = 1.0;
    private int attachCenterOnePadding = 0;
    private int attachOneTwoPadding = 0;
    private double attachTwoStretchX = 0.06;
    private double attachTwoStretchY = 1.0;
    private int attachTwoThreePadding = 0;
    private Font attachThreeFont = new Font("\u5b8b\u4f53", 1, 30);
    private double attachThreeStretchX = 0.06;
    private double attachThreeStretchY = 1.0;
    private int centerImagePaddingBottom = 10;
    private int attachPaddingBottom = 10;
    private String picturePath;
    private int pictureWidth;
    private int pictureHeight;
    private String innerText = null;
    private Font innerTextFont = new Font("\u5b8b\u4f53", 1, 50);
    private int innerCircleBorder = 3;
    private int innerCirclePadding = 5;
    private double innerCircleAngle = 240.0;
    private int innerOuterCirclePadding = 0;
    private boolean transparent = false;
    private BufferedImage bufferedImage = null;
    private Graphics2D g2 = null;
    private int times = 1;
    private float xCoordinate = 0.0f;
    private float yCoordinate = 0.0f;
    int descent = 0;
    int fontPadding = 0;

    protected CircleSignCreator() {
    }

    public static CircleSignCreator getInstance() {
        return (CircleSignCreator)KGFacadeCglib.getInstance(CircleSignCreator.class);
    }

    public void load(String json) {
        try {
            Font font;
            JSONObject obj = JSONObject.parseObject((String)json);
            this.times = JSONHelper.getDefault(obj, "times", 1);
            this.imageSideLength = JSONHelper.getDefault(obj, "width", 400) * this.times;
            this.imageSideHeight = JSONHelper.getDefault(obj, "height", 400) * this.times;
            this.imagePadding = JSONHelper.getDefault(obj, "imagePadding", 0) * this.times;
            this.stretchX = JSONHelper.getDefault(obj, "stretchX", 0.6);
            this.stretchY = JSONHelper.getDefault(obj, "stretchY", 1.0);
            this.color = new Color(JSONHelper.getDefault(obj, "color", Color.RED.getRGB()));
            this.scale = JSONHelper.getDefault(obj, "scale", 1.0);
            this.transparent = JSONHelper.getDefault(obj, "transparent", false);
            if (obj.containsKey((Object)"circle")) {
                JSONObject circle = obj.getJSONObject("circle");
                this.text = circle.getString("text");
                this.circlePadding = JSONHelper.getDefault(circle, "padding", 5) * this.times;
                this.circleBorder = JSONHelper.getDefault(circle, "border", 4) * this.times;
                this.textAngle = JSONHelper.getDefault(circle, "textAngle", 240.0);
                if (circle.getString("fontPath") != null) {
                    font = Font.createFont(0, new File(circle.getString("fontPath")));
                    this.textFont = font.deriveFont((int)JSONHelper.getDefault(circle, "fontStyle", 1), JSONHelper.getDefault(circle, "fontSize", 50) * this.times);
                } else {
                    this.textFont = new Font(JSONHelper.getDefault(circle, "fontName", "\u5b8b\u4f53"), (int)JSONHelper.getDefault(circle, "fontStyle", 1), JSONHelper.getDefault(circle, "fontSize", 50) * this.times);
                }
                if (26 > this.textFont.getSize()) {
                    throw new IllegalArgumentException("\u6587\u672c\u5927\u5c0f\u4e0d\u80fd\u5c0f\u4e8e26");
                }
            }
            if (obj.containsKey((Object)"centerImage")) {
                JSONObject centerImage = obj.getJSONObject("centerImage");
                this.centerImage = JSONHelper.getDefault(centerImage, "image", "\u2605");
                this.centerImageFont = new Font(JSONHelper.getDefault(centerImage, "fontName", "\u5b8b\u4f53"), (int)JSONHelper.getDefault(centerImage, "fontStyle", 1), JSONHelper.getDefault(centerImage, "fontSize", 100) * this.times);
                this.centerImagePaddingBottom = JSONHelper.getDefault(centerImage, "paddingBottom", 10) * this.times;
                this.picturePath = JSONHelper.getDefault(centerImage, "picturePath", "");
                this.pictureWidth = JSONHelper.getDefault(centerImage, "pictureWidth", 0) * this.times;
                this.pictureHeight = JSONHelper.getDefault(centerImage, "pictureHeight", 0) * this.times;
            }
            if (obj.containsKey((Object)"innerCircle")) {
                JSONObject innerCircle = obj.getJSONObject("innerCircle");
                this.innerText = innerCircle.getString("text");
                this.innerCircleBorder = JSONHelper.getDefault(innerCircle, "border", 3) * this.times;
                this.innerCirclePadding = JSONHelper.getDefault(innerCircle, "padding", 5) * this.times;
                this.innerCircleAngle = JSONHelper.getDefault(innerCircle, "textAngle", 240.0);
                if (innerCircle.getString("fontPath") != null) {
                    font = Font.createFont(0, new File(innerCircle.getString("fontPath")));
                    this.innerTextFont = font.deriveFont((int)JSONHelper.getDefault(innerCircle, "fontStyle", 1), JSONHelper.getDefault(innerCircle, "fontSize", 50) * this.times);
                } else {
                    this.innerTextFont = new Font(JSONHelper.getDefault(innerCircle, "fontName", "\u5b8b\u4f53"), (int)JSONHelper.getDefault(innerCircle, "fontStyle", 1), JSONHelper.getDefault(innerCircle, "fontSize", 50) * this.times);
                }
                this.innerOuterCirclePadding = JSONHelper.getDefault(innerCircle, "outerCirclePadding", 2) * this.times;
                if (26 > this.innerTextFont.getSize()) {
                    throw new IllegalArgumentException("\u6587\u672c\u5927\u5c0f\u4e0d\u80fd\u5c0f\u4e8e26");
                }
            }
            if (obj.containsKey((Object)"business")) {
                JSONObject business = obj.getJSONObject("business");
                this.businessLicenseNo = business.getString("licenseNo");
                if (business.getString("fontPath") != null) {
                    font = Font.createFont(0, new File(business.getString("fontPath")));
                    this.attachOneFont = font.deriveFont((int)JSONHelper.getDefault(business, "fontStyle", 600), JSONHelper.getDefault(business, "fontSize", 10) * this.times);
                } else {
                    this.businessLicenseNoFont = new Font(JSONHelper.getDefault(business, "fontName", "\u9ed1\u4f53"), (int)JSONHelper.getDefault(business, "fontStyle", 600), JSONHelper.getDefault(business, "fontSize", 10) * this.times);
                }
                this.blnOffsetOfCircleBorder = JSONHelper.getDefault(business, "blnOffsetOfCircleBorder", 12) * this.times;
                this.businessLicAngle = JSONHelper.getDefault(business, "businessLicAngle", 80.0);
                this.businessLicenseScaleX = JSONHelper.getDefault(business, "scaleX", 1.5);
                this.businessLicenseScaleY = JSONHelper.getDefault(business, "scaleY", 2.0);
            }
            if (obj.containsKey((Object)"attachOne")) {
                JSONObject attach1 = obj.getJSONObject("attachOne");
                this.attachOne = attach1.getString("text");
                if (attach1.getString("fontPath") != null) {
                    font = Font.createFont(0, new File(attach1.getString("fontPath")));
                    this.attachOneFont = font.deriveFont((int)JSONHelper.getDefault(attach1, "fontStyle", 1), JSONHelper.getDefault(attach1, "fontSize", 20) * this.times);
                } else {
                    this.attachOneFont = new Font(JSONHelper.getDefault(attach1, "fontName", "\u5b8b\u4f53"), (int)JSONHelper.getDefault(attach1, "fontStyle", 1), JSONHelper.getDefault(attach1, "fontSize", 20) * this.times);
                }
                this.attachCenterOnePadding = JSONHelper.getDefault(attach1, "padding", 0) * this.times;
                this.attachOneStretchX = JSONHelper.getDefault(attach1, "stretchX", this.stretchX);
                this.attachOneStretchY = JSONHelper.getDefault(attach1, "stretchY", this.stretchY);
            }
            if (obj.containsKey((Object)"attachTwo")) {
                JSONObject attach2 = obj.getJSONObject("attachTwo");
                this.attachTwo = attach2.getString("text");
                if (attach2.getString("fontPath") != null) {
                    font = Font.createFont(0, new File(attach2.getString("fontPath")));
                    this.attachTwoFont = font.deriveFont((int)JSONHelper.getDefault(attach2, "fontStyle", 1), JSONHelper.getDefault(attach2, "fontSize", 20) * this.times);
                } else {
                    this.attachTwoFont = new Font(JSONHelper.getDefault(attach2, "fontName", "\u5b8b\u4f53"), (int)JSONHelper.getDefault(attach2, "fontStyle", 1), JSONHelper.getDefault(attach2, "fontSize", 20) * this.times);
                }
                this.attachOneTwoPadding = JSONHelper.getDefault(attach2, "padding", 0) * this.times;
                this.attachPaddingBottom = JSONHelper.getDefault(attach2, "paddingBottom", 10) * this.times;
                this.attachTwoStretchX = JSONHelper.getDefault(attach2, "stretchX", this.stretchX);
                this.attachTwoStretchY = JSONHelper.getDefault(attach2, "stretchY", this.stretchY);
            }
            if (obj.containsKey((Object)"attachThree")) {
                JSONObject attach3 = obj.getJSONObject("attachThree");
                this.attachThree = attach3.getString("text");
                if (attach3.getString("fontPath") != null) {
                    font = Font.createFont(0, new File(attach3.getString("fontPath")));
                    this.attachThreeFont = font.deriveFont((int)JSONHelper.getDefault(attach3, "fontStyle", 1), JSONHelper.getDefault(attach3, "fontSize", 20) * this.times);
                } else {
                    this.attachThreeFont = new Font(JSONHelper.getDefault(attach3, "fontName", "\u5b8b\u4f53"), (int)JSONHelper.getDefault(attach3, "fontStyle", 1), JSONHelper.getDefault(attach3, "fontSize", 20) * this.times);
                }
                this.attachTwoThreePadding = JSONHelper.getDefault(attach3, "padding", 0) * this.times;
                this.attachThreeStretchX = JSONHelper.getDefault(attach3, "stretchX", this.stretchX);
                this.attachThreeStretchY = JSONHelper.getDefault(attach3, "stretchY", this.stretchY);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u53c2\u6570\u5f02\u5e38:" + e);
        }
    }

    private void init() {
        this.bufferedImage = new BufferedImage(this.imageSideLength, this.imageSideHeight, 2);
        this.g2 = this.bufferedImage.createGraphics();
        if (this.transparent) {
            this.bufferedImage = this.g2.getDeviceConfiguration().createCompatibleImage(this.imageSideLength, this.imageSideHeight, 3);
            this.g2.dispose();
            this.g2 = this.bufferedImage.createGraphics();
        } else {
            this.g2.setColor(Color.white);
            this.g2.fillRect(0, 0, this.imageSideLength, this.imageSideHeight);
        }
        this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.g2.setColor(this.color);
        this.g2.setStroke(new BasicStroke(this.circleBorder));
        int x = 0;
        x = this.circleBorder % 2 == 0 ? this.circleBorder / 2 + this.imagePadding : this.circleBorder / 2 + 1 + this.imagePadding;
        this.innerOuterCirclePadding += x;
        int w = this.imageSideLength - (this.circleBorder + 1) - 2 * this.imagePadding;
        int h = this.imageSideHeight - (this.circleBorder + 1) - 2 * this.imagePadding;
        Ellipse2D.Double circle = new Ellipse2D.Double(x, x, w, h);
        this.g2.draw(circle);
    }

    @AuthorizationMethod(authEx=true)
    public BufferedImage create() throws IOException {
        this.init();
        Font font = null;
        FontMetrics fontMetrics = null;
        this.drawText();
        this.drawInnerText();
        this.drawBusinessLicenseNo();
        this.xCoordinate = this.getCenterX();
        this.yCoordinate = this.getCenterY();
        if (this.centerImage != null && !"".equals(this.centerImage)) {
            font = this.centerImageFont;
            this.g2.setFont(font);
            fontMetrics = this.g2.getFontMetrics();
            int stringWidth = fontMetrics.stringWidth(this.centerImage);
            int ascent = fontMetrics.getAscent();
            int leading = fontMetrics.getLeading();
            this.descent = fontMetrics.getDescent() + this.centerImagePaddingBottom;
            this.xCoordinate -= (float)(stringWidth / 2);
            this.yCoordinate = this.yCoordinate + (float)(ascent / 2) - (float)leading;
            this.g2.drawString(this.centerImage, this.xCoordinate, this.yCoordinate);
        }
        if (this.picturePath != null && !"".equals(this.picturePath)) {
            BufferedImage picture = ImageIO.read(new File(this.picturePath));
            this.g2.drawImage(picture, this.getCenterX() - this.pictureWidth / 2, this.getCenterY() - this.pictureWidth / 2, this.pictureWidth, this.pictureHeight, null);
        }
        if (this.attachOne != null && !"".equals(this.attachOne)) {
            this.yCoordinate += (float)this.attachCenterOnePadding;
            this.drawAttchText(this.g2, this.attachOne, this.attachOneFont, this.fontPadding, this.attachOneStretchX, this.attachOneStretchY);
        }
        if (this.attachTwo != null && !"".equals(this.attachTwo)) {
            this.yCoordinate += (float)this.attachOneTwoPadding;
            this.drawAttchText(this.g2, this.attachTwo, this.attachTwoFont, 0, this.attachTwoStretchX, this.attachTwoStretchY);
        }
        if (this.attachThree != null && !"".equals(this.attachThree)) {
            this.yCoordinate += (float)this.attachTwoThreePadding;
            this.drawAttchText(this.g2, this.attachThree, this.attachThreeFont, 0, this.attachThreeStretchX, this.attachThreeStretchY);
        }
        this.g2.dispose();
        if (this.scale == 1.0) {
            return this.bufferedImage;
        }
        Double newImageWidht = (double)this.imageSideLength * this.scale;
        Double newImageHeight = (double)this.imageSideHeight * this.scale;
        Image image = this.bufferedImage.getScaledInstance(newImageWidht.intValue(), newImageHeight.intValue(), 4);
        BufferedImage bufImg = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g = bufImg.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bufImg;
    }

    private void drawEllipseText(Double totalArcAng, double minRat, String text) {
        Point center = new Point(this.imageSideLength / 2, this.imageSideHeight / 2);
        int radiusX = this.imageSideLength / 2 - this.textFont.getSize();
        int radiusY = this.imageSideHeight / 2 - this.textFont.getSize();
        this.drawEllipseText(this.g2, this.textFont, center, radiusX, radiusY, totalArcAng, minRat, true, text);
    }

    private void drawText() {
        FontRenderContext context = null;
        Font font = this.textFont;
        if (this.text != null && !"".equals(this.text)) {
            font = this.textFont;
            context = this.g2.getFontRenderContext();
            Rectangle2D bounds = font.getStringBounds(this.text, context);
            double charHeight = -bounds.getY() * this.stretchY;
            this.innerOuterCirclePadding += new Double(charHeight).intValue();
            this.drawEllipseText(this.textAngle, this.circlePadding + this.circleBorder, this.text);
        }
    }

    private void drawInnerText() {
        Font font = null;
        if (this.innerText != null && !"".equals(this.innerText)) {
            int xcircle = 0;
            xcircle = this.innerCircleBorder % 2 == 0 ? this.innerOuterCirclePadding + this.innerCircleBorder / 2 : this.innerOuterCirclePadding + this.innerCircleBorder / 2 + 1;
            int w = this.imageSideLength - (this.innerCircleBorder + 1) - this.innerOuterCirclePadding * 2;
            int h = this.imageSideHeight - (this.innerCircleBorder + 1) - this.innerOuterCirclePadding * 2;
            Ellipse2D.Double innerCircle = new Ellipse2D.Double(xcircle, xcircle, w, h);
            this.g2.setStroke(new BasicStroke(this.innerCircleBorder));
            this.g2.draw(innerCircle);
            font = this.innerTextFont;
            Point center = new Point(this.imageSideLength / 2, this.imageSideHeight / 2);
            int radiusX = this.imageSideLength / 2 - font.getSize() - this.innerOuterCirclePadding - this.innerCirclePadding - this.innerCircleBorder;
            int radiusY = this.imageSideHeight / 2 - font.getSize() - this.innerOuterCirclePadding - this.innerCirclePadding - this.innerCircleBorder;
            this.drawEllipseText(this.g2, this.innerTextFont, center, radiusX, radiusY, this.innerCircleAngle, this.innerCirclePadding, true, this.innerText);
        }
    }

    private void drawBusinessLicenseNo() {
        block6: {
            FontMetrics fontMetrics = null;
            if (this.businessLicenseNo == null || this.businessLicenseNo.trim().length() == 0) break block6;
            String bizzLicNo = this.businessLicenseNo.trim();
            int length = bizzLicNo.length();
            double apartAngle = this.businessLicAngle / 180.0 * Math.PI / (double)(length - 1);
            this.g2.setFont(this.businessLicenseNoFont);
            fontMetrics = this.g2.getFontMetrics();
            double charWidth = 0.0;
            double disx = this.imageSideLength / 2;
            double disy = this.imageSideLength - (this.circleBorder + this.blnOffsetOfCircleBorder);
            int index = length / 2;
            String c = null;
            if (length % 2 == 0) {
                double y;
                double x;
                AffineTransform rotateTransform;
                double offsetAngle = 0.0;
                int i = 1;
                while (i <= length / 2) {
                    c = bizzLicNo.substring(index - i, index - i + 1);
                    offsetAngle = i == 1 ? apartAngle / 2.0 : (offsetAngle += apartAngle);
                    rotateTransform = AffineTransform.getRotateInstance(offsetAngle);
                    rotateTransform.scale(this.businessLicenseScaleX, this.businessLicenseScaleY);
                    this.g2.setFont(this.businessLicenseNoFont.deriveFont(rotateTransform));
                    fontMetrics = this.g2.getFontMetrics();
                    charWidth = fontMetrics.stringWidth(c);
                    x = disx - Math.sin(offsetAngle) * (disy / 2.0) - charWidth / 2.0 * Math.cos(offsetAngle);
                    y = disy / 2.0 + Math.cos(offsetAngle) * (disy / 2.0) - charWidth / 2.0 * Math.sin(offsetAngle);
                    this.g2.drawString(c, (float)x, (float)y);
                    ++i;
                }
                i = 0;
                while (i < length / 2) {
                    c = bizzLicNo.substring(index + i, index + i + 1);
                    offsetAngle = i == 0 ? apartAngle / 2.0 : (offsetAngle += apartAngle);
                    rotateTransform = AffineTransform.getRotateInstance(-offsetAngle);
                    rotateTransform.scale(this.businessLicenseScaleX, this.businessLicenseScaleY);
                    this.g2.setFont(this.businessLicenseNoFont.deriveFont(rotateTransform));
                    fontMetrics = this.g2.getFontMetrics();
                    charWidth = fontMetrics.stringWidth(c);
                    x = disx + Math.sin(offsetAngle) * (disy / 2.0) - charWidth / 2.0 * Math.cos(offsetAngle);
                    y = disy / 2.0 + Math.cos(offsetAngle) * (disy / 2.0) + charWidth * Math.sin(offsetAngle) / 2.0;
                    this.g2.drawString(c, (float)x, (float)y);
                    ++i;
                }
            } else {
                double y;
                double x;
                AffineTransform rotateTransform;
                double offsetAngle = 0.0;
                AffineTransform scale = AffineTransform.getScaleInstance(this.businessLicenseScaleX, this.businessLicenseScaleY);
                this.g2.setFont(this.businessLicenseNoFont.deriveFont(scale));
                c = bizzLicNo.substring(index, index + 1);
                fontMetrics = this.g2.getFontMetrics();
                charWidth = fontMetrics.stringWidth(c);
                this.g2.drawString(c, (float)(disx - charWidth / 2.0), (float)disy);
                int i = 1;
                while (i <= length / 2) {
                    c = bizzLicNo.substring(index - i, index - i + 1);
                    rotateTransform = AffineTransform.getRotateInstance(offsetAngle += apartAngle);
                    rotateTransform.scale(this.businessLicenseScaleX, this.businessLicenseScaleY);
                    this.g2.setFont(this.businessLicenseNoFont.deriveFont(rotateTransform));
                    fontMetrics = this.g2.getFontMetrics();
                    charWidth = fontMetrics.stringWidth(c);
                    x = disx - Math.sin(offsetAngle) * (disy / 2.0) - charWidth * Math.cos(offsetAngle) / 2.0;
                    y = disy / 2.0 + Math.cos(offsetAngle) * (disy / 2.0) - charWidth * Math.sin(offsetAngle) / 2.0;
                    this.g2.drawString(c, (float)x, (float)y);
                    ++i;
                }
                offsetAngle = 0.0;
                i = 1;
                while (i <= length / 2) {
                    c = bizzLicNo.substring(index + i, index + i + 1);
                    rotateTransform = AffineTransform.getRotateInstance(-(offsetAngle += apartAngle));
                    rotateTransform.scale(this.businessLicenseScaleX, this.businessLicenseScaleY);
                    this.g2.setFont(this.businessLicenseNoFont.deriveFont(rotateTransform));
                    fontMetrics = this.g2.getFontMetrics();
                    charWidth = fontMetrics.stringWidth(c);
                    x = disx + Math.sin(offsetAngle) * (disy / 2.0) - charWidth * Math.cos(offsetAngle) / 2.0;
                    y = disy / 2.0 + Math.cos(offsetAngle) * (disy / 2.0) + charWidth * Math.sin(offsetAngle) / 2.0;
                    this.g2.drawString(c, (float)x, (float)y);
                    ++i;
                }
            }
        }
    }

    private void drawAttchText(Graphics2D g2, String attachText, Font font, int fontPadding, double textStretchX, double textStretchY) {
        int len = attachText.length();
        AffineTransform transform = AffineTransform.getScaleInstance(textStretchX, textStretchY);
        Font f2 = font.deriveFont(transform);
        g2.setFont(f2);
        FontMetrics fontMetrics = g2.getFontMetrics();
        int attachTextWidth = fontMetrics.stringWidth(attachText);
        int ascent = fontMetrics.getAscent();
        float startX = (float)this.getCenterX() - (float)(attachTextWidth + len * fontPadding) / 2.0f;
        this.yCoordinate = this.yCoordinate + (float)this.descent + (float)ascent;
        this.xCoordinate = startX;
        g2.drawString(attachText, this.xCoordinate, this.yCoordinate);
        this.descent = fontMetrics.getDescent() + this.attachPaddingBottom;
    }

    private void drawEllipseText(Graphics2D g2, Font font, Point center, int radiusX, int radiusY, double totalArcAng, double minRat, boolean top, String text) {
        double startAng = top ? -90.0 - totalArcAng / 2.0 : 90.0 - totalArcAng / 2.0;
        int count = text.length();
        double step = 0.5;
        int alCount = (int)Math.ceil(totalArcAng / step) + 1;
        double[] angArr = new double[alCount];
        double[] arcLenArr = new double[alCount];
        int num = 0;
        double accArcLen = 0.0;
        angArr[num] = startAng;
        arcLenArr[num] = accArcLen;
        ++num;
        double angR = startAng * Math.PI / 180.0;
        double lastX = (double)radiusX * Math.cos(angR) + center.getX();
        double laxtY = (double)radiusY * Math.sin(angR) + center.getY();
        double i = startAng + step;
        while (num < alCount) {
            angR = i * Math.PI / 180.0;
            double x = (double)radiusX * Math.cos(angR) + center.getX();
            double y = (double)radiusY * Math.sin(angR) + center.getY();
            angArr[num] = i;
            arcLenArr[num] = accArcLen += Math.sqrt((lastX - x) * (lastX - x) + (laxtY - y) * (laxtY - y));
            lastX = x;
            laxtY = y;
            ++num;
            i += step;
        }
        AffineTransform transform = AffineTransform.getScaleInstance(this.stretchX, this.stretchY);
        Font f1 = font.deriveFont(transform);
        g2.setFont(f1);
        double arcPer = accArcLen / (double)count;
        int i2 = 0;
        while (i2 < count) {
            Font f2;
            AffineTransform transform1;
            double arcL = (double)i2 * arcPer + arcPer / 2.0;
            double ang = 0.0;
            int p = 0;
            while (p < arcLenArr.length - 1) {
                if (arcLenArr[p] <= arcL && arcL <= arcLenArr[p + 1]) {
                    ang = arcL >= (arcLenArr[p] + arcLenArr[p + 1]) / 2.0 ? angArr[p + 1] : angArr[p];
                    break;
                }
                ++p;
            }
            angR = ang * Math.PI / 180.0;
            double x = (double)((float)radiusX * (float)Math.cos(angR)) + center.getX();
            double y = (double)((float)radiusY * (float)Math.sin(angR)) + center.getY();
            double qxang = Math.atan2((double)radiusY * Math.cos(angR), (double)(-radiusX) * Math.sin(angR));
            double fxang = qxang + 1.5707963267948966;
            int index = top ? i2 : text.length() - 1 - i2;
            String c = text.substring(index, index + 1);
            g2.setFont(f1);
            FontMetrics fontMetrics = g2.getFontMetrics();
            int ascent = fontMetrics.getAscent();
            int leading = fontMetrics.getLeading();
            int w = fontMetrics.stringWidth(c);
            int h = ascent - leading;
            if (top) {
                x += minRat * Math.cos(fxang);
                y += minRat * Math.sin(fxang);
                x += (double)((float)(-w) / 2.0f) * Math.cos(qxang);
                y += (double)((float)(-w) / 2.0f) * Math.sin(qxang);
            } else {
                x += (minRat + (double)h) * Math.cos(fxang);
                y += (minRat + (double)h) * Math.sin(fxang);
                x += (double)((float)w / 2.0f) * Math.cos(qxang);
                y += (double)((float)w / 2.0f) * Math.sin(qxang);
            }
            if (top) {
                transform1 = AffineTransform.getRotateInstance(fxang -= 1.5707963267948966);
                transform1.scale(this.stretchX, this.stretchY);
                f2 = font.deriveFont(transform1);
                g2.setFont(f2);
                g2.drawString(c, (float)x, (float)y);
            } else {
                transform1 = AffineTransform.getRotateInstance(fxang += 1.5707963267948966);
                transform1.scale(this.stretchX, this.stretchY);
                f2 = font.deriveFont(transform1);
                g2.setFont(f2);
                g2.drawString(c, (float)x, (float)(y + (double)(3 * h / 2)));
            }
            ++i2;
        }
    }

    private int getCenterX() {
        return this.imageSideLength / 2;
    }

    private int getCenterY() {
        return this.imageSideHeight / 2;
    }

    public int getImageSideLength() {
        return this.imageSideLength;
    }

    public void setImageSideLength(int imageHeight) {
        this.imageSideLength = imageHeight;
    }

    public int getImagePadding() {
        return this.imagePadding;
    }

    public void setImagePadding(int imagePadding) {
        this.imagePadding = imagePadding;
    }

    public float getCircleBorder() {
        return this.circleBorder;
    }

    public void setCircleBorder(int circleBorder) {
        this.circleBorder = circleBorder;
    }

    public int getCirclePadding() {
        return this.circlePadding;
    }

    public void setCirclePadding(int circlePadding) {
        this.circlePadding = circlePadding;
    }

    public double getTextAngle() {
        return this.textAngle;
    }

    public void setTextAngle(double textAngle) {
        this.textAngle = textAngle;
    }

    public int getAttachPaddingBottom() {
        return this.attachPaddingBottom;
    }

    public void setAttachPaddingBottom(int attachPaddingBottom) {
        this.attachPaddingBottom = attachPaddingBottom;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setText(String text, Font font) {
        this.text = text;
        this.textFont = font;
    }

    public String getCenterImage() {
        return this.centerImage;
    }

    public void setCenterImage(String centerImage) {
        this.centerImage = centerImage;
    }

    public void setCenterImage(String centerImage, Font font) {
        this.centerImage = centerImage;
        this.centerImageFont = font;
    }

    public int getCenterImagePaddingBottom() {
        return this.centerImagePaddingBottom;
    }

    public void setCenterImagePaddingBottom(int centerImagePaddingBottom) {
        this.centerImagePaddingBottom = centerImagePaddingBottom;
    }

    public String getAttachOne() {
        return this.attachOne;
    }

    public void setAttachOne(String attachOne) {
        this.attachOne = attachOne;
    }

    public void setAttachOne(String attachOne, Font font) {
        this.attachOne = attachOne;
        this.attachOneFont = font;
    }

    public void setAttachOne(String attachOne, Font font, int padding) {
        this.attachOne = attachOne;
        this.attachOneFont = font;
        this.attachCenterOnePadding = padding;
    }

    public String getAttachTwo() {
        return this.attachTwo;
    }

    public void setAttachTwo(String attachTwo) {
        this.attachTwo = attachTwo;
    }

    public void setAttachTwo(String attachTwo, Font font) {
        this.attachTwo = attachTwo;
        this.attachTwoFont = font;
    }

    public void setAttachTwo(String attachTwo, Font font, int padding) {
        this.attachTwo = attachTwo;
        this.attachTwoFont = font;
        this.attachOneTwoPadding = padding;
    }

    public String getAttachThree() {
        return this.attachThree;
    }

    public void setAttachThree(String attachThree) {
        this.attachThree = attachThree;
    }

    public void setAttachThree(String attachThree, Font font) {
        this.attachThree = attachThree;
        this.attachThreeFont = font;
    }

    public void setAttachThree(String attachThree, Font font, int padding) {
        this.attachThree = attachThree;
        this.attachThreeFont = font;
        this.attachTwoThreePadding = padding;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public int getFontPadding() {
        return this.fontPadding;
    }

    public void setFontPadding(int fontPadding) {
        this.fontPadding = fontPadding;
    }

    public double getStretchX() {
        return this.stretchX;
    }

    public void setStretchX(double stretchX) {
        this.stretchX = stretchX;
    }

    public double getStretchY() {
        return this.stretchY;
    }

    public void setStretchY(double stretchY) {
        this.stretchY = stretchY;
    }

    public String getBusinessLicenseNo() {
        return this.businessLicenseNo;
    }

    public void setBusinessLicenseNo(String businessLicenseNo) {
        this.businessLicenseNo = businessLicenseNo;
    }

    public Font getBusinessLicenseNoFont() {
        return this.businessLicenseNoFont;
    }

    public void setBusinessLicenseNoFont(Font businessLicenseNoFont) {
        this.businessLicenseNoFont = businessLicenseNoFont;
    }

    public double getBusinessLicAngle() {
        return this.businessLicAngle;
    }

    public void setBusinessLicAngle(double businessLicAngle) {
        this.businessLicAngle = businessLicAngle;
    }

    public int getBlnOffsetOfCircleBorder() {
        return this.blnOffsetOfCircleBorder;
    }

    public void setBlnOffsetOfCircleBorder(int blnOffsetOfCircleBorder) {
        this.blnOffsetOfCircleBorder = blnOffsetOfCircleBorder;
    }

    public void setCenterPicture(String picturePath, int pictureWidth, int pictureHeight) {
        this.picturePath = picturePath;
        this.pictureWidth = pictureWidth;
        this.pictureHeight = pictureHeight;
    }

    public int getImageSideHeight() {
        return this.imageSideHeight;
    }

    public void setImageSideHeight(int imageSideHeight) {
        this.imageSideHeight = imageSideHeight;
    }
}

