/*
 * Decompiled with CFR 0.152.
 */
package com.kinggrid.authorization;

import com.kinggrid.commons.KGDateUtils;
import com.kinggrid.encrypt.KGBase64;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public class KGLicense {
    private static KGLicense license = null;
    private static final String BASE64TABLE = "=ABCDEFGHIJKLabcdefghijklmnopqrstuvwxyzMNOPQRSTUVWXYZ0123456789+/";
    private static final String LIC = "/iSignature_PDF_API.lic";
    private static final String NEWLIC = "/iSignature_Cloud_API.lic";
    private static final Map<String, String> AUTH_MAP = new HashMap<String, String>();
    private static String enableAuthorization = null;
    private static String lic = null;
    private static String issue_date = null;
    private static String filePath = null;
    private static long lastModified = -1L;
    private static String mac = null;
    private static String companyName;

    public static String getCompanyName() {
        KGLicense.license();
        return companyName;
    }

    public static void authorization(String clazzName, String methodName) {
        KGLicense.license();
        String val = AUTH_MAP.get(clazzName);
        if (val == null || val.indexOf(String.valueOf(methodName) + ",") == -1) {
            throw new IllegalArgumentException("\u64cd\u4f5c\u672a\u6388\u6743\uff0c\u8bf7\u8054\u7cfb\u8be5\u8f6f\u4ef6\u63d0\u4f9b\u5546\u3002\u7c7b\u540d\uff1a" + clazzName + ",\u65b9\u6cd5\u540d\uff1a " + methodName);
        }
    }

    public static boolean authorizationNoEx(String clazzName, String methodName) {
        KGLicense.license();
        String val = AUTH_MAP.get(clazzName);
        return val != null && val.indexOf(String.valueOf(methodName) + ",") != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void license() {
        if (license == null) {
            Map<String, String> map = AUTH_MAP;
            synchronized (map) {
                if (license == null) {
                    KGLicense _license = new KGLicense();
                    KGLicense.readLic(_license.getLicenseFromLic());
                    license = _license;
                }
            }
        }
        if (license.isReplaced()) {
            KGLicense.readLic(license.getLicenseFromLic());
        }
        if (!"0".equals(enableAuthorization)) {
            if (lic != null && lic.length() != 0) {
                String cpuMessage = System.getProperty("sun.cpu.isalist");
                String mac = license.getMacfromOs();
                String licenseMsg = String.valueOf(cpuMessage) + mac;
                if (!lic.equals(licenseMsg)) {
                    throw new IllegalStateException("iSignature_PDF_API\u4e2d\u95f4\u4ef6\u672a\u6388\u6743\uff0c\u8bf7\u8054\u7cfb\u8be5\u8f6f\u4ef6\u63d0\u4f9b\u5546\u3002");
                }
            } else {
                Date date = KGDateUtils.parse2Date(issue_date, "yyyy-MM-dd");
                if (KGDateUtils.compareDate(new Date(), date) >= 0) {
                    throw new IllegalStateException("\u60a8\u4f7f\u7528\u7684\u6388\u6743\u5df2\u5230\u671f\uff0c\u8bf7\u8054\u7cfb\u5382\u5546\u66f4\u65b0\u6388\u6743\uff01");
                }
            }
        }
    }

    private boolean isReplaced() {
        if (lastModified == -1L) {
            return true;
        }
        if (filePath != null) {
            File file = new File(filePath);
            if (file.exists()) {
                long newLastModified = file.lastModified();
                return newLastModified != lastModified;
            }
            return false;
        }
        return false;
    }

    private static void readLic(String content) {
        AUTH_MAP.clear();
        if (content == null) {
            throw new IllegalArgumentException("\u6388\u6743\u6587\u4ef6iSignature_Cloud_API.lic\u6216iSignature_PDF_API.lic\u4e0d\u5b58\u5728\u3002");
        }
        try {
            StringBuilder stringBuilder;
            block21: {
                Document document = DocumentHelper.parseText((String)content);
                Node node = document.selectSingleNode("/kinggrid/iSignature_PDF_API/item[@name='enableAuthorization']");
                if (node != null) {
                    enableAuthorization = node.getText();
                }
                issue_date = document.selectSingleNode("/kinggrid/iSignature_PDF_API/item[@name='expiredDateTime']").getText();
                lic = document.selectSingleNode("/kinggrid/iSignature_PDF_API/item[@name='license']").getText();
                List clazzNames = document.selectNodes("/kinggrid/iSignature_PDF_API/className");
                int i = 0;
                while (i < clazzNames.size()) {
                    Element element = (Element)clazzNames.get(i);
                    String clazzName = element.attributeValue("name");
                    List methodNames = element.selectNodes("methodName");
                    StringBuilder builder = new StringBuilder();
                    int k = 0;
                    while (k < methodNames.size()) {
                        Element methodName = (Element)methodNames.get(k);
                        builder.append(methodName.getText()).append(",");
                        ++k;
                    }
                    String methods = AUTH_MAP.get(clazzName);
                    if (methods != null) {
                        builder.append(methods);
                    }
                    AUTH_MAP.put(clazzName, builder.toString());
                    ++i;
                }
                companyName = document.selectSingleNode("/kinggrid/iSignature_PDF_API/item[@name='company']").getText();
                System.out.println("-------------------------------------------------------------------------------------\n");
                stringBuilder = new StringBuilder();
                stringBuilder.append("iSignature_PDF_API\u4e2d\u95f4\u4ef6\u6388\u6743\u5355\u4f4d\u540d\u79f0\uff1a").append(companyName).append("\n\n");
                if ("0".equals(enableAuthorization)) {
                    if (lic == null || lic.length() == 0) {
                        stringBuilder.append("\u6388\u6743\u6a21\u5f0f\uff1a\u9879\u76ee\u6388\u6743");
                    }
                } else {
                    if (lic == null || lic.length() == 0) {
                        stringBuilder.append("\u8fc7\u671f\u65f6\u95f4\uff1a").append(issue_date);
                        InputStream in = null;
                        try {
                            try {
                                in = KGLicense.class.getResourceAsStream("module.txt");
                                byte[] buff = new byte[in.available()];
                                in.read(buff);
                                stringBuilder.append("\n\n").append(new String(buff, "UTF-8"));
                                break block21;
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        finally {
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                    }
                    stringBuilder.append("\u6388\u6743\u6a21\u5f0f\uff1a\u7ed1\u5b9a\u673a\u5668\u7801");
                }
            }
            stringBuilder.append("\n");
            System.out.println(stringBuilder.toString());
            System.out.println("-------------------------------------------------------------------------------------");
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
    }

    private String getLicenseFromLic() {
        InputStream in = null;
        String license = null;
        try {
            try {
                File file = null;
                if (filePath != null) {
                    file = new File(filePath);
                } else {
                    URL url = KGLicense.class.getResource(LIC);
                    if (url == null) {
                        url = KGLicense.class.getResource(NEWLIC);
                    }
                    if (url != null) {
                        filePath = URLDecoder.decode(url.getPath(), "UTF-8");
                        file = new File(filePath);
                    }
                }
                if (file != null && file.exists()) {
                    lastModified = file.lastModified();
                    in = new FileInputStream(file);
                } else {
                    lastModified = System.currentTimeMillis();
                    in = KGLicense.class.getResourceAsStream(LIC);
                    if (in == null) {
                        in = KGLicense.class.getResourceAsStream(NEWLIC);
                    }
                }
                if (in == null) {
                    throw new IllegalArgumentException("\u8bf7\u6309\u8981\u6c42\u653e\u7f6e\u6388\u6743\u6587\u4ef6iSignature_Cloud_API.lic\u6216iSignature_PDF_API.lic.");
                }
                in = new BufferedInputStream(in);
                byte[] buff = new byte[in.available()];
                in.read(buff);
                KGBase64 base64 = new KGBase64();
                base64.setBase64Table(BASE64TABLE);
                license = new String(base64.decode(new String(buff)), "UTF-8");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            KGLicense.close(in);
            throw throwable;
        }
        KGLicense.close(in);
        return license;
    }

    public static void setLicenseFilePath(String licenseFilePath) {
        filePath = licenseFilePath;
    }

    private String getMacfromOs() {
        if (mac == null) {
            String osName = System.getProperty("os.name");
            mac = osName.indexOf("Windows") != -1 ? this.getMACfromWindows() : this.getMACfromLinux();
        }
        return mac;
    }

    private String getMACfromWindows() {
        StringBuilder mac = new StringBuilder();
        BufferedReader bufferedReader = null;
        try {
            try {
                Process process = Runtime.getRuntime().exec("ipconfig -all");
                bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String line = null;
                Pattern pattern = Pattern.compile("([\\s]{1}[0-9a-zA-Z]{2}-[0-9a-zA-Z]{2}-[0-9a-zA-Z]{2}-[0-9a-zA-Z]{2}-[0-9a-zA-Z]{2}-[0-9a-zA-Z]{2}){1}$");
                while ((line = bufferedReader.readLine()) != null) {
                    String endline;
                    Matcher matcher;
                    int index = line.indexOf(":");
                    if (index == -1 || !(matcher = pattern.matcher(endline = line.substring(index + 1))).matches()) continue;
                    mac.append(line.substring(line.length() - 18));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            KGLicense.close(bufferedReader);
            throw throwable;
        }
        KGLicense.close(bufferedReader);
        return mac.toString();
    }

    private String getMACfromLinux() {
        StringBuilder mac = new StringBuilder();
        this.ifConfig("eth", mac);
        if (mac.length() == 0) {
            this.ifConfig("em", mac);
        }
        if (mac.length() == 0) {
            this.ifConfigAll(mac);
        }
        return mac.toString();
    }

    private void ifConfig(String arg, StringBuilder mac) {
        int i = 0;
        while (i < 10) {
            BufferedReader bufferedReader = null;
            try {
                try {
                    Process processn = Runtime.getRuntime().exec("ifconfig " + arg + i);
                    bufferedReader = new BufferedReader(new InputStreamReader(processn.getInputStream()));
                    String line = null;
                    while ((line = bufferedReader.readLine()) != null) {
                        if (line.indexOf("HWaddr") == -1) continue;
                        mac.append(line.substring(line.length() - 18));
                        break;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            catch (Throwable throwable) {
                KGLicense.close(bufferedReader);
                throw throwable;
            }
            KGLicense.close(bufferedReader);
            ++i;
        }
    }

    private void ifConfigAll(StringBuilder mac) {
        BufferedReader br = null;
        try {
            try {
                String line;
                Process p = Runtime.getRuntime().exec("ifconfig -a");
                br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((line = br.readLine()) != null) {
                    Pattern pat = Pattern.compile("\\b\\w+:\\w+:\\w+:\\w+:\\w+:\\w+\\b");
                    Matcher mat = pat.matcher(line);
                    if (!mat.find()) continue;
                    mac.append(String.valueOf(mat.group(0)) + " ");
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            KGLicense.close(br);
            throw throwable;
        }
        KGLicense.close(br);
    }

    private static void close(Closeable able) {
        try {
            if (able != null) {
                able.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        KGLicense.license();
    }
}

