/*
 * Decompiled with CFR 0.152.
 */
package com.KGitextpdf.xmp.impl;

import com.KGitextpdf.xmp.XMPConst;

public class Utils
implements XMPConst {
    public static final int UUID_SEGMENT_COUNT = 4;
    public static final int UUID_LENGTH = 36;
    private static boolean[] xmlNameStartChars;
    private static boolean[] xmlNameChars;

    static {
        Utils.initCharTables();
    }

    private Utils() {
    }

    public static String normalizeLangValue(String value) {
        if ("x-default".equals(value)) {
            return value;
        }
        int subTag = 1;
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < value.length()) {
            switch (value.charAt(i)) {
                case '-': 
                case '_': {
                    buffer.append('-');
                    ++subTag;
                    break;
                }
                case ' ': {
                    break;
                }
                default: {
                    if (subTag != 2) {
                        buffer.append(Character.toLowerCase(value.charAt(i)));
                        break;
                    }
                    buffer.append(Character.toUpperCase(value.charAt(i)));
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    static String[] splitNameAndValue(String selector) {
        int eq = selector.indexOf(61);
        int pos = 1;
        if (selector.charAt(pos) == '?') {
            ++pos;
        }
        String name = selector.substring(pos, eq);
        pos = eq + 1;
        char quote = selector.charAt(pos);
        ++pos;
        int end = selector.length() - 2;
        StringBuffer value = new StringBuffer(end - eq);
        while (pos < end) {
            value.append(selector.charAt(pos));
            if (selector.charAt(++pos) != quote) continue;
            ++pos;
        }
        return new String[]{name, value.toString()};
    }

    static boolean isInternalProperty(String schema, String prop) {
        boolean isInternal = false;
        if ("http://purl.org/dc/elements/1.1/".equals(schema)) {
            if ("dc:format".equals(prop) || "dc:language".equals(prop)) {
                isInternal = true;
            }
        } else if ("http://ns.adobe.com/xap/1.0/".equals(schema)) {
            if ("xmp:BaseURL".equals(prop) || "xmp:CreatorTool".equals(prop) || "xmp:Format".equals(prop) || "xmp:Locale".equals(prop) || "xmp:MetadataDate".equals(prop) || "xmp:ModifyDate".equals(prop)) {
                isInternal = true;
            }
        } else if ("http://ns.adobe.com/pdf/1.3/".equals(schema)) {
            if ("pdf:BaseURL".equals(prop) || "pdf:Creator".equals(prop) || "pdf:ModDate".equals(prop) || "pdf:PDFVersion".equals(prop) || "pdf:Producer".equals(prop)) {
                isInternal = true;
            }
        } else if ("http://ns.adobe.com/tiff/1.0/".equals(schema)) {
            isInternal = true;
            if ("tiff:ImageDescription".equals(prop) || "tiff:Artist".equals(prop) || "tiff:Copyright".equals(prop)) {
                isInternal = false;
            }
        } else if ("http://ns.adobe.com/exif/1.0/".equals(schema)) {
            isInternal = true;
            if ("exif:UserComment".equals(prop)) {
                isInternal = false;
            }
        } else if ("http://ns.adobe.com/exif/1.0/aux/".equals(schema)) {
            isInternal = true;
        } else if ("http://ns.adobe.com/photoshop/1.0/".equals(schema)) {
            if ("photoshop:ICCProfile".equals(prop)) {
                isInternal = true;
            }
        } else if ("http://ns.adobe.com/camera-raw-settings/1.0/".equals(schema)) {
            if ("crs:Version".equals(prop) || "crs:RawFileName".equals(prop) || "crs:ToneCurveName".equals(prop)) {
                isInternal = true;
            }
        } else if ("http://ns.adobe.com/StockPhoto/1.0/".equals(schema)) {
            isInternal = true;
        } else if ("http://ns.adobe.com/xap/1.0/mm/".equals(schema)) {
            isInternal = true;
        } else if ("http://ns.adobe.com/xap/1.0/t/".equals(schema)) {
            isInternal = true;
        } else if ("http://ns.adobe.com/xap/1.0/t/pg/".equals(schema)) {
            isInternal = true;
        } else if ("http://ns.adobe.com/xap/1.0/g/".equals(schema)) {
            isInternal = true;
        } else if ("http://ns.adobe.com/xap/1.0/g/img/".equals(schema)) {
            isInternal = true;
        } else if ("http://ns.adobe.com/xap/1.0/sType/Font#".equals(schema)) {
            isInternal = true;
        }
        return isInternal;
    }

    static boolean checkUUIDFormat(String uuid) {
        boolean result = true;
        int delimCnt = 0;
        int delimPos = 0;
        if (uuid == null) {
            return false;
        }
        delimPos = 0;
        while (delimPos < uuid.length()) {
            if (uuid.charAt(delimPos) == '-') {
                ++delimCnt;
                result = result && (delimPos == 8 || delimPos == 13 || delimPos == 18 || delimPos == 23);
            }
            ++delimPos;
        }
        return result && 4 == delimCnt && 36 == delimPos;
    }

    public static boolean isXMLName(String name) {
        if (name.length() > 0 && !Utils.isNameStartChar(name.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < name.length()) {
            if (!Utils.isNameChar(name.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isXMLNameNS(String name) {
        if (!(name.length() <= 0 || Utils.isNameStartChar(name.charAt(0)) && name.charAt(0) != ':')) {
            return false;
        }
        int i = 1;
        while (i < name.length()) {
            if (!Utils.isNameChar(name.charAt(i)) || name.charAt(i) == ':') {
                return false;
            }
            ++i;
        }
        return true;
    }

    static boolean isControlChar(char c) {
        return (c <= '\u001f' || c == '\u007f') && c != '\t' && c != '\n' && c != '\r';
    }

    public static String escapeXML(String value, boolean forAttribute, boolean escapeWhitespaces) {
        boolean needsEscaping = false;
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            if (c == '<' || c == '>' || c == '&' || escapeWhitespaces && (c == '\t' || c == '\n' || c == '\r') || forAttribute && c == '\"') {
                needsEscaping = true;
                break;
            }
            ++i;
        }
        if (!needsEscaping) {
            return value;
        }
        StringBuffer buffer = new StringBuffer(value.length() * 4 / 3);
        int i2 = 0;
        while (i2 < value.length()) {
            char c = value.charAt(i2);
            if (!escapeWhitespaces || c != '\t' && c != '\n' && c != '\r') {
                switch (c) {
                    case '<': {
                        buffer.append("&lt;");
                        break;
                    }
                    case '>': {
                        buffer.append("&gt;");
                        break;
                    }
                    case '&': {
                        buffer.append("&amp;");
                        break;
                    }
                    case '\"': {
                        buffer.append(forAttribute ? "&quot;" : "\"");
                        break;
                    }
                    default: {
                        buffer.append(c);
                        break;
                    }
                }
            } else {
                buffer.append("&#x");
                buffer.append(Integer.toHexString(c).toUpperCase());
                buffer.append(';');
            }
            ++i2;
        }
        return buffer.toString();
    }

    static String removeControlChars(String value) {
        StringBuffer buffer = new StringBuffer(value);
        int i = 0;
        while (i < buffer.length()) {
            if (Utils.isControlChar(buffer.charAt(i))) {
                buffer.setCharAt(i, ' ');
            }
            ++i;
        }
        return buffer.toString();
    }

    private static boolean isNameStartChar(char ch) {
        return ch <= '\u00ff' && xmlNameStartChars[ch] || ch >= '\u0100' && ch <= '\u02ff' || ch >= '\u0370' && ch <= '\u037d' || ch >= '\u037f' && ch <= '\u1fff' || ch >= '\u200c' && ch <= '\u200d' || ch >= '\u2070' && ch <= '\u218f' || ch >= '\u2c00' && ch <= '\u2fef' || ch >= '\u3001' && ch <= '\ud7ff' || ch >= '\uf900' && ch <= '\ufdcf' || ch >= '\ufdf0' && ch <= '\ufffd' || ch >= '\u10000' && ch <= '\ueffff';
    }

    private static boolean isNameChar(char ch) {
        return ch <= '\u00ff' && xmlNameChars[ch] || Utils.isNameStartChar(ch) || ch >= '\u0300' && ch <= '\u036f' || ch >= '\u203f' && ch <= '\u2040';
    }

    private static void initCharTables() {
        xmlNameChars = new boolean[256];
        xmlNameStartChars = new boolean[256];
        int ch = 0;
        while (ch < xmlNameChars.length) {
            Utils.xmlNameStartChars[ch] = ch == 58 || 65 <= ch && ch <= 90 || ch == 95 || 97 <= ch && ch <= 122 || 192 <= ch && ch <= 214 || 216 <= ch && ch <= 246 || 248 <= ch && ch <= 255;
            Utils.xmlNameChars[ch] = xmlNameStartChars[ch] || ch == 45 || ch == 46 || 48 <= ch && ch <= 57 || ch == 183;
            ch = (char)(ch + 1);
        }
    }
}

