/*
 * Decompiled with CFR 0.152.
 */
package com.KGitextpdf.text.pdf.security;

import com.KGitextpdf.text.log.Logger;
import com.KGitextpdf.text.log.LoggerFactory;
import com.KGitextpdf.text.pdf.security.CertificateVerifier;
import com.KGitextpdf.text.pdf.security.OcspClientBouncyCastle;
import com.KGitextpdf.text.pdf.security.RootStoreVerifier;
import com.KGitextpdf.text.pdf.security.VerificationException;
import com.KGitextpdf.text.pdf.security.VerificationOK;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import org.kg.bouncycastle.cert.X509CertificateHolder;
import org.kg.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.kg.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.kg.bouncycastle.cert.ocsp.CertificateStatus;
import org.kg.bouncycastle.cert.ocsp.OCSPException;
import org.kg.bouncycastle.cert.ocsp.SingleResp;
import org.kg.bouncycastle.operator.ContentVerifierProvider;
import org.kg.bouncycastle.operator.DigestCalculatorProvider;
import org.kg.bouncycastle.operator.OperatorCreationException;
import org.kg.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.kg.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;

public class OCSPVerifier
extends RootStoreVerifier {
    protected static final Logger LOGGER = LoggerFactory.getLogger(OCSPVerifier.class);
    protected List<BasicOCSPResp> ocsps;

    public OCSPVerifier(CertificateVerifier verifier, List<BasicOCSPResp> ocsps) {
        super(verifier);
        this.ocsps = ocsps;
    }

    @Override
    public List<VerificationOK> verify(X509Certificate signCert, X509Certificate issuerCert, Date signDate) throws GeneralSecurityException, IOException {
        ArrayList<VerificationOK> result = new ArrayList<VerificationOK>();
        int validOCSPsFound = 0;
        if (this.ocsps != null) {
            for (BasicOCSPResp ocspResp : this.ocsps) {
                if (!this.verify(ocspResp, signCert, issuerCert, signDate)) continue;
                ++validOCSPsFound;
            }
        }
        boolean online = false;
        if (this.onlineCheckingAllowed && validOCSPsFound == 0 && this.verify(this.getOcspResponse(signCert, issuerCert), signCert, issuerCert, signDate)) {
            ++validOCSPsFound;
            online = true;
        }
        LOGGER.info("Valid OCSPs found: " + validOCSPsFound);
        if (validOCSPsFound > 0) {
            result.add(new VerificationOK(signCert, this.getClass(), "Valid OCSPs Found: " + validOCSPsFound + (online ? " (online)" : "")));
        }
        if (this.verifier != null) {
            result.addAll(this.verifier.verify(signCert, issuerCert, signDate));
        }
        return result;
    }

    public boolean verify(BasicOCSPResp ocspResp, X509Certificate signCert, X509Certificate issuerCert, Date signDate) throws GeneralSecurityException, IOException {
        if (ocspResp == null) {
            return false;
        }
        SingleResp[] resp = ocspResp.getResponses();
        int i = 0;
        while (i < resp.length) {
            block11: {
                if (signCert.getSerialNumber().equals(resp[i].getCertID().getSerialNumber())) {
                    try {
                        if (issuerCert == null) {
                            issuerCert = signCert;
                        }
                        if (!resp[i].getCertID().matchesIssuer(new X509CertificateHolder(issuerCert.getEncoded()), (DigestCalculatorProvider)new BcDigestCalculatorProvider())) {
                            LOGGER.info("OCSP: Issuers doesn't match.");
                        }
                    }
                    catch (OCSPException e) {}
                    break block11;
                    Date nextUpdate = resp[i].getNextUpdate();
                    if (nextUpdate == null) {
                        nextUpdate = new Date(resp[i].getThisUpdate().getTime() + 180000L);
                        LOGGER.info(String.format("No 'next update' for OCSP Response; assuming %s", nextUpdate));
                    }
                    if (signDate.after(nextUpdate)) {
                        LOGGER.info(String.format("OCSP no longer valid: %s after %s", signDate, nextUpdate));
                    } else {
                        CertificateStatus status = resp[i].getCertStatus();
                        if (status == CertificateStatus.GOOD) {
                            this.isValidResponse(ocspResp, issuerCert);
                            return true;
                        }
                    }
                }
            }
            ++i;
        }
        return false;
    }

    public void isValidResponse(BasicOCSPResp ocspResp, X509Certificate issuerCert) throws GeneralSecurityException, IOException {
        X509Certificate responderCert;
        block4: {
            responderCert = issuerCert;
            X509CertificateHolder[] certHolders = ocspResp.getCerts();
            if (certHolders.length > 0) {
                responderCert = new JcaX509CertificateConverter().setProvider("KGBC").getCertificate(certHolders[0]);
                try {
                    responderCert.verify(issuerCert.getPublicKey());
                }
                catch (GeneralSecurityException e) {
                    if (super.verify(responderCert, issuerCert, null).size() != 0) break block4;
                    throw new VerificationException(responderCert, "Responder certificate couldn't be verified");
                }
            }
        }
        if (!this.verifyResponse(ocspResp, responderCert)) {
            throw new VerificationException(responderCert, "OCSP response could not be verified");
        }
    }

    public boolean verifyResponse(BasicOCSPResp ocspResp, X509Certificate responderCert) {
        if (this.isSignatureValid(ocspResp, responderCert)) {
            return true;
        }
        if (this.rootStore == null) {
            return false;
        }
        Enumeration<String> aliases = this.rootStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            try {
                X509Certificate anchor;
                if (!this.rootStore.isCertificateEntry(alias) || !this.isSignatureValid(ocspResp, anchor = (X509Certificate)this.rootStore.getCertificate(alias))) continue;
                return true;
            }
            catch (GeneralSecurityException generalSecurityException) {
                try {
                }
                catch (GeneralSecurityException e) {
                    return false;
                }
            }
        }
        return false;
    }

    public boolean isSignatureValid(BasicOCSPResp ocspResp, Certificate responderCert) {
        try {
            ContentVerifierProvider verifierProvider = new JcaContentVerifierProviderBuilder().setProvider("KGBC").build(responderCert.getPublicKey());
            return ocspResp.isSignatureValid(verifierProvider);
        }
        catch (OperatorCreationException e) {
            return false;
        }
        catch (OCSPException e) {
            return false;
        }
    }

    public BasicOCSPResp getOcspResponse(X509Certificate signCert, X509Certificate issuerCert) {
        if (signCert == null && issuerCert == null) {
            return null;
        }
        OcspClientBouncyCastle ocsp = new OcspClientBouncyCastle();
        BasicOCSPResp ocspResp = ocsp.getBasicOCSPResp(signCert, issuerCert, null);
        if (ocspResp == null) {
            return null;
        }
        SingleResp[] resp = ocspResp.getResponses();
        int i = 0;
        while (i < resp.length) {
            CertificateStatus status = resp[i].getCertStatus();
            if (status == CertificateStatus.GOOD) {
                return ocspResp;
            }
            ++i;
        }
        return null;
    }
}

