/*
 * Decompiled with CFR 0.152.
 */
package com.KGitextpdf.text.pdf.parser;

import com.KGitextpdf.text.pdf.parser.ImageRenderInfo;
import com.KGitextpdf.text.pdf.parser.RenderFilter;
import com.KGitextpdf.text.pdf.parser.RenderListener;
import com.KGitextpdf.text.pdf.parser.TextRenderInfo;
import java.util.ArrayList;
import java.util.List;

public class MultiFilteredRenderListener
implements RenderListener {
    private final List<RenderListener> delegates = new ArrayList<RenderListener>();
    private final List<RenderFilter[]> filters = new ArrayList<RenderFilter[]>();

    public <E extends RenderListener> E attachRenderListener(E delegate, RenderFilter ... filterSet) {
        this.delegates.add(delegate);
        this.filters.add(filterSet);
        return delegate;
    }

    @Override
    public void beginTextBlock() {
        for (RenderListener delegate : this.delegates) {
            delegate.beginTextBlock();
        }
    }

    @Override
    public void renderText(TextRenderInfo renderInfo) {
        int i = 0;
        while (i < this.delegates.size()) {
            boolean filtersPassed = true;
            RenderFilter[] renderFilterArray = this.filters.get(i);
            int n = renderFilterArray.length;
            int n2 = 0;
            while (n2 < n) {
                RenderFilter filter = renderFilterArray[n2];
                if (!filter.allowText(renderInfo)) {
                    filtersPassed = false;
                    break;
                }
                ++n2;
            }
            if (filtersPassed) {
                this.delegates.get(i).renderText(renderInfo);
            }
            ++i;
        }
    }

    @Override
    public void endTextBlock() {
        for (RenderListener delegate : this.delegates) {
            delegate.endTextBlock();
        }
    }

    @Override
    public void renderImage(ImageRenderInfo renderInfo) {
        int i = 0;
        while (i < this.delegates.size()) {
            boolean filtersPassed = true;
            RenderFilter[] renderFilterArray = this.filters.get(i);
            int n = renderFilterArray.length;
            int n2 = 0;
            while (n2 < n) {
                RenderFilter filter = renderFilterArray[n2];
                if (!filter.allowImage(renderInfo)) {
                    filtersPassed = false;
                    break;
                }
                ++n2;
            }
            if (filtersPassed) {
                this.delegates.get(i).renderImage(renderInfo);
            }
            ++i;
        }
    }
}

