/*
 * Decompiled with CFR 0.152.
 */
package com.KGitextpdf.text.pdf.parser;

import com.KGitextpdf.text.pdf.parser.ImageRenderInfo;
import com.KGitextpdf.text.pdf.parser.RenderFilter;
import com.KGitextpdf.text.pdf.parser.RenderListener;
import com.KGitextpdf.text.pdf.parser.TextRenderInfo;

public class FilteredRenderListener
implements RenderListener {
    private final RenderListener delegate;
    private final RenderFilter[] filters;

    public FilteredRenderListener(RenderListener delegate, RenderFilter ... filters) {
        this.delegate = delegate;
        this.filters = filters;
    }

    @Override
    public void renderText(TextRenderInfo renderInfo) {
        RenderFilter[] renderFilterArray = this.filters;
        int n = this.filters.length;
        int n2 = 0;
        while (n2 < n) {
            RenderFilter filter = renderFilterArray[n2];
            if (!filter.allowText(renderInfo)) {
                return;
            }
            ++n2;
        }
        this.delegate.renderText(renderInfo);
    }

    @Override
    public void beginTextBlock() {
        this.delegate.beginTextBlock();
    }

    @Override
    public void endTextBlock() {
        this.delegate.endTextBlock();
    }

    @Override
    public void renderImage(ImageRenderInfo renderInfo) {
        RenderFilter[] renderFilterArray = this.filters;
        int n = this.filters.length;
        int n2 = 0;
        while (n2 < n) {
            RenderFilter filter = renderFilterArray[n2];
            if (!filter.allowImage(renderInfo)) {
                return;
            }
            ++n2;
        }
        this.delegate.renderImage(renderInfo);
    }
}

