/*
 * Decompiled with CFR 0.152.
 */
package com.KGitextpdf.text.pdf.parser;

import com.KGitextpdf.text.pdf.PRIndirectReference;
import com.KGitextpdf.text.pdf.PRStream;
import com.KGitextpdf.text.pdf.PdfArray;
import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfObject;
import com.KGitextpdf.text.pdf.PdfReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ListIterator;

public class ContentByteUtils {
    private ContentByteUtils() {
    }

    public static byte[] getContentBytesFromContentObject(PdfObject contentObject) throws IOException {
        byte[] result;
        switch (contentObject.type()) {
            case 10: {
                PRIndirectReference ref = (PRIndirectReference)contentObject;
                PdfObject directObject = PdfReader.getPdfObjectRelease(ref);
                result = ContentByteUtils.getContentBytesFromContentObject(directObject);
                break;
            }
            case 7: {
                PRStream stream = (PRStream)PdfReader.getPdfObjectRelease(contentObject);
                result = PdfReader.getStreamBytes(stream);
                break;
            }
            case 5: {
                ByteArrayOutputStream allBytes = new ByteArrayOutputStream();
                PdfArray contentArray = (PdfArray)contentObject;
                ListIterator<PdfObject> iter = contentArray.listIterator();
                while (iter.hasNext()) {
                    PdfObject element = iter.next();
                    allBytes.write(ContentByteUtils.getContentBytesFromContentObject(element));
                    allBytes.write(32);
                }
                result = allBytes.toByteArray();
                break;
            }
            default: {
                String msg = "Unable to handle Content of type " + contentObject.getClass();
                throw new IllegalStateException(msg);
            }
        }
        return result;
    }

    public static byte[] getContentBytesForPage(PdfReader reader, int pageNum) throws IOException {
        PdfDictionary pageDictionary = reader.getPageN(pageNum);
        PdfObject contentObject = pageDictionary.get(PdfName.CONTENTS);
        if (contentObject == null) {
            return new byte[0];
        }
        byte[] contentBytes = ContentByteUtils.getContentBytesFromContentObject(contentObject);
        return contentBytes;
    }
}

