/*
 * Decompiled with CFR 0.152.
 */
package com.KGitextpdf.text.pdf.internal;

import com.KGitextpdf.text.BaseColor;
import com.KGitextpdf.text.error_messages.MessageLocalization;
import com.KGitextpdf.text.pdf.BaseFont;
import com.KGitextpdf.text.pdf.ExtendedColor;
import com.KGitextpdf.text.pdf.PatternColor;
import com.KGitextpdf.text.pdf.PdfArray;
import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfGState;
import com.KGitextpdf.text.pdf.PdfImage;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfNumber;
import com.KGitextpdf.text.pdf.PdfObject;
import com.KGitextpdf.text.pdf.PdfWriter;
import com.KGitextpdf.text.pdf.PdfXConformanceException;
import com.KGitextpdf.text.pdf.ShadingColor;
import com.KGitextpdf.text.pdf.SpotColor;
import com.KGitextpdf.text.pdf.interfaces.PdfXConformance;

public class PdfXConformanceImp
implements PdfXConformance {
    protected int pdfxConformance = 0;
    protected PdfWriter writer;

    public PdfXConformanceImp(PdfWriter writer) {
        this.writer = writer;
    }

    @Override
    public void setPDFXConformance(int pdfxConformance) {
        this.pdfxConformance = pdfxConformance;
    }

    @Override
    public int getPDFXConformance() {
        return this.pdfxConformance;
    }

    @Override
    public boolean isPdfIso() {
        return this.isPdfX();
    }

    @Override
    public boolean isPdfX() {
        return this.pdfxConformance != 0;
    }

    public boolean isPdfX1A2001() {
        return this.pdfxConformance == 1;
    }

    public boolean isPdfX32002() {
        return this.pdfxConformance == 2;
    }

    @Override
    public void checkPdfIsoConformance(int key, Object obj1) {
        if (this.writer == null || !this.writer.isPdfX()) {
            return;
        }
        int conf = this.writer.getPDFXConformance();
        block0 : switch (key) {
            case 1: {
                switch (conf) {
                    case 1: {
                        if (obj1 instanceof ExtendedColor) {
                            ExtendedColor ec = (ExtendedColor)obj1;
                            switch (ec.getType()) {
                                case 1: 
                                case 2: {
                                    return;
                                }
                                case 0: {
                                    throw new PdfXConformanceException(MessageLocalization.getComposedMessage("colorspace.rgb.is.not.allowed", new Object[0]));
                                }
                                case 3: {
                                    SpotColor sc = (SpotColor)ec;
                                    this.checkPdfIsoConformance(1, sc.getPdfSpotColor().getAlternativeCS());
                                    break;
                                }
                                case 5: {
                                    ShadingColor xc = (ShadingColor)ec;
                                    this.checkPdfIsoConformance(1, xc.getPdfShadingPattern().getShading().getColorSpace());
                                    break;
                                }
                                case 4: {
                                    PatternColor pc = (PatternColor)ec;
                                    this.checkPdfIsoConformance(1, pc.getPainter().getDefaultColor());
                                }
                            }
                            break block0;
                        }
                        if (!(obj1 instanceof BaseColor)) break block0;
                        throw new PdfXConformanceException(MessageLocalization.getComposedMessage("colorspace.rgb.is.not.allowed", new Object[0]));
                    }
                }
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                if (conf != 1) break;
                throw new PdfXConformanceException(MessageLocalization.getComposedMessage("colorspace.rgb.is.not.allowed", new Object[0]));
            }
            case 4: {
                if (((BaseFont)obj1).isEmbedded()) break;
                throw new PdfXConformanceException(MessageLocalization.getComposedMessage("all.the.fonts.must.be.embedded.this.one.isn.t.1", ((BaseFont)obj1).getPostscriptFontName()));
            }
            case 5: {
                PdfImage image = (PdfImage)obj1;
                if (image.get(PdfName.SMASK) != null) {
                    throw new PdfXConformanceException(MessageLocalization.getComposedMessage("the.smask.key.is.not.allowed.in.images", new Object[0]));
                }
                switch (conf) {
                    case 1: {
                        PdfObject cs = image.get(PdfName.COLORSPACE);
                        if (cs == null) {
                            return;
                        }
                        if (cs.isName()) {
                            if (!PdfName.DEVICERGB.equals(cs)) break block0;
                            throw new PdfXConformanceException(MessageLocalization.getComposedMessage("colorspace.rgb.is.not.allowed", new Object[0]));
                        }
                        if (!cs.isArray() || !PdfName.CALRGB.equals(((PdfArray)cs).getPdfObject(0))) break block0;
                        throw new PdfXConformanceException(MessageLocalization.getComposedMessage("colorspace.calrgb.is.not.allowed", new Object[0]));
                    }
                }
                break;
            }
            case 6: {
                PdfDictionary gs = (PdfDictionary)obj1;
                if (gs == null) break;
                PdfObject obj = gs.get(PdfName.BM);
                if (obj != null && !PdfGState.BM_NORMAL.equals(obj) && !PdfGState.BM_COMPATIBLE.equals(obj)) {
                    throw new PdfXConformanceException(MessageLocalization.getComposedMessage("blend.mode.1.not.allowed", obj.toString()));
                }
                obj = gs.get(PdfName.CA);
                double v = 0.0;
                if (obj != null && (v = ((PdfNumber)obj).doubleValue()) != 1.0) {
                    throw new PdfXConformanceException(MessageLocalization.getComposedMessage("transparency.is.not.allowed.ca.eq.1", String.valueOf(v)));
                }
                obj = gs.get(PdfName.ca);
                v = 0.0;
                if (obj == null || (v = ((PdfNumber)obj).doubleValue()) == 1.0) break;
                throw new PdfXConformanceException(MessageLocalization.getComposedMessage("transparency.is.not.allowed.ca.eq.1", String.valueOf(v)));
            }
            case 7: {
                throw new PdfXConformanceException(MessageLocalization.getComposedMessage("layers.are.not.allowed", new Object[0]));
            }
        }
    }
}

