/*
 * Decompiled with CFR 0.152.
 */
package com.KGitextpdf.text.pdf.fonts.otf;

import com.KGitextpdf.text.io.RandomAccessSourceFactory;
import com.KGitextpdf.text.log.Logger;
import com.KGitextpdf.text.log.LoggerFactory;
import com.KGitextpdf.text.pdf.RandomAccessFileOrArray;
import com.KGitextpdf.text.pdf.fonts.otf.FontReadingException;
import com.KGitextpdf.text.pdf.fonts.otf.Language;
import com.KGitextpdf.text.pdf.fonts.otf.TableHeader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class OpenTypeFontTableReader {
    protected static final Logger LOG = LoggerFactory.getLogger(OpenTypeFontTableReader.class);
    protected final RandomAccessFileOrArray rf;
    protected final int tableLocation;
    private List<String> supportedLanguages;

    public OpenTypeFontTableReader(String fontFilePath, int tableLocation) throws IOException {
        this.rf = new RandomAccessFileOrArray(new RandomAccessSourceFactory().createBestSource(fontFilePath));
        this.tableLocation = tableLocation;
    }

    public Language getSupportedLanguage() throws FontReadingException {
        Language[] allLangs = Language.values();
        for (String supportedLang : this.supportedLanguages) {
            Language[] languageArray = allLangs;
            int n = allLangs.length;
            int n2 = 0;
            while (n2 < n) {
                Language lang = languageArray[n2];
                if (lang.isSupported(supportedLang)) {
                    return lang;
                }
                ++n2;
            }
        }
        throw new FontReadingException("Unsupported languages " + this.supportedLanguages);
    }

    protected final void startReadingTable() throws FontReadingException {
        try {
            TableHeader header = this.readHeader();
            this.readScriptListTable(this.tableLocation + header.scriptListOffset);
            this.readFeatureListTable(this.tableLocation + header.featureListOffset);
            this.readLookupListTable(this.tableLocation + header.lookupListOffset);
        }
        catch (IOException e) {
            throw new FontReadingException("Error reading font file", e);
        }
    }

    protected abstract void readSubTable(int var1, int var2) throws IOException;

    private void readLookupListTable(int lookupListTableLocation) throws IOException {
        int lookupTableOffset;
        this.rf.seek(lookupListTableLocation);
        int lookupCount = this.rf.readShort();
        ArrayList<Integer> lookupTableOffsets = new ArrayList<Integer>();
        int i = 0;
        while (i < lookupCount) {
            lookupTableOffset = this.rf.readShort();
            lookupTableOffsets.add(lookupTableOffset);
            ++i;
        }
        i = 0;
        while (i < lookupCount) {
            lookupTableOffset = (Integer)lookupTableOffsets.get(i);
            this.readLookupTable(lookupListTableLocation + lookupTableOffset);
            ++i;
        }
    }

    private void readLookupTable(int lookupTableLocation) throws IOException {
        this.rf.seek(lookupTableLocation);
        short lookupType = this.rf.readShort();
        this.rf.skipBytes(2);
        int subTableCount = this.rf.readShort();
        ArrayList<Integer> subTableOffsets = new ArrayList<Integer>();
        int i = 0;
        while (i < subTableCount) {
            short subTableOffset = this.rf.readShort();
            subTableOffsets.add(Integer.valueOf(subTableOffset));
            ++i;
        }
        Iterator iterator = subTableOffsets.iterator();
        while (iterator.hasNext()) {
            int subTableOffset = (Integer)iterator.next();
            this.readSubTable(lookupType, lookupTableLocation + subTableOffset);
        }
    }

    protected final List<Integer> readCoverageFormat(int coverageLocation) throws IOException {
        ArrayList<Integer> glyphIds;
        this.rf.seek(coverageLocation);
        short coverageFormat = this.rf.readShort();
        if (coverageFormat == 1) {
            int glyphCount = this.rf.readShort();
            glyphIds = new ArrayList<Integer>(glyphCount);
            int i = 0;
            while (i < glyphCount) {
                short coverageGlyphId = this.rf.readShort();
                glyphIds.add(Integer.valueOf(coverageGlyphId));
                ++i;
            }
        } else if (coverageFormat == 2) {
            int rangeCount = this.rf.readShort();
            glyphIds = new ArrayList();
            int i = 0;
            while (i < rangeCount) {
                this.readRangeRecord(glyphIds);
                ++i;
            }
        } else {
            throw new UnsupportedOperationException("Invalid coverage format: " + coverageFormat);
        }
        return Collections.unmodifiableList(glyphIds);
    }

    private void readRangeRecord(List<Integer> glyphIds) throws IOException {
        int startGlyphId = this.rf.readShort();
        short endGlyphId = this.rf.readShort();
        short startCoverageIndex = this.rf.readShort();
        int glyphId = startGlyphId;
        while (glyphId <= endGlyphId) {
            glyphIds.add(glyphId);
            ++glyphId;
        }
    }

    private void readScriptListTable(int scriptListTableLocationOffset) throws IOException {
        this.rf.seek(scriptListTableLocationOffset);
        int scriptCount = this.rf.readShort();
        HashMap<String, Integer> scriptRecords = new HashMap<String, Integer>(scriptCount);
        int i = 0;
        while (i < scriptCount) {
            this.readScriptRecord(scriptListTableLocationOffset, scriptRecords);
            ++i;
        }
        ArrayList<String> supportedLanguages = new ArrayList<String>(scriptCount);
        for (String scriptName : scriptRecords.keySet()) {
            this.readScriptTable((Integer)scriptRecords.get(scriptName));
            supportedLanguages.add(scriptName);
        }
        this.supportedLanguages = Collections.unmodifiableList(supportedLanguages);
    }

    private void readScriptRecord(int scriptListTableLocationOffset, Map<String, Integer> scriptRecords) throws IOException {
        String scriptTag = this.rf.readString(4, "utf-8");
        short scriptOffset = this.rf.readShort();
        scriptRecords.put(scriptTag, scriptListTableLocationOffset + scriptOffset);
    }

    private void readScriptTable(int scriptTableLocationOffset) throws IOException {
        this.rf.seek(scriptTableLocationOffset);
        short defaultLangSys = this.rf.readShort();
        int langSysCount = this.rf.readShort();
        if (langSysCount > 0) {
            LinkedHashMap<String, Integer> langSysRecords = new LinkedHashMap<String, Integer>(langSysCount);
            int i = 0;
            while (i < langSysCount) {
                this.readLangSysRecord(langSysRecords);
                ++i;
            }
            for (String langSysTag : langSysRecords.keySet()) {
                this.readLangSysTable(scriptTableLocationOffset + (Integer)langSysRecords.get(langSysTag));
            }
        }
        this.readLangSysTable(scriptTableLocationOffset + defaultLangSys);
    }

    private void readLangSysRecord(Map<String, Integer> langSysRecords) throws IOException {
        String langSysTag = this.rf.readString(4, "utf-8");
        short langSys = this.rf.readShort();
        langSysRecords.put(langSysTag, Integer.valueOf(langSys));
    }

    private void readLangSysTable(int langSysTableLocationOffset) throws IOException {
        this.rf.seek(langSysTableLocationOffset);
        short lookupOrderOffset = this.rf.readShort();
        LOG.debug("lookupOrderOffset=" + lookupOrderOffset);
        short reqFeatureIndex = this.rf.readShort();
        LOG.debug("reqFeatureIndex=" + reqFeatureIndex);
        int featureCount = this.rf.readShort();
        ArrayList<Short> featureListIndices = new ArrayList<Short>(featureCount);
        int i = 0;
        while (i < featureCount) {
            featureListIndices.add(this.rf.readShort());
            ++i;
        }
        LOG.debug("featureListIndices=" + featureListIndices);
    }

    private void readFeatureListTable(int featureListTableLocationOffset) throws IOException {
        this.rf.seek(featureListTableLocationOffset);
        int featureCount = this.rf.readShort();
        LOG.debug("featureCount=" + featureCount);
        LinkedHashMap<String, Short> featureRecords = new LinkedHashMap<String, Short>(featureCount);
        int i = 0;
        while (i < featureCount) {
            featureRecords.put(this.rf.readString(4, "utf-8"), this.rf.readShort());
            ++i;
        }
        for (String featureName : featureRecords.keySet()) {
            LOG.debug("*************featureName=" + featureName);
            this.readFeatureTable(featureListTableLocationOffset + (Short)featureRecords.get(featureName));
        }
    }

    private void readFeatureTable(int featureTableLocationOffset) throws IOException {
        this.rf.seek(featureTableLocationOffset);
        short featureParamsOffset = this.rf.readShort();
        LOG.debug("featureParamsOffset=" + featureParamsOffset);
        int lookupCount = this.rf.readShort();
        LOG.debug("lookupCount=" + lookupCount);
        ArrayList<Short> lookupListIndices = new ArrayList<Short>(lookupCount);
        int i = 0;
        while (i < lookupCount) {
            lookupListIndices.add(this.rf.readShort());
            ++i;
        }
    }

    private TableHeader readHeader() throws IOException {
        this.rf.seek(this.tableLocation);
        int version = this.rf.readInt();
        int scriptListOffset = this.rf.readUnsignedShort();
        int featureListOffset = this.rf.readUnsignedShort();
        int lookupListOffset = this.rf.readUnsignedShort();
        TableHeader header = new TableHeader(version, scriptListOffset, featureListOffset, lookupListOffset);
        return header;
    }
}

