/*
 * Decompiled with CFR 0.152.
 */
package com.KGitextpdf.text.pdf.fonts.otf;

import com.KGitextpdf.text.pdf.fonts.otf.FontReadingException;
import com.KGitextpdf.text.pdf.fonts.otf.OpenTypeFontTableReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class GlyphPositioningTableReader
extends OpenTypeFontTableReader {
    public GlyphPositioningTableReader(String fontFilePath, int gposTableLocation) throws IOException {
        super(fontFilePath, gposTableLocation);
    }

    public void read() throws FontReadingException {
        this.startReadingTable();
    }

    @Override
    protected void readSubTable(int lookupType, int subTableLocation) throws IOException {
        if (lookupType == 1) {
            this.readLookUpType_1(subTableLocation);
        } else if (lookupType == 4) {
            this.readLookUpType_4(subTableLocation);
        } else if (lookupType == 8) {
            this.readLookUpType_8(subTableLocation);
        } else {
            System.err.println("The lookupType " + lookupType + " is not yet supported by " + GlyphPositioningTableReader.class.getSimpleName());
        }
    }

    private void readLookUpType_1(int lookupTableLocation) throws IOException {
        this.rf.seek(lookupTableLocation);
        short posFormat = this.rf.readShort();
        if (posFormat == 1) {
            LOG.debug("Reading `Look Up Type 1, Format 1` ....");
            short coverageOffset = this.rf.readShort();
            short valueFormat = this.rf.readShort();
            if ((valueFormat & 1) == 1) {
                short xPlacement = this.rf.readShort();
                LOG.debug("xPlacement=" + xPlacement);
            }
            if ((valueFormat & 2) == 2) {
                short yPlacement = this.rf.readShort();
                LOG.debug("yPlacement=" + yPlacement);
            }
            List<Integer> glyphCodes = this.readCoverageFormat(lookupTableLocation + coverageOffset);
            LOG.debug("glyphCodes=" + glyphCodes);
        } else {
            System.err.println("The PosFormat " + posFormat + " for `LookupType 1` is not yet supported by " + GlyphPositioningTableReader.class.getSimpleName());
        }
    }

    private void readLookUpType_4(int lookupTableLocation) throws IOException {
        this.rf.seek(lookupTableLocation);
        short posFormat = this.rf.readShort();
        if (posFormat == 1) {
            LOG.debug("Reading `Look Up Type 4, Format 1` ....");
            short markCoverageOffset = this.rf.readShort();
            short baseCoverageOffset = this.rf.readShort();
            short classCount = this.rf.readShort();
            short markArrayOffset = this.rf.readShort();
            short baseArrayOffset = this.rf.readShort();
            List<Integer> markCoverages = this.readCoverageFormat(lookupTableLocation + markCoverageOffset);
            LOG.debug("markCoverages=" + markCoverages);
            List<Integer> baseCoverages = this.readCoverageFormat(lookupTableLocation + baseCoverageOffset);
            LOG.debug("baseCoverages=" + baseCoverages);
            this.readMarkArrayTable(lookupTableLocation + markArrayOffset);
            this.readBaseArrayTable(lookupTableLocation + baseArrayOffset, classCount);
        } else {
            System.err.println("The posFormat " + posFormat + " is not supported by " + GlyphPositioningTableReader.class.getSimpleName());
        }
    }

    private void readLookUpType_8(int lookupTableLocation) throws IOException {
        this.rf.seek(lookupTableLocation);
        short posFormat = this.rf.readShort();
        if (posFormat == 3) {
            LOG.debug("Reading `Look Up Type 8, Format 3` ....");
            this.readChainingContextPositioningFormat_3(lookupTableLocation);
        } else {
            System.err.println("The posFormat " + posFormat + " for `Look Up Type 8` is not supported by " + GlyphPositioningTableReader.class.getSimpleName());
        }
    }

    private void readChainingContextPositioningFormat_3(int lookupTableLocation) throws IOException {
        int backtrackGlyphCount = this.rf.readShort();
        LOG.debug("backtrackGlyphCount=" + backtrackGlyphCount);
        ArrayList<Integer> backtrackGlyphOffsets = new ArrayList<Integer>(backtrackGlyphCount);
        int i = 0;
        while (i < backtrackGlyphCount) {
            short backtrackGlyphOffset = this.rf.readShort();
            backtrackGlyphOffsets.add(Integer.valueOf(backtrackGlyphOffset));
            ++i;
        }
        int inputGlyphCount = this.rf.readShort();
        LOG.debug("inputGlyphCount=" + inputGlyphCount);
        ArrayList<Integer> inputGlyphOffsets = new ArrayList<Integer>(inputGlyphCount);
        int i2 = 0;
        while (i2 < inputGlyphCount) {
            short inputGlyphOffset = this.rf.readShort();
            inputGlyphOffsets.add(Integer.valueOf(inputGlyphOffset));
            ++i2;
        }
        int lookaheadGlyphCount = this.rf.readShort();
        LOG.debug("lookaheadGlyphCount=" + lookaheadGlyphCount);
        ArrayList<Integer> lookaheadGlyphOffsets = new ArrayList<Integer>(lookaheadGlyphCount);
        int i3 = 0;
        while (i3 < lookaheadGlyphCount) {
            short lookaheadGlyphOffset = this.rf.readShort();
            lookaheadGlyphOffsets.add(Integer.valueOf(lookaheadGlyphOffset));
            ++i3;
        }
        int posCount = this.rf.readShort();
        LOG.debug("posCount=" + posCount);
        ArrayList<PosLookupRecord> posLookupRecords = new ArrayList<PosLookupRecord>(posCount);
        int i4 = 0;
        while (i4 < posCount) {
            short sequenceIndex = this.rf.readShort();
            short lookupListIndex = this.rf.readShort();
            LOG.debug("sequenceIndex=" + sequenceIndex + ", lookupListIndex=" + lookupListIndex);
            posLookupRecords.add(new PosLookupRecord(sequenceIndex, lookupListIndex));
            ++i4;
        }
        Iterator iterator = backtrackGlyphOffsets.iterator();
        while (iterator.hasNext()) {
            int backtrackGlyphOffset = (Integer)iterator.next();
            List<Integer> backtrackGlyphs = this.readCoverageFormat(lookupTableLocation + backtrackGlyphOffset);
            LOG.debug("backtrackGlyphs=" + backtrackGlyphs);
        }
        iterator = inputGlyphOffsets.iterator();
        while (iterator.hasNext()) {
            int inputGlyphOffset = (Integer)iterator.next();
            List<Integer> inputGlyphs = this.readCoverageFormat(lookupTableLocation + inputGlyphOffset);
            LOG.debug("inputGlyphs=" + inputGlyphs);
        }
        iterator = lookaheadGlyphOffsets.iterator();
        while (iterator.hasNext()) {
            int lookaheadGlyphOffset = (Integer)iterator.next();
            List<Integer> lookaheadGlyphs = this.readCoverageFormat(lookupTableLocation + lookaheadGlyphOffset);
            LOG.debug("lookaheadGlyphs=" + lookaheadGlyphs);
        }
    }

    private void readMarkArrayTable(int markArrayLocation) throws IOException {
        this.rf.seek(markArrayLocation);
        int markCount = this.rf.readShort();
        ArrayList<MarkRecord> markRecords = new ArrayList<MarkRecord>();
        int i = 0;
        while (i < markCount) {
            markRecords.add(this.readMarkRecord());
            ++i;
        }
        for (MarkRecord markRecord : markRecords) {
            this.readAnchorTable(markArrayLocation + markRecord.markAnchorOffset);
        }
    }

    private MarkRecord readMarkRecord() throws IOException {
        short markClass = this.rf.readShort();
        short markAnchorOffset = this.rf.readShort();
        return new MarkRecord(markClass, markAnchorOffset);
    }

    private void readAnchorTable(int anchorTableLocation) throws IOException {
        this.rf.seek(anchorTableLocation);
        short anchorFormat = this.rf.readShort();
        if (anchorFormat != 1) {
            System.err.println("The extra features of the AnchorFormat " + anchorFormat + " will not be used");
        }
        short x = this.rf.readShort();
        short y = this.rf.readShort();
    }

    private void readBaseArrayTable(int baseArrayTableLocation, int classCount) throws IOException {
        this.rf.seek(baseArrayTableLocation);
        int baseCount = this.rf.readShort();
        HashSet<Integer> baseAnchors = new HashSet<Integer>();
        int i = 0;
        while (i < baseCount) {
            int k = 0;
            while (k < classCount) {
                short baseAnchor = this.rf.readShort();
                baseAnchors.add(Integer.valueOf(baseAnchor));
                ++k;
            }
            ++i;
        }
        Iterator iterator = baseAnchors.iterator();
        while (iterator.hasNext()) {
            int baseAnchor = (Integer)iterator.next();
            this.readAnchorTable(baseArrayTableLocation + baseAnchor);
        }
    }

    static class MarkRecord {
        final int markClass;
        final int markAnchorOffset;

        public MarkRecord(int markClass, int markAnchorOffset) {
            this.markClass = markClass;
            this.markAnchorOffset = markAnchorOffset;
        }
    }

    static class PosLookupRecord {
        final int sequenceIndex;
        final int lookupListIndex;

        public PosLookupRecord(int sequenceIndex, int lookupListIndex) {
            this.sequenceIndex = sequenceIndex;
            this.lookupListIndex = lookupListIndex;
        }
    }
}

