/*
 * Decompiled with CFR 0.152.
 */
package com.KGitextpdf.text.pdf;

import com.KGitextpdf.text.BaseColor;
import com.KGitextpdf.text.error_messages.MessageLocalization;
import com.KGitextpdf.text.pdf.CMYKColor;
import com.KGitextpdf.text.pdf.ExtendedColor;
import com.KGitextpdf.text.pdf.GrayColor;
import com.KGitextpdf.text.pdf.PdfArray;
import com.KGitextpdf.text.pdf.PdfFunction;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfObject;
import com.KGitextpdf.text.pdf.PdfWriter;

public class PdfSpotColor {
    public PdfName name;
    public BaseColor altcs;

    public PdfSpotColor(String name, BaseColor altcs) {
        this.name = new PdfName(name);
        this.altcs = altcs;
    }

    public BaseColor getAlternativeCS() {
        return this.altcs;
    }

    protected PdfObject getSpotObject(PdfWriter writer) {
        PdfFunction func;
        PdfArray array;
        block5: {
            block4: {
                array = new PdfArray(PdfName.SEPARATION);
                array.add(this.name);
                func = null;
                if (!(this.altcs instanceof ExtendedColor)) break block4;
                int type = ((ExtendedColor)this.altcs).type;
                switch (type) {
                    case 1: {
                        array.add(PdfName.DEVICEGRAY);
                        func = PdfFunction.type2(writer, new float[]{0.0f, 1.0f}, null, new float[]{0.0f}, new float[]{((GrayColor)this.altcs).getGray()}, 1.0f);
                        break block5;
                    }
                    case 2: {
                        array.add(PdfName.DEVICECMYK);
                        CMYKColor cmyk = (CMYKColor)this.altcs;
                        func = PdfFunction.type2(writer, new float[]{0.0f, 1.0f}, null, new float[]{0.0f, 0.0f, 0.0f, 0.0f}, new float[]{cmyk.getCyan(), cmyk.getMagenta(), cmyk.getYellow(), cmyk.getBlack()}, 1.0f);
                        break block5;
                    }
                    default: {
                        throw new RuntimeException(MessageLocalization.getComposedMessage("only.rgb.gray.and.cmyk.are.supported.as.alternative.color.spaces", new Object[0]));
                    }
                }
            }
            array.add(PdfName.DEVICERGB);
            func = PdfFunction.type2(writer, new float[]{0.0f, 1.0f}, null, new float[]{1.0f, 1.0f, 1.0f}, new float[]{(float)this.altcs.getRed() / 255.0f, (float)this.altcs.getGreen() / 255.0f, (float)this.altcs.getBlue() / 255.0f}, 1.0f);
        }
        array.add(func.getReference());
        return array;
    }

    public boolean equals(Object obj) {
        return obj instanceof PdfSpotColor && ((PdfSpotColor)obj).name == this.name && ((PdfSpotColor)obj).altcs == this.altcs;
    }
}

