/*
 * Decompiled with CFR 0.152.
 */
package com.KGitextpdf.text.pdf;

import com.KGitextpdf.text.ExceptionConverter;
import com.KGitextpdf.text.pdf.BaseFont;

class PdfFont
implements Comparable<PdfFont> {
    private BaseFont font;
    private float size;
    protected float hScale = 1.0f;

    PdfFont(BaseFont bf, float size) {
        this.size = size;
        this.font = bf;
    }

    @Override
    public int compareTo(PdfFont pdfFont) {
        block5: {
            if (pdfFont == null) {
                return -1;
            }
            try {
                if (this.font == pdfFont.font) break block5;
                return 1;
            }
            catch (ClassCastException cce) {
                return -2;
            }
        }
        if (this.size() != pdfFont.size()) {
            return 2;
        }
        return 0;
    }

    float size() {
        return this.size;
    }

    float width() {
        return this.width(32);
    }

    float width(int character) {
        return this.font.getWidthPoint(character, this.size) * this.hScale;
    }

    float width(String s) {
        return this.font.getWidthPoint(s, this.size) * this.hScale;
    }

    BaseFont getFont() {
        return this.font;
    }

    static PdfFont getDefaultFont() {
        try {
            BaseFont bf = BaseFont.createFont("Helvetica", "Cp1252", false);
            return new PdfFont(bf, 12.0f);
        }
        catch (Exception ee) {
            throw new ExceptionConverter(ee);
        }
    }

    void setHorizontalScaling(float hScale) {
        this.hScale = hScale;
    }

    float getHorizontalScaling() {
        return this.hScale;
    }
}

