/*
 * Decompiled with CFR 0.152.
 */
package com.KGitextpdf.text.pdf;

import com.KGitextpdf.text.DocumentException;
import com.KGitextpdf.text.ExceptionConverter;
import com.KGitextpdf.text.Utilities;
import com.KGitextpdf.text.io.RandomAccessSourceFactory;
import com.KGitextpdf.text.pdf.BaseFont;
import com.KGitextpdf.text.pdf.CJKFont;
import com.KGitextpdf.text.pdf.GlyphList;
import com.KGitextpdf.text.pdf.IntHashtable;
import com.KGitextpdf.text.pdf.PRIndirectReference;
import com.KGitextpdf.text.pdf.PRStream;
import com.KGitextpdf.text.pdf.PRTokeniser;
import com.KGitextpdf.text.pdf.PdfArray;
import com.KGitextpdf.text.pdf.PdfContentParser;
import com.KGitextpdf.text.pdf.PdfDictionary;
import com.KGitextpdf.text.pdf.PdfEncodings;
import com.KGitextpdf.text.pdf.PdfIndirectReference;
import com.KGitextpdf.text.pdf.PdfName;
import com.KGitextpdf.text.pdf.PdfNumber;
import com.KGitextpdf.text.pdf.PdfObject;
import com.KGitextpdf.text.pdf.PdfReader;
import com.KGitextpdf.text.pdf.PdfStream;
import com.KGitextpdf.text.pdf.PdfString;
import com.KGitextpdf.text.pdf.PdfWriter;
import com.KGitextpdf.text.pdf.RandomAccessFileOrArray;
import com.KGitextpdf.text.pdf.fonts.cmaps.CMapParserEx;
import com.KGitextpdf.text.pdf.fonts.cmaps.CMapToUnicode;
import com.KGitextpdf.text.pdf.fonts.cmaps.CidLocationFromByte;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class DocumentFont
extends BaseFont {
    private HashMap<Integer, int[]> metrics = new HashMap();
    private String fontName;
    private PRIndirectReference refFont;
    private PdfDictionary font;
    private IntHashtable uni2byte = new IntHashtable();
    private IntHashtable byte2uni = new IntHashtable();
    private IntHashtable diffmap;
    private float ascender = 800.0f;
    private float capHeight = 700.0f;
    private float descender = -200.0f;
    private float italicAngle = 0.0f;
    private float fontWeight = 0.0f;
    private float llx = -50.0f;
    private float lly = -200.0f;
    private float urx = 100.0f;
    private float ury = 900.0f;
    protected boolean isType0 = false;
    protected int defaultWidth = 1000;
    private IntHashtable hMetrics;
    protected String cjkEncoding;
    protected String uniMap;
    private BaseFont cjkMirror;
    private static final int[] stdEnc;

    static {
        int[] nArray = new int[256];
        nArray[32] = 32;
        nArray[33] = 33;
        nArray[34] = 34;
        nArray[35] = 35;
        nArray[36] = 36;
        nArray[37] = 37;
        nArray[38] = 38;
        nArray[39] = 8217;
        nArray[40] = 40;
        nArray[41] = 41;
        nArray[42] = 42;
        nArray[43] = 43;
        nArray[44] = 44;
        nArray[45] = 45;
        nArray[46] = 46;
        nArray[47] = 47;
        nArray[48] = 48;
        nArray[49] = 49;
        nArray[50] = 50;
        nArray[51] = 51;
        nArray[52] = 52;
        nArray[53] = 53;
        nArray[54] = 54;
        nArray[55] = 55;
        nArray[56] = 56;
        nArray[57] = 57;
        nArray[58] = 58;
        nArray[59] = 59;
        nArray[60] = 60;
        nArray[61] = 61;
        nArray[62] = 62;
        nArray[63] = 63;
        nArray[64] = 64;
        nArray[65] = 65;
        nArray[66] = 66;
        nArray[67] = 67;
        nArray[68] = 68;
        nArray[69] = 69;
        nArray[70] = 70;
        nArray[71] = 71;
        nArray[72] = 72;
        nArray[73] = 73;
        nArray[74] = 74;
        nArray[75] = 75;
        nArray[76] = 76;
        nArray[77] = 77;
        nArray[78] = 78;
        nArray[79] = 79;
        nArray[80] = 80;
        nArray[81] = 81;
        nArray[82] = 82;
        nArray[83] = 83;
        nArray[84] = 84;
        nArray[85] = 85;
        nArray[86] = 86;
        nArray[87] = 87;
        nArray[88] = 88;
        nArray[89] = 89;
        nArray[90] = 90;
        nArray[91] = 91;
        nArray[92] = 92;
        nArray[93] = 93;
        nArray[94] = 94;
        nArray[95] = 95;
        nArray[96] = 8216;
        nArray[97] = 97;
        nArray[98] = 98;
        nArray[99] = 99;
        nArray[100] = 100;
        nArray[101] = 101;
        nArray[102] = 102;
        nArray[103] = 103;
        nArray[104] = 104;
        nArray[105] = 105;
        nArray[106] = 106;
        nArray[107] = 107;
        nArray[108] = 108;
        nArray[109] = 109;
        nArray[110] = 110;
        nArray[111] = 111;
        nArray[112] = 112;
        nArray[113] = 113;
        nArray[114] = 114;
        nArray[115] = 115;
        nArray[116] = 116;
        nArray[117] = 117;
        nArray[118] = 118;
        nArray[119] = 119;
        nArray[120] = 120;
        nArray[121] = 121;
        nArray[122] = 122;
        nArray[123] = 123;
        nArray[124] = 124;
        nArray[125] = 125;
        nArray[126] = 126;
        nArray[161] = 161;
        nArray[162] = 162;
        nArray[163] = 163;
        nArray[164] = 8260;
        nArray[165] = 165;
        nArray[166] = 402;
        nArray[167] = 167;
        nArray[168] = 164;
        nArray[169] = 39;
        nArray[170] = 8220;
        nArray[171] = 171;
        nArray[172] = 8249;
        nArray[173] = 8250;
        nArray[174] = 64257;
        nArray[175] = 64258;
        nArray[177] = 8211;
        nArray[178] = 8224;
        nArray[179] = 8225;
        nArray[180] = 183;
        nArray[182] = 182;
        nArray[183] = 8226;
        nArray[184] = 8218;
        nArray[185] = 8222;
        nArray[186] = 8221;
        nArray[187] = 187;
        nArray[188] = 8230;
        nArray[189] = 8240;
        nArray[191] = 191;
        nArray[193] = 96;
        nArray[194] = 180;
        nArray[195] = 710;
        nArray[196] = 732;
        nArray[197] = 175;
        nArray[198] = 728;
        nArray[199] = 729;
        nArray[200] = 168;
        nArray[202] = 730;
        nArray[203] = 184;
        nArray[205] = 733;
        nArray[206] = 731;
        nArray[207] = 711;
        nArray[208] = 8212;
        nArray[225] = 198;
        nArray[227] = 170;
        nArray[232] = 321;
        nArray[233] = 216;
        nArray[234] = 338;
        nArray[235] = 186;
        nArray[241] = 230;
        nArray[245] = 305;
        nArray[248] = 322;
        nArray[249] = 248;
        nArray[250] = 339;
        nArray[251] = 223;
        stdEnc = nArray;
    }

    DocumentFont(PdfDictionary font) {
        this.refFont = null;
        this.font = font;
        this.init();
    }

    DocumentFont(PRIndirectReference refFont) {
        this.refFont = refFont;
        this.font = (PdfDictionary)PdfReader.getPdfObject(refFont);
        this.init();
    }

    public PdfDictionary getFontDictionary() {
        return this.font;
    }

    private void init() {
        this.encoding = "";
        this.fontSpecific = false;
        this.fontType = 4;
        PdfName baseFont = this.font.getAsName(PdfName.BASEFONT);
        this.fontName = baseFont != null ? PdfName.decodeName(baseFont.toString()) : "Unspecified Font Name";
        PdfName subType = this.font.getAsName(PdfName.SUBTYPE);
        if (PdfName.TYPE1.equals(subType) || PdfName.TRUETYPE.equals(subType)) {
            this.doType1TT();
        } else {
            PdfName encodingName = this.font.getAsName(PdfName.ENCODING);
            if (encodingName != null) {
                String enc = PdfName.decodeName(encodingName.toString());
                String ffontname = CJKFont.GetCompatibleFont(enc);
                if (ffontname != null) {
                    try {
                        this.cjkMirror = BaseFont.createFont(ffontname, enc, false);
                    }
                    catch (Exception e) {
                        throw new ExceptionConverter(e);
                    }
                    this.cjkEncoding = enc;
                    this.uniMap = ((CJKFont)this.cjkMirror).getUniMap();
                }
                if (PdfName.TYPE0.equals(subType)) {
                    this.isType0 = true;
                    if (!enc.equals("Identity-H") && this.cjkMirror != null) {
                        PdfArray df = (PdfArray)PdfReader.getPdfObjectRelease(this.font.get(PdfName.DESCENDANTFONTS));
                        PdfDictionary cidft = (PdfDictionary)PdfReader.getPdfObjectRelease(df.getPdfObject(0));
                        PdfNumber dwo = (PdfNumber)PdfReader.getPdfObjectRelease(cidft.get(PdfName.DW));
                        if (dwo != null) {
                            this.defaultWidth = dwo.intValue();
                        }
                        this.hMetrics = this.readWidths((PdfArray)PdfReader.getPdfObjectRelease(cidft.get(PdfName.W)));
                        PdfDictionary fontDesc = (PdfDictionary)PdfReader.getPdfObjectRelease(cidft.get(PdfName.FONTDESCRIPTOR));
                        this.fillFontDesc(fontDesc);
                    } else {
                        this.processType0(this.font);
                    }
                }
            }
        }
    }

    private void processType0(PdfDictionary font) {
        try {
            PdfObject toUniObject = PdfReader.getPdfObjectRelease(font.get(PdfName.TOUNICODE));
            PdfArray df = (PdfArray)PdfReader.getPdfObjectRelease(font.get(PdfName.DESCENDANTFONTS));
            PdfDictionary cidft = (PdfDictionary)PdfReader.getPdfObjectRelease(df.getPdfObject(0));
            PdfNumber dwo = (PdfNumber)PdfReader.getPdfObjectRelease(cidft.get(PdfName.DW));
            int dw = 1000;
            if (dwo != null) {
                dw = dwo.intValue();
            }
            IntHashtable widths = this.readWidths((PdfArray)PdfReader.getPdfObjectRelease(cidft.get(PdfName.W)));
            PdfDictionary fontDesc = (PdfDictionary)PdfReader.getPdfObjectRelease(cidft.get(PdfName.FONTDESCRIPTOR));
            this.fillFontDesc(fontDesc);
            if (toUniObject instanceof PRStream) {
                this.fillMetrics(PdfReader.getStreamBytes((PRStream)toUniObject), widths, dw);
            }
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    private IntHashtable readWidths(PdfArray ws) {
        IntHashtable hh = new IntHashtable();
        if (ws == null) {
            return hh;
        }
        int k = 0;
        while (k < ws.size()) {
            PdfObject obj;
            int c1 = ((PdfNumber)PdfReader.getPdfObjectRelease(ws.getPdfObject(k))).intValue();
            if ((obj = PdfReader.getPdfObjectRelease(ws.getPdfObject(++k))).isArray()) {
                PdfArray a2 = (PdfArray)obj;
                int j = 0;
                while (j < a2.size()) {
                    int c2 = ((PdfNumber)PdfReader.getPdfObjectRelease(a2.getPdfObject(j))).intValue();
                    hh.put(c1++, c2);
                    ++j;
                }
            } else {
                int c2 = ((PdfNumber)obj).intValue();
                int w = ((PdfNumber)PdfReader.getPdfObjectRelease(ws.getPdfObject(++k))).intValue();
                while (c1 <= c2) {
                    hh.put(c1, w);
                    ++c1;
                }
            }
            ++k;
        }
        return hh;
    }

    private String decodeString(PdfString ps) {
        if (ps.isHexWriting()) {
            return PdfEncodings.convertToString(ps.getBytes(), "UnicodeBigUnmarked");
        }
        return ps.toUnicodeString();
    }

    private void fillMetrics(byte[] touni, IntHashtable widths, int dw) {
        try {
            PdfContentParser ps = new PdfContentParser(new PRTokeniser(new RandomAccessFileOrArray(new RandomAccessSourceFactory().createSource(touni))));
            PdfObject ob = null;
            boolean notFound = true;
            int nestLevel = 0;
            int maxExc = 50;
            while (notFound || nestLevel > 0) {
                PdfObject nx;
                try {
                    ob = ps.readPRObject();
                }
                catch (Exception ex) {
                    if (--maxExc >= 0) continue;
                    break;
                }
                if (ob == null) break;
                if (ob.type() != 200) continue;
                if (ob.toString().equals("begin")) {
                    notFound = false;
                    ++nestLevel;
                    continue;
                }
                if (ob.toString().equals("end")) {
                    --nestLevel;
                    continue;
                }
                if (ob.toString().equals("beginbfchar")) {
                    while (!(nx = ps.readPRObject()).toString().startsWith("endbfchar")) {
                        String cid = this.decodeString((PdfString)nx);
                        String uni = this.decodeString((PdfString)ps.readPRObject());
                        if (uni.length() != 1) continue;
                        char cidc = cid.charAt(0);
                        char unic = uni.charAt(uni.length() - 1);
                        int w = dw;
                        if (widths.containsKey(cidc)) {
                            w = widths.get(cidc);
                        }
                        this.metrics.put(Integer.valueOf(unic), new int[]{cidc, w});
                    }
                    continue;
                }
                if (!ob.toString().equals("beginbfrange")) continue;
                while (!(nx = ps.readPRObject()).toString().equals("endbfrange")) {
                    String cid1 = this.decodeString((PdfString)nx);
                    String cid2 = this.decodeString((PdfString)ps.readPRObject());
                    int cid1c = cid1.charAt(0);
                    char cid2c = cid2.charAt(0);
                    PdfObject ob2 = ps.readPRObject();
                    if (ob2.isString()) {
                        String uni = this.decodeString((PdfString)ob2);
                        if (uni.length() != 1) continue;
                        int unic = uni.charAt(uni.length() - 1);
                        while (cid1c <= cid2c) {
                            int w = dw;
                            if (widths.containsKey(cid1c)) {
                                w = widths.get(cid1c);
                            }
                            this.metrics.put(unic, new int[]{cid1c++, w});
                            ++unic;
                        }
                        continue;
                    }
                    PdfArray a = (PdfArray)ob2;
                    int j = 0;
                    while (j < a.size()) {
                        String uni = this.decodeString(a.getAsString(j));
                        if (uni.length() == 1) {
                            char unic = uni.charAt(uni.length() - 1);
                            int w = dw;
                            if (widths.containsKey(cid1c)) {
                                w = widths.get(cid1c);
                            }
                            this.metrics.put(Integer.valueOf(unic), new int[]{cid1c, w});
                        }
                        ++j;
                        ++cid1c;
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void doType1TT() {
        toUnicode = null;
        enc = PdfReader.getPdfObject(this.font.get(PdfName.ENCODING));
        if (enc == null) {
            this.fillEncoding(null);
            try {
                toUnicode = this.processToUnicode();
                if (toUnicode == null) ** GOTO lbl58
                rm = toUnicode.createReverseMapping();
                for (Map.Entry<Integer, Integer> kv : rm.entrySet()) {
                    this.uni2byte.put(kv.getKey(), kv.getValue());
                    this.byte2uni.put(kv.getValue(), kv.getKey());
                }
            }
            catch (Exception ex) {
                throw new ExceptionConverter(ex);
            }
        } else if (enc.isName()) {
            this.fillEncoding((PdfName)enc);
        } else if (enc.isDictionary()) {
            encDic = (PdfDictionary)enc;
            if ((enc = PdfReader.getPdfObject(encDic.get(PdfName.BASEENCODING))) == null) {
                this.fillEncoding(null);
            } else {
                this.fillEncoding((PdfName)enc);
            }
            diffs = encDic.getAsArray(PdfName.DIFFERENCES);
            if (diffs != null) {
                this.diffmap = new IntHashtable();
                currentNumber = 0;
                k = 0;
                while (k < diffs.size()) {
                    obj = diffs.getPdfObject(k);
                    if (obj.isNumber()) {
                        currentNumber = ((PdfNumber)obj).intValue();
                    } else {
                        c = GlyphList.nameToUnicode(PdfName.decodeName(((PdfName)obj).toString()));
                        if (c != null && c.length > 0) {
                            this.uni2byte.put(c[0], currentNumber);
                            this.byte2uni.put(currentNumber, c[0]);
                            this.diffmap.put(c[0], currentNumber);
                        } else {
                            if (toUnicode == null && (toUnicode = this.processToUnicode()) == null) {
                                toUnicode = new CMapToUnicode();
                            }
                            if ((unicode = toUnicode.lookup(new byte[]{(byte)currentNumber}, 0, 1)) != null && unicode.length() == 1) {
                                this.uni2byte.put(unicode.charAt(0), currentNumber);
                                this.byte2uni.put(currentNumber, unicode.charAt(0));
                                this.diffmap.put(unicode.charAt(0), currentNumber);
                            }
                        }
                        ++currentNumber;
                    }
                    ++k;
                }
            }
        }
lbl58:
        // 8 sources

        newWidths = this.font.getAsArray(PdfName.WIDTHS);
        first = this.font.getAsNumber(PdfName.FIRSTCHAR);
        last = this.font.getAsNumber(PdfName.LASTCHAR);
        if (DocumentFont.BuiltinFonts14.containsKey(this.fontName)) {
            try {
                bf = BaseFont.createFont(this.fontName, "Cp1252", false);
            }
            catch (Exception e) {
                throw new ExceptionConverter(e);
            }
            e = this.uni2byte.toOrderedKeys();
            k = 0;
            while (k < e.length) {
                n = this.uni2byte.get(e[k]);
                this.widths[n] = bf.getRawWidth(n, GlyphList.unicodeToName(e[k]));
                ++k;
            }
            if (this.diffmap != null) {
                e = this.diffmap.toOrderedKeys();
                k = 0;
                while (k < e.length) {
                    n = this.diffmap.get(e[k]);
                    this.widths[n] = bf.getRawWidth(n, GlyphList.unicodeToName(e[k]));
                    ++k;
                }
                this.diffmap = null;
            }
            this.ascender = bf.getFontDescriptor(1, 1000.0f);
            this.capHeight = bf.getFontDescriptor(2, 1000.0f);
            this.descender = bf.getFontDescriptor(3, 1000.0f);
            this.italicAngle = bf.getFontDescriptor(4, 1000.0f);
            this.fontWeight = bf.getFontDescriptor(23, 1000.0f);
            this.llx = bf.getFontDescriptor(5, 1000.0f);
            this.lly = bf.getFontDescriptor(6, 1000.0f);
            this.urx = bf.getFontDescriptor(7, 1000.0f);
            this.ury = bf.getFontDescriptor(8, 1000.0f);
        }
        if (first != null && last != null && newWidths != null) {
            f = first.intValue();
            nSize = f + newWidths.size();
            if (this.widths.length < nSize) {
                tmp = new int[nSize];
                System.arraycopy(this.widths, 0, tmp, 0, f);
                this.widths = tmp;
            }
            k = 0;
            while (k < newWidths.size()) {
                this.widths[f + k] = newWidths.getAsNumber(k).intValue();
                ++k;
            }
        }
        this.fillFontDesc(this.font.getAsDict(PdfName.FONTDESCRIPTOR));
    }

    private CMapToUnicode processToUnicode() {
        CMapToUnicode cmapRet = null;
        PdfObject toUni = PdfReader.getPdfObjectRelease(this.font.get(PdfName.TOUNICODE));
        if (toUni instanceof PRStream) {
            try {
                byte[] touni = PdfReader.getStreamBytes((PRStream)toUni);
                CidLocationFromByte lb = new CidLocationFromByte(touni);
                cmapRet = new CMapToUnicode();
                CMapParserEx.parseCid("", cmapRet, lb);
            }
            catch (Exception e) {
                cmapRet = null;
            }
        }
        return cmapRet;
    }

    private void fillFontDesc(PdfDictionary fontDesc) {
        PdfArray bbox;
        if (fontDesc == null) {
            return;
        }
        PdfNumber v = fontDesc.getAsNumber(PdfName.ASCENT);
        if (v != null) {
            this.ascender = v.floatValue();
        }
        if ((v = fontDesc.getAsNumber(PdfName.CAPHEIGHT)) != null) {
            this.capHeight = v.floatValue();
        }
        if ((v = fontDesc.getAsNumber(PdfName.DESCENT)) != null) {
            this.descender = v.floatValue();
        }
        if ((v = fontDesc.getAsNumber(PdfName.ITALICANGLE)) != null) {
            this.italicAngle = v.floatValue();
        }
        if ((v = fontDesc.getAsNumber(PdfName.FONTWEIGHT)) != null) {
            this.fontWeight = v.floatValue();
        }
        if ((bbox = fontDesc.getAsArray(PdfName.FONTBBOX)) != null) {
            float t;
            this.llx = bbox.getAsNumber(0).floatValue();
            this.lly = bbox.getAsNumber(1).floatValue();
            this.urx = bbox.getAsNumber(2).floatValue();
            this.ury = bbox.getAsNumber(3).floatValue();
            if (this.llx > this.urx) {
                t = this.llx;
                this.llx = this.urx;
                this.urx = t;
            }
            if (this.lly > this.ury) {
                t = this.lly;
                this.lly = this.ury;
                this.ury = t;
            }
        }
        float maxAscent = Math.max(this.ury, this.ascender);
        float minDescent = Math.min(this.lly, this.descender);
        this.ascender = maxAscent * 1000.0f / (maxAscent - minDescent);
        this.descender = minDescent * 1000.0f / (maxAscent - minDescent);
    }

    private void fillEncoding(PdfName encoding) {
        if (PdfName.MAC_ROMAN_ENCODING.equals(encoding) || PdfName.WIN_ANSI_ENCODING.equals(encoding)) {
            byte[] b = new byte[256];
            int k = 0;
            while (k < 256) {
                b[k] = (byte)k;
                ++k;
            }
            String enc = "Cp1252";
            if (PdfName.MAC_ROMAN_ENCODING.equals(encoding)) {
                enc = "MacRoman";
            }
            String cv = PdfEncodings.convertToString(b, enc);
            char[] arr = cv.toCharArray();
            int k2 = 0;
            while (k2 < 256) {
                this.uni2byte.put(arr[k2], k2);
                this.byte2uni.put(k2, arr[k2]);
                ++k2;
            }
        } else {
            int k = 0;
            while (k < 256) {
                this.uni2byte.put(stdEnc[k], k);
                this.byte2uni.put(k, stdEnc[k]);
                ++k;
            }
        }
    }

    @Override
    public String[][] getFamilyFontName() {
        return this.getFullFontName();
    }

    @Override
    public float getFontDescriptor(int key, float fontSize) {
        if (this.cjkMirror != null) {
            return this.cjkMirror.getFontDescriptor(key, fontSize);
        }
        switch (key) {
            case 1: 
            case 9: {
                return this.ascender * fontSize / 1000.0f;
            }
            case 2: {
                return this.capHeight * fontSize / 1000.0f;
            }
            case 3: 
            case 10: {
                return this.descender * fontSize / 1000.0f;
            }
            case 4: {
                return this.italicAngle;
            }
            case 5: {
                return this.llx * fontSize / 1000.0f;
            }
            case 6: {
                return this.lly * fontSize / 1000.0f;
            }
            case 7: {
                return this.urx * fontSize / 1000.0f;
            }
            case 8: {
                return this.ury * fontSize / 1000.0f;
            }
            case 11: {
                return 0.0f;
            }
            case 12: {
                return (this.urx - this.llx) * fontSize / 1000.0f;
            }
            case 23: {
                return this.fontWeight * fontSize / 1000.0f;
            }
        }
        return 0.0f;
    }

    @Override
    public String[][] getFullFontName() {
        return new String[][]{{"", "", "", this.fontName}};
    }

    @Override
    public String[][] getAllNameEntries() {
        return new String[][]{{"4", "", "", "", this.fontName}};
    }

    @Override
    public int getKerning(int char1, int char2) {
        return 0;
    }

    @Override
    public String getPostscriptFontName() {
        return this.fontName;
    }

    @Override
    int getRawWidth(int c, String name) {
        return 0;
    }

    @Override
    public boolean hasKernPairs() {
        return false;
    }

    @Override
    void writeFont(PdfWriter writer, PdfIndirectReference ref, Object[] params) throws DocumentException, IOException {
    }

    @Override
    public PdfStream getFullFontStream() {
        return null;
    }

    @Override
    public int getWidth(int char1) {
        if (this.isType0) {
            if (this.hMetrics != null && this.cjkMirror != null && !this.cjkMirror.isVertical()) {
                int c = this.cjkMirror.getCidCode(char1);
                int v = this.hMetrics.get(c);
                if (v > 0) {
                    return v;
                }
                return this.defaultWidth;
            }
            int[] ws = this.metrics.get(char1);
            if (ws != null) {
                return ws[1];
            }
            return 0;
        }
        if (this.cjkMirror != null) {
            return this.cjkMirror.getWidth(char1);
        }
        return super.getWidth(char1);
    }

    @Override
    public int getWidth(String text) {
        if (this.isType0) {
            int total = 0;
            if (this.hMetrics != null && this.cjkMirror != null && !this.cjkMirror.isVertical()) {
                if (((CJKFont)this.cjkMirror).isIdentity()) {
                    int k = 0;
                    while (k < text.length()) {
                        total += this.getWidth(text.charAt(k));
                        ++k;
                    }
                } else {
                    int k = 0;
                    while (k < text.length()) {
                        int val;
                        if (Utilities.isSurrogatePair(text, k)) {
                            val = Utilities.convertToUtf32(text, k);
                            ++k;
                        } else {
                            val = text.charAt(k);
                        }
                        total += this.getWidth(val);
                        ++k;
                    }
                }
            } else {
                char[] chars = text.toCharArray();
                int len = chars.length;
                int k = 0;
                while (k < len) {
                    int[] ws = this.metrics.get(chars[k]);
                    if (ws != null) {
                        total += ws[1];
                    }
                    ++k;
                }
            }
            return total;
        }
        if (this.cjkMirror != null) {
            return this.cjkMirror.getWidth(text);
        }
        return super.getWidth(text);
    }

    @Override
    public byte[] convertToBytes(String text) {
        if (this.cjkMirror != null) {
            return this.cjkMirror.convertToBytes(text);
        }
        if (this.isType0) {
            char[] chars = text.toCharArray();
            int len = chars.length;
            byte[] b = new byte[len * 2];
            int bptr = 0;
            int k = 0;
            while (k < len) {
                int[] ws = this.metrics.get(chars[k]);
                if (ws != null) {
                    int g = ws[0];
                    b[bptr++] = (byte)(g / 256);
                    b[bptr++] = (byte)g;
                }
                ++k;
            }
            if (bptr == b.length) {
                return b;
            }
            byte[] nb = new byte[bptr];
            System.arraycopy(b, 0, nb, 0, bptr);
            return nb;
        }
        char[] cc = text.toCharArray();
        byte[] b = new byte[cc.length];
        int ptr = 0;
        int k = 0;
        while (k < cc.length) {
            if (this.uni2byte.containsKey(cc[k])) {
                b[ptr++] = (byte)this.uni2byte.get(cc[k]);
            }
            ++k;
        }
        if (ptr == b.length) {
            return b;
        }
        byte[] b2 = new byte[ptr];
        System.arraycopy(b, 0, b2, 0, ptr);
        return b2;
    }

    @Override
    byte[] convertToBytes(int char1) {
        if (this.cjkMirror != null) {
            return this.cjkMirror.convertToBytes(char1);
        }
        if (this.isType0) {
            int[] ws = this.metrics.get(char1);
            if (ws != null) {
                int g = ws[0];
                return new byte[]{(byte)(g / 256), (byte)g};
            }
            return new byte[0];
        }
        if (this.uni2byte.containsKey(char1)) {
            return new byte[]{(byte)this.uni2byte.get(char1)};
        }
        return new byte[0];
    }

    PdfIndirectReference getIndirectReference() {
        if (this.refFont == null) {
            throw new IllegalArgumentException("Font reuse not allowed with direct font objects.");
        }
        return this.refFont;
    }

    @Override
    public boolean charExists(int c) {
        if (this.cjkMirror != null) {
            return this.cjkMirror.charExists(c);
        }
        if (this.isType0) {
            return this.metrics.containsKey(c);
        }
        return super.charExists(c);
    }

    @Override
    public void setPostscriptFontName(String name) {
    }

    @Override
    public boolean setKerning(int char1, int char2, int kern) {
        return false;
    }

    @Override
    public int[] getCharBBox(int c) {
        return null;
    }

    @Override
    protected int[] getRawCharBBox(int c, String name) {
        return null;
    }

    @Override
    public boolean isVertical() {
        if (this.cjkMirror != null) {
            return this.cjkMirror.isVertical();
        }
        return super.isVertical();
    }

    IntHashtable getUni2Byte() {
        return this.uni2byte;
    }

    IntHashtable getByte2Uni() {
        return this.byte2uni;
    }

    IntHashtable getDiffmap() {
        return this.diffmap;
    }
}

