/*
 * Decompiled with CFR 0.152.
 */
package com.KGitextpdf.text.log;

import com.KGitextpdf.text.log.Level;
import com.KGitextpdf.text.log.Logger;

public class SysoLogger
implements Logger {
    private String name;
    private final int shorten;

    public SysoLogger() {
        this(1);
    }

    public SysoLogger(int packageReduce) {
        this.shorten = packageReduce;
    }

    protected SysoLogger(String klass, int shorten) {
        this.shorten = shorten;
        this.name = klass;
    }

    @Override
    public Logger getLogger(Class<?> klass) {
        return new SysoLogger(klass.getName(), this.shorten);
    }

    @Override
    public Logger getLogger(String name) {
        return new SysoLogger("[itext]", 0);
    }

    @Override
    public boolean isLogging(Level level) {
        return true;
    }

    @Override
    public void warn(String message) {
        System.out.println(String.format("%s WARN  %s", this.shorten(this.name), message));
    }

    private String shorten(String className) {
        if (this.shorten != 0) {
            StringBuilder target = new StringBuilder();
            String name = className;
            int fromIndex = className.indexOf(46);
            while (fromIndex != -1) {
                int parseTo = fromIndex < this.shorten ? fromIndex : this.shorten;
                target.append(name.substring(0, parseTo));
                target.append('.');
                name = name.substring(fromIndex + 1);
                fromIndex = name.indexOf(46);
            }
            target.append(className.substring(className.lastIndexOf(46) + 1));
            return target.toString();
        }
        return className;
    }

    @Override
    public void trace(String message) {
        System.out.println(String.format("%s TRACE %s", this.shorten(this.name), message));
    }

    @Override
    public void debug(String message) {
        System.out.println(String.format("%s DEBUG %s", this.shorten(this.name), message));
    }

    @Override
    public void info(String message) {
        System.out.println(String.format("%s INFO  %s", this.shorten(this.name), message));
    }

    @Override
    public void error(String message) {
        System.out.println(String.format("%s ERROR %s", this.name, message));
    }

    @Override
    public void error(String message, Exception e) {
        System.out.println(String.format("%s ERROR %s", this.name, message));
        e.printStackTrace(System.out);
    }
}

