/*
 * Decompiled with CFR 0.152.
 */
package com.KGitextpdf.text.html.simpleparser;

import com.KGitextpdf.text.BaseColor;
import com.KGitextpdf.text.Chunk;
import com.KGitextpdf.text.DocListener;
import com.KGitextpdf.text.DocumentException;
import com.KGitextpdf.text.Font;
import com.KGitextpdf.text.FontFactory;
import com.KGitextpdf.text.FontProvider;
import com.KGitextpdf.text.Image;
import com.KGitextpdf.text.List;
import com.KGitextpdf.text.ListItem;
import com.KGitextpdf.text.Paragraph;
import com.KGitextpdf.text.html.HtmlUtilities;
import com.KGitextpdf.text.html.simpleparser.ChainedProperties;
import com.KGitextpdf.text.html.simpleparser.ImageProvider;
import com.KGitextpdf.text.pdf.HyphenationAuto;
import com.KGitextpdf.text.pdf.HyphenationEvent;
import com.KGitextpdf.text.pdf.draw.LineSeparator;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class ElementFactory {
    private FontProvider provider = FontFactory.getFontImp();

    public void setFontProvider(FontProvider provider) {
        this.provider = provider;
    }

    public FontProvider getFontProvider() {
        return this.provider;
    }

    public Font getFont(ChainedProperties chain) {
        String encoding;
        String face = chain.getProperty("face");
        if (face == null || face.trim().length() == 0) {
            face = chain.getProperty("font-family");
        }
        if (face != null) {
            StringTokenizer tok = new StringTokenizer(face, ",");
            while (tok.hasMoreTokens()) {
                face = tok.nextToken().trim();
                if (face.startsWith("\"")) {
                    face = face.substring(1);
                }
                if (face.endsWith("\"")) {
                    face = face.substring(0, face.length() - 1);
                }
                if (this.provider.isRegistered(face)) break;
            }
        }
        if ((encoding = chain.getProperty("encoding")) == null) {
            encoding = "Cp1252";
        }
        String value = chain.getProperty("size");
        float size = 12.0f;
        if (value != null) {
            size = Float.parseFloat(value);
        }
        int style = 0;
        String decoration = chain.getProperty("text-decoration");
        if (decoration != null && decoration.trim().length() != 0) {
            if ("underline".equals(decoration)) {
                style |= 4;
            } else if ("line-through".equals(decoration)) {
                style |= 8;
            }
        }
        if (chain.hasProperty("i")) {
            style |= 2;
        }
        if (chain.hasProperty("b")) {
            style |= 1;
        }
        if (chain.hasProperty("u")) {
            style |= 4;
        }
        if (chain.hasProperty("s")) {
            style |= 8;
        }
        BaseColor color = HtmlUtilities.decodeColor(chain.getProperty("color"));
        return this.provider.getFont(face, encoding, true, size, style, color);
    }

    public Chunk createChunk(String content, ChainedProperties chain) {
        Font font = this.getFont(chain);
        Chunk ck = new Chunk(content, font);
        if (chain.hasProperty("sub")) {
            ck.setTextRise(-font.getSize() / 2.0f);
        } else if (chain.hasProperty("sup")) {
            ck.setTextRise(font.getSize() / 2.0f);
        }
        ck.setHyphenation(this.getHyphenation(chain));
        return ck;
    }

    public Paragraph createParagraph(ChainedProperties chain) {
        Paragraph paragraph = new Paragraph();
        this.updateElement(paragraph, chain);
        return paragraph;
    }

    public ListItem createListItem(ChainedProperties chain) {
        ListItem item = new ListItem();
        this.updateElement(item, chain);
        return item;
    }

    protected void updateElement(Paragraph paragraph, ChainedProperties chain) {
        String value = chain.getProperty("align");
        paragraph.setAlignment(HtmlUtilities.alignmentValue(value));
        paragraph.setHyphenation(this.getHyphenation(chain));
        ElementFactory.setParagraphLeading(paragraph, chain.getProperty("leading"));
        value = chain.getProperty("after");
        if (value != null) {
            try {
                paragraph.setSpacingBefore(Float.parseFloat(value));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((value = chain.getProperty("after")) != null) {
            try {
                paragraph.setSpacingAfter(Float.parseFloat(value));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((value = chain.getProperty("extraparaspace")) != null) {
            try {
                paragraph.setExtraParagraphSpace(Float.parseFloat(value));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((value = chain.getProperty("indent")) != null) {
            try {
                paragraph.setIndentationLeft(Float.parseFloat(value));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected static void setParagraphLeading(Paragraph paragraph, String leading) {
        if (leading == null) {
            paragraph.setLeading(0.0f, 1.5f);
            return;
        }
        try {
            StringTokenizer tk = new StringTokenizer(leading, " ,");
            String v = tk.nextToken();
            float v1 = Float.parseFloat(v);
            if (!tk.hasMoreTokens()) {
                paragraph.setLeading(v1, 0.0f);
                return;
            }
            v = tk.nextToken();
            float v2 = Float.parseFloat(v);
            paragraph.setLeading(v1, v2);
        }
        catch (Exception e) {
            paragraph.setLeading(0.0f, 1.5f);
        }
    }

    public HyphenationEvent getHyphenation(ChainedProperties chain) {
        int leftMin;
        String value = chain.getProperty("hyphenation");
        if (value == null || value.length() == 0) {
            return null;
        }
        int pos = value.indexOf(95);
        if (pos == -1) {
            return new HyphenationAuto(value, null, 2, 2);
        }
        String lang = value.substring(0, pos);
        String country = value.substring(pos + 1);
        if ((pos = country.indexOf(44)) == -1) {
            return new HyphenationAuto(lang, country, 2, 2);
        }
        int rightMin = 2;
        value = country.substring(pos + 1);
        country = country.substring(0, pos);
        pos = value.indexOf(44);
        if (pos == -1) {
            leftMin = Integer.parseInt(value);
        } else {
            leftMin = Integer.parseInt(value.substring(0, pos));
            rightMin = Integer.parseInt(value.substring(pos + 1));
        }
        return new HyphenationAuto(lang, country, leftMin, rightMin);
    }

    public LineSeparator createLineSeparator(Map<String, String> attrs, float offset) {
        float tmpSize;
        float lineWidth = 1.0f;
        String size = attrs.get("size");
        if (size != null && (tmpSize = HtmlUtilities.parseLength(size, 12.0f)) > 0.0f) {
            lineWidth = tmpSize;
        }
        String width = attrs.get("width");
        float percentage = 100.0f;
        if (width != null) {
            float tmpWidth = HtmlUtilities.parseLength(width, 12.0f);
            if (tmpWidth > 0.0f) {
                percentage = tmpWidth;
            }
            if (!width.endsWith("%")) {
                percentage = 100.0f;
            }
        }
        BaseColor lineColor = null;
        int align = HtmlUtilities.alignmentValue(attrs.get("align"));
        return new LineSeparator(lineWidth, percentage, lineColor, align, offset);
    }

    public Image createImage(String src, Map<String, String> attrs, ChainedProperties chain, DocListener document, ImageProvider img_provider, HashMap<String, Image> img_store, String img_baseurl) throws DocumentException, IOException {
        String after;
        Image tim;
        Image img = null;
        if (img_provider != null) {
            img = img_provider.getImage(src, attrs, chain, document);
        }
        if (img == null && img_store != null && (tim = img_store.get(src)) != null) {
            img = Image.getInstance(tim);
        }
        if (img != null) {
            return img;
        }
        if (!src.startsWith("http") && img_baseurl != null) {
            src = String.valueOf(img_baseurl) + src;
        } else if (img == null && !src.startsWith("http")) {
            String path = chain.getProperty("image_path");
            if (path == null) {
                path = "";
            }
            src = new File(path, src).getPath();
        }
        img = Image.getInstance(src);
        if (img == null) {
            return null;
        }
        float actualFontSize = HtmlUtilities.parseLength(chain.getProperty("size"), 12.0f);
        if (actualFontSize <= 0.0f) {
            actualFontSize = 12.0f;
        }
        String width = attrs.get("width");
        float widthInPoints = HtmlUtilities.parseLength(width, actualFontSize);
        String height = attrs.get("height");
        float heightInPoints = HtmlUtilities.parseLength(height, actualFontSize);
        if (widthInPoints > 0.0f && heightInPoints > 0.0f) {
            img.scaleAbsolute(widthInPoints, heightInPoints);
        } else if (widthInPoints > 0.0f) {
            heightInPoints = img.getHeight() * widthInPoints / img.getWidth();
            img.scaleAbsolute(widthInPoints, heightInPoints);
        } else if (heightInPoints > 0.0f) {
            widthInPoints = img.getWidth() * heightInPoints / img.getHeight();
            img.scaleAbsolute(widthInPoints, heightInPoints);
        }
        String before = chain.getProperty("before");
        if (before != null) {
            img.setSpacingBefore(Float.parseFloat(before));
        }
        if ((after = chain.getProperty("after")) != null) {
            img.setSpacingAfter(Float.parseFloat(after));
        }
        img.setWidthPercentage(0.0f);
        return img;
    }

    public List createList(String tag, ChainedProperties chain) {
        List list;
        if ("ul".equalsIgnoreCase(tag)) {
            list = new List(false);
            list.setListSymbol("\u2022 ");
        } else {
            list = new List(true);
        }
        try {
            list.setIndentationLeft(new Float(chain.getProperty("indent")).floatValue());
        }
        catch (Exception e) {
            list.setAutoindent(true);
        }
        return list;
    }
}

