/*
 * Decompiled with CFR 0.152.
 */
package com.KGitextpdf.text.html.simpleparser;

import com.KGitextpdf.text.Chunk;
import com.KGitextpdf.text.Element;
import com.KGitextpdf.text.ElementListener;
import com.KGitextpdf.text.TextElementArray;
import com.KGitextpdf.text.html.HtmlUtilities;
import com.KGitextpdf.text.html.simpleparser.ChainedProperties;
import com.KGitextpdf.text.pdf.PdfPCell;
import java.util.List;

public class CellWrapper
implements TextElementArray {
    private final PdfPCell cell;
    private float width;
    private boolean percentage;

    public CellWrapper(String tag, ChainedProperties chain) {
        this.cell = this.createPdfPCell(tag, chain);
        String value = chain.getProperty("width");
        if (value != null) {
            if ((value = value.trim()).endsWith("%")) {
                this.percentage = true;
                value = value.substring(0, value.length() - 1);
            }
            this.width = Float.parseFloat(value);
        }
    }

    public PdfPCell createPdfPCell(String tag, ChainedProperties chain) {
        PdfPCell cell = new PdfPCell(null);
        String value = chain.getProperty("colspan");
        if (value != null) {
            cell.setColspan(Integer.parseInt(value));
        }
        if ((value = chain.getProperty("rowspan")) != null) {
            cell.setRowspan(Integer.parseInt(value));
        }
        if (tag.equals("th")) {
            cell.setHorizontalAlignment(1);
        }
        if ((value = chain.getProperty("align")) != null) {
            cell.setHorizontalAlignment(HtmlUtilities.alignmentValue(value));
        }
        value = chain.getProperty("valign");
        cell.setVerticalAlignment(5);
        if (value != null) {
            cell.setVerticalAlignment(HtmlUtilities.alignmentValue(value));
        }
        value = chain.getProperty("border");
        float border = 0.0f;
        if (value != null) {
            border = Float.parseFloat(value);
        }
        cell.setBorderWidth(border);
        value = chain.getProperty("cellpadding");
        if (value != null) {
            cell.setPadding(Float.parseFloat(value));
        }
        cell.setUseDescender(true);
        value = chain.getProperty("bgcolor");
        cell.setBackgroundColor(HtmlUtilities.decodeColor(value));
        return cell;
    }

    public PdfPCell getCell() {
        return this.cell;
    }

    public float getWidth() {
        return this.width;
    }

    public boolean isPercentage() {
        return this.percentage;
    }

    @Override
    public boolean add(Element o) {
        this.cell.addElement(o);
        return true;
    }

    @Override
    public List<Chunk> getChunks() {
        return null;
    }

    @Override
    public boolean isContent() {
        return false;
    }

    @Override
    public boolean isNestable() {
        return false;
    }

    @Override
    public boolean process(ElementListener listener) {
        return false;
    }

    @Override
    public int type() {
        return 0;
    }
}

