/*
 * Decompiled with CFR 0.152.
 */
package com.teemlink.sync.service;

import cn.myapps.authtime.common.dao.PersistenceUtils;
import cn.myapps.common.dao.datasource.FileSystemDataSourceDAO;
import cn.myapps.common.model.datasource.DataSource;
import com.teemlink.sync.dao.SyncDao;
import com.teemlink.sync.model.DataOperation;
import com.teemlink.sync.service.SyncService;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.NamingException;
import org.springframework.stereotype.Service;

@Service
public class SyncServiceImpl
implements SyncService {
    @Override
    public void syncData(DataOperation dataPackage) throws Exception {
        String action;
        switch (action = dataPackage.getAction()) {
            case "create": {
                this.getDao(dataPackage).create(dataPackage.getDataObject());
                break;
            }
            case "update": {
                this.getDao(dataPackage).update(dataPackage.getDataObject());
                break;
            }
            case "delete": {
                this.getDao(dataPackage).delete(dataPackage.getDataObject());
            }
        }
    }

    private SyncDao getDao(DataOperation dataPackage) {
        SyncDao syncDao = null;
        try {
            FileSystemDataSourceDAO dataSourceDao = new FileSystemDataSourceDAO(DataSource.class);
            DataSource dataSource = dataSourceDao.getDataSource(dataPackage.getDataSourceName(), dataPackage.getApplicationId());
            Connection connection = this.getConnection(dataSource);
            syncDao = new SyncDao(connection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return syncDao;
    }

    private Connection getConnection(DataSource dataSource) throws NamingException, SQLException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        Connection connection = null;
        if ("JNDI".equals(dataSource.getUseType())) {
            connection = dataSource.getJNDIConnection();
        } else {
            String url = dataSource.getUrl();
            String driver = dataSource.getDriverClass();
            connection = PersistenceUtils.getDruidDataSource((String)"SyncServiceImpl", (String)dataSource.getUsername(), (String)dataSource.getPassword(), (String)driver, (String)url, (String)"100", (String)"3000").getConnection();
        }
        return connection;
    }
}

