/*
 * Decompiled with CFR 0.152.
 */
package com.teemlink.sync.dao;

import cn.myapps.authtime.common.dao.ConnectionManager;
import com.teemlink.sync.model.log.SyncLog;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncLogDao {
    private static Logger log = LoggerFactory.getLogger(SyncLogDao.class);

    public void create(SyncLog syncLog) throws Exception {
        Connection connection = ConnectionManager.getConnection();
        PreparedStatement stmt = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into ");
        sql.append(" t_synclog ");
        sql.append(" ( ");
        sql.append(" id,action,actiontime,tablename,status,dataoperation,msg ");
        sql.append(" ) ");
        sql.append(" values ( ?,?,?,?,?,?,?");
        sql.append(" ) ");
        log.debug(sql.toString());
        int index = 0;
        try {
            stmt = connection.prepareStatement(sql.toString());
            stmt.setString(++index, syncLog.getId());
            this.setParameters(syncLog, stmt, index);
            stmt.execute();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e);
        }
        finally {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                ConnectionManager.closeConnection();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public void update(SyncLog syncLog) throws Exception {
        Connection connection = ConnectionManager.getConnection();
        PreparedStatement stmt = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" update ");
        sql.append(" t_synclog ");
        sql.append(" set ");
        sql.append(" action=?,actiontime=?,tablename=?,status=?,dataoperation=?,msg=? ");
        sql.append(" where id=?");
        log.debug(sql.toString());
        int index = 0;
        try {
            stmt = connection.prepareStatement(sql.toString());
            this.setParameters(syncLog, stmt, index);
            stmt.setString(7, syncLog.getId());
            stmt.execute();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e);
        }
        finally {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                ConnectionManager.closeConnection();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isExsit(String id) throws Exception {
        boolean flag = false;
        Connection connection = ConnectionManager.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String sql = " select count(*) from t_synclog where id=?";
        log.debug(sql);
        try {
            stmt = connection.prepareStatement(sql);
            stmt.setString(1, id);
            rs = stmt.executeQuery();
            if (rs.next() && rs.getInt(1) > 0) {
                flag = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e);
        }
        finally {
            rs.close();
            try {
                stmt.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return flag;
    }

    private void setParameters(SyncLog syncLog, PreparedStatement stmt, int index) throws Exception {
        stmt.setString(++index, syncLog.getAction());
        stmt.setTimestamp(++index, new Timestamp(syncLog.getActionTime().getTime()));
        stmt.setString(++index, syncLog.getTableName());
        stmt.setInt(++index, syncLog.getStatus());
        stmt.setString(++index, syncLog.getDataOperation());
        stmt.setString(++index, syncLog.getMsg());
    }
}

