/*
 * Decompiled with CFR 0.152.
 */
package com.teemlink.sync.dao;

import cn.myapps.util.StringUtil;
import com.teemlink.sync.model.ColumnValue;
import com.teemlink.sync.model.DataObject;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncDao {
    private static Logger log = LoggerFactory.getLogger(SyncDao.class);
    private Connection connection;

    public SyncDao(Connection conn) throws Exception {
        this.connection = conn;
    }

    public boolean create(DataObject dataObject) throws Exception {
        int i;
        boolean flag = false;
        Statement stmt = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into ");
        sql.append(dataObject.getTableName());
        sql.append(" ( ");
        List<ColumnValue> columnValues = dataObject.getColumnValues();
        for (i = 0; i < columnValues.size(); ++i) {
            ColumnValue columnValue = columnValues.get(i);
            if (i != 0) {
                sql.append(",");
            }
            sql.append(columnValue.getName());
        }
        sql.append(" ) ");
        sql.append(" values ( ");
        for (i = 0; i < columnValues.size(); ++i) {
            if (i != 0) {
                sql.append(",");
            }
            sql.append("?");
        }
        sql.append(" ) ");
        log.debug(sql.toString());
        int index = 0;
        try {
            stmt = this.connection.prepareStatement(sql.toString());
            this.setParameters(columnValues, (PreparedStatement)stmt, index);
            stmt.execute();
            flag = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e);
        }
        finally {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return flag;
    }

    public boolean update(DataObject dataObject) throws Exception {
        boolean flag = false;
        Statement stmt = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" update ");
        sql.append(dataObject.getTableName());
        sql.append(" set ");
        List<ColumnValue> columnValues = dataObject.getColumnValues();
        for (int i = 0; i < columnValues.size(); ++i) {
            ColumnValue columnValue = columnValues.get(i);
            if (i != 0) {
                sql.append(",");
            }
            sql.append(columnValue.getName());
            sql.append("=?");
        }
        sql.append(" where id=?");
        log.debug(sql.toString());
        int index = 0;
        try {
            stmt = this.connection.prepareStatement(sql.toString());
            this.setParameters(columnValues, (PreparedStatement)stmt, index);
            stmt.setObject(columnValues.size() + 1, dataObject.getId());
            stmt.execute();
            flag = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e);
        }
        finally {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return flag;
    }

    public boolean delete(DataObject dataObject) throws Exception {
        boolean flag = false;
        Statement stmt = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" delete from ");
        sql.append(dataObject.getTableName());
        sql.append(" where id=? ");
        log.debug(sql.toString());
        int index = 0;
        try {
            stmt = this.connection.prepareStatement(sql.toString());
            stmt.setObject(++index, dataObject.getId());
            stmt.execute();
            flag = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e);
        }
        finally {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return flag;
    }

    private void setParameters(List<ColumnValue> columnValues, PreparedStatement stmt, int index) throws Exception {
        for (ColumnValue columnValue : columnValues) {
            String type;
            switch (type = columnValue.getType()) {
                case "date": {
                    Date dateValue = this.parseDate(columnValue.getValue());
                    if (dateValue == null) {
                        stmt.setNull(++index, 91);
                        break;
                    }
                    stmt.setDate(++index, new java.sql.Date(dateValue.getTime()));
                    break;
                }
                case "text": {
                    String stringValue = columnValue.getValue();
                    if (stringValue == null) {
                        stmt.setNull(++index, 12);
                        break;
                    }
                    stmt.setString(++index, stringValue);
                    break;
                }
                case "datetime": {
                    Date dateTimeValue = this.parseDateTime(columnValue.getValue());
                    if (dateTimeValue == null) {
                        stmt.setNull(++index, 93);
                        break;
                    }
                    stmt.setTimestamp(++index, new Timestamp(dateTimeValue.getTime()));
                    break;
                }
                case "timestamp": {
                    Timestamp timestampValue = new Timestamp(this.parseTimestamp(columnValue.getValue()).getTime());
                    if (timestampValue == null) {
                        stmt.setNull(++index, 93);
                        break;
                    }
                    stmt.setTimestamp(++index, timestampValue);
                    break;
                }
                case "double": {
                    if (StringUtil.isNumber((String)columnValue.getValue())) {
                        double doubleValue = StringUtil.parseDouble((String)columnValue.getValue());
                        stmt.setDouble(++index, doubleValue);
                        break;
                    }
                    stmt.setNull(++index, 2);
                    break;
                }
                case "integer": {
                    if (StringUtil.isNumber((String)columnValue.getValue())) {
                        long longValue = StringUtil.parseLong((String)columnValue.getValue());
                        stmt.setLong(++index, longValue);
                        break;
                    }
                    stmt.setNull(++index, 2);
                    break;
                }
                case "boolean": {
                    if (columnValue.getValue() != null) {
                        boolean booleanValue = "1".equals(columnValue.getValue()) || "true".equals(columnValue.getValue());
                        stmt.setBoolean(++index, booleanValue);
                        break;
                    }
                    stmt.setNull(++index, 16);
                }
            }
        }
    }

    private Date parseDateTime(String time) {
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return format.parse(time);
        }
        catch (Exception e) {
            try {
                return new Date(time);
            }
            catch (Exception x) {
                log.debug(x.getMessage());
                return null;
            }
        }
    }

    private Date parseDate(String time) {
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            return format.parse(time);
        }
        catch (Exception e) {
            try {
                return new Date(time);
            }
            catch (Exception x) {
                log.debug(x.getMessage());
                return null;
            }
        }
    }

    private Date parseTimestamp(String time) {
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            return format.parse(time);
        }
        catch (Exception e) {
            try {
                return new Date(time);
            }
            catch (Exception x) {
                log.debug(x.getMessage());
                return null;
            }
        }
    }
}

