/*
 * Decompiled with CFR 0.152.
 */
package com.teemlink.kujiale.util;

import cn.myapps.common.util.FileWriteUtil;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.common.util.StringUtil;
import cn.myapps.util.ftp.FTPTools;
import cn.myapps.util.http.RequestFileUtil;
import cn.myapps.util.http.RequestUtils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.codec.digest.DigestUtils;

public class KujialeUtil {
    private String openapi_url;
    private String design_url;
    private String appkey;
    private String appsecret;
    private int port;
    private String user;
    private String password;
    private String server;

    public KujialeUtil() {
        PropertyUtil.reload((String)"kujiale");
        this.openapi_url = PropertyUtil.get((String)"openapi_url");
        this.design_url = PropertyUtil.get((String)"design_url");
        this.appkey = PropertyUtil.get((String)"appkey");
        this.appsecret = PropertyUtil.get((String)"appsecret");
        PropertyUtil.reload((String)"ftp");
        this.user = PropertyUtil.get((String)"ftp.user");
        this.password = PropertyUtil.get((String)"ftp.password");
        this.server = PropertyUtil.get((String)"ftp.server");
        this.port = PropertyUtil.get((String)"ftp.port") != null ? Integer.valueOf(PropertyUtil.get((String)"ftp.port")) : 21;
    }

    public String getToken(String appuid) throws Exception {
        String timestamp = new Date().getTime() + "";
        String sign = this.getMD5(this.appsecret + this.appkey + appuid + timestamp);
        return this.getToken(appuid, timestamp, sign);
    }

    public String getToken(String appuid, String timestamp, String sign) throws Exception {
        String url = this.openapi_url + "/v2/sso/token?appuid=" + appuid + "&sign=" + sign + "&dest=4&timestamp=" + timestamp + "&appkey=" + this.appkey;
        JSONObject result = RequestUtils.post((String)url, null);
        if ("0".equals(result.getString("c"))) {
            return result.getString("d");
        }
        String msg = this.handleErrorMsg(result);
        throw new Exception(msg);
    }

    public String getDesignUrl(String name, String email, String appuid) throws Exception {
        return this.getDesignUrl(name, null, email, appuid);
    }

    public String getDesignUrl(String name, String designId, String email, String appuid) throws Exception {
        String sign;
        String timestamp = new Date().getTime() + "";
        boolean isRegister = this.isRegister(appuid, timestamp, sign = this.getMD5(this.appsecret + this.appkey + appuid + timestamp));
        if (!isRegister) {
            this.register(name, email, appuid, timestamp, sign);
        }
        String token = this.getToken(appuid, timestamp, sign);
        String url = this.design_url + "/v/auth?accesstoken=" + token;
        url = StringUtil.isBlank((String)designId) ? url + "&dest=4" : url + "&dest=1&designid=" + designId;
        return url;
    }

    public void register(String name, String email, String appuid) throws Exception {
        String timestamp = new Date().getTime() + "";
        String sign = this.getMD5(this.appsecret + this.appkey + appuid + timestamp);
        this.register(name, email, appuid, timestamp, sign);
    }

    public void register(String name, String email, String appuid, String timestamp, String sign) throws Exception {
        String url = this.openapi_url + "/v2/register?appuid=" + appuid + "&sign=" + sign + "&timestamp=" + timestamp + "&appkey=" + this.appkey;
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("name", (Object)name);
        jsonObject.put("email", (Object)email);
        jsonObject.put("avatar", (Object)"");
        jsonObject.put("type", (Object)0);
        jsonObject.put("maxChildrenCount", (Object)5);
        jsonObject.put("defaultPassword", (Object)"123456");
        jsonObject.put("creator", (Object)"");
        JSONObject result = RequestUtils.post((String)url, (String)jsonObject.toString());
        if (!"0".equals(result.getString("c"))) {
            String msg = this.handleErrorMsg(result);
            throw new Exception(msg);
        }
    }

    public boolean isRegister(String appuid) throws Exception {
        String timestamp = new Date().getTime() + "";
        String sign = this.getMD5(this.appsecret + this.appkey + appuid + timestamp);
        return this.isRegister(appuid, timestamp, sign);
    }

    public boolean isRegister(String appuid, String timestamp, String sign) throws Exception {
        String url = this.openapi_url + "/v2/user/info?appuid=" + appuid + "&sign=" + sign + "&timestamp=" + timestamp + "&appkey=" + this.appkey;
        JSONObject result = RequestUtils.get((String)url);
        return "0".equals(result.getString("c"));
    }

    public JSONObject getUserDesignList(String name, String email, String appuid) throws Exception {
        String url;
        JSONObject result;
        String sign;
        String timestamp = new Date().getTime() + "";
        boolean isRegister = this.isRegister(appuid, timestamp, sign = this.getMD5(this.appsecret + this.appkey + appuid + timestamp));
        if (!isRegister) {
            this.register(name, email, appuid, timestamp, sign);
        }
        if ("0".equals((result = RequestUtils.get((String)(url = this.openapi_url + "/v2/design/list?appuid=" + appuid + "&sign=" + sign + "&timestamp=" + timestamp + "&appkey=" + this.appkey + "&num=50&start=0"))).getString("c"))) {
            return result.getJSONObject("d");
        }
        String msg = this.handleErrorMsg(result);
        throw new Exception(msg);
    }

    public JSONObject getUserDesignRenderpicList(String designId) throws Exception {
        String timestamp = new Date().getTime() + "";
        String sign = this.getMD5(this.appsecret + this.appkey + timestamp);
        String url = this.openapi_url + "/v2/renderpic/list?sign=" + sign + "&timestamp=" + timestamp + "&appkey=" + this.appkey + "&num=50&start=0&design_id=" + designId;
        JSONObject result = RequestUtils.get((String)url);
        if ("0".equals(result.getString("c"))) {
            return result.getJSONObject("d");
        }
        String msg = this.handleErrorMsg(result);
        throw new Exception(msg);
    }

    public JSONObject getUserDesignAuditPlanList(String designId) throws Exception {
        String timestamp = new Date().getTime() + "";
        String sign = this.getMD5(this.appsecret + this.appkey + timestamp);
        String url = this.openapi_url + "/v2/cus/audit/design/" + designId + "?sign=" + sign + "&timestamp=" + timestamp + "&appkey=" + this.appkey + "&num=50&start=0&isOrderV2=true";
        JSONObject result = RequestUtils.get((String)url);
        if ("0".equals(result.getString("c"))) {
            return result.getJSONObject("d");
        }
        String msg = this.handleErrorMsg(result);
        throw new Exception(msg);
    }

    public JSONObject getUserAuditList(String name, int type, String email, String appuid) throws Exception {
        String url;
        JSONObject result;
        String sign;
        String timestamp = new Date().getTime() + "";
        boolean isRegister = this.isRegister(appuid, timestamp, sign = this.getMD5(this.appsecret + this.appkey + appuid + timestamp));
        if (!isRegister) {
            this.register(name, email, appuid, timestamp, sign);
        }
        if ("0".equals((result = RequestUtils.get((String)(url = this.openapi_url + "/v2/customization-order/audit/list?type=" + type + "&appuid=" + appuid + "&sign=" + sign + "&timestamp=" + timestamp + "&appkey=" + this.appkey + "&num=50&start=0"))).getString("c"))) {
            return result.getJSONObject("d");
        }
        String msg = this.handleErrorMsg(result);
        throw new Exception(msg);
    }

    public JSONObject getUserAuditList(String name, String email, String appuid) throws Exception {
        return this.getUserAuditList(name, 0, email, appuid);
    }

    public JSONObject getUserRenderpic(String appuid) throws Exception {
        String timestamp = new Date().getTime() + "";
        String sign = this.getMD5(this.appsecret + this.appkey + appuid + timestamp);
        String url = this.openapi_url + "/v2/renderpic/pano?appuid=" + appuid + "&sign=" + sign + "&timestamp=" + timestamp + "&appkey=" + this.appkey + "&num=50&start=0";
        JSONObject result = RequestUtils.get((String)url);
        if ("0".equals(result.getString("c"))) {
            return result.getJSONObject("d");
        }
        String msg = this.handleErrorMsg(result);
        throw new Exception(msg);
    }

    public String getAuditDesignUrl(String name, String designid, int designtype, int customtype, String obsorderdesignid, String email, String appuid) throws Exception {
        String sign;
        String timestamp = new Date().getTime() + "";
        boolean isRegister = this.isRegister(appuid, timestamp, sign = this.getMD5(this.appsecret + this.appkey + appuid + timestamp));
        if (!isRegister) {
            this.register(name, email, appuid, timestamp, sign);
        }
        String token = this.getToken(appuid, timestamp, sign);
        String url = this.design_url + "/v/auth?accesstoken=" + token + "&dest=11&designid=" + designid + "&obsorderdesignid=" + obsorderdesignid + "&customtype=" + customtype + "&designtype=" + designtype;
        return url;
    }

    public boolean executeUserEvent(String name, String templatekey, String orderreadableid, String eventkey, String body, String email, String appuid) throws Exception {
        String sign;
        String timestamp = new Date().getTime() + "";
        boolean isRegister = this.isRegister(appuid, timestamp, sign = this.getMD5(this.appsecret + this.appkey + appuid + timestamp));
        if (!isRegister) {
            this.register(name, email, appuid, timestamp, sign);
        }
        String url = this.openapi_url + "/v2/cus/order/event/execute?appuid=" + appuid + "&templatekey=" + templatekey + "&orderreadableid=" + orderreadableid + "&eventkey=" + eventkey + "&sign=" + sign + "&timestamp=" + timestamp + "&appkey=" + this.appkey;
        JSONObject result = null;
        result = body == null ? RequestUtils.post((String)url, null) : RequestUtils.post((String)url, (String)body, (String)"text/plain;charset=utf-8");
        if ("0".equals(result.getString("c"))) {
            return result.getBoolean("d");
        }
        String msg = this.handleErrorMsg(result);
        throw new Exception(msg);
    }

    public JSONObject getArchiveList(String designid) throws Exception {
        String timestamp = new Date().getTime() + "";
        String sign = this.getMD5(this.appsecret + this.appkey + timestamp);
        String url = this.openapi_url + "/v2/archive/list?design_id=" + designid + "&sign=" + sign + "&timestamp=" + timestamp + "&appkey=" + this.appkey;
        JSONObject result = RequestUtils.get((String)url);
        if ("0".equals(result.getString("c"))) {
            return result.getJSONObject("d");
        }
        String msg = this.handleErrorMsg(result);
        throw new Exception(msg);
    }

    public JSONObject getCADBluePrint(String designid) throws Exception {
        String timestamp = new Date().getTime() + "";
        String sign = this.getMD5(this.appsecret + this.appkey + timestamp);
        String url = this.openapi_url + "/v2/design/" + designid + "/cd?sign=" + sign + "&timestamp=" + timestamp + "&appkey=" + this.appkey;
        JSONObject result = RequestUtils.get((String)url);
        if ("0".equals(result.getString("c"))) {
            return result.getJSONObject("d");
        }
        String msg = this.handleErrorMsg(result);
        throw new Exception(msg);
    }

    public JSONObject createCADBluePrint(String designid, String body) throws Exception {
        String timestamp = new Date().getTime() + "";
        String sign = this.getMD5(this.appsecret + this.appkey + timestamp);
        String url = this.openapi_url + "/v2/design/" + designid + "/cd?sign=" + sign + "&timestamp=" + timestamp + "&appkey=" + this.appkey;
        JSONObject result = RequestUtils.post((String)url, (String)body);
        if ("0".equals(result.getString("c"))) {
            return result.getJSONObject("d");
        }
        String msg = this.handleErrorMsg(result);
        throw new Exception(msg);
    }

    public JSONObject initDetailList(String designid) throws Exception {
        String timestamp = new Date().getTime() + "";
        String sign = this.getMD5(this.appsecret + this.appkey + timestamp);
        String url = this.openapi_url + "/v2/listing/init?design_id=" + designid + "&sign=" + sign + "&timestamp=" + timestamp + "&appkey=" + this.appkey;
        JSONObject result = RequestUtils.get((String)url);
        if ("0".equals(result.getString("c"))) {
            return result.getJSONObject("d");
        }
        String msg = this.handleErrorMsg(result);
        throw new Exception(msg);
    }

    public String createDetailListTask(String name, String body, String email, String appuid) throws Exception {
        String url;
        JSONObject result;
        String sign;
        String timestamp = new Date().getTime() + "";
        boolean isRegister = this.isRegister(appuid, timestamp, sign = this.getMD5(this.appsecret + this.appkey + appuid + timestamp));
        if (!isRegister) {
            this.register(name, email, appuid, timestamp, sign);
        }
        if ("0".equals((result = RequestUtils.get((String)(url = this.openapi_url + "/v2/cus/task/listing?appuid=" + appuid + "&sign=" + sign + "&timestamp=" + timestamp + "&appkey=" + this.appkey))).getString("c"))) {
            JSONObject json = result.getJSONObject("d");
            return result.getString("d");
        }
        String msg = this.handleErrorMsg(result);
        throw new Exception(msg);
    }

    public String createProjectListTask(String name, String body, String email, String appuid) throws Exception {
        String url;
        JSONObject result;
        String sign;
        String timestamp = new Date().getTime() + "";
        boolean isRegister = this.isRegister(appuid, timestamp, sign = this.getMD5(this.appsecret + this.appkey + appuid + timestamp));
        if (!isRegister) {
            this.register(name, email, appuid, timestamp, sign);
        }
        if ("0".equals((result = RequestUtils.post((String)(url = this.openapi_url + "/v2/cus/task/design?appuid=" + appuid + "&sign=" + sign + "&timestamp=" + timestamp + "&appkey=" + this.appkey), (String)body)).getString("c"))) {
            return result.getString("d");
        }
        String msg = this.handleErrorMsg(result);
        throw new Exception(msg);
    }

    public int getTaskStatus(String task_id) throws Exception {
        String timestamp = new Date().getTime() + "";
        String sign = this.getMD5(this.appsecret + this.appkey + timestamp);
        String url = this.openapi_url + "/v2/cus/task/status?task_id=" + task_id + "&sign=" + sign + "&timestamp=" + timestamp + "&appkey=" + this.appkey;
        JSONObject result = RequestUtils.get((String)url);
        if ("0".equals(result.getString("c"))) {
            return result.getIntValue("d");
        }
        String msg = this.handleErrorMsg(result);
        throw new Exception(msg);
    }

    public String getTaskResult(String task_id) throws Exception {
        String timestamp = new Date().getTime() + "";
        String sign = this.getMD5(this.appsecret + this.appkey + timestamp);
        String url = this.openapi_url + "/v2/cus/task/result?task_id=" + task_id + "&sign=" + sign + "&timestamp=" + timestamp + "&appkey=" + this.appkey;
        JSONObject result = RequestUtils.get((String)url);
        if ("0".equals(result.getString("c"))) {
            return result.getString("d");
        }
        String msg = this.handleErrorMsg(result);
        throw new Exception(msg);
    }

    public String getProjectListTaskResult(String name, String designId, int type, int levelIndex, String auditDesignId, String orderDesignType, String quotationModeName, int wait, String fileName, String ftpFolderPath, String email, String appuid) throws Exception {
        JSONObject json = new JSONObject();
        json.put("designId", (Object)designId);
        json.put("type", (Object)type);
        json.put("isNewType", (Object)true);
        json.put("levelIndex", (Object)levelIndex);
        json.put("auditDesignId", (Object)auditDesignId);
        json.put("orderDesignType", (Object)orderDesignType);
        json.put("quotationModeName", (Object)quotationModeName);
        String taskId = this.createProjectListTask(name, json.toString(), email, appuid);
        for (int count = 0; count <= 100; ++count) {
            int status = this.getTaskStatus(taskId);
            if (status == 2) {
                boolean result;
                String jsonUrl = this.getTaskResult(taskId);
                if (StringUtil.isBlank((String)fileName)) {
                    fileName = jsonUrl.substring(jsonUrl.lastIndexOf("/") + 1);
                }
                String folderPath = File.separator + "uploads" + File.separator + "kujiale" + File.separator;
                String savePath = PropertyUtil.getPath() + folderPath + fileName;
                File folder = new File(PropertyUtil.getPath() + folderPath);
                if (!folder.exists()) {
                    folder.mkdirs();
                }
                if (result = RequestFileUtil.downLoadFromUrl((String)jsonUrl, (String)savePath)) {
                    FTPTools.uploadFileForWindows((String)this.server, (int)this.port, (String)this.user, (String)this.password, (String)ftpFolderPath, (String)savePath);
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    JSONArray jsonArray = new JSONArray();
                    JSONObject fileItem = new JSONObject();
                    fileItem.put("name", (Object)fileName);
                    File file = new File(savePath);
                    fileItem.put("path", (Object)(folderPath + fileName));
                    fileItem.put("size", (Object)(file.length() + ""));
                    fileItem.put("userName", (Object)"system");
                    fileItem.put("time", (Object)format.format(new Date()));
                    jsonArray.add((Object)fileItem);
                    return jsonArray.toString();
                }
            }
            Thread.sleep(wait);
        }
        return "";
    }

    public String createCusOrder(String name, String body, String email, String appuid) throws Exception {
        String url;
        JSONObject result;
        String sign;
        String timestamp = new Date().getTime() + "";
        boolean isRegister = this.isRegister(appuid, timestamp, sign = this.getMD5(this.appsecret + this.appkey + appuid + timestamp));
        if (!isRegister) {
            this.register(name, email, appuid, timestamp, sign);
        }
        if ("0".equals((result = RequestUtils.post((String)(url = this.openapi_url + "/v2/cus/order/create?appuid=" + appuid + "&sign=" + sign + "&timestamp=" + timestamp + "&appkey=" + this.appkey), (String)body)).getString("c"))) {
            return result.getString("d");
        }
        String msg = this.handleErrorMsg(result);
        throw new Exception(msg);
    }

    public String getOrderDetail(String name, String orderreadableid, String email, String appuid) throws Exception {
        String url;
        JSONObject result;
        String sign;
        String timestamp = new Date().getTime() + "";
        boolean isRegister = this.isRegister(appuid, timestamp, sign = this.getMD5(this.appsecret + this.appkey + appuid + timestamp));
        if (!isRegister) {
            this.register(name, email, appuid, timestamp, sign);
        }
        if ("0".equals((result = RequestUtils.get((String)(url = this.openapi_url + "/v2/cus/order/detail?appuid=" + appuid + "&orderreadableid=" + orderreadableid + "&sign=" + sign + "&timestamp=" + timestamp + "&appkey=" + this.appkey))).getString("c"))) {
            return result.getString("d");
        }
        String msg = this.handleErrorMsg(result);
        throw new Exception(msg);
    }

    public String getFileItem(String name, String orderreadableid, String userName, String email, String appuid) throws Exception {
        String orderDetail = this.getOrderDetail(name, orderreadableid, email, appuid);
        JSONObject orderDetailJson = JSONObject.parseObject((String)orderDetail);
        JSONArray attachmentList = orderDetailJson.getJSONArray("attachmentList");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        String folderPath = File.separator + "uploads" + File.separator + "item" + File.separator + year + File.separator;
        if (attachmentList != null && attachmentList.size() > 0) {
            JSONArray jsonArray = new JSONArray();
            for (JSONObject json : attachmentList) {
                String downloadUrl = json.getString("downloadUrl");
                String fileName = json.getString("fileName");
                long expire = json.getLong("expire");
                boolean flag = RequestFileUtil.downLoadFromUrl((String)downloadUrl, (String)(PropertyUtil.getPath() + folderPath + fileName));
                FileWriteUtil.writeKmConvertTask((String)PropertyUtil.getPath(), (String)fileName.substring(0, fileName.lastIndexOf(".")), (String)(PropertyUtil.getPath() + folderPath + fileName));
                if (!flag) continue;
                JSONObject fileItem = new JSONObject();
                fileItem.put("name", (Object)fileName);
                File file = new File(PropertyUtil.getPath() + folderPath + fileName);
                fileItem.put("path", (Object)(folderPath + fileName));
                fileItem.put("size", (Object)(file.length() + ""));
                fileItem.put("userName", (Object)userName);
                fileItem.put("time", (Object)format.format(new Date(expire)));
                jsonArray.add((Object)fileItem);
            }
            return jsonArray.toString();
        }
        return "";
    }

    public boolean associateCusOrderAndDesign(String name, String orderreadableid, String designidlist, String email, String appuid) throws Exception {
        String url;
        JSONObject result;
        String sign;
        String timestamp = new Date().getTime() + "";
        boolean isRegister = this.isRegister(appuid, timestamp, sign = this.getMD5(this.appsecret + this.appkey + appuid + timestamp));
        if (!isRegister) {
            this.register(name, email, appuid, timestamp, sign);
        }
        if ("0".equals((result = RequestUtils.post((String)(url = this.openapi_url + "/v2/cus/order/customer/associate/design?appuid=" + appuid + "&orderreadableid=" + orderreadableid + "&designidlist=" + designidlist + "&sign=" + sign + "&timestamp=" + timestamp + "&appkey=" + this.appkey), null)).getString("c"))) {
            return result.getBoolean("d");
        }
        String msg = this.handleErrorMsg(result);
        throw new Exception(msg);
    }

    public boolean cancelAssociateCusOrderAndDesign(String name, String orderreadableid, String designidlist, String email, String appuid) throws Exception {
        String url;
        JSONObject result;
        String sign;
        String timestamp = new Date().getTime() + "";
        boolean isRegister = this.isRegister(appuid, timestamp, sign = this.getMD5(this.appsecret + this.appkey + appuid + timestamp));
        if (!isRegister) {
            this.register(name, email, appuid, timestamp, sign);
        }
        if ("0".equals((result = RequestUtils.post((String)(url = this.openapi_url + "/v2/cus/order/customer/disassociate/design?appuid=" + appuid + "&orderreadableid=" + orderreadableid + "&designidlist=" + designidlist + "&sign=" + sign + "&timestamp=" + timestamp + "&appkey=" + this.appkey), null)).getString("c"))) {
            return result.getBoolean("d");
        }
        String msg = this.handleErrorMsg(result);
        throw new Exception(msg);
    }

    public boolean disassociateCusOrderAndDesign(String name, String orderreadableid, String designidlist, String email, String appuid) throws Exception {
        String url;
        JSONObject result;
        String sign;
        String timestamp = new Date().getTime() + "";
        boolean isRegister = this.isRegister(appuid, timestamp, sign = this.getMD5(this.appsecret + this.appkey + appuid + timestamp));
        if (!isRegister) {
            this.register(name, email, appuid, timestamp, sign);
        }
        if ("0".equals((result = RequestUtils.post((String)(url = this.openapi_url + "/v2/cus/order/customer/disassociate/design?appuid=" + appuid + "&orderreadableid=" + orderreadableid + "&designidlist=" + designidlist + "&sign=" + sign + "&timestamp=" + timestamp + "&appkey=" + this.appkey), null)).getString("c"))) {
            return result.getBoolean("d");
        }
        String msg = this.handleErrorMsg(result);
        throw new Exception(msg);
    }

    public JSONObject searchUserOrder(String name, String body, String email, String appuid) throws Exception {
        String url;
        JSONObject result;
        String sign;
        String timestamp = new Date().getTime() + "";
        boolean isRegister = this.isRegister(appuid, timestamp, sign = this.getMD5(this.appsecret + this.appkey + appuid + timestamp));
        if (!isRegister) {
            this.register(name, email, appuid, timestamp, sign);
        }
        if ("0".equals((result = RequestUtils.post((String)(url = this.openapi_url + "/v2/cus/order/search?appuid=" + appuid + "&sign=" + sign + "&timestamp=" + timestamp + "&appkey=" + this.appkey), (String)body.toString())).getString("c"))) {
            JSONObject json = result.getJSONObject("d");
            return result.getJSONObject("d");
        }
        String msg = this.handleErrorMsg(result);
        throw new Exception(msg);
    }

    public JSONObject getUserOrderAndDesignAssociateList(String name, String email, String appuid) throws Exception {
        String url;
        JSONObject result;
        String sign;
        String timestamp = new Date().getTime() + "";
        boolean isRegister = this.isRegister(appuid, timestamp, sign = this.getMD5(this.appsecret + this.appkey + appuid + timestamp));
        if (!isRegister) {
            this.register(name, email, appuid, timestamp, sign);
        }
        if ("0".equals((result = RequestUtils.get((String)(url = this.openapi_url + "/v2/cus/order/design/list?appuid=" + appuid + "&sign=" + sign + "&timestamp=" + timestamp + "&appkey=" + this.appkey + "&num=10000&start=0"))).getString("c"))) {
            JSONObject json = result.getJSONObject("d");
            return result.getJSONObject("d");
        }
        String msg = this.handleErrorMsg(result);
        throw new Exception(msg);
    }

    public String getAssociateDesignFromKujiale(String name, String orderreadableid, String email, String appuid) throws Exception {
        JSONObject associateJson = this.getUserOrderAndDesignAssociateList(name, email, appuid);
        JSONArray result = associateJson.getJSONArray("result");
        String designIds = "";
        for (JSONObject associate : result) {
            String orderReadableId;
            boolean orderAssociated = associate.getBoolean("orderAssociated");
            if (!orderAssociated || !orderreadableid.equals(orderReadableId = associate.getString("orderReadableId"))) continue;
            String designId = associate.getString("designId");
            if (designIds.equals("")) {
                designIds = designId;
                continue;
            }
            designIds = designIds + "," + designId;
        }
        return designIds;
    }

    public String getMD5(String str) throws Exception {
        return DigestUtils.md5Hex((String)str);
    }

    private String handleErrorMsg(JSONObject json) {
        String code = json.getString("c");
        String msg = json.getString("m");
        if ("100001".equals(code)) {
            msg = "\u7528\u6237\u672a\u6ce8\u518c,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!";
        }
        return msg;
    }
}

