/*
 * Decompiled with CFR 0.152.
 */
package com.teemlink.kujiale.controller;

import cn.myapps.common.model.ValueObject;
import cn.myapps.common.util.StringUtil;
import cn.myapps.runtime.dynaform.document.ejb.Document;
import cn.myapps.runtime.dynaform.document.ejb.DocumentProcess;
import cn.myapps.runtime.dynaform.document.ejb.Item;
import cn.myapps.util.ProcessFactory;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.teemlink.kujiale.controller.ResultData;
import com.teemlink.kujiale.util.KujialeUtil;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/api/runtime/kujiale"}, produces={"application/json;charset=UTF-8"})
public class KujialeController {
    @GetMapping(value={"/users/{id}/designs"})
    public ResultData getUserDesignList(@PathVariable String id, @RequestParam String email, @RequestParam String name, @RequestParam(required=false) String orderreadableid) throws Exception {
        KujialeUtil kujialeUtil = new KujialeUtil();
        JSONObject json = kujialeUtil.getUserDesignList(name, email, id);
        if (!StringUtil.isBlank((String)orderreadableid)) {
            JSONArray result = json.getJSONArray("result");
            JSONObject associateJson = kujialeUtil.getUserOrderAndDesignAssociateList(name, email, id);
            JSONArray associateList = associateJson.getJSONArray("result");
            String designIds = "";
            for (JSONObject associate : associateList) {
                boolean orderAssociated = associate.getBoolean("orderAssociated");
                if (!orderAssociated) continue;
                String designId = associate.getString("designId");
                if (designIds.equals("")) {
                    designIds = designId;
                    continue;
                }
                designIds = designIds + "," + designId;
            }
            for (JSONObject design : result) {
                String designId = design.getString("designId");
                if (!designIds.contains(designId)) continue;
                design.put("orderAssociated", (Object)true);
            }
        }
        return new ResultData(0, "ok", json);
    }

    @GetMapping(value={"/users/{id}/designs/{designid}/url"})
    public ResultData getDesignUrl(@PathVariable String id, @PathVariable String designid, @RequestParam String email, @RequestParam String name) throws Exception {
        String result = new KujialeUtil().getDesignUrl(name, designid, email, id);
        return new ResultData(0, "ok", result);
    }

    @GetMapping(value={"/users/designs/{designid}/renderpic"})
    public ResultData getUserDesignRenderpicList(@PathVariable String designid) throws Exception {
        JSONObject json = new KujialeUtil().getUserDesignRenderpicList(designid);
        return new ResultData(0, "ok", json);
    }

    @PutMapping(value={"/users/{id}/orders/{orderreadableid}/associate"})
    public ResultData associateOrderAndDesign(@PathVariable String id, @PathVariable String orderreadableid, String designIds, @RequestParam(required=false) String applicationId, @RequestParam(required=false) String docId, @RequestParam(required=false) String fieldName, @RequestParam String email, @RequestParam String name) {
        try {
            boolean result = new KujialeUtil().associateCusOrderAndDesign(name, orderreadableid, designIds, email, id);
            if (result && !StringUtil.isBlank((String)docId)) {
                DocumentProcess documentProcess = (DocumentProcess)ProcessFactory.createRuntimeProcess(DocumentProcess.class, (String)applicationId);
                Document doc = (Document)documentProcess.doView(docId);
                Item item = doc.findItem(fieldName);
                if (item.getValue() != null && !StringUtil.isBlank((String)item.getVarcharvalue())) {
                    item.setValue((Object)(item.getValue() + "," + designIds));
                } else {
                    item.setValue((Object)designIds);
                }
                documentProcess.doUpdate((ValueObject)doc);
            }
            return new ResultData(0, "ok", result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResultData(500, e.getMessage());
        }
    }

    @PutMapping(value={"/users/{id}/orders/{orderreadableid}/cancelAssociate"})
    public ResultData cancelAssociateOrderAndDesign(@PathVariable String id, @PathVariable String orderreadableid, String designId, @RequestParam(required=false) String applicationId, @RequestParam(required=false) String docId, @RequestParam(required=false) String fieldName, @RequestParam String email, @RequestParam String name) {
        try {
            boolean result = new KujialeUtil().cancelAssociateCusOrderAndDesign(name, orderreadableid, designId, email, id);
            String value = "";
            if (result && !StringUtil.isBlank((String)docId)) {
                DocumentProcess documentProcess = (DocumentProcess)ProcessFactory.createRuntimeProcess(DocumentProcess.class, (String)applicationId);
                Document doc = (Document)documentProcess.doView(docId);
                Item item = doc.findItem(fieldName);
                String[] values = item.getVarcharvalue().split(",");
                for (int i = 0; i < values.length; ++i) {
                    String val = values[i];
                    if (designId.equals(val)) continue;
                    value = "".equals(value) ? val : value + "," + val;
                }
                item.setValue((Object)value);
                documentProcess.doUpdate((ValueObject)doc);
            }
            return new ResultData(0, "ok", value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResultData(500, e.getMessage());
        }
    }
}

