/*
 * Decompiled with CFR 0.152.
 */
package com.jgqz.jgutil;

import cn.myapps.base.web.WebUser;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.ValueObject;
import cn.myapps.common.model.workflow.BillDefiVO;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.common.util.SpringApplicationContextUtil;
import cn.myapps.common.util.cache.MemoryCacheUtil;
import cn.myapps.conf.FeignConfig;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.form.service.FormDesignTimeService;
import cn.myapps.runtime.common.feign.service.KmsFeignService;
import cn.myapps.runtime.common.service.RunTimeServiceManager;
import cn.myapps.runtime.dynaform.document.ejb.Document;
import cn.myapps.runtime.dynaform.document.ejb.DocumentProcess;
import cn.myapps.runtime.dynaform.document.model.IDocument;
import cn.myapps.runtime.dynaform.form.ejb.ButtonField;
import cn.myapps.runtime.dynaform.form.ejb.Form;
import cn.myapps.runtime.dynaform.form.ejb.FormField;
import cn.myapps.runtime.macro.runner.IRunner;
import cn.myapps.runtime.macro.runner.JavaScriptFactory;
import cn.myapps.runtime.workflow.element.FlowDiagram;
import cn.myapps.runtime.workflow.element.Node;
import cn.myapps.runtime.workflow.element.Relation;
import cn.myapps.runtime.workflow.engine.StateMachine;
import cn.myapps.runtime.workflow.storage.runtime.ejb.FlowStateRT;
import cn.myapps.runtime.workflow.storage.runtime.ejb.NodeRT;
import cn.myapps.util.ProcessFactory;
import cn.myapps.util.StringUtil;
import cn.myapps.util.file.FileOperate;
import cn.myapps.util.http.CookieUtil;
import cn.myapps.util.sequence.Sequence;
import com.kinggrid.pdf.KGExecute;
import com.kinggrid.pdf.KGPdfHummer;
import com.kinggrid.pdf.executes.DeleteElectronicSeal;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;

public class PdfSignatureUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createPdf(String fileName, String applicationId, String formId, String docId, WebUser user, ParamsTable params, HttpServletRequest request) {
        FileOutputStream out = null;
        try {
            JSONObject kinggridSignatureJson;
            DocumentProcess proxy = RunTimeServiceManager.documentProcess((String)applicationId);
            Document doc = (Document)proxy.doView(docId);
            boolean flag = true;
            if (doc == null) {
                flag = false;
                doc = (Document)MemoryCacheUtil.getFromPrivateSpace((Object)docId, (IUser)user);
            }
            String pTotalLable = "";
            String cTotalLable = "";
            String language = CookieUtil.getMultiLanguage((HttpServletRequest)request);
            if ("CN".equals(language)) {
                pTotalLable = "\u5f53\u524d\u9875\u5c0f\u8ba1";
                cTotalLable = "\u603b\u8ba1";
            } else if ("TW".equals(language)) {
                pTotalLable = "\u7576\u524d\u9801\u5c0f\u8a08";
                cTotalLable = "\u7e3d\u8a08";
            } else if ("EN".equals(language)) {
                pTotalLable = "Current page total";
                cTotalLable = "Grand total";
            }
            FormDesignTimeService formService = DesignTimeServiceManager.formDesignTimeService();
            Form form = formService.doView(formId);
            StringBuffer html = new StringBuffer();
            html.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
            html.append("<html>\n<head>\n");
            html.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />\n");
            String pdfA4CssFilePath = PropertyUtil.getPath() + File.separator + "pdf" + File.separator + "pdf-a4.css";
            html.append(this.getCssContent(pdfA4CssFilePath));
            html.append("</head>\n");
            html.append("<body>\n");
            html.append("<div id=\"container\">\n");
            html.append("<table id=\"toAll\">");
            html.append("<tr>\n");
            html.append("<td valign=\"top\" colspan=\"2\">\n");
            html.append(form.toPdfHtml(doc, params, (IUser)user, new ArrayList())).append("\n");
            html.append("</td></tr></table>");
            html.append("</div>\n");
            html.append("</body>\n");
            html.append("</html>\n");
            String pdfHtml = html.toString().replace("{*[cn.myapps.runtime.dynaform.view.current_page_total]*}", pTotalLable).replace("{*[cn.myapps.runtime.dynaform.view.Grant_Total]*}", cTotalLable);
            pdfHtml = pdfHtml.replaceAll("&nbsp;", "<span style=\"color:white;\">n</span>");
            Calendar cal = Calendar.getInstance();
            int year = cal.get(1);
            int month = cal.get(2) + 1;
            String path = File.separator + "uploads" + File.separator + "pdf" + File.separator + year + month + File.separator;
            String realPath = PropertyUtil.getPath() + path;
            File folder = new File(realPath);
            if (!folder.exists()) {
                folder.mkdirs();
            }
            if (StringUtil.isBlank((String)fileName)) {
                fileName = Sequence.getSequence() + ".pdf";
            }
            String filePath = realPath + "temp.html";
            FileOutputStream fos = new FileOutputStream(filePath);
            fos.write("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">".getBytes());
            fos.write(pdfHtml.getBytes());
            fos.close();
            FeignConfig.ACCESS_TOKEN = user.getACCESS_TOKEN(request);
            String outputPDF = realPath + fileName + ".pdf";
            String pdfPath = File.separator + "uploads" + File.separator + "exportPdf" + File.separator + fileName + ".pdf";
            KmsFeignService kmsFeignService = (KmsFeignService)SpringApplicationContextUtil.getBean(KmsFeignService.class);
            kmsFeignService.htmlConvertPdf(filePath, outputPDF);
            String savePath = outputPDF.substring(realPath.lastIndexOf("uploads") - 1).replace("\\", "/");
            String kinggridSignature = doc.getKinggridSignature();
            if (StringUtil.isBlank((String)kinggridSignature)) {
                kinggridSignatureJson = new JSONObject();
                JSONObject pdfSignature = new JSONObject();
                pdfSignature.put((Object)"pdfUrl", (Object)savePath);
                kinggridSignatureJson.put((Object)"pdfSignature", (Object)pdfSignature);
                doc.setKinggridSignature(kinggridSignatureJson.toString());
            } else {
                kinggridSignatureJson = JSONObject.fromObject((Object)kinggridSignature);
                JSONObject pdfSignatureJson = new JSONObject();
                pdfSignatureJson.put((Object)"pdfUrl", (Object)savePath);
                kinggridSignatureJson.put((Object)"pdfSignature", (Object)pdfSignatureJson);
                doc.setKinggridSignature(kinggridSignatureJson.toString());
            }
            if (flag) {
                proxy.doUpdate((ValueObject)doc);
            }
            Document document = (Document)MemoryCacheUtil.getFromPrivateSpace((Object)doc.getId(), (IUser)user);
            document.setKinggridSignature(doc.getKinggridSignature());
            MemoryCacheUtil.putToPrivateSpace((Object)doc.getId(), (Object)document, (IUser)user);
            String string = pdfPath;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            String string = e.getMessage();
            return string;
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isSignature(String applicationId, String docId, String position) {
        try {
            JSONObject signaturesJson;
            Object data;
            JSONObject pdfSignatureJson;
            Object signatures;
            JSONObject kinggridSignatureJson;
            Object pdfSignature;
            String kinggridSignature;
            DocumentProcess process = (DocumentProcess)ProcessFactory.createRuntimeProcess(DocumentProcess.class, (String)applicationId);
            Document doc = (Document)process.doView(docId);
            if (doc != null && !StringUtil.isBlank((String)(kinggridSignature = doc.getKinggridSignature())) && (pdfSignature = (kinggridSignatureJson = JSONObject.fromObject((Object)kinggridSignature)).get("pdfSignature")) != null && (signatures = (pdfSignatureJson = (JSONObject)pdfSignature).get("signatures")) != null && (data = (signaturesJson = (JSONObject)signatures).get("data")) != null) {
                Collection dataList = (Collection)data;
                for (JSONObject signature : dataList) {
                    String pos = signature.getString("position");
                    if (!position.equals(pos)) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public void recordSignatrueAmounts(String applicationId, String docId, String recordDocId, ParamsTable params, WebUser user) {
        try {
            DocumentProcess process = (DocumentProcess)ProcessFactory.createRuntimeProcess(DocumentProcess.class, (String)applicationId);
            Document doc = (Document)process.doView(docId);
            if (doc != null) {
                if (!StringUtil.isBlank((String)recordDocId)) {
                    Document recordDoc = (Document)process.doView(recordDocId);
                    if (recordDoc != null) {
                        FlowStateRT flowStateRT = doc.getState();
                        if (flowStateRT != null) {
                            Collection nodeRTs = flowStateRT.getNoderts();
                            FlowDiagram fd = flowStateRT.getFlowVO().toFlowDiagram();
                            for (NodeRT nodeRT : nodeRTs) {
                                JSONObject kinggridSignatureJson;
                                Node currnode = fd.getNodeByID(nodeRT.getNodeid());
                                String kinggridSignature = recordDoc.getKinggridSignature();
                                if (!StringUtil.isBlank((String)kinggridSignature)) {
                                    JSONObject pdfSignatureJson;
                                    kinggridSignatureJson = JSONObject.fromObject((Object)kinggridSignature);
                                    Object pdfSignature = kinggridSignatureJson.get("pdfSignature");
                                    if (pdfSignature != null) {
                                        Object data;
                                        JSONObject signaturesJson;
                                        pdfSignatureJson = (JSONObject)pdfSignature;
                                        Object signatures = pdfSignatureJson.get("signatures");
                                        if (signatures != null) {
                                            JSONArray dataArr;
                                            signaturesJson = (JSONObject)signatures;
                                            data = signaturesJson.get("data");
                                            if (data != null) {
                                                dataArr = (JSONArray)data;
                                                int maxSignatureNum = 0;
                                                boolean isExist = false;
                                                for (JSONObject signature : dataArr) {
                                                    int signatureNum = signature.getInt("signatureNum");
                                                    String nodeId = signature.getString("nodeId");
                                                    if (signatureNum > maxSignatureNum) {
                                                        maxSignatureNum = signatureNum;
                                                    }
                                                    if (!nodeId.equalsIgnoreCase(currnode.id)) continue;
                                                    isExist = true;
                                                }
                                                if (!isExist) {
                                                    JSONObject signature;
                                                    signature = new JSONObject();
                                                    signature.put((Object)"position", (Object)"ignore");
                                                    signature.put((Object)"userId", (Object)"ignore");
                                                    signature.put((Object)"isSignature", (Object)false);
                                                    signature.put((Object)"signatureNum", (Object)(++maxSignatureNum));
                                                    signature.put((Object)"nodeId", (Object)currnode.id);
                                                    signature.put((Object)"statelabel", (Object)currnode.statelabel);
                                                    dataArr.add((Object)signature);
                                                    signaturesJson.put((Object)"data", (Object)dataArr);
                                                }
                                            } else {
                                                dataArr = new JSONArray();
                                                JSONObject signature = new JSONObject();
                                                signature.put((Object)"position", (Object)"ignore");
                                                signature.put((Object)"userId", (Object)"ignore");
                                                signature.put((Object)"isSignature", (Object)false);
                                                signature.put((Object)"signatureNum", (Object)0);
                                                signature.put((Object)"nodeId", (Object)currnode.id);
                                                signature.put((Object)"statelabel", (Object)currnode.statelabel);
                                                dataArr.add((Object)signature);
                                                signaturesJson.put((Object)"data", (Object)dataArr);
                                            }
                                            pdfSignatureJson.put((Object)"signatures", (Object)signaturesJson);
                                        } else {
                                            signaturesJson = new JSONObject();
                                            data = new JSONArray();
                                            JSONObject signature = new JSONObject();
                                            signature.put((Object)"position", (Object)"ignore");
                                            signature.put((Object)"userId", (Object)"ignore");
                                            signature.put((Object)"isSignature", (Object)false);
                                            signature.put((Object)"signatureNum", (Object)0);
                                            signature.put((Object)"nodeId", (Object)currnode.id);
                                            signature.put((Object)"statelabel", (Object)currnode.statelabel);
                                            data.add((Object)signature);
                                            signaturesJson.put((Object)"data", data);
                                            pdfSignatureJson.put((Object)"signatures", (Object)signaturesJson);
                                        }
                                        kinggridSignatureJson.put((Object)"pdfSignature", (Object)pdfSignatureJson);
                                        recordDoc.setKinggridSignature(kinggridSignatureJson.toString());
                                        process.doUpdate((ValueObject)recordDoc);
                                        continue;
                                    }
                                    pdfSignatureJson = new JSONObject();
                                    JSONObject signaturesJson = new JSONObject();
                                    JSONArray dataArr = new JSONArray();
                                    JSONObject signature = new JSONObject();
                                    signature.put((Object)"position", (Object)"ignore");
                                    signature.put((Object)"userId", (Object)"ignore");
                                    signature.put((Object)"isSignature", (Object)false);
                                    signature.put((Object)"signatureNum", (Object)0);
                                    signature.put((Object)"nodeId", (Object)currnode.id);
                                    signature.put((Object)"statelabel", (Object)currnode.statelabel);
                                    dataArr.add((Object)signature);
                                    signaturesJson.put((Object)"data", (Object)dataArr);
                                    pdfSignatureJson.put((Object)"signatures", (Object)signaturesJson);
                                    kinggridSignatureJson.put((Object)"pdfSignature", (Object)pdfSignatureJson);
                                    recordDoc.setKinggridSignature(kinggridSignatureJson.toString());
                                    process.doUpdate((ValueObject)recordDoc);
                                    continue;
                                }
                                kinggridSignatureJson = new JSONObject();
                                JSONObject pdfSignatureJson = new JSONObject();
                                JSONObject signaturesJson = new JSONObject();
                                JSONArray dataArr = new JSONArray();
                                JSONObject signature = new JSONObject();
                                signature.put((Object)"position", (Object)"ignore");
                                signature.put((Object)"userId", (Object)"ignore");
                                signature.put((Object)"isSignature", (Object)false);
                                signature.put((Object)"signatureNum", (Object)0);
                                signature.put((Object)"nodeId", (Object)currnode.id);
                                signature.put((Object)"statelabel", (Object)currnode.statelabel);
                                dataArr.add((Object)signature);
                                signaturesJson.put((Object)"data", (Object)dataArr);
                                pdfSignatureJson.put((Object)"signatures", (Object)signaturesJson);
                                kinggridSignatureJson.put((Object)"pdfSignature", (Object)pdfSignatureJson);
                                recordDoc.setKinggridSignature(kinggridSignatureJson.toString());
                                process.doUpdate((ValueObject)recordDoc);
                            }
                        }
                        Document document = (Document)MemoryCacheUtil.getFromPrivateSpace((Object)recordDoc.getId(), (IUser)user);
                        document.setKinggridSignature(recordDoc.getKinggridSignature());
                        MemoryCacheUtil.putToPrivateSpace((Object)recordDoc.getId(), (Object)document, (IUser)user);
                    }
                } else {
                    FlowStateRT flowStateRT = doc.getState();
                    if (flowStateRT != null) {
                        Collection nodeRTs = doc.getState().getNoderts();
                        FlowDiagram fd = flowStateRT.getFlowVO().toFlowDiagram();
                        for (NodeRT nodeRT : nodeRTs) {
                            JSONObject kinggridSignatureJson;
                            Node currnode = fd.getNodeByID(nodeRT.getNodeid());
                            String kinggridSignature = doc.getKinggridSignature();
                            if (!StringUtil.isBlank((String)kinggridSignature)) {
                                JSONObject pdfSignatureJson;
                                kinggridSignatureJson = JSONObject.fromObject((Object)kinggridSignature);
                                Object pdfSignature = kinggridSignatureJson.get("pdfSignature");
                                if (pdfSignature != null) {
                                    Object data;
                                    JSONObject signaturesJson;
                                    pdfSignatureJson = (JSONObject)pdfSignature;
                                    Object signatures = pdfSignatureJson.get("signatures");
                                    if (signatures != null) {
                                        JSONArray dataArr;
                                        signaturesJson = (JSONObject)signatures;
                                        data = signaturesJson.get("data");
                                        if (data != null) {
                                            dataArr = (JSONArray)data;
                                            int maxSignatureNum = 0;
                                            boolean isExist = false;
                                            for (JSONObject signature : dataArr) {
                                                int signatureNum = signature.getInt("signatureNum");
                                                String nodeId = signature.getString("nodeId");
                                                if (signatureNum > maxSignatureNum) {
                                                    maxSignatureNum = signatureNum;
                                                }
                                                if (!nodeId.equalsIgnoreCase(currnode.id)) continue;
                                                isExist = true;
                                            }
                                            if (!isExist) {
                                                JSONObject signature;
                                                signature = new JSONObject();
                                                signature.put((Object)"position", (Object)"ignore");
                                                signature.put((Object)"userId", (Object)"ignore");
                                                signature.put((Object)"isSignature", (Object)false);
                                                signature.put((Object)"signatureNum", (Object)(++maxSignatureNum));
                                                signature.put((Object)"nodeId", (Object)currnode.id);
                                                signature.put((Object)"statelabel", (Object)currnode.statelabel);
                                                dataArr.add((Object)signature);
                                                signaturesJson.put((Object)"data", (Object)dataArr);
                                            }
                                        } else {
                                            dataArr = new JSONArray();
                                            JSONObject signature = new JSONObject();
                                            signature.put((Object)"position", (Object)"ignore");
                                            signature.put((Object)"userId", (Object)"ignore");
                                            signature.put((Object)"isSignature", (Object)false);
                                            signature.put((Object)"signatureNum", (Object)0);
                                            signature.put((Object)"nodeId", (Object)currnode.id);
                                            signature.put((Object)"statelabel", (Object)currnode.statelabel);
                                            dataArr.add((Object)signature);
                                            signaturesJson.put((Object)"data", (Object)dataArr);
                                        }
                                        pdfSignatureJson.put((Object)"signatures", (Object)signaturesJson);
                                    } else {
                                        signaturesJson = new JSONObject();
                                        data = new JSONArray();
                                        JSONObject signature = new JSONObject();
                                        signature.put((Object)"position", (Object)"ignore");
                                        signature.put((Object)"userId", (Object)"ignore");
                                        signature.put((Object)"isSignature", (Object)false);
                                        signature.put((Object)"signatureNum", (Object)0);
                                        signature.put((Object)"nodeId", (Object)currnode.id);
                                        signature.put((Object)"statelabel", (Object)currnode.statelabel);
                                        data.add((Object)signature);
                                        signaturesJson.put((Object)"data", data);
                                        pdfSignatureJson.put((Object)"signatures", (Object)signaturesJson);
                                    }
                                    kinggridSignatureJson.put((Object)"pdfSignature", (Object)pdfSignatureJson);
                                    doc.setKinggridSignature(kinggridSignatureJson.toString());
                                    process.doUpdate((ValueObject)doc);
                                    continue;
                                }
                                pdfSignatureJson = new JSONObject();
                                JSONObject signaturesJson = new JSONObject();
                                JSONArray dataArr = new JSONArray();
                                JSONObject signature = new JSONObject();
                                signature.put((Object)"position", (Object)"ignore");
                                signature.put((Object)"userId", (Object)"ignore");
                                signature.put((Object)"isSignature", (Object)false);
                                signature.put((Object)"signatureNum", (Object)0);
                                signature.put((Object)"nodeId", (Object)currnode.id);
                                signature.put((Object)"statelabel", (Object)currnode.statelabel);
                                dataArr.add((Object)signature);
                                signaturesJson.put((Object)"data", (Object)dataArr);
                                pdfSignatureJson.put((Object)"signatures", (Object)signaturesJson);
                                kinggridSignatureJson.put((Object)"pdfSignature", (Object)pdfSignatureJson);
                                doc.setKinggridSignature(kinggridSignatureJson.toString());
                                process.doUpdate((ValueObject)doc);
                                continue;
                            }
                            kinggridSignatureJson = new JSONObject();
                            JSONObject pdfSignatureJson = new JSONObject();
                            JSONObject signaturesJson = new JSONObject();
                            JSONArray dataArr = new JSONArray();
                            JSONObject signature = new JSONObject();
                            signature.put((Object)"position", (Object)"ignore");
                            signature.put((Object)"userId", (Object)"ignore");
                            signature.put((Object)"isSignature", (Object)false);
                            signature.put((Object)"signatureNum", (Object)0);
                            signature.put((Object)"nodeId", (Object)currnode.id);
                            signature.put((Object)"statelabel", (Object)currnode.statelabel);
                            dataArr.add((Object)signature);
                            signaturesJson.put((Object)"data", (Object)dataArr);
                            pdfSignatureJson.put((Object)"signatures", (Object)signaturesJson);
                            kinggridSignatureJson.put((Object)"pdfSignature", (Object)pdfSignatureJson);
                            doc.setKinggridSignature(kinggridSignatureJson.toString());
                            process.doUpdate((ValueObject)doc);
                        }
                    }
                    Document document = (Document)MemoryCacheUtil.getFromPrivateSpace((Object)doc.getId(), (IUser)user);
                    document.setKinggridSignature(doc.getKinggridSignature());
                    MemoryCacheUtil.putToPrivateSpace((Object)doc.getId(), (Object)document, (IUser)user);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean checkSignatureAmounts(String applicationId, String docId, ParamsTable params, WebUser user) {
        try {
            DocumentProcess process = (DocumentProcess)ProcessFactory.createRuntimeProcess(DocumentProcess.class, (String)applicationId);
            Document doc = (Document)process.doView(docId);
            if (doc != null) {
                Form form = doc.getForm();
                int mySignatureActsCount = this.getSignatureAct(doc = form.recalculateDocument(doc, params, (IUser)user), form.getAllFields(), params, user, new ArrayList<Integer>());
                return mySignatureActsCount == 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    private String getCssContent(String url) throws Exception {
        StringBuffer content = new StringBuffer();
        content.append("<style>\n");
        String filePath = url;
        content.append(FileOperate.getFileContentAsString((String)filePath));
        content.append("</style>\n");
        return content.toString();
    }

    private Node getCurrentNode(Document doc, WebUser user) throws Exception {
        FlowStateRT instance = doc.getState();
        if (instance != null) {
            BillDefiVO flowVO = instance.getFlowVO();
            String currNodeId = null;
            FlowDiagram fd = null;
            if (flowVO != null) {
                NodeRT nodert = null;
                fd = flowVO.toFlowDiagram();
                if (instance.isTemp()) {
                    nodert = (NodeRT)((List)instance.getNoderts()).get(0);
                    currNodeId = nodert.getNodeid();
                }
                if (currNodeId == null && nodert == null && (nodert = StateMachine.getCurrUserNodeRT((IDocument)doc, (IUser)user, currNodeId)) != null) {
                    currNodeId = nodert.getNodeid();
                }
            }
            Node currnode = null;
            if (currNodeId != null) {
                currnode = (Node)fd.getElementByID(currNodeId);
            }
            return currnode;
        }
        return null;
    }

    private int getSignatureAct(Document doc, Collection<FormField> fields, ParamsTable params, WebUser user, List<Integer> signatureActsCount) throws Exception {
        int mySignatureActsCount = 0;
        IRunner runner = JavaScriptFactory.getInstance((String)user.getSessionid(), (String)doc.getApplicationid());
        runner.initBSFManager((IDocument)doc, params, (IUser)user, new ArrayList());
        for (FormField formField : fields) {
            int displayType;
            String signatureAction;
            if (!(formField instanceof ButtonField) || ((ButtonField)formField).getActType() != 28 || !"PDF".equals(((ButtonField)formField).getSignatureType()) || "date".equals(signatureAction = ((ButtonField)formField).getSignatureAction()) || (displayType = formField.getDisplayType(doc, runner, (IUser)user, 2)) == 3) continue;
            ++mySignatureActsCount;
            signatureActsCount.add(1);
        }
        return mySignatureActsCount;
    }

    public void deleteSignatures(String applicationId, String docId, String deleteDocId, WebUser user) {
        try {
            DocumentProcess process = (DocumentProcess)ProcessFactory.createRuntimeProcess(DocumentProcess.class, (String)applicationId);
            Document doc = (Document)process.doView(docId);
            if (doc != null) {
                if (!StringUtil.isBlank((String)deleteDocId)) {
                    Document deleteDoc = (Document)process.doView(deleteDocId);
                    if (deleteDoc != null) {
                        FlowStateRT flowStateRT;
                        JSONObject signaturesJson;
                        Object data;
                        JSONObject pdfSignatureJson;
                        Object signatures;
                        JSONObject kinggridSignature;
                        Object pdfSignature;
                        if (!StringUtil.isBlank((String)deleteDoc.getKinggridSignature()) && (pdfSignature = (kinggridSignature = JSONObject.fromObject((Object)deleteDoc.getKinggridSignature())).get("pdfSignature")) != null && (signatures = (pdfSignatureJson = (JSONObject)pdfSignature).get("signatures")) != null && (data = (signaturesJson = (JSONObject)signatures).get("data")) != null && (flowStateRT = doc.getState()) != null) {
                            Collection nodeRTs = flowStateRT.getNoderts();
                            FlowDiagram fd = flowStateRT.getFlowVO().toFlowDiagram();
                            Node firstNode = fd.getFirstNode();
                            String pdfUrl = pdfSignatureJson.getString("pdfUrl");
                            int signatureCount = 0;
                            JSONArray dataArr = (JSONArray)data;
                            for (JSONObject dataJson : dataArr) {
                                Object isSignatureObj = dataJson.get("isSignature");
                                if (isSignatureObj != null) {
                                    boolean isSignature = dataJson.getBoolean("isSignature");
                                    if (!isSignature) continue;
                                    ++signatureCount;
                                    continue;
                                }
                                ++signatureCount;
                            }
                            NodeRT nodeRT = (NodeRT)nodeRTs.iterator().next();
                            if (nodeRT != null) {
                                Node currnode = fd.getNodeByID(nodeRT.getNodeid());
                                if (this.isFirstNode(fd, currnode)) {
                                    for (int i = 0; i < signatureCount; ++i) {
                                        PdfSignatureUtil.delElectronicSeal(pdfUrl);
                                    }
                                    signaturesJson.put((Object)"data", (Object)new JSONArray());
                                    pdfSignatureJson.put((Object)"signatures", (Object)signaturesJson);
                                    kinggridSignature.put((Object)"pdfSignature", (Object)pdfSignatureJson);
                                    deleteDoc.setKinggridSignature(kinggridSignature.toString());
                                    process.doUpdate((ValueObject)deleteDoc);
                                } else {
                                    JSONObject signature;
                                    Iterator iterator = dataArr.iterator();
                                    boolean countDeleteNum = false;
                                    int minSignatureNum = 1000;
                                    while (iterator.hasNext()) {
                                        signature = (JSONObject)iterator.next();
                                        String nodeId = signature.getString("nodeId");
                                        int signatureNum = signature.getInt("signatureNum");
                                        if (!currnode.id.equals(nodeId) || signatureNum >= minSignatureNum) continue;
                                        minSignatureNum = signatureNum;
                                    }
                                    iterator = dataArr.iterator();
                                    while (iterator.hasNext()) {
                                        signature = (JSONObject)iterator.next();
                                        int signatureNum = signature.getInt("signatureNum");
                                        if (signatureNum < minSignatureNum) continue;
                                        iterator.remove();
                                    }
                                    signature = new JSONObject();
                                    signature.put((Object)"position", (Object)"ignore");
                                    signature.put((Object)"userId", (Object)"ignore");
                                    signature.put((Object)"isSignature", (Object)false);
                                    signature.put((Object)"signatureNum", (Object)minSignatureNum);
                                    signature.put((Object)"nodeId", (Object)currnode.id);
                                    signature.put((Object)"statelabel", (Object)currnode.statelabel);
                                    dataArr.add((Object)signature);
                                    int afterSignatureCount = 0;
                                    for (JSONObject dataJson : dataArr) {
                                        Object isSignatureObj = dataJson.get("isSignature");
                                        if (isSignatureObj != null) {
                                            boolean isSignature = dataJson.getBoolean("isSignature");
                                            if (!isSignature) continue;
                                            ++afterSignatureCount;
                                            continue;
                                        }
                                        ++afterSignatureCount;
                                    }
                                    for (int i = 0; i < signatureCount - afterSignatureCount; ++i) {
                                        PdfSignatureUtil.delElectronicSeal(pdfUrl);
                                    }
                                    signaturesJson.put((Object)"data", (Object)dataArr);
                                    pdfSignatureJson.put((Object)"signatures", (Object)signaturesJson);
                                    kinggridSignature.put((Object)"pdfSignature", (Object)pdfSignatureJson);
                                    deleteDoc.setKinggridSignature(kinggridSignature.toString());
                                    process.doUpdate((ValueObject)deleteDoc);
                                }
                            }
                        }
                        Document document = (Document)MemoryCacheUtil.getFromPrivateSpace((Object)deleteDoc.getId(), (IUser)user);
                        document.setKinggridSignature(deleteDoc.getKinggridSignature());
                        MemoryCacheUtil.putToPrivateSpace((Object)deleteDoc.getId(), (Object)document, (IUser)user);
                    }
                } else {
                    FlowStateRT flowStateRT;
                    JSONObject signaturesJson;
                    Object data;
                    JSONObject pdfSignatureJson;
                    Object signatures;
                    JSONObject kinggridSignature;
                    Object pdfSignature;
                    if (!StringUtil.isBlank((String)doc.getKinggridSignature()) && (pdfSignature = (kinggridSignature = JSONObject.fromObject((Object)doc.getKinggridSignature())).get("pdfSignature")) != null && (signatures = (pdfSignatureJson = (JSONObject)pdfSignature).get("signatures")) != null && (data = (signaturesJson = (JSONObject)signatures).get("data")) != null && (flowStateRT = doc.getState()) != null) {
                        Collection nodeRTs = flowStateRT.getNoderts();
                        FlowDiagram fd = flowStateRT.getFlowVO().toFlowDiagram();
                        Node firstNode = fd.getFirstNode();
                        String pdfUrl = pdfSignatureJson.getString("pdfUrl");
                        int signatureCount = 0;
                        JSONArray dataArr = (JSONArray)data;
                        for (JSONObject dataJson : dataArr) {
                            Object isSignatureObj = dataJson.get("isSignature");
                            if (isSignatureObj != null) {
                                boolean isSignature = dataJson.getBoolean("isSignature");
                                if (!isSignature) continue;
                                ++signatureCount;
                                continue;
                            }
                            ++signatureCount;
                        }
                        NodeRT nodeRT = (NodeRT)nodeRTs.iterator().next();
                        if (nodeRT != null) {
                            Node currnode = fd.getNodeByID(nodeRT.getNodeid());
                            if (this.isFirstNode(fd, currnode)) {
                                for (int i = 0; i < signatureCount; ++i) {
                                    PdfSignatureUtil.delElectronicSeal(pdfUrl);
                                }
                                signaturesJson.put((Object)"data", (Object)new JSONArray());
                                pdfSignatureJson.put((Object)"signatures", (Object)signaturesJson);
                                kinggridSignature.put((Object)"pdfSignature", (Object)pdfSignatureJson);
                                doc.setKinggridSignature(kinggridSignature.toString());
                                process.doUpdate((ValueObject)doc);
                            } else {
                                JSONObject signature;
                                Iterator iterator = dataArr.iterator();
                                int minSignatureNum = 1000;
                                while (iterator.hasNext()) {
                                    signature = (JSONObject)iterator.next();
                                    String nodeId = signature.getString("nodeId");
                                    int signatureNum = signature.getInt("signatureNum");
                                    if (!currnode.id.equals(nodeId) || signatureNum >= minSignatureNum) continue;
                                    minSignatureNum = signatureNum;
                                }
                                iterator = dataArr.iterator();
                                while (iterator.hasNext()) {
                                    signature = (JSONObject)iterator.next();
                                    int signatureNum = signature.getInt("signatureNum");
                                    if (signatureNum < minSignatureNum) continue;
                                    iterator.remove();
                                }
                                signature = new JSONObject();
                                signature.put((Object)"position", (Object)"ignore");
                                signature.put((Object)"userId", (Object)"ignore");
                                signature.put((Object)"isSignature", (Object)false);
                                signature.put((Object)"signatureNum", (Object)minSignatureNum);
                                signature.put((Object)"nodeId", (Object)currnode.id);
                                signature.put((Object)"statelabel", (Object)currnode.statelabel);
                                dataArr.add((Object)signature);
                                int afterSignatureCount = 0;
                                for (JSONObject dataJson : dataArr) {
                                    Object isSignatureObj = dataJson.get("isSignature");
                                    if (isSignatureObj != null) {
                                        boolean isSignature = dataJson.getBoolean("isSignature");
                                        if (!isSignature) continue;
                                        ++afterSignatureCount;
                                        continue;
                                    }
                                    ++afterSignatureCount;
                                }
                                for (int i = 0; i < signatureCount - afterSignatureCount; ++i) {
                                    PdfSignatureUtil.delElectronicSeal(pdfUrl);
                                }
                                signaturesJson.put((Object)"data", (Object)dataArr);
                                pdfSignatureJson.put((Object)"signatures", (Object)signaturesJson);
                                kinggridSignature.put((Object)"pdfSignature", (Object)pdfSignatureJson);
                                doc.setKinggridSignature(kinggridSignature.toString());
                                process.doUpdate((ValueObject)doc);
                            }
                        }
                    }
                    Document document = (Document)MemoryCacheUtil.getFromPrivateSpace((Object)doc.getId(), (IUser)user);
                    document.setKinggridSignature(doc.getKinggridSignature());
                    MemoryCacheUtil.putToPrivateSpace((Object)doc.getId(), (Object)document, (IUser)user);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isFirstNode(FlowDiagram fd, Node currNode) {
        Vector relations = fd.getNodeNextRelation(fd.getFirstNode());
        boolean isFirstNode = false;
        for (Relation relation : relations) {
            Node node = relation.getEndnode();
            if (!currNode.id.equals(node.id)) continue;
            isFirstNode = true;
        }
        return isFirstNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void delElectronicSeal(String pdfPath) {
        KGPdfHummer hummer = null;
        FileOutputStream fileOutputStream = null;
        String oldPdfUrl = "";
        String newPdfUrl = "";
        try {
            int num = pdfPath.lastIndexOf("/") + 1;
            String fileName = pdfPath.substring(num, pdfPath.length());
            String path = PropertyUtil.getPath() + pdfPath.substring(0, num);
            oldPdfUrl = path + fileName;
            newPdfUrl = path + "tmp_" + fileName;
            fileOutputStream = new FileOutputStream(newPdfUrl);
            hummer = KGPdfHummer.createInstance((String)oldPdfUrl, null, (boolean)true, (OutputStream)fileOutputStream, (boolean)true);
            DeleteElectronicSeal deleteElectronicSeal = new DeleteElectronicSeal();
            deleteElectronicSeal.setDeleteLastOneSeal(true);
            hummer.addExecute((KGExecute)deleteElectronicSeal);
            hummer.doExecute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (hummer != null) {
                hummer.close();
            }
            PdfSignatureUtil.saveFile(oldPdfUrl, newPdfUrl);
        }
    }

    private static void saveFile(String oldPdfUrl, String newPdfUrl) {
        FileOutputStream fileOutputStream = null;
        FileInputStream in = null;
        File newFile = new File(newPdfUrl);
        try {
            in = new FileInputStream(newFile);
            fileOutputStream = new FileOutputStream(oldPdfUrl);
            IOUtils.copy((InputStream)in, (OutputStream)fileOutputStream);
        }
        catch (IOException var10) {
            try {
                throw new RuntimeException(var10.getMessage(), var10);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(fileOutputStream);
                if (newFile.exists()) {
                    newFile.delete();
                }
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)fileOutputStream);
        if (newFile.exists()) {
            newFile.delete();
        }
    }
}

