/*
 * Decompiled with CFR 0.152.
 */
package com.jgqz.jgutil;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5Util {
    public static String getMD5(InputStream is) throws NoSuchAlgorithmException, IOException {
        StringBuffer md5 = new StringBuffer();
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] dataBytes = new byte[1024];
        int nread = 0;
        while ((nread = is.read(dataBytes)) != -1) {
            md.update(dataBytes, 0, nread);
        }
        byte[] mdbytes = md.digest();
        for (int i = 0; i < mdbytes.length; ++i) {
            md5.append(Integer.toString((mdbytes[i] & 0xFF) + 256, 16).substring(1));
        }
        return md5.toString();
    }

    public static String getBodyMD5(byte[] dataBytes) throws NoSuchAlgorithmException, IOException {
        StringBuffer md5 = new StringBuffer();
        MessageDigest md = MessageDigest.getInstance("MD5");
        int nlength = dataBytes.length;
        md.update(dataBytes, 0, nlength);
        byte[] mdbytes = md.digest();
        for (int i = 0; i < mdbytes.length; ++i) {
            md5.append(Integer.toString((mdbytes[i] & 0xFF) + 256, 16).substring(1));
        }
        return md5.toString();
    }

    public static String getMD5(File file) throws NoSuchAlgorithmException, IOException {
        FileInputStream fis = new FileInputStream(file);
        return MD5Util.getMD5(fis);
    }

    public static String getMD5(String path) throws NoSuchAlgorithmException, IOException {
        FileInputStream fis = new FileInputStream(path);
        return MD5Util.getMD5(fis);
    }

    public static boolean md5CheckSum(InputStream is, String toBeCheckSum) throws NoSuchAlgorithmException, IOException {
        return MD5Util.getMD5(is).equals(toBeCheckSum);
    }

    public static boolean md5CheckSum(File file, String toBeCheckSum) throws NoSuchAlgorithmException, IOException {
        return MD5Util.getMD5(file).equals(toBeCheckSum);
    }

    public static boolean md5CheckSum(String path, String toBeCheckSum) throws NoSuchAlgorithmException, IOException {
        return MD5Util.getMD5(path).equals(toBeCheckSum);
    }
}

