/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.services.impls;

import cn.myapps.common.RunnableMeta;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.controller.ErrorMessage;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.activity.Activity;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.activity.service.ActivityDesignTimeService;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.form.service.FormDesignTimeService;
import cn.myapps.designtime.view.service.ViewDesignTimeService;
import cn.myapps.runtime.common.service.RunTimeServiceManager;
import cn.myapps.runtime.dynaform.document.ejb.Document;
import cn.myapps.runtime.dynaform.document.ejb.DocumentProcess;
import cn.myapps.runtime.dynaform.document.ejb.Item;
import cn.myapps.runtime.dynaform.document.model.IDocument;
import cn.myapps.runtime.dynaform.form.ejb.Form;
import cn.myapps.runtime.dynaform.form.ejb.ValidateMessage;
import cn.myapps.runtime.macro.runner.IRunner;
import cn.myapps.runtime.macro.runner.JavaScriptFactory;
import cn.myapps.runtime.macro.runner.JsMessage;
import cn.myapps.runtime.workflow.storage.runtime.ejb.FlowRuntimeServiceImpl;
import cn.myapps.runtime.workflow.storage.runtime.ejb.FlowStateRT;
import com.bcxin.dtos.ExecuteActionResultDto;
import com.bcxin.enums.ActionStep;
import com.bcxin.saas.core.exceptions.SaasBadException;
import com.bcxin.saas.core.exceptions.SaasNofoundException;
import com.bcxin.services.DocumentService;
import com.bcxin.services.commands.CreatedDocumentCommand;
import com.bcxin.services.commands.results.CreatedDocumentCommandResult;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.springframework.stereotype.Service;

@Service
public class DocumentServiceImpl
implements DocumentService {
    @Override
    public CreatedDocumentCommandResult dispatch(CreatedDocumentCommand command) {
        DocumentProcess dProcess = null;
        try {
            Document doc = this.prepareDocument(command.getContent(), command.getAppId(), "$.document", command.getParams(), command.getUser());
            Activity act = this.getSelectedActivity(command.getAppId(), command.getActId(), doc, command.getParams());
            if (act == null) {
                throw new SaasNofoundException("\u7cfb\u7edf\u5f02\u5e38, \u627e\u4e0d\u5230Activity\u4e8b\u4ef6");
            }
            ExecuteActionResultDto actionResult = null;
            ActionStep step = command.getStep();
            dProcess = RunTimeServiceManager.documentProcess((String)command.getAppId());
            dProcess.beginTransaction();
            if (step.executable(ActionStep.BeforeAction)) {
                actionResult = this.executeCore_runBefore(doc, command.getParams(), command.getUser(), act);
                if (actionResult.getResultType() != ExecuteActionResultDto.ActionResultType.OK) {
                    if (dProcess != null) {
                        dProcess.rollbackTransaction();
                    }
                    return CreatedDocumentCommandResult.result(actionResult, ActionStep.BeforeAction);
                }
                ActionStep actionStep = step = act.getType() == 10 ? ActionStep.AfterAction : ActionStep.ActionCore;
            }
            if (step.executable(ActionStep.ActionCore)) {
                switch (act.getType()) {
                    case 11: 
                    case 34: {
                        actionResult = this.executeCore_Normal_Button(command.getAppId(), doc, command.getParams(), command.getUser());
                        break;
                    }
                    case 13: {
                        actionResult = this.executeCore_Custom_Button(command.getAppId(), doc, command.getParams(), command.getUser(), act);
                        break;
                    }
                    default: {
                        throw new SaasNofoundException("\u7cfb\u7edf\u5f02\u5e38, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458,\u6682\u4e0d\u652f\u6301\u8be5\u6309\u94ae\u7c7b\u578b");
                    }
                }
                if (actionResult.getResultType() != ExecuteActionResultDto.ActionResultType.OK) {
                    if (dProcess != null) {
                        dProcess.rollbackTransaction();
                    }
                    return CreatedDocumentCommandResult.result(actionResult, ActionStep.ActionCore);
                }
                step = ActionStep.AfterAction;
            }
            if (step.executable(ActionStep.AfterAction)) {
                actionResult = this.executeCore_runAfter(command.getParams(), doc, command.getUser(), act);
            }
            if (actionResult.getResultType() != ExecuteActionResultDto.ActionResultType.Error) {
                dProcess.commitTransaction();
            } else {
                dProcess.rollbackTransaction();
            }
            return CreatedDocumentCommandResult.result(actionResult, step);
        }
        catch (Exception ex) {
            try {
                if (dProcess != null) {
                    dProcess.rollbackTransaction();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new SaasBadException("\u6587\u6863\u63d0\u4ea4\u5931\u8d25:" + ex.getMessage());
        }
    }

    private Document prepareDocument(String jsonContent, String applicationId, String baseJsonPath, ParamsTable params, IUser user) throws Exception {
        Document temp;
        Configuration configuration = Configuration.defaultConfiguration();
        configuration = configuration.addOptions(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL});
        DocumentContext parse = JsonPath.parse((String)jsonContent, (Configuration)configuration);
        String formid = (String)parse.read(baseJsonPath + ".formId", new Predicate[0]);
        String viewid = (String)parse.read(baseJsonPath + ".viewId", new Predicate[0]);
        String stateid = (String)parse.read(baseJsonPath + ".stateId", new Predicate[0]);
        String parentid = (String)parse.read(baseJsonPath + ".parentId", new Predicate[0]);
        String sign = (String)parse.read(baseJsonPath + ".sign", new Predicate[0]);
        String docId = params.getDocId();
        if (StringUtil.isBlank((String)docId)) {
            docId = (String)parse.read(baseJsonPath + ".id", new Predicate[0]);
        }
        String isRelate = (String)parse.read(baseJsonPath + ".isRelate", new Predicate[0]);
        List subDocuments = (List)parse.read(baseJsonPath + ".subDocuments", new Predicate[0]);
        Map items = (Map)parse.read(baseJsonPath + ".items", new Predicate[0]);
        Object delete = parse.read(baseJsonPath + ".delete", new Predicate[0]);
        Object edit = parse.read(baseJsonPath + ".edit", new Predicate[0]);
        Object isFromRefresh = params.getParameter("isFromRefresh");
        Object exparams = parse.read(baseJsonPath + ".exparams", new Predicate[0]);
        if (exparams != null) {
            Map exparamsMap = (Map)exparams;
            for (Map.Entry entry : exparamsMap.entrySet()) {
                String key = entry.getKey().toString();
                Object value = entry.getValue();
                params.setParameter(key, value);
            }
        }
        if (isRelate != null && isRelate.equals("true")) {
            params.setParameter("isRelate", (Object)"true");
            if (!StringUtil.isBlank((String)parentid)) {
                params.setParameter("relateid", (Object)parentid);
            }
        } else {
            if (!StringUtil.isBlank((String)parentid)) {
                params.setParameter("relateid", (Object)parentid);
            }
            parentid = "";
        }
        if (parentid != null && !parentid.isEmpty()) {
            params.setParameter("parentid", (Object)parentid);
        }
        if (viewid != null && !viewid.isEmpty()) {
            params.setParameter("viewid", (Object)viewid);
        }
        DocumentProcess dProcess = RunTimeServiceManager.documentProcess((String)applicationId);
        Form form = null;
        Document doc = null;
        if (items != null) {
            temp = (Document)dProcess.doView(docId);
            if (temp == null) {
                form = DesignTimeServiceManager.formDesignTimeService().doView(formid);
                temp = dProcess.doNew(form, user, params);
                temp.setId(docId);
            }
            for (Map.Entry entry : items.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                Item item = temp.findItem(key);
                if (item == null && !StringUtil.isBlank((String)key) && key.lastIndexOf("_show") > -1) {
                    item = temp.findItem(key.substring(0, key.lastIndexOf("_show")));
                }
                if (item == null) continue;
                params.setParameter(key, value);
                item.setValue(value);
            }
        } else {
            return new Document();
        }
        doc = temp;
        if (!items.isEmpty() && isFromRefresh == null) {
            if (form == null) {
                form = DesignTimeServiceManager.formDesignTimeService().doView(formid);
            }
            doc = form.createDocument(doc, params, user);
        }
        if (!StringUtil.isBlank((String)parentid)) {
            doc.setParent(parentid);
        }
        if (!StringUtil.isBlank((String)stateid)) {
            doc.setState(stateid);
        }
        if (!StringUtil.isBlank((String)sign)) {
            doc.setSign(sign);
        }
        if (StringUtil.isBlank((String)doc.getFormid()) && !StringUtil.isBlank((String)formid)) {
            doc.setFormid(formid);
        }
        if (StringUtil.isBlank((String)doc.getApplicationid()) && !StringUtil.isBlank((String)applicationId)) {
            doc.setApplicationid(applicationId);
        }
        ArrayList<Document> subDocumentList = new ArrayList<Document>();
        if (subDocuments != null) {
            for (Map map : subDocuments) {
                ParamsTable newParams = params.copyContextParams();
                for (Map.Entry entry : map.entrySet()) {
                    String name = (String)entry.getKey();
                    Object value = entry.getValue();
                    if (value instanceof String[]) {
                        if (((String[])value).length > 1) {
                            newParams.setParameter(name, value);
                            continue;
                        }
                        newParams.setParameter(name, (Object)((String[])value)[0]);
                        continue;
                    }
                    newParams.setParameter(name, value);
                }
                Document subDoc = this.prepareDocument(JSONObject.fromObject((Object)map).toString(), applicationId, "$", newParams, user);
                subDocumentList.add(subDoc);
            }
        }
        doc.setSubDocuments(subDocumentList.isEmpty() ? null : subDocumentList);
        if (delete != null) {
            doc.setDelete(true);
        }
        if (edit != null) {
            doc.setEdit(true);
        }
        return doc;
    }

    private ExecuteActionResultDto executeCore_runBefore(Document doc, ParamsTable params, IUser user, Activity act) throws Exception {
        if (!StringUtil.isBlank((String)act.getBeforeActionScript()) || !StringUtil.isBlank((String)act.getRetractBeforeActionScript())) {
            Object result = act.runBeforeActionScript(doc, params, user);
            if (result != null && result instanceof String && ((String)result).trim().length() > 0) {
                result = new JsMessage(1, (String)result);
            }
            com.alibaba.fastjson.JSONObject jsonObj = new com.alibaba.fastjson.JSONObject();
            if (result != null && result instanceof JsMessage && !StringUtil.isBlank((String)((JsMessage)result).getContent())) {
                JsMessage jsMessage = (JsMessage)result;
                jsonObj.put("type", (Object)((JsMessage)result).getType());
                jsonObj.put("content", (Object)((JsMessage)result).getContent());
                jsonObj.put("step", (Object)ActionStep.BeforeAction);
                if (jsMessage.getType() == 32) {
                    jsonObj.put("next-step", (Object)ActionStep.ActionCore);
                } else {
                    jsonObj.put("next-step", (Object)ActionStep.BeforeAction);
                }
                return ExecuteActionResultDto.create(ExecuteActionResultDto.ActionResultType.Message, Resource.ok((Object)jsonObj));
            }
            return ExecuteActionResultDto.create(ExecuteActionResultDto.ActionResultType.OK, Resource.ok((Object)jsonObj, (String)ActionStep.BeforeAction.name()));
        }
        return ExecuteActionResultDto.create(ExecuteActionResultDto.ActionResultType.OK, Resource.ok(null, (String)ActionStep.BeforeAction.name()));
    }

    private ExecuteActionResultDto executeCore_Normal_Button(String applicationId, Document doc, ParamsTable params, IUser user) throws Exception {
        DocumentProcess dProcess = RunTimeServiceManager.documentProcess((String)applicationId);
        Collection subDocuments = doc.getFrontSubDocuments();
        Collection<ErrorMessage> errors = this.validateDocument(params, doc, applicationId, user);
        if (errors.isEmpty()) {
            FlowStateRT instance;
            if (subDocuments != null) {
                ArrayList copySubDocuments = new ArrayList();
                copySubDocuments.addAll(doc.getSubDocuments());
                for (Document document : copySubDocuments) {
                    if (document.isDelete()) {
                        dProcess.doRemove(document.getId());
                        doc.removeSubDocument(document.getId());
                        continue;
                    }
                    if (!document.isEdit()) continue;
                    Collection<ErrorMessage> subErrors = this.validateDocument(params, document, applicationId, user);
                    if (!subErrors.isEmpty()) {
                        return ExecuteActionResultDto.create(ExecuteActionResultDto.ActionResultType.Error, Resource.error((int)4001, (String)"\u5b50\u8868\u5355\u6821\u9a8c\u4e0d\u901a\u8fc7", subErrors));
                    }
                    dProcess.doCreateOrUpdate((IDocument)document, user);
                }
                doc = doc.getForm().recalculateDocument(doc, params, user);
            }
            FlowRuntimeServiceImpl stateProcess = new FlowRuntimeServiceImpl(applicationId);
            if (!StringUtil.isBlank((String)doc.getStateid()) && (instance = stateProcess.findFlowStateRT(doc.getStateid())) == null) {
                doc.setStateid("");
            }
            dProcess.doCreateOrUpdate((IDocument)doc, user);
            return ExecuteActionResultDto.create(ExecuteActionResultDto.ActionResultType.OK, Resource.ok((Object)doc, (String)ActionStep.ActionCore.name()));
        }
        return ExecuteActionResultDto.create(ExecuteActionResultDto.ActionResultType.Error, Resource.error((int)4001, (String)ActionStep.ActionCore.name(), (String)"\u8868\u5355\u6821\u9a8c\u4e0d\u901a\u8fc7", errors));
    }

    private ExecuteActionResultDto executeCore_Custom_Button(String applicationId, Document doc, ParamsTable params, IUser user, Activity act) throws Exception {
        com.alibaba.fastjson.JSONObject jsonObj = new com.alibaba.fastjson.JSONObject();
        if (!StringUtil.isBlank((String)act.getActionScript()) || !StringUtil.isBlank((String)act.getDispatcherUrl())) {
            IRunner runner = JavaScriptFactory.getInstance((String)user.getSessionid(), (String)applicationId);
            StringBuffer labelAction = new StringBuffer();
            labelAction.append("Activity(").append(act.getId()).append(")." + act.getName()).append(".actionScript");
            runner.initBSFManager((IDocument)doc, params, user, new ArrayList());
            runner.run((RunnableMeta)act, labelAction.toString(), act.getActionScript());
            StringBuffer labelDispatcherUrl = new StringBuffer();
            labelDispatcherUrl.append("Activity(").append(act.getId()).append(")." + act.getName()).append(".dispatcherUrlScript");
            String dispatcherUrl = (String)runner.run((RunnableMeta)act, labelDispatcherUrl.toString(), act.getDispatcherUrl());
            if (!StringUtil.isBlank((String)dispatcherUrl)) {
                jsonObj.put("dispatcherUrl", (Object)dispatcherUrl);
            }
        }
        return ExecuteActionResultDto.create(ExecuteActionResultDto.ActionResultType.OK, Resource.ok((Object)jsonObj));
    }

    private ExecuteActionResultDto executeCore_runAfter(ParamsTable params, Document doc, IUser user, Activity act) throws Exception {
        com.alibaba.fastjson.JSONObject jsonObj = new com.alibaba.fastjson.JSONObject();
        if (!StringUtil.isBlank((String)act.getAfterActionScript()) || !StringUtil.isBlank((String)act.getRetractAfterActionScript())) {
            params.setParameter("_flowType", (Object)doc.getLastFlowOperation());
            Object message = act.runAfterActionScript(doc, params, user);
            if (message != null) {
                if (message instanceof String && ((String)message).trim().length() > 0) {
                    message = new JsMessage(1, (String)message);
                }
                if (message instanceof JsMessage) {
                    jsonObj.put("type", (Object)"message");
                    jsonObj.put("content", message);
                    jsonObj.put("step", (Object)ActionStep.AfterAction);
                    jsonObj.put("next-step", (Object)ActionStep.AfterAction);
                }
                return ExecuteActionResultDto.create(ExecuteActionResultDto.ActionResultType.Message, Resource.ok((Object)jsonObj, (String)ActionStep.AfterAction.name()));
            }
        }
        return ExecuteActionResultDto.create(ExecuteActionResultDto.ActionResultType.OK, Resource.ok((Object)jsonObj, (String)ActionStep.AfterAction.name()));
    }

    private Collection<ErrorMessage> validateDocument(ParamsTable params, Document doc, String applicationId, IUser webUser) throws Exception {
        ArrayList<ErrorMessage> errmsgs = new ArrayList<ErrorMessage>();
        doc.setDomainid(webUser.getDomainid());
        DocumentProcess proxy = RunTimeServiceManager.documentProcess((String)applicationId);
        Collection errors = proxy.doValidate(doc, params, webUser);
        if (errors != null && errors.size() > 0) {
            for (ValidateMessage err : errors) {
                ErrorMessage msg = new ErrorMessage();
                msg.setErrcode(40001);
                msg.setErrmsg(err.getErrmessage());
                msg.setField(err.getFieldname());
                errmsgs.add(msg);
            }
        }
        return errmsgs;
    }

    private Activity getSelectedActivity(String applicationId, String id, Document doc, ParamsTable params) throws Exception {
        ActivityDesignTimeService activityService;
        Form actParent = null;
        Activity act = null;
        String docid = params.getParameterAsString("docId");
        String viewid = params.getParameterAsString("viewId");
        String formid = params.getParameterAsString("formId");
        String templateForm = params.getParameterAsString("_templateForm");
        String parentId = params.getParameterAsString("parentId");
        params.setParameter("application", (Object)applicationId);
        params.setParameter("docid", (Object)docid);
        params.setParameter("viewid", (Object)viewid);
        params.setParameter("formid", (Object)formid);
        params.setParameter("parentid", (Object)parentId);
        if (docid != null && docid.equals(parentId)) {
            parentId = null;
            params.removeParameter("parentid");
        }
        if (id != null && id.trim().length() > 0) {
            if (!StringUtil.isBlank((String)formid) || !StringUtil.isBlank((String)templateForm)) {
                FormDesignTimeService formService = DesignTimeServiceManager.formDesignTimeService();
                if (!StringUtil.isBlank((String)templateForm)) {
                    actParent = formService.doView(templateForm);
                    act = actParent.findActivity(id);
                }
                if (act == null && (actParent = formService.doView(formid)) != null) {
                    act = actParent.findActivity(id);
                }
            } else if (act == null && !StringUtil.isBlank((String)viewid)) {
                ViewDesignTimeService viewService = DesignTimeServiceManager.viewDesignTimeService();
                actParent = viewService.doView(viewid);
                act = actParent.findActivity(id);
            } else {
                activityService = DesignTimeServiceManager.activityDesignTimeService();
                act = (Activity)activityService.findById(id);
            }
        }
        if (act == null) {
            activityService = DesignTimeServiceManager.activityDesignTimeService();
            act = (Activity)activityService.findById(id);
        }
        return act;
    }
}

