/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.intercepters;

import cn.myapps.components.HmacComponent;
import com.bcxin.intercepters.values.SecretSaltValueType;
import com.bcxin.saas.core.components.JsonProvider;
import com.bcxin.saas.core.exceptions.SaasForbidException;
import com.bcxin.saas.core.exceptions.SaasUnAuthorizeException;
import com.bcxin.saas.domains.entities.HmacAuthEntity;
import com.bcxin.saas.domains.repositories.HmacAuthRepository;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.HandlerInterceptor;

public class HmacAuthInterceptor
implements HandlerInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(HmacAuthInterceptor.class);
    private final HmacAuthRepository hmacAuthRepository;
    private final StringRedisTemplate redisTemplate;
    private final JsonProvider jsonProvider;
    private final HmacComponent hmacComponent;
    private static final long MAX_TIME_DIFF = 604800000L;

    public HmacAuthInterceptor(HmacAuthRepository hmacAuthRepository, StringRedisTemplate redisTemplate, JsonProvider jsonProvider, HmacComponent hmacComponent) {
        this.hmacAuthRepository = hmacAuthRepository;
        this.redisTemplate = redisTemplate;
        this.jsonProvider = jsonProvider;
        this.hmacComponent = hmacComponent;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String clientId = null;
        String signature = null;
        String timestampStr = null;
        try {
            long timestamp;
            clientId = request.getHeader("x-client-id");
            signature = request.getHeader("x-signature");
            timestampStr = request.getHeader("x-timestamp");
            if (clientId == null || signature == null || timestampStr == null) {
                response.sendError(HttpStatus.UNAUTHORIZED.value(), "x-client-Id;x-signature;x-timestamp \u662f\u5fc5\u586b\u7684");
                return false;
            }
            try {
                timestamp = Long.parseLong(timestampStr);
            }
            catch (NumberFormatException e) {
                response.sendError(HttpStatus.UNAUTHORIZED.value(), "\u65e0\u6548\u7684x-timestamp\u683c\u5f0f");
                return false;
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            long currentTime = Long.parseLong(dateFormat.format(new Date()));
            if (Math.abs(currentTime - timestamp) > 604800000L) {
                response.sendError(HttpStatus.UNAUTHORIZED.value(), "\u8bf7\u6c42\u5df2\u8fc7\u671f");
                return false;
            }
            SecretSaltValueType saltValue = this.getSecretSalt(clientId, request.getRequestURI());
            String data = String.format("%s#%s", timestampStr, saltValue.getDataToSign());
            String computedSignature = this.calculateHmac(saltValue.getSecret(), data);
            if (!signature.equalsIgnoreCase(computedSignature)) {
                response.sendError(HttpStatus.UNAUTHORIZED.value(), "x-signature\u7b7e\u540d\u5185\u5bb9\u65e0\u6548");
                return false;
            }
            return super.preHandle(request, response, handler);
        }
        catch (Exception e) {
            logger.error("\u56de\u8c03\u8bf7\u6c42\u53d1\u751f\u5f02\u5e38(clientId={},signature={},timestampStr={}):url={}", new Object[]{clientId, signature, timestampStr, request, e});
            throw e;
        }
    }

    private SecretSaltValueType getSecretSalt(String clientId, String url) {
        String cacheKey = String.format("com:bcx:hmac:%s", clientId);
        String secretValueString = (String)this.redisTemplate.opsForValue().get((Object)cacheKey);
        SecretSaltValueType saltValue = (SecretSaltValueType)((Object)this.jsonProvider.getData(secretValueString, SecretSaltValueType.class));
        if (saltValue == null) {
            HmacAuthEntity hmacAuthEntity = this.hmacAuthRepository.findByClientId(clientId);
            if (hmacAuthEntity != null) {
                if (hmacAuthEntity.isExpired()) {
                    throw new SaasUnAuthorizeException("\u5bc6\u94a5\u5df2\u8fc7\u671f");
                }
                saltValue = SecretSaltValueType.create(hmacAuthEntity.getSecret(), hmacAuthEntity.getDataToSign(), hmacAuthEntity.getResource());
                secretValueString = this.jsonProvider.getJson((Object)saltValue);
                this.redisTemplate.opsForValue().set((Object)cacheKey, (Object)secretValueString, Duration.of(1L, ChronoUnit.HOURS));
            } else {
                throw new SaasUnAuthorizeException("\u5bc6\u94a5\u65e0\u6548");
            }
        }
        if (!saltValue.isAllowedResource(url)) {
            throw new SaasForbidException(String.format("\u8be5\u6388\u6743\u7801\u4e0d\u5141\u8bb8\u8bbf\u95ee\u6b64\u8d44\u6e90:%s, \u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5", url));
        }
        return saltValue;
    }

    public String calculateHmac(String key, String data) throws Exception {
        return this.hmacComponent.calculate(key, data);
    }
}

