/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.api.controllers;

import cn.myapps.common.model.ValueObject;
import cn.myapps.common.model.task.Task;
import cn.myapps.designtime.common.cache.DesignTimeSerializableCache;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.task.service.TaskDesignTimeService;
import cn.myapps.runtime.common.service.RunTimeServiceManager;
import cn.myapps.runtime.scheduler.ejb.TriggerProcess;
import cn.myapps.runtime.scheduler.ejb.TriggerVO;
import cn.myapps.runtime.scheduler.engine.job.BpmPlatformWorkFlowEventJob;
import cn.myapps.runtime.scheduler.engine.job.IscriptTaskJob;
import cn.myapps.runtime.scheduler.engine.job.Job;
import com.bcxin.dtos.TriggerVOWrapper;
import com.bcxin.responses.TriggerDefinitionResponse;
import com.bcxin.runtime.apis.controllers.ControllerAbstract;
import com.bcxin.saas.core.components.DistributedCacheProvider;
import com.bcxin.saas.core.exceptions.SaasBadException;
import com.bcxin.saas.core.utils.ExceptionUtils;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="v2_script_execute_controller")
@RequestMapping(value={"/api/v2/runtime/definitions/apps/{appId}/"})
public class ScriptExecuteController
extends ControllerAbstract {
    private static final Logger logger = LoggerFactory.getLogger(ScriptExecuteController.class);
    private static Map<String, TriggerVO> _toBeUpdatedTriggers = new ConcurrentHashMap<String, TriggerVO>();
    private final DistributedCacheProvider distributedCacheProvider;

    public ScriptExecuteController(DistributedCacheProvider distributedCacheProvider) {
        this.distributedCacheProvider = distributedCacheProvider;
    }

    @PostMapping(value={"/triggers/{id}/execute"})
    public ResponseEntity execute(@PathVariable String appId, @PathVariable String id) throws Exception {
        AtomicBoolean updateFlag = new AtomicBoolean(false);
        String result = null;
        try {
            TriggerProcess triggerProcess = RunTimeServiceManager.triggerProcess((String)appId);
            TriggerVOWrapper wrapper = (TriggerVOWrapper)this.distributedCacheProvider.get(this.getTriggerCacheKey(appId, id), () -> {
                try {
                    TriggerVO triggerVO;
                    if (!CollectionUtils.isEmpty(_toBeUpdatedTriggers) && (triggerVO = _toBeUpdatedTriggers.get(this.getTriggerCacheKey(appId, id))) != null) {
                        triggerProcess.doUpdateStateById((ValueObject)triggerVO);
                        updateFlag.set(true);
                    }
                    TriggerVO tmpTrigger = (TriggerVO)triggerProcess.doView(id);
                    return TriggerVOWrapper.create(tmpTrigger, false);
                }
                catch (Exception ex) {
                    throw new SaasBadException(ex);
                }
            }, 600L);
            if (wrapper == null) {
                return this.notFound(String.format("Task not found(%s)message", id));
            }
            if (wrapper.getTriggerVO() == null || wrapper.isDeleted()) {
                return this.notFound(String.format("Task may be deleted(%s)", id));
            }
            TriggerVO trigger = wrapper.getTriggerVO();
            if ("stop".equals(trigger.getState())) {
                return this.ok("Task Execution is stop");
            }
            this.execute(trigger, triggerProcess);
            result = String.format("id=%s;times=%s;state=%s;lastModifyDate=%s;deadline=%s;", trigger.getId(), trigger.getRunTimes(), trigger.getState(), trigger.getLastModifyDate(), trigger.getDeadline());
        }
        catch (Exception ex) {
            return this.badRequest(ExceptionUtils.getStackMessage((Throwable)ex));
        }
        return this.ok(String.format("Task Execution is completed: changed =%s;re=%s;", updateFlag.get(), result));
    }

    @GetMapping(value={"/triggers"})
    public ResponseEntity<Collection<TriggerDefinitionResponse>> search(@PathVariable String appId) throws Exception {
        Collection jobScriptResponses = (Collection)this.distributedCacheProvider.get(DesignTimeSerializableCache.getWrapperKey((String)String.format("com:app:%s:triggers", appId)), () -> {
            try {
                TriggerProcess triggerProcess = RunTimeServiceManager.triggerProcess((String)appId);
                Collection list = triggerProcess.getStandbyTriggers(appId);
                Collection jobs = list.stream().map(ii -> TriggerDefinitionResponse.create(ii.getApplicationId(), ii.getId(), ii.getTaskId())).collect(Collectors.toList());
                return jobs;
            }
            catch (Exception ex) {
                throw new SaasBadException(ex);
            }
        }, 600L);
        logger.error("\u83b7\u53d6\u5b9a\u65f6\u4efb\u52a1\u5217\u8868:{}-{}", (Object)appId, (Object)jobScriptResponses.stream().map(ii -> ii.getTaskId()).collect(Collectors.joining(";")));
        return this.ok(jobScriptResponses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(TriggerVO trigger, TriggerProcess process) throws Exception {
        if (trigger != null) {
            Job job = trigger.getJob();
            if (job instanceof BpmPlatformWorkFlowEventJob) {
                BpmPlatformWorkFlowEventJob bpmPlatformWorkFlowEventJob = (BpmPlatformWorkFlowEventJob)job;
                bpmPlatformWorkFlowEventJob.setDoc(trigger.getDoc());
                bpmPlatformWorkFlowEventJob.execute();
            } else if (job instanceof IscriptTaskJob) {
                IscriptTaskJob iscriptTaskJob = (IscriptTaskJob)job;
                iscriptTaskJob.setApplicationId(trigger.getApplicationId());
                iscriptTaskJob.execute();
            } else {
                job.execute();
            }
            boolean deleted = false;
            try {
                Date lastExecuteTime = new Date();
                if (!trigger.isLoop()) {
                    if (trigger.getJobType() != 4) {
                        process.doRemove(trigger.getId());
                        deleted = true;
                    } else {
                        trigger.setState("stop");
                        trigger.setRunTimes(trigger.getRunTimes() + 1);
                        _toBeUpdatedTriggers.put(this.getTriggerCacheKey(trigger.getApplicationId(), trigger.getId()), trigger);
                    }
                } else {
                    trigger.setState("waiting");
                    trigger.setRunTimes(trigger.getRunTimes() + 1);
                    TaskDesignTimeService tp = DesignTimeServiceManager.taskDesignTimeService();
                    IscriptTaskJob iscriptTaskJob = (IscriptTaskJob)job;
                    Task task = (Task)tp.findById(iscriptTaskJob.getTaskId());
                    if (task != null) {
                        long nextExecuteTime = task.getNextExecuteTime(lastExecuteTime);
                        trigger.setDeadline(nextExecuteTime);
                    }
                    _toBeUpdatedTriggers.put(this.getTriggerCacheKey(trigger.getApplicationId(), trigger.getId()), trigger);
                }
            }
            finally {
                this.distributedCacheProvider.put(this.getTriggerCacheKey(trigger.getApplicationId(), trigger.getId()), (Object)TriggerVOWrapper.create(trigger, deleted), 7200L);
            }
        }
    }

    private String getTriggerCacheKey(String appId, String id) {
        return DesignTimeSerializableCache.getDynamicKey((String)String.format("se:%s:trigger:%s", appId, id));
    }
}

