/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.api.controllers;

import cn.myapps.common.auth.IUser;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.util.StringUtil;
import cn.myapps.common.util.cache.MemoryCacheUtil;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.runtime.common.service.RunTimeServiceManager;
import cn.myapps.runtime.dynaform.document.ejb.Document;
import cn.myapps.runtime.dynaform.document.ejb.DocumentProcess;
import cn.myapps.runtime.dynaform.document.ejb.Item;
import cn.myapps.runtime.dynaform.form.ejb.Form;
import cn.myapps.util.ParamsTableUtil;
import com.bcxin.enums.ActionStep;
import com.bcxin.runtime.apis.controllers.ControllerAbstract;
import com.bcxin.services.DocumentService;
import com.bcxin.services.commands.CreatedDocumentCommand;
import com.bcxin.services.commands.results.CreatedDocumentCommandResult;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="v2_document_controller")
@RequestMapping(value={"/api/runtime-ex/apps/{appId}"})
public class DocumentController
extends ControllerAbstract {
    private final DocumentService documentService;

    public DocumentController(DocumentService documentService) {
        this.documentService = documentService;
    }

    @PostMapping(value={"/activities/{actId}/documents"})
    public ResponseEntity<Resource> post(@PathVariable String appId, @PathVariable String actId, @RequestBody String content, @RequestParam ActionStep step, HttpServletRequest request) throws Exception {
        ParamsTable params = this.getParams(request);
        params = ParamsTableUtil.parseAndMergeActionB_A(params, actId, content, true);
        IUser user = this.getWebUser();
        CreatedDocumentCommand command = CreatedDocumentCommand.create(appId, actId, step, params, content, user);
        CreatedDocumentCommandResult commandResult = this.documentService.dispatch(command);
        return ResponseEntity.ok((Object)commandResult.getResult());
    }

    private ParamsTable getParams(HttpServletRequest request) {
        String isRelate;
        String parentid;
        String parentId;
        ParamsTable pm = ParamsTable.convertHTTP((HttpServletRequest)request);
        String domainId = this.getCurrentDomainId(request);
        if (domainId != null) {
            pm.setParameter("domainid", (Object)domainId);
        }
        if (pm.getParameter("_pagelines") == null) {
            pm.setParameter("_pagelines", (Object)"10");
        }
        if (!StringUtil.isBlank((String)(parentId = pm.getParameterAsString("parentId")))) {
            pm.setParameter("relateid", (Object)parentId);
            pm.setParameter("parentid", (Object)parentId);
        }
        if (!StringUtil.isBlank((String)(parentid = pm.getParameterAsString("parentid")))) {
            pm.setParameter("relateid", (Object)parentid);
            pm.setParameter("parentId", (Object)parentid);
        }
        if (StringUtil.isBlank((String)(isRelate = pm.getParameterAsString("isRelate"))) || !"true".equals(isRelate)) {
            pm.removeParameter("parentId");
            pm.removeParameter("parentid");
        }
        return pm;
    }

    private Document prepareDocument(String jsonContent, String applicationId, String baseJsonPath, ParamsTable params) throws Exception {
        Document temp;
        Configuration configuration = Configuration.defaultConfiguration();
        configuration = configuration.addOptions(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL});
        DocumentContext parse = JsonPath.parse((String)jsonContent, (Configuration)configuration);
        String formid = (String)parse.read(baseJsonPath + ".formId", new Predicate[0]);
        String viewid = (String)parse.read(baseJsonPath + ".viewId", new Predicate[0]);
        String stateid = (String)parse.read(baseJsonPath + ".stateId", new Predicate[0]);
        String parentid = (String)parse.read(baseJsonPath + ".parentId", new Predicate[0]);
        String sign = (String)parse.read(baseJsonPath + ".sign", new Predicate[0]);
        String docId = params.getDocId();
        if (StringUtil.isBlank((String)docId)) {
            docId = (String)parse.read(baseJsonPath + ".id", new Predicate[0]);
        }
        String isRelate = (String)parse.read(baseJsonPath + ".isRelate", new Predicate[0]);
        List subDocuments = (List)parse.read(baseJsonPath + ".subDocuments", new Predicate[0]);
        Map items = (Map)parse.read(baseJsonPath + ".items", new Predicate[0]);
        Object delete = parse.read(baseJsonPath + ".delete", new Predicate[0]);
        Object edit = parse.read(baseJsonPath + ".edit", new Predicate[0]);
        Object isFromRefresh = params.getParameter("isFromRefresh");
        Object exparams = parse.read(baseJsonPath + ".exparams", new Predicate[0]);
        if (exparams != null) {
            Map exparamsMap = (Map)exparams;
            for (Map.Entry entry : exparamsMap.entrySet()) {
                String key = entry.getKey().toString();
                Object value = entry.getValue();
                params.setParameter(key, value);
            }
        }
        if (isRelate != null && isRelate.equals("true")) {
            params.setParameter("isRelate", (Object)"true");
            if (!StringUtil.isBlank((String)parentid)) {
                params.setParameter("relateid", (Object)parentid);
            }
        } else {
            if (!StringUtil.isBlank((String)parentid)) {
                params.setParameter("relateid", (Object)parentid);
            }
            parentid = "";
        }
        if (parentid != null && !parentid.isEmpty()) {
            params.setParameter("parentid", (Object)parentid);
        }
        if (viewid != null && !viewid.isEmpty()) {
            params.setParameter("viewid", (Object)viewid);
        }
        DocumentProcess dProcess = RunTimeServiceManager.documentProcess((String)applicationId);
        Form form = null;
        IUser user = this.getWebUser();
        Document doc = null;
        if (items != null) {
            temp = (Document)MemoryCacheUtil.getFromPrivateSpace((Object)docId, (IUser)user);
            if (temp == null) {
                temp = (Document)dProcess.doView(docId);
            }
            if (temp == null) {
                form = DesignTimeServiceManager.formDesignTimeService().doView(formid);
                temp = dProcess.doNew(form, user, params);
                temp.setId(docId);
            }
            for (Map.Entry entry : items.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                Item item = temp.findItem(key);
                if (item == null && !StringUtil.isBlank((String)key) && key.lastIndexOf("_show") > -1) {
                    item = temp.findItem(key.substring(0, key.lastIndexOf("_show")));
                }
                if (item == null) continue;
                params.setParameter(key, value);
            }
        } else {
            return new Document();
        }
        doc = temp;
        if (!items.isEmpty() && isFromRefresh == null) {
            if (form == null) {
                form = DesignTimeServiceManager.formDesignTimeService().doView(formid);
            }
            doc = form.createDocument(doc, params, user);
        }
        if (!StringUtil.isBlank((String)parentid)) {
            doc.setParent(parentid);
        }
        if (!StringUtil.isBlank((String)stateid)) {
            doc.setState(stateid);
        }
        if (!StringUtil.isBlank((String)sign)) {
            doc.setSign(sign);
        }
        if (StringUtil.isBlank((String)doc.getFormid()) && !StringUtil.isBlank((String)formid)) {
            doc.setFormid(formid);
        }
        if (StringUtil.isBlank((String)doc.getApplicationid()) && !StringUtil.isBlank((String)applicationId)) {
            doc.setApplicationid(applicationId);
        }
        ArrayList<Document> subDocumentList = new ArrayList<Document>();
        if (subDocuments != null) {
            for (Map map : subDocuments) {
                ParamsTable newParams = params.copyContextParams();
                for (Map.Entry entry : map.entrySet()) {
                    String name = (String)entry.getKey();
                    Object value = entry.getValue();
                    if (value instanceof String[]) {
                        if (((String[])value).length > 1) {
                            newParams.setParameter(name, value);
                            continue;
                        }
                        newParams.setParameter(name, (Object)((String[])value)[0]);
                        continue;
                    }
                    newParams.setParameter(name, value);
                }
                Document subDoc = this.prepareDocument(JSONObject.fromObject((Object)map).toString(), applicationId, "$", newParams);
                subDocumentList.add(subDoc);
            }
        }
        doc.setSubDocuments(subDocumentList.isEmpty() ? null : subDocumentList);
        if (delete != null) {
            doc.setDelete(true);
        }
        if (edit != null) {
            doc.setEdit(true);
        }
        MemoryCacheUtil.putToPrivateSpace((Object)doc.getId(), (Object)doc, (IUser)this.getWebUser());
        return doc;
    }
}

