/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.api.controllers;

import cn.myapps.common.data.DataPackage;
import cn.myapps.common.model.workflow.BillDefiVO;
import cn.myapps.designtime.application.service.ApplicationDesignTimeService;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.task.service.TaskDesignTimeService;
import cn.myapps.designtime.workflow.definition.service.BillDefiDesignTimeService;
import com.bcxin.requests.FlowDefinitionRequest;
import com.bcxin.responses.AppDefinitionResponse;
import com.bcxin.responses.FlowDefinitionResponse;
import com.bcxin.responses.TaskDefinitionResponse;
import com.bcxin.runtime.apis.controllers.ControllerAbstract;
import com.bcxin.saas.core.utils.ExceptionUtils;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="v2_meta_controller")
@RequestMapping(value={"/api/v2/runtime/definitions/apps"})
public class DefinitionController
extends ControllerAbstract {
    private final ApplicationDesignTimeService applicationDesignTimeService = DesignTimeServiceManager.applicationDesignTimeService();
    private final TaskDesignTimeService taskDesignTimeService = DesignTimeServiceManager.taskDesignTimeService();
    private final BillDefiDesignTimeService billDefiDesignTimeService = DesignTimeServiceManager.billDefiDesignTimeService();

    @GetMapping
    public ResponseEntity<Collection<AppDefinitionResponse>> getApps() throws Exception {
        ResponseEntity responseEntity;
        String result = "";
        try {
            List apps = this.applicationDesignTimeService.list(null, null);
            Collection appDefinitionResponses = apps.stream().map(ii -> AppDefinitionResponse.create(ii.getId(), ii.getName())).collect(Collectors.toList());
            result = "\u6267\u884c\u5b8c\u6bd5";
            responseEntity = ResponseEntity.ok((Object)appDefinitionResponses);
        }
        catch (Exception ex) {
            try {
                result = ExceptionUtils.getStackMessage((Throwable)ex);
                throw ex;
            }
            catch (Throwable throwable) {
                System.err.println(String.format("\u83b7\u53d6\u5e94\u7528\u5217\u8868/apps:\u7ed3\u679c=%s;", result));
                throw throwable;
            }
        }
        System.err.println(String.format("\u83b7\u53d6\u5e94\u7528\u5217\u8868/apps:\u7ed3\u679c=%s;", result));
        return responseEntity;
    }

    @GetMapping(value={"/{appId}/tasks"})
    public ResponseEntity<Collection<TaskDefinitionResponse>> getTasks(@PathVariable String appId) throws Exception {
        DataPackage data = this.taskDesignTimeService.queryByNameOrDescript(appId, "", 1, Integer.MAX_VALUE);
        Collection taskResponses = data.getDatas().stream().map(ii -> TaskDefinitionResponse.create(ii.getApplicationid(), ii.getId(), ii.getName(), ii.getTaskScript(), ii.getRunningTime(), ii.getModifyTime(), ii.getExecutedCount(), ii.getFrequency())).collect(Collectors.toList());
        return ResponseEntity.ok((Object)taskResponses);
    }

    @GetMapping(value={"/{appId}/flows"})
    public ResponseEntity<Collection<FlowDefinitionResponse>> getFlows(@PathVariable String appId) throws Exception {
        List allFlows = this.billDefiDesignTimeService.list(null, null);
        Collection flowDefinitionResponses = allFlows.stream().filter(ii -> ii.getApplicationid().equalsIgnoreCase(appId)).map(ii -> FlowDefinitionResponse.create(ii.getApplicationid(), ii.getId(), ii.getName(), ii.getSubject(), ii.getFlow())).collect(Collectors.toList());
        return this.ok(flowDefinitionResponses);
    }

    @PutMapping(value={"/{appId}/flows/{id}"})
    public ResponseEntity putFlow(@PathVariable String appId, @PathVariable String id, @RequestBody FlowDefinitionRequest request) throws Exception {
        Optional<BillDefiVO> billDefiVOOptional = this.billDefiDesignTimeService.list(null, null).stream().filter(ii -> ii.getApplicationid().equalsIgnoreCase(appId) && ii.getId().equalsIgnoreCase(id)).findFirst();
        if (!billDefiVOOptional.isPresent()) {
            return this.notFound(String.format("\u627e\u4e0d\u5230\u6d41\u7a0b(%s)", id));
        }
        BillDefiVO billDefiVO = billDefiVOOptional.get();
        billDefiVO.setFlow(request.getFlow());
        billDefiVO.setName(request.getName());
        billDefiVO.setSubject(request.getSubject());
        this.billDefiDesignTimeService.update((Object)billDefiVO);
        return this.ok("\u66f4\u65b0\u5b8c\u6bd5");
    }
}

