/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.webservice.util;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.department.model.DepartmentVO;
import cn.myapps.authtime.department.service.DepartmentProcess;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.domain.service.DomainProcess;
import cn.myapps.authtime.user.model.BaseUser;
import cn.myapps.authtime.user.model.UserDepartmentRoleSet;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.workcalendar.calendar.model.CalendarVO;
import cn.myapps.authtime.workcalendar.calendar.service.CalendarProcess;
import cn.myapps.common.model.application.Application;
import cn.myapps.common.model.superuser.SuperUserVO;
import cn.myapps.util.ObjectUtil;
import cn.myapps.util.ProcessFactory;
import cn.myapps.webservice.WebServiceUtil;
import cn.myapps.webservice.fault.UserServiceFault;
import cn.myapps.webservice.model.SimpleAdmin;
import cn.myapps.webservice.model.SimpleUser;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class UserUtil {
    public static SimpleUser convertToSimple(BaseUser user) throws Exception {
        if (user != null) {
            SimpleUser dest = new SimpleUser();
            ObjectUtil.copyProperties((Object)dest, (Object)user);
            if (user instanceof UserVO) {
                UserUtil.setOtherProperties(dest, (UserVO)user);
            }
            return dest;
        }
        return null;
    }

    public static Object convertToSimple(SuperUserVO user, Class beanClass) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        if (user != null) {
            Object dest = beanClass.newInstance();
            ObjectUtil.copyProperties(dest, (Object)user);
            if (dest instanceof SimpleAdmin) {
                UserUtil.setOtherProperties((SimpleAdmin)dest, user);
            }
            return dest;
        }
        return null;
    }

    public static UserVO convertToVO(UserVO vo, SimpleUser user) throws Exception {
        try {
            vo.setId(user.getId() != null ? user.getId() : vo.getId());
            vo.setName(user.getName() != null ? user.getName() : vo.getName());
            vo.setLoginno(user.getLoginno() != null ? user.getLoginno() : vo.getLoginno());
            vo.setLoginpwd(user.getLoginpwd() != null ? user.getLoginpwd() : vo.getLoginpwd());
            vo.setEmail(user.getEmail() != null ? user.getEmail() : vo.getEmail());
            vo.setTelephone(user.getTelephone() != null ? user.getTelephone() : vo.getTelephone());
            vo.setLockFlag(1);
            vo.setStatus(1);
            UserUtil.setDomainInfo(vo, user);
        }
        catch (Exception e) {
            throw new UserServiceFault(e.getMessage());
        }
        return vo;
    }

    public static SuperUserVO convertToVO(SuperUserVO vo, SimpleAdmin admin) throws Exception {
        try {
            vo.setId(admin.getId() != null ? admin.getId() : vo.getId());
            vo.setName(admin.getName() != null ? admin.getName() : vo.getName());
            vo.setLoginno(admin.getLoginno() != null ? admin.getLoginno() : vo.getLoginno());
            vo.setLoginpwd(admin.getLoginpwd() != null ? admin.getLoginpwd() : vo.getLoginpwd());
            vo.setEmail(admin.getEmail() != null ? admin.getEmail() : vo.getEmail());
            UserUtil.setOtherInfo(vo, admin);
        }
        catch (Exception e) {
            throw new UserServiceFault(e.getMessage());
        }
        return vo;
    }

    private static void setOtherProperties(SimpleUser dest, UserVO user) throws Exception {
        DomainProcess dp = AuthTimeServiceManager.domainRuntimeService();
        DepartmentProcess process = AuthTimeServiceManager.departmentRuntimeService();
        DepartmentVO vo = (DepartmentVO)process.doView(user.getDefaultDepartment());
        dest.setDefaultDepartmentName(vo != null ? vo.getName() : null);
        DomainVO domain = (DomainVO)dp.doView(user.getDomainid());
        dest.setDomainName(domain != null ? domain.getName() : null);
    }

    private static void setOtherProperties(SimpleAdmin dest, SuperUserVO user) {
        Collection apps = user.getApplicationList();
        String[] appNames = null;
        if (apps != null) {
            appNames = new String[apps.size()];
            int i = 0;
            for (Application applicationVO : apps) {
                appNames[i++] = applicationVO.getName();
            }
        }
        dest.setApplicationNames(appNames);
        List domains = user.getDomainList();
        String[] domainNames = null;
        if (domains != null) {
            domainNames = new String[domains.size()];
            int i = 0;
            for (DomainVO domainVO : domains) {
                domainNames[i++] = domainVO.getName();
            }
        }
        dest.setDomainNames(domainNames);
        int[] type = new int[]{3};
        dest.setUserType(type);
    }

    private static void setDomainInfo(UserVO vo, SimpleUser user) throws Exception {
        DepartmentProcess process = AuthTimeServiceManager.departmentRuntimeService();
        CalendarProcess calendarProcess = (CalendarProcess)ProcessFactory.createProcess(CalendarProcess.class);
        DomainVO domain = WebServiceUtil.validateDomain(user.getDomainName());
        vo.setDomainid(domain.getId());
        CalendarVO calendar = (CalendarVO)calendarProcess.doViewByName("Standard_Calendar", domain.getId());
        vo.setCalendarType(calendar.getId());
        String deptName = user.getDefaultDepartmentName();
        Collection coll = vo.getUserDepartmentRoleSets();
        if (deptName == null) {
            if (vo.getDefaultDepartment() == null) {
                if (coll.isEmpty() && coll.size() <= 0) {
                    DepartmentVO defaultDep = process.getRootDepartmentByDomainId(domain.getId());
                    if (defaultDep == null) {
                        throw new UserServiceFault("\u4f01\u4e1a\u57df[" + domain.getName() + "]\u8fd8\u6ca1\u6709\u90e8\u95e8,\u8bf7\u5148\u6dfb\u52a0\u90e8\u95e8.");
                    }
                    UserDepartmentRoleSet set = new UserDepartmentRoleSet(vo.getId(), defaultDep.getId(), "");
                    coll.add(set);
                    vo.setUserDepartmentRoleSets(coll);
                    vo.setDefaultDepartment(defaultDep != null ? defaultDep.getId() : null);
                } else {
                    UserDepartmentRoleSet set = (UserDepartmentRoleSet)coll.iterator().next();
                    DepartmentVO defaultDep = (DepartmentVO)process.doView(set.getDepartmentId());
                    vo.setDefaultDepartment(defaultDep.getId());
                }
            }
        } else {
            DepartmentVO defaultDep = (DepartmentVO)process.doViewByName(deptName, domain.getId());
            if (defaultDep == null) {
                throw new UserServiceFault("\u90e8\u95e8[" + defaultDep + "]\u4e0d\u5b58\u5728\u4f01\u4e1a\u57df[" + domain.getName() + "]\u4e0b.");
            }
            boolean exist = false;
            for (UserDepartmentRoleSet set : coll) {
                if (!defaultDep.getId().equals(set.getDepartmentId())) continue;
                exist = true;
                break;
            }
            if (!exist) {
                UserDepartmentRoleSet set = new UserDepartmentRoleSet(vo.getId(), defaultDep.getId(), "");
                coll.add(set);
                vo.setUserDepartmentRoleSets(coll);
            }
            vo.setDefaultDepartment(defaultDep.getId());
        }
    }

    private static void setOtherInfo(SuperUserVO vo, SimpleAdmin admin) throws Exception {
        String[] apps = admin.getApplicationNames();
        HashSet<String> applications = new HashSet<String>();
        if (apps != null) {
            for (int i = 0; i < apps.length; ++i) {
                Application appVO = WebServiceUtil.validateApplication(apps[i]);
                applications.add(appVO.getId());
            }
            vo.setApplications(applications);
        }
        String[] domainNames = admin.getDomainNames();
        HashSet<String> domains = new HashSet<String>();
        if (domainNames != null) {
            for (int i = 0; i < domainNames.length; ++i) {
                DomainVO domain = WebServiceUtil.validateDomain(domainNames[i]);
                domains.add(domain.getId());
            }
            vo.setDomains(domains);
        }
        int[] type = admin.getUserType();
    }
}

