/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.webservice.util;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.department.model.DepartmentVO;
import cn.myapps.authtime.department.service.DepartmentProcess;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.webservice.WebServiceUtil;
import cn.myapps.webservice.fault.DepartmentServiceFault;
import cn.myapps.webservice.model.SimpleDepartment;

public class DepartmentUtil {
    public static SimpleDepartment convert(SimpleDepartment dep, DepartmentVO vo) throws DepartmentServiceFault {
        try {
            dep.setId(vo.getId());
            dep.setName(vo.getName());
            dep.setCode(vo.getCode());
            dep.setLevel(vo.getLevel());
            dep.setDomainName(vo.getDomain().getName());
            dep.setSuperiorName(vo.getSuperior() != null ? vo.getSuperior().getName() : null);
            return dep;
        }
        catch (Exception e) {
            throw new DepartmentServiceFault(e.getMessage());
        }
    }

    public static DepartmentVO convert(DepartmentVO vo, SimpleDepartment dep) throws DepartmentServiceFault {
        try {
            DomainVO domain = WebServiceUtil.validateDomain(dep.getDomainName());
            DepartmentProcess process = AuthTimeServiceManager.departmentRuntimeService();
            if (dep.getSuperiorName() == null) {
                if (vo.getSuperior() == null) {
                    DepartmentVO superior = process.getRootDepartmentByDomainId(domain.getId());
                    vo.setSuperior(superior);
                }
            } else {
                DepartmentVO superior = (DepartmentVO)process.doViewByName(dep.getSuperiorName(), domain.getId());
                if (superior == null) {
                    throw new DepartmentServiceFault("\u4e0a\u7ea7\u90e8\u95e8[" + dep.getSuperiorName() + "]\u4e0d\u5b58\u5728\u4f01\u4e1a\u57df[" + domain.getName() + "]\u4e0b.");
                }
                vo.setSuperior(superior);
            }
            vo.setId(dep.getId() != null ? dep.getId() : vo.getId());
            vo.setName(dep.getName() != null ? dep.getName() : vo.getName());
            vo.setCode(dep.getCode() != null ? dep.getCode() : vo.getCode());
            vo.setLevel(vo.getSuperior() != null ? vo.getSuperior().getLevel() + 1 : 0);
            vo.setDomain(domain);
            vo.setDomainid(domain.getId());
            return vo;
        }
        catch (Exception e) {
            throw new DepartmentServiceFault(e.getMessage());
        }
    }
}

