/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.webservice.handler;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.common.util.DefaultProperty;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.security.SecurityProvider;
import org.apache.axis.security.simple.SimpleAuthenticatedUser;
import org.apache.axis.security.simple.SimpleSecurityProvider;
import org.apache.axis.utils.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationHandler
extends BasicHandler {
    private static final long serialVersionUID = -2329407486293251431L;
    protected static Logger log = LoggerFactory.getLogger(AuthenticationHandler.class);

    public void invoke(MessageContext msgContext) throws AxisFault {
        try {
            SecurityProvider provider;
            int loginPasswordErrortimes = 100;
            boolean useAuthentication = Boolean.parseBoolean(DefaultProperty.getProperty((String)"webservices.use.authentication", (String)"true"));
            if (!useAuthentication) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("{}", (Object)"Enter: SimpleAuthenticationHandler::invoke");
            }
            if ((provider = (SecurityProvider)msgContext.getProperty("securityProvider")) == null) {
                provider = new SimpleSecurityProvider();
                msgContext.setProperty("securityProvider", (Object)provider);
            }
            if (provider != null) {
                String userID = msgContext.getRequestMessage().getSOAPEnvelope().getHeaderByName("Authorization", "loginno").getValue();
                if (log.isDebugEnabled()) {
                    log.debug("{}", (Object)Messages.getMessage((String)"user00", (String)userID));
                }
                if (userID == null || userID.equals("")) {
                    throw new AxisFault("Server.Unauthenticated", Messages.getMessage((String)"cantAuth00", (String)userID), null, null);
                }
                String passwd = msgContext.getRequestMessage().getSOAPEnvelope().getHeaderByName("Authorization", "password").getValue();
                if (log.isDebugEnabled()) {
                    log.debug("{}", (Object)Messages.getMessage((String)"password00", (String)passwd));
                }
                String domain = msgContext.getRequestMessage().getSOAPEnvelope().getHeaderByName("Authorization", "domain").getValue();
                if (log.isDebugEnabled()) {
                    log.debug("{}", (Object)Messages.getMessage((String)"domain00", (String)passwd));
                }
                msgContext.setUsername(userID);
                msgContext.setPassword(passwd);
                UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
                UserVO user = userProcess.login(userID, passwd, domain, loginPasswordErrortimes);
                SimpleAuthenticatedUser authUser = new SimpleAuthenticatedUser(user.getName());
                if (authUser == null) {
                    throw new AxisFault("Server.Unauthenticated", Messages.getMessage((String)"cantAuth01", (String)userID), null, null);
                }
                if (log.isDebugEnabled()) {
                    log.debug("{}", (Object)Messages.getMessage((String)"auth00", (String)userID));
                }
                msgContext.setProperty("authenticatedUser", (Object)authUser);
            }
        }
        catch (Exception e) {
            throw new AxisFault("Server.Unauthenticated", (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("{}", (Object)"Exit: SimpleAuthenticationHandler::invoke");
        }
    }
}

