/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.webservice;

import cn.myapps.authtime.common.dao.PersistenceUtils;
import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.workflow.BillDefiVO;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.form.service.FormDesignTimeService;
import cn.myapps.designtime.workflow.definition.service.BillDefiDesignTimeService;
import cn.myapps.runtime.common.service.RunTimeServiceManager;
import cn.myapps.runtime.dynaform.document.ejb.DocumentProcess;
import cn.myapps.runtime.dynaform.document.ejb.WorkVO;
import cn.myapps.runtime.dynaform.form.ejb.Form;
import cn.myapps.runtime.workflow.storage.runtime.ejb.Circulator;
import cn.myapps.runtime.workflow.storage.runtime.ejb.CirculatorProcess;
import cn.myapps.util.json.JsonUtil;
import cn.myapps.util.xml.XmlUtil;
import cn.myapps.webservice.WebServiceUtil;
import cn.myapps.webservice.fault.WorkServiceFault;
import cn.myapps.webservice.model.SimpleCirculator;
import cn.myapps.webservice.model.SimpleWork;
import cn.myapps.webservice.util.WorkUtil;
import java.util.ArrayList;
import java.util.Collection;

public class WorkService {
    private DataPackage<WorkVO> queryWorks(ParamsTable params, WebUser user, String applicationId) throws WorkServiceFault {
        try {
            WebServiceUtil.validateApplicationById(applicationId);
            DocumentProcess docProcess = RunTimeServiceManager.documentProcess((String)applicationId);
            String _currpage = params.getParameterAsString("_currpage");
            String _pagelines = params.getParameterAsString("_pagelines");
            int page = _currpage != null && _currpage.length() > 0 ? Integer.parseInt(_currpage) : 1;
            int lines = _pagelines != null && _pagelines.length() > 0 ? Integer.parseInt(_pagelines) : Integer.MAX_VALUE;
            DataPackage dataPackage = docProcess.queryWorkBySQLPage(params, page, lines, (IUser)user);
            return dataPackage;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WorkServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new WorkServiceFault(e.getMessage());
            }
        }
    }

    private Collection<SimpleWork> queryWorksByUser(ParamsTable params, String userId, String applicationId) throws WorkServiceFault {
        try {
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            UserVO user = (UserVO)userProcess.doView(userId);
            if (user != null) {
                Collection<SimpleWork> collection = WorkUtil.convertToSimpleDatas(this.queryWorks(params, new WebUser((IUser)user), applicationId));
                return collection;
            }
            ArrayList<SimpleWork> arrayList = new ArrayList<SimpleWork>();
            return arrayList;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WorkServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new WorkServiceFault(e.getMessage());
            }
        }
    }

    public SimpleWork getSimpleWorkInstance() {
        return new SimpleWork();
    }

    public Collection<SimpleWork> getPendingWorkByUser(String userId, String applicationId) throws WorkServiceFault {
        ParamsTable params = new ParamsTable();
        params.setParameter("_processType", (Object)"processing");
        return this.queryWorksByUser(params, userId, applicationId);
    }

    public String getPendingWorkByUserFormat2XML(String userId, String applicationId) throws WorkServiceFault {
        Collection<SimpleWork> datas = this.getPendingWorkByUser(userId, applicationId);
        return XmlUtil.toXml(datas);
    }

    public String getPendingWorkByUserFormat2Json(String userId, String applicationId) throws WorkServiceFault {
        Collection<SimpleWork> datas = this.getPendingWorkByUser(userId, applicationId);
        return JsonUtil.collection2Json(datas);
    }

    public Collection<SimpleWork> getProcessedWorkByUser(String userId, String applicationId) throws WorkServiceFault {
        ParamsTable params = new ParamsTable();
        params.setParameter("_processType", (Object)"processed");
        return this.queryWorksByUser(params, userId, applicationId);
    }

    public String getProcessedWorkByUserFormat2XML(String userId, String applicationId) throws WorkServiceFault {
        Collection<SimpleWork> datas = this.getProcessedWorkByUser(userId, applicationId);
        return XmlUtil.toXml(datas);
    }

    public String getProcessedWorkByUserFormat2Json(String userId, String applicationId) throws WorkServiceFault {
        Collection<SimpleWork> datas = this.getProcessedWorkByUser(userId, applicationId);
        return JsonUtil.collection2Json(datas);
    }

    private Form doViewByFormName(String formName, String application) throws WorkServiceFault {
        try {
            if (StringUtil.isBlank((String)formName)) {
                throw new WorkServiceFault("formName\u4e0d\u80fd\u4e3a\u7a7a");
            }
            FormDesignTimeService process = DesignTimeServiceManager.formDesignTimeService();
            Form form = process.doViewByFormName(formName, application);
            return form;
        }
        catch (Exception e) {
            throw new WorkServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new WorkServiceFault(e.getMessage());
            }
        }
    }

    private BillDefiVO doViewBySubject(String subject, String applicationId) throws WorkServiceFault {
        try {
            if (StringUtil.isBlank((String)subject)) {
                throw new WorkServiceFault("flowName\u4e0d\u80fd\u4e3a\u7a7a");
            }
            BillDefiDesignTimeService process = DesignTimeServiceManager.billDefiDesignTimeService();
            BillDefiVO billDefiVO = process.doViewBySubject(subject, applicationId);
            return billDefiVO;
        }
        catch (Exception e) {
            throw new WorkServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new WorkServiceFault(e.getMessage());
            }
        }
    }

    public Collection<SimpleWork> getPendingWorkByUser(String userId, String formName, String flowName, String applicationId, int currpage, int pagelines) throws WorkServiceFault {
        try {
            WebServiceUtil.validateApplicationById(applicationId);
            ParamsTable params = new ParamsTable();
            params.setParameter("_processType", (Object)"processing");
            params.setParameter("_currpage", (Object)String.valueOf(currpage));
            params.setParameter("_pagelines", (Object)String.valueOf(pagelines));
            if (!StringUtil.isBlank((String)formName)) {
                Form form = this.doViewByFormName(formName, applicationId);
                if (form == null) {
                    throw new WorkServiceFault("\u8868\u5355[" + formName + "]\u4e0d\u5b58\u5728\u8f6f\u4ef6[id=" + applicationId + "]\u4e0b.");
                }
                params.setParameter("_formId", (Object)form.getId());
            }
            if (!StringUtil.isBlank((String)flowName)) {
                BillDefiVO flow = this.doViewBySubject(flowName, applicationId);
                if (flow == null) {
                    throw new WorkServiceFault("\u6d41\u7a0b[" + flowName + "]\u4e0d\u5b58\u5728\u8f6f\u4ef6[id=" + applicationId + "]\u4e0b.");
                }
                params.setParameter("_flowId", (Object)flow.getId());
            }
            return this.queryWorksByUser(params, userId, applicationId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WorkServiceFault(e.getMessage());
        }
    }

    public String getPendingWorkByUserFormat2XML(String userId, String formName, String flowName, String applicationId, int currpage, int pagelines) throws WorkServiceFault {
        Collection<SimpleWork> datas = this.getPendingWorkByUser(userId, formName, flowName, applicationId, currpage, pagelines);
        return XmlUtil.toXml(datas);
    }

    public String getPendingWorkByUserFormat2Json(String userId, String formName, String flowName, String applicationId, int currpage, int pagelines) throws WorkServiceFault {
        Collection<SimpleWork> datas = this.getPendingWorkByUser(userId, formName, flowName, applicationId, currpage, pagelines);
        return JsonUtil.collection2Json(datas);
    }

    public Collection<SimpleWork> getProcessedWorkByUser(String userId, String formName, String flowName, String applicationId, int currpage, int pagelines) throws WorkServiceFault {
        try {
            WebServiceUtil.validateApplicationById(applicationId);
            ParamsTable params = new ParamsTable();
            params.setParameter("_processType", (Object)"processed");
            params.setParameter("_currpage", (Object)String.valueOf(currpage));
            params.setParameter("_pagelines", (Object)String.valueOf(pagelines));
            if (!StringUtil.isBlank((String)formName)) {
                Form form = this.doViewByFormName(formName, applicationId);
                if (form == null) {
                    throw new WorkServiceFault("\u8868\u5355[" + formName + "]\u4e0d\u5b58\u5728\u8f6f\u4ef6[id=" + applicationId + "]\u4e0b.");
                }
                params.setParameter("_formId", (Object)form.getId());
            }
            if (!StringUtil.isBlank((String)flowName)) {
                BillDefiVO flow = this.doViewBySubject(flowName, applicationId);
                if (flow == null) {
                    throw new WorkServiceFault("\u6d41\u7a0b[" + flowName + "]\u4e0d\u5b58\u5728\u8f6f\u4ef6[id=" + applicationId + "]\u4e0b.");
                }
                params.setParameter("_flowId", (Object)flow.getId());
            }
            return this.queryWorksByUser(params, userId, applicationId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WorkServiceFault(e.getMessage());
        }
    }

    public String getProcessedWorkByUserFormat2XML(String userId, String formName, String flowName, String applicationId, int currpage, int pagelines) throws WorkServiceFault {
        Collection<SimpleWork> datas = this.getProcessedWorkByUser(userId, formName, flowName, applicationId, currpage, pagelines);
        return XmlUtil.toXml(datas);
    }

    public String getProcessedWorkByUserFormat2Json(String userId, String formName, String flowName, String applicationId, int currpage, int pagelines) throws WorkServiceFault {
        Collection<SimpleWork> datas = this.getProcessedWorkByUser(userId, formName, flowName, applicationId, currpage, pagelines);
        return JsonUtil.collection2Json(datas);
    }

    private DataPackage<Circulator> queryWorks4Cc(ParamsTable params, WebUser user, String applicationId) throws WorkServiceFault {
        try {
            WebServiceUtil.validateApplicationById(applicationId);
            CirculatorProcess process = RunTimeServiceManager.circulatorProcess((String)applicationId);
            String _currpage = params.getParameterAsString("_currpage");
            String _pagelines = params.getParameterAsString("_pagelines");
            int page = _currpage != null && _currpage.length() > 0 ? Integer.parseInt(_currpage) : 1;
            int lines = _pagelines != null && _pagelines.length() > 0 ? Integer.parseInt(_pagelines) : Integer.MAX_VALUE;
            params.setParameter("_currpage", (Object)String.valueOf(page));
            params.setParameter("_pagelines", (Object)String.valueOf(lines));
            DataPackage dataPackage = process.getWorksByUser(params, (IUser)user);
            return dataPackage;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WorkServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new WorkServiceFault(e.getMessage());
            }
        }
    }

    private Collection<SimpleCirculator> queryWorksByUser4Cc(ParamsTable params, String userId, String applicationId) throws WorkServiceFault {
        try {
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            UserVO user = (UserVO)userProcess.doView(userId);
            if (user != null) {
                Collection<SimpleCirculator> collection = WorkUtil.convertToSimpleDatas4Cc(this.queryWorks4Cc(params, new WebUser((IUser)user), applicationId));
                return collection;
            }
            ArrayList<SimpleCirculator> arrayList = new ArrayList<SimpleCirculator>();
            return arrayList;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WorkServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new WorkServiceFault(e.getMessage());
            }
        }
    }

    public SimpleCirculator getSimpleCirculatorInstance() {
        return new SimpleCirculator();
    }

    public Collection<SimpleCirculator> getPendingInfoByUser(String userId, String applicationId) throws WorkServiceFault {
        ParamsTable params = new ParamsTable();
        params.setParameter("_isRead", (Object)"0");
        return this.queryWorksByUser4Cc(params, userId, applicationId);
    }

    public String getPendingInfoByUserFormat2XML(String userId, String applicationId) throws WorkServiceFault {
        Collection<SimpleCirculator> datas = this.getPendingInfoByUser(userId, applicationId);
        return XmlUtil.toXml(datas);
    }

    public String getPendingInfoByUserFormat2Json(String userId, String applicationId) throws WorkServiceFault {
        Collection<SimpleCirculator> datas = this.getPendingInfoByUser(userId, applicationId);
        return JsonUtil.collection2Json(datas);
    }

    public Collection<SimpleCirculator> getProcessedInfoByUser(String userId, String applicationId) throws WorkServiceFault {
        ParamsTable params = new ParamsTable();
        params.setParameter("_isRead", (Object)"1");
        return this.queryWorksByUser4Cc(params, userId, applicationId);
    }

    public String getProcessedInfoByUserFormat2XML(String userId, String applicationId) throws WorkServiceFault {
        Collection<SimpleCirculator> datas = this.getProcessedInfoByUser(userId, applicationId);
        return XmlUtil.toXml(datas);
    }

    public String getProcessedInfoByUserFormat2Json(String userId, String applicationId) throws WorkServiceFault {
        Collection<SimpleCirculator> datas = this.getProcessedInfoByUser(userId, applicationId);
        return JsonUtil.collection2Json(datas);
    }

    public Collection<SimpleCirculator> getPendingInfoByUser(String userId, String formName, String flowName, String applicationId, int currpage, int pagelines) throws WorkServiceFault {
        try {
            WebServiceUtil.validateApplicationById(applicationId);
            ParamsTable params = new ParamsTable();
            params.setParameter("_isRead", (Object)"0");
            params.setParameter("_currpage", (Object)String.valueOf(currpage));
            params.setParameter("_pagelines", (Object)String.valueOf(pagelines));
            if (!StringUtil.isBlank((String)formName)) {
                Form form = this.doViewByFormName(formName, applicationId);
                if (form == null) {
                    throw new WorkServiceFault("\u8868\u5355[" + formName + "]\u4e0d\u5b58\u5728\u8f6f\u4ef6[id=" + applicationId + "]\u4e0b.");
                }
                params.setParameter("_formId", (Object)form.getId());
            }
            if (!StringUtil.isBlank((String)flowName)) {
                BillDefiVO flow = this.doViewBySubject(flowName, applicationId);
                if (flow == null) {
                    throw new WorkServiceFault("\u6d41\u7a0b[" + flowName + "]\u4e0d\u5b58\u5728\u8f6f\u4ef6[id=" + applicationId + "]\u4e0b.");
                }
                params.setParameter("_flowId", (Object)flow.getId());
            }
            return this.queryWorksByUser4Cc(params, userId, applicationId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WorkServiceFault(e.getMessage());
        }
    }

    public String getPendingInfoByUserFormat2XML(String userId, String formName, String flowName, String applicationId, int currpage, int pagelines) throws WorkServiceFault {
        Collection<SimpleCirculator> datas = this.getPendingInfoByUser(userId, formName, flowName, applicationId, currpage, pagelines);
        return XmlUtil.toXml(datas);
    }

    public String getPendingInfoByUserFormat2Json(String userId, String formName, String flowName, String applicationId, int currpage, int pagelines) throws WorkServiceFault {
        Collection<SimpleCirculator> datas = this.getPendingInfoByUser(userId, formName, flowName, applicationId, currpage, pagelines);
        return JsonUtil.collection2Json(datas);
    }

    public Collection<SimpleCirculator> getProcessedInfoByUser(String userId, String formName, String flowName, String applicationId, int currpage, int pagelines) throws WorkServiceFault {
        try {
            WebServiceUtil.validateApplicationById(applicationId);
            ParamsTable params = new ParamsTable();
            params.setParameter("_isRead", (Object)"1");
            params.setParameter("_currpage", (Object)String.valueOf(currpage));
            params.setParameter("_pagelines", (Object)String.valueOf(pagelines));
            if (!StringUtil.isBlank((String)formName)) {
                Form form = this.doViewByFormName(formName, applicationId);
                if (form == null) {
                    throw new WorkServiceFault("\u8868\u5355[" + formName + "]\u4e0d\u5b58\u5728\u8f6f\u4ef6[id=" + applicationId + "]\u4e0b.");
                }
                params.setParameter("_formId", (Object)form.getId());
            }
            if (!StringUtil.isBlank((String)flowName)) {
                BillDefiVO flow = this.doViewBySubject(flowName, applicationId);
                if (flow == null) {
                    throw new WorkServiceFault("\u6d41\u7a0b[" + flowName + "]\u4e0d\u5b58\u5728\u8f6f\u4ef6[id=" + applicationId + "]\u4e0b.");
                }
                params.setParameter("_flowId", (Object)flow.getId());
            }
            return this.queryWorksByUser4Cc(params, userId, applicationId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WorkServiceFault(e.getMessage());
        }
    }

    public String getProcessedInfoByUserFormat2XML(String userId, String formName, String flowName, String applicationId, int currpage, int pagelines) throws WorkServiceFault {
        Collection<SimpleCirculator> datas = this.getProcessedInfoByUser(userId, formName, flowName, applicationId, currpage, pagelines);
        return XmlUtil.toXml(datas);
    }

    public String getProcessedInfoByUserFormat2Json(String userId, String formName, String flowName, String applicationId, int currpage, int pagelines) throws WorkServiceFault {
        Collection<SimpleCirculator> datas = this.getProcessedInfoByUser(userId, formName, flowName, applicationId, currpage, pagelines);
        return JsonUtil.collection2Json(datas);
    }
}

