/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.webservice;

import cn.myapps.authtime.common.dao.PersistenceUtils;
import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.workflow.BillDefiVO;
import cn.myapps.common.util.StringUtil;
import cn.myapps.runtime.common.service.RunTimeServiceManager;
import cn.myapps.runtime.dynaform.document.ejb.Document;
import cn.myapps.runtime.dynaform.document.ejb.DocumentProcess;
import cn.myapps.runtime.dynaform.document.model.IDocument;
import cn.myapps.runtime.workflow.element.FlowDiagram;
import cn.myapps.runtime.workflow.element.Node;
import cn.myapps.runtime.workflow.engine.StateMachine;
import cn.myapps.runtime.workflow.storage.runtime.ejb.FlowHistoryServiceImpl;
import cn.myapps.runtime.workflow.storage.runtime.ejb.FlowRuntimeServiceImpl;
import cn.myapps.runtime.workflow.storage.runtime.ejb.NodeRT;
import cn.myapps.runtime.workflow.storage.runtime.ejb.RelationHIS;
import cn.myapps.webservice.WebServiceUtil;
import cn.myapps.webservice.fault.WorkFlowProcessServiceFault;

public class WorkFlowProcessService {
    private void process(String docId, String currNodeId, String[] nextNodeIds, String userId, String flowOption, String attitude, String applicationId) throws WorkFlowProcessServiceFault {
        try {
            WebServiceUtil.validateApplicationById(applicationId);
            DocumentProcess docProcess = RunTimeServiceManager.documentProcess((String)applicationId);
            UserProcess process = AuthTimeServiceManager.userRuntimeService();
            Document doc = (Document)docProcess.doView(docId);
            if (doc == null) {
                throw new WorkFlowProcessServiceFault("\u8f6f\u4ef6(\u8f6f\u4ef6ID\uff1a" + applicationId + ")\u4e0b\u627e\u4e0d\u5230\u6587\u6863(\u6587\u6863ID\uff1a" + docId + ")");
            }
            UserVO user = (UserVO)process.doView(userId);
            if (user == null) {
                throw new WorkFlowProcessServiceFault("\u627e\u4e0d\u5230\u7528\u6237(\u7528\u6237ID\uff1a" + userId + ")");
            }
            if (nextNodeIds == null) {
                throw new WorkFlowProcessServiceFault("\u4e0b\u4e00\u7ed3\u70b9id\u6570\u7ec4\u4e0d\u80fd\u4e3a\u7a7a.");
            }
            ParamsTable params = new ParamsTable();
            params.setParameter("_attitude", (Object)attitude);
            params.setParameter("_flowid", (Object)doc.getState().getFlowid());
            if (StringUtil.isBlank((String)currNodeId)) {
                NodeRT currNode = StateMachine.getCurrUserNodeRT((IDocument)doc, (IUser)new WebUser((IUser)user), null);
                currNodeId = currNode.getNodeid();
            }
            FlowRuntimeServiceImpl stateProcess = new FlowRuntimeServiceImpl(doc.getApplicationid());
            stateProcess.doApprove(doc.getState(currNodeId), currNodeId, nextNodeIds, flowOption, "", params, (IUser)new WebUser((IUser)user), true, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WorkFlowProcessServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new WorkFlowProcessServiceFault(e.getMessage());
            }
        }
    }

    public int doStartFlow(String docId, String flowId, String userId, String applicationId) throws WorkFlowProcessServiceFault {
        int result = -1;
        try {
            DocumentProcess docProcess = RunTimeServiceManager.documentProcess((String)applicationId);
            Document doc = (Document)docProcess.doView(docId);
            if (doc == null) {
                throw new WorkFlowProcessServiceFault("\u8f6f\u4ef6(\u8f6f\u4ef6ID\uff1a" + applicationId + ")\u4e0b\u627e\u4e0d\u5230\u6587\u6863(\u6587\u6863ID\uff1a" + docId + ")");
            }
            UserProcess process = AuthTimeServiceManager.userRuntimeService();
            UserVO user = (UserVO)process.doView(userId);
            if (user == null) {
                throw new WorkFlowProcessServiceFault("\u627e\u4e0d\u5230\u7528\u6237(\u7528\u6237ID\uff1a" + userId + ")");
            }
            ParamsTable params = new ParamsTable();
            params.setParameter("_flowid", (Object)flowId);
            params.setParameter("_attitude", (Object)"");
            if (StringUtil.isBlank((String)doc.getParentid()) && docProcess.isNotStart((IDocument)doc, params) && !StringUtil.isBlank((String)flowId)) {
                docProcess.doStartFlowOrUpdate((IDocument)doc, params, (IUser)new WebUser((IUser)user));
                result = 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WorkFlowProcessServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new WorkFlowProcessServiceFault(e.getMessage());
            }
        }
        return result;
    }

    public int doFlow(String docId, String[] nextNodeIds, String userId, String attitude, String applicationId) throws WorkFlowProcessServiceFault {
        int result = -1;
        try {
            this.process(docId, null, nextNodeIds, userId, "80", attitude, applicationId);
            result = 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WorkFlowProcessServiceFault(e.getMessage());
        }
        return result;
    }

    public int doFlow(String docId, String[] nextNodeIds, String userId, String flowType, String attitude, String applicationId) throws WorkFlowProcessServiceFault {
        int result = -1;
        try {
            this.process(docId, null, nextNodeIds, userId, flowType, attitude, applicationId);
            result = 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WorkFlowProcessServiceFault(e.getMessage());
        }
        return result;
    }

    public int doFlow(String docId, String currNodeId, String[] nextNodeIds, String userId, String attitude, String applicationId) throws WorkFlowProcessServiceFault {
        int result = -1;
        try {
            this.process(docId, currNodeId, nextNodeIds, userId, "80", attitude, applicationId);
            result = 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WorkFlowProcessServiceFault(e.getMessage());
        }
        return result;
    }

    public int doFlowBack(String docId, String backNodeId, String userId, String attitude, String applicationId) throws WorkFlowProcessServiceFault {
        int result = -1;
        try {
            String[] nextNodeIds = new String[]{backNodeId};
            this.process(docId, null, nextNodeIds, userId, "81", attitude, applicationId);
            result = 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WorkFlowProcessServiceFault(e.getMessage());
        }
        return result;
    }

    public int doBatchFlow(String[] docIds, String[] nextNodeIds, String userId, String attitude, String applicationId) throws WorkFlowProcessServiceFault {
        int result = -1;
        try {
            if (docIds != null) {
                for (int i = 0; i < docIds.length; ++i) {
                    this.process(docIds[i], null, nextNodeIds, userId, "80", attitude, applicationId);
                }
            }
            result = 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WorkFlowProcessServiceFault(e.getMessage());
        }
        return result;
    }

    public int doRetracement(String docId, String flowId, String userId, String applicationId) throws WorkFlowProcessServiceFault {
        int result = -1;
        try {
            DocumentProcess proxy = RunTimeServiceManager.documentProcess((String)applicationId);
            Document doc = (Document)proxy.doView(docId);
            if (doc == null) {
                throw new WorkFlowProcessServiceFault("\u8f6f\u4ef6(\u8f6f\u4ef6ID\uff1a" + applicationId + ")\u4e0b\u627e\u4e0d\u5230\u6587\u6863(\u6587\u6863ID\uff1a" + docId + ")");
            }
            BillDefiVO flowVO = doc.getState().getFlowVO();
            FlowDiagram fd = flowVO.toFlowDiagram();
            UserProcess process = AuthTimeServiceManager.userRuntimeService();
            UserVO user = (UserVO)process.doView(userId);
            if (user == null) {
                throw new WorkFlowProcessServiceFault("\u627e\u4e0d\u5230\u7528\u6237(\u7528\u6237ID\uff1a" + userId + ")");
            }
            ParamsTable params = new ParamsTable();
            Node currNode = null;
            if (doc.getState().isComplete()) {
                FlowHistoryServiceImpl procss = new FlowHistoryServiceImpl(doc.getApplicationid());
                RelationHIS his = procss.getCompleteRelationHIS(doc.getId(), doc.getState().getId());
                currNode = (Node)fd.getElementByID(his.getEndnodeid());
            } else if (doc.getState().getNoderts() != null && doc.getState().getNoderts().size() > 0) {
                NodeRT nodert = (NodeRT)doc.getState().getNoderts().iterator().next();
                currNode = (Node)fd.getElementByID(nodert.getNodeid());
            }
            Node nextNode = StateMachine.getBackNodeByHis((IDocument)doc, (BillDefiVO)flowVO, (String)currNode.id, (IUser)new WebUser((IUser)user), (int)256);
            if (nextNode == null) {
                throw new WorkFlowProcessServiceFault("\u4f60\u6ca1\u6709\u56de\u64a4\u7684\u6743\u9650");
            }
            String submitTo = "[{\"nodeid\":'" + nextNode.id + "',\"isToPerson\":'true',\"userids\":\"[" + user.getId() + "]\"},]";
            params.setParameter("submitTo", (Object)submitTo);
            params.setParameter("doRetracement", (Object)"true");
            String[] nextNodeIds = new String[]{nextNode.id};
            proxy.doFlow((IDocument)doc, params, currNode.id, nextNodeIds, "85", "", (IUser)new WebUser((IUser)user));
            result = 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WorkFlowProcessServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new WorkFlowProcessServiceFault(e.getMessage());
            }
        }
        return result;
    }
}

