/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.webservice;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.department.model.DepartmentVO;
import cn.myapps.authtime.department.service.DepartmentProcess;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.domain.service.DomainProcess;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.application.Application;
import cn.myapps.common.model.role.Role;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.application.service.ApplicationDesignTimeService;
import cn.myapps.designtime.common.service.DesignTimeServiceFactory;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.role.service.RoleDesignTimeService;
import cn.myapps.runtime.common.service.RunTimeServiceManager;
import cn.myapps.runtime.dynaform.document.ejb.Document;
import cn.myapps.runtime.dynaform.document.ejb.DocumentProcess;
import cn.myapps.runtime.dynaform.form.ejb.ValidateMessage;
import cn.myapps.webservice.ApplicationService;
import cn.myapps.webservice.fault.DocumentServiceFault;
import java.util.Collection;
import java.util.List;

public class WebServiceUtil {
    public static DomainVO validateDomain(String domainName) throws Exception {
        if (StringUtil.isBlank((String)domainName)) {
            throw new Exception("\u57df\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        DomainProcess dp = AuthTimeServiceManager.domainRuntimeService();
        DomainVO vo = dp.getDomainByName(domainName);
        if (vo == null) {
            throw new Exception("\u8be5\u57df(" + domainName + ")\u4e0d\u5b58\u5728.");
        }
        return vo;
    }

    public static Application validateApplication(String name) throws Exception {
        ApplicationDesignTimeService appService = (ApplicationDesignTimeService)DesignTimeServiceFactory.resolve(ApplicationService.class);
        List apps = appService.list(null, name);
        if (apps.isEmpty()) {
            throw new Exception("\u8be5\u5e94\u7528(" + name + ")\u4e0d\u5b58\u5728.");
        }
        return (Application)apps.get(0);
    }

    public static Application validateApplicationById(String applicationId) throws Exception {
        ApplicationDesignTimeService appService = (ApplicationDesignTimeService)DesignTimeServiceFactory.resolve(ApplicationService.class);
        Application app = (Application)appService.findById(applicationId);
        if (app == null) {
            throw new Exception("\u8be5\u5e94\u7528(ID=" + applicationId + ")\u4e0d\u5b58\u5728.");
        }
        return app;
    }

    public static UserVO findUserWithValidate(String userId) throws Exception {
        UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
        UserVO user = (UserVO)userProcess.doView(userId);
        if (user == null) {
            throw new Exception("\u8be5\u7528\u6237(ID=" + userId + ")\u4e0d\u5b58\u5728.");
        }
        return user;
    }

    public static DepartmentVO findDepartmentWithValidate(String depId) throws Exception {
        DepartmentProcess process = AuthTimeServiceManager.departmentRuntimeService();
        DepartmentVO vo = (DepartmentVO)process.doView(depId);
        if (vo == null) {
            throw new Exception("\u8be5\u90e8\u95e8(ID=" + depId + ")\u4e0d\u5b58\u5728.");
        }
        return vo;
    }

    public static Role findRoleWithValidate(String roleId) throws Exception {
        RoleDesignTimeService roleService = DesignTimeServiceManager.roleDesignTimeService();
        Role vo = (Role)roleService.findById(roleId);
        if (vo == null) {
            throw new Exception("\u8be5\u89d2\u8272(ID=" + roleId + ")\u4e0d\u5b58\u5728.");
        }
        return vo;
    }

    public static void validateDocument(Document doc, ParamsTable params, WebUser user, String applicationId) throws DocumentServiceFault {
        try {
            DocumentProcess docProcess = RunTimeServiceManager.documentProcess((String)applicationId);
            Collection errors = docProcess.doValidate(doc, params, (IUser)user);
            if (errors != null && errors.size() > 0) {
                StringBuffer msg = new StringBuffer();
                for (ValidateMessage err : errors) {
                    msg.append(err.getFieldname()).append(":").append(err.getErrmessage()).append(";");
                }
                if (msg.length() > 0) {
                    throw new DocumentServiceFault(msg.toString());
                }
            }
        }
        catch (DocumentServiceFault e) {
            throw e;
        }
        catch (Exception e) {
            throw new DocumentServiceFault(e.getMessage());
        }
    }
}

