/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.webservice;

import cn.myapps.authtime.common.dao.PersistenceUtils;
import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.department.model.DepartmentVO;
import cn.myapps.authtime.department.service.DepartmentProcess;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.domain.service.DomainProcess;
import cn.myapps.authtime.user.model.BaseUser;
import cn.myapps.authtime.user.model.UserDepartmentRoleSet;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.common.model.AuthtimeValueObject;
import cn.myapps.common.model.application.Application;
import cn.myapps.common.model.role.Role;
import cn.myapps.common.model.superuser.SuperUserVO;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.role.service.RoleDesignTimeService;
import cn.myapps.designtime.superuser.service.SuperUserDesignTimeService;
import cn.myapps.util.json.JsonUtil;
import cn.myapps.util.xml.XmlUtil;
import cn.myapps.webservice.WebServiceUtil;
import cn.myapps.webservice.fault.UserServiceFault;
import cn.myapps.webservice.model.SimpleAdmin;
import cn.myapps.webservice.model.SimpleUser;
import cn.myapps.webservice.util.UserUtil;
import com.teemlink.email.email.action.EmailUserHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserService {
    private static final Logger LOG = LoggerFactory.getLogger(UserService.class);
    public static final String STANDARD_CALENDAR_NAME = "Standard_Calendar";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleUser validateUser(String domainName, String userAccount, String userPassword, int userType) throws UserServiceFault {
        SimpleUser simpleUser = null;
        try {
            UserVO user = null;
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            switch (userType) {
                case 0: {
                    user = userProcess.login(userAccount, userPassword, domainName, 0);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    throw new UserServiceFault("Invaild.user.type");
                }
            }
            if (user != null) {
                simpleUser = UserUtil.convertToSimple(user);
                simpleUser.setLoginpwd(userPassword);
                simpleUser.setDomainName(domainName);
            }
            SimpleUser simpleUser2 = simpleUser;
            return simpleUser2;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new UserServiceFault(e.getMessage());
            }
        }
        return simpleUser;
    }

    public int changePassword(String id, String password) throws UserServiceFault {
        int result = -1;
        try {
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            UserVO user = (UserVO)userProcess.doView(id);
            if (user == null) {
                throw new Exception("\u8be5\u7528\u6237(ID=" + id + ")\u4e0d\u5b58\u5728.");
            }
            user.setLoginpwd(password);
            userProcess.doUpdate((AuthtimeValueObject)user);
            result = 0;
        }
        catch (Exception e) {
            throw new UserServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new UserServiceFault(e.getMessage());
            }
        }
        return result;
    }

    public int changeAdminPassword(String id, String password) throws UserServiceFault {
        int result = -1;
        try {
            SuperUserDesignTimeService superUserProcess = DesignTimeServiceManager.superUserDesignTimeService();
            SuperUserVO admin = superUserProcess.doView(id);
            admin.setLoginpwd(password);
            superUserProcess.doUpdate(admin);
            result = 0;
        }
        catch (Exception e) {
            throw new UserServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new UserServiceFault(e.getMessage());
            }
        }
        return result;
    }

    public int createAdmin(SimpleAdmin admin) throws UserServiceFault {
        int result = -1;
        try {
            SuperUserDesignTimeService superUserProcess = DesignTimeServiceManager.superUserDesignTimeService();
            if (this.validateAdminParameter(admin)) {
                throw new NullPointerException("\u5bf9\u8c61\u6216\u5bf9\u8c61\u5c5e\u6027\u5b58\u5728\u7a7a\u503c!");
            }
            SuperUserVO vo = new SuperUserVO();
            UserUtil.convertToVO(vo, admin);
            try {
                superUserProcess.doCreate(vo);
            }
            catch (Exception e) {
                throw new Exception("\u8be5\u8d26\u53f7" + admin.getLoginno() + "\u5df2\u5b58\u5728.");
            }
            result = 0;
        }
        catch (Exception e) {
            throw new UserServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new UserServiceFault(e.getMessage());
            }
        }
        return result;
    }

    public int updateAdmin(SimpleAdmin admin) throws UserServiceFault {
        int result = -1;
        try {
            SuperUserVO temp;
            SuperUserDesignTimeService superUserProcess = DesignTimeServiceManager.superUserDesignTimeService();
            if (admin == null || StringUtil.isBlank((String)admin.getId())) {
                throw new NullPointerException("\u5bf9\u8c61\u4e3a\u7a7a\u6216\u5bf9\u8c61\u7684ID\u4e3a\u7a7a.");
            }
            SuperUserVO vo = superUserProcess.doView(admin.getId());
            if (vo == null) {
                throw new Exception("\u6570\u636e\u5e93\u4e0d\u5b58\u5728\u8be5ID" + admin.getId() + "\u5bf9\u8c61.");
            }
            UserUtil.convertToVO(vo, admin);
            if (!vo.getLoginno().equals(admin.getLoginno()) && (temp = superUserProcess.doViewByLoginno(admin.getLoginno())) != null) {
                throw new Exception("\u8be5\u7ba1\u7406\u5458\u5e10\u53f7" + admin.getLoginno() + "\u5df2\u5b58\u5728\uff01");
            }
            superUserProcess.doUpdate(vo);
            result = 0;
        }
        catch (Exception e) {
            throw new UserServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new UserServiceFault(e.getMessage());
            }
        }
        return result;
    }

    public SimpleAdmin getAdmin(String id) throws UserServiceFault {
        try {
            SuperUserDesignTimeService superUserProcess = DesignTimeServiceManager.superUserDesignTimeService();
            if (id == null) {
                throw new NullPointerException("\u4e3b\u952e\u4e3a\u7a7a!");
            }
            SuperUserVO vo = superUserProcess.doView(id);
            if (vo != null) {
                SimpleAdmin simpleAdmin = (SimpleAdmin)UserUtil.convertToSimple(vo, SimpleAdmin.class);
                return simpleAdmin;
            }
        }
        catch (Exception e) {
            throw new UserServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new UserServiceFault(e.getMessage());
            }
        }
        return null;
    }

    public int deleteAdmin(String id) throws UserServiceFault {
        int result = -1;
        try {
            SuperUserDesignTimeService superUserProcess = DesignTimeServiceManager.superUserDesignTimeService();
            if (id == null) {
                throw new NullPointerException("\u4e3b\u952e\u4e3a\u7a7a!");
            }
            superUserProcess.doRemove(id);
            result = 0;
        }
        catch (Exception e) {
            throw new UserServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new UserServiceFault(e.getMessage());
            }
        }
        return result;
    }

    public int createUser(SimpleUser user) throws UserServiceFault {
        int result = -1;
        try {
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            if (this.validateUserParameter(user)) {
                throw new NullPointerException("\u5bf9\u8c61\u6216\u5bf9\u8c61\u5c5e\u6027\u5b58\u5728\u7a7a\u503c!");
            }
            WebServiceUtil.validateDomain(user.getDomainName());
            UserVO vo = new UserVO();
            UserUtil.convertToVO(vo, user);
            try {
                HttpServletRequest request = null;
                EmailUserHelper.checkAndCreateEmailUser((UserVO)vo, request);
                userProcess.doCreate((AuthtimeValueObject)vo);
            }
            catch (Exception e) {
                throw new Exception("\u8be5\u8d26\u53f7" + user.getLoginno() + "\u5df2\u5b58\u5728.");
            }
            result = 0;
        }
        catch (Exception e) {
            throw new UserServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new UserServiceFault(e.getMessage());
            }
        }
        return result;
    }

    public int updateUser(SimpleUser user) throws UserServiceFault {
        int result = -1;
        try {
            UserVO temp;
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            if (user == null || StringUtil.isBlank((String)user.getId())) {
                throw new NullPointerException("\u5bf9\u8c61\u4e3a\u7a7a\u6216\u5bf9\u8c61\u7684ID\u4e3a\u7a7a.");
            }
            DomainVO domain = WebServiceUtil.validateDomain(user.getDomainName());
            UserVO vo = (UserVO)userProcess.doView(user.getId());
            if (vo == null) {
                throw new Exception("\u6570\u636e\u5e93\u4e0d\u5b58\u5728\u8be5ID" + user.getId() + "\u5bf9\u8c61.");
            }
            UserUtil.convertToVO(vo, user);
            if (StringUtil.isBlank((String)user.getLoginpwd())) {
                vo.setLoginpwd("888888qqqq");
            }
            if (!vo.getLoginno().equals(user.getLoginno()) && (temp = userProcess.getUserByLoginno(user.getLoginno(), domain.getId())) != null) {
                throw new Exception("\u8be5\u7528\u6237\u5e10\u53f7" + user.getLoginno() + "\u5df2\u5b58\u5728\uff01");
            }
            result = 0;
        }
        catch (Exception e) {
            throw new UserServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new UserServiceFault(e.getMessage());
            }
        }
        return result;
    }

    public SimpleUser getUser(String pk) throws UserServiceFault {
        SimpleUser user = null;
        try {
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            if (pk == null) {
                throw new NullPointerException("\u4e3b\u952e\u4e3a\u7a7a!");
            }
            UserVO vo = (UserVO)userProcess.doView(pk);
            if (vo != null) {
                user = UserUtil.convertToSimple((BaseUser)vo);
            }
        }
        catch (Exception e) {
            throw new UserServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new UserServiceFault(e.getMessage());
            }
        }
        return user;
    }

    public int deleteUser(String pk) throws UserServiceFault {
        int result = -1;
        try {
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            if (pk == null) {
                throw new NullPointerException("\u4e3b\u952e\u4e3a\u7a7a!");
            }
            userProcess.doRemove(pk);
            result = 0;
        }
        catch (Exception e) {
            throw new UserServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new UserServiceFault(e.getMessage());
            }
        }
        return result;
    }

    public int deleteUser(String[] pks) throws UserServiceFault {
        int result = -1;
        try {
            if (pks != null) {
                for (int i = 0; i < pks.length; ++i) {
                    this.deleteUser(pks[i]);
                }
            }
            result = 0;
        }
        catch (Exception e) {
            throw new UserServiceFault(e.getMessage());
        }
        return result;
    }

    public int deleteUser(SimpleUser user) throws UserServiceFault {
        int result = -1;
        try {
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            if (user == null || StringUtil.isBlank((String)user.getId())) {
                throw new NullPointerException("\u5bf9\u8c61\u4e3a\u7a7a\u6216\u5bf9\u8c61\u7684ID\u4e3a\u7a7a.");
            }
            WebServiceUtil.validateDomain(user.getDomainName());
            UserVO vo = (UserVO)userProcess.doView(user.getId());
            if (vo != null) {
                userProcess.doRemove((AuthtimeValueObject)vo);
            }
            result = 0;
        }
        catch (Exception e) {
            throw new UserServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new UserServiceFault(e.getMessage());
            }
        }
        return result;
    }

    private boolean validateUserParameter(SimpleUser user) {
        return user == null || StringUtil.isBlank((String)user.getName()) || StringUtil.isBlank((String)user.getLoginno()) || StringUtil.isBlank((String)user.getLoginpwd());
    }

    private boolean validateAdminParameter(SimpleAdmin admin) {
        return admin == null || StringUtil.isBlank((String)admin.getName()) || StringUtil.isBlank((String)admin.getLoginno()) || StringUtil.isBlank((String)admin.getLoginpwd());
    }

    public int setRoleSet(String userId, String[] roles) throws UserServiceFault {
        int result = -1;
        try {
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            UserVO vo = (UserVO)userProcess.doView(userId);
            if (vo == null) {
                throw new NullPointerException("\u5bf9\u8c61\u4e3a\u7a7a\u6216\u5bf9\u8c61\u7684ID\u4e3a\u7a7a!");
            }
            DomainVO domain = vo.getDomain();
            HashSet<UserDepartmentRoleSet> coll = new HashSet<UserDepartmentRoleSet>();
            if (roles != null) {
                for (int i = 0; i < roles.length; ++i) {
                    RoleDesignTimeService roleService = DesignTimeServiceManager.roleDesignTimeService();
                    Role role = (Role)roleService.findById(roles[i]);
                    boolean flag = true;
                    if (role != null) {
                        for (Application temp : domain.getApplications()) {
                            if (!temp.getId().equals(role.getApplicationid())) continue;
                            UserDepartmentRoleSet set = new UserDepartmentRoleSet(vo.getId(), "", role.getId());
                            coll.add(set);
                            flag = false;
                            break;
                        }
                    }
                    if (!flag) continue;
                    throw new Exception("\u8be5\u89d2\u8272" + roles[i] + "\u5bf9\u5e94\u7684\u5e94\u7528" + role.getApplicationid() + "\u8fd8\u6ca1\u5e94\u7528\u5230\u8be5\u57df" + domain.getName());
                }
            }
            vo.setUserDepartmentRoleSets(coll);
            userProcess.doUpdate((AuthtimeValueObject)vo);
            result = 0;
        }
        catch (Exception e) {
            throw new UserServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new UserServiceFault(e.getMessage());
            }
        }
        return result;
    }

    public int setDepartmentSet(String userId, String[] deps, String defaultDepartmentId) throws UserServiceFault {
        int result = -1;
        try {
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            DomainProcess domainProcess = AuthTimeServiceManager.domainRuntimeService();
            UserVO vo = (UserVO)userProcess.doView(userId);
            if (vo == null) {
                throw new NullPointerException("\u7528\u6237\u5bf9\u8c61\u4e3a\u7a7a\u6216\u7528\u6237\u5bf9\u8c61\u7684ID\u4e3a\u7a7a!");
            }
            DomainVO userDomain = vo.getDomain();
            HashSet<UserDepartmentRoleSet> coll = new HashSet<UserDepartmentRoleSet>();
            if (deps != null) {
                DepartmentProcess da = AuthTimeServiceManager.departmentRuntimeService();
                for (int i = 0; i < deps.length; ++i) {
                    DepartmentVO dpt = (DepartmentVO)da.doView(deps[i]);
                    if (dpt == null) continue;
                    DomainVO deptDomain = (DomainVO)domainProcess.doView(dpt.getDomain().getId());
                    if (deptDomain != null && deptDomain.getName().equals(userDomain.getName())) {
                        UserDepartmentRoleSet set = new UserDepartmentRoleSet(vo.getId(), dpt.getId(), "");
                        coll.add(set);
                        continue;
                    }
                    throw new Exception("\u90e8\u95e8" + deps[i] + "\u4e0d\u5b58\u5728\u6216\u90e8\u95e8\u4e0e\u7528\u6237\u4e0d\u5728\u540c\u4e00\u4e2a\u57df.");
                }
            }
            vo.setUserDepartmentRoleSets(coll);
            userProcess.doUpdate((AuthtimeValueObject)vo);
            this.setDefaultDepartment(userId, defaultDepartmentId);
            result = 0;
        }
        catch (Exception e) {
            throw new UserServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new UserServiceFault(e.getMessage());
            }
        }
        return result;
    }

    public int setDefaultDepartment(String userId, String depId) throws UserServiceFault {
        int result = -1;
        try {
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            UserVO user = WebServiceUtil.findUserWithValidate(userId);
            DepartmentVO department = WebServiceUtil.findDepartmentWithValidate(depId);
            if (!user.getDomainid().equals(department.getDomainid())) {
                throw new UserServiceFault("\u7528\u6237[" + user.getName() + "]\u4e0e\u90e8\u95e8[" + department.getName() + "]\u4e0d\u5728\u540c\u4e00\u4e2a\u4f01\u4e1a\u57df.");
            }
            Collection depts = user.getDepartments();
            if (!depts.contains(department)) {
                throw new UserServiceFault("\u7528\u6237[" + user.getName() + "]\u4e0d\u5c5e\u4e8e\u90e8\u95e8[" + department.getName() + "],\u65e0\u6cd5\u8bbe\u7f6e\u5176\u4e3a\u9ed8\u8ba4\u90e8\u95e8.");
            }
            user.setDefaultDepartment(department.getId());
            userProcess.doUpdate((AuthtimeValueObject)user);
            result = 0;
        }
        catch (Exception e) {
            throw new UserServiceFault(e.getMessage());
        }
        return result;
    }

    public int createUserFromJson(String jsonStr) throws UserServiceFault {
        int result = -1;
        try {
            if (StringUtil.isBlank((String)jsonStr)) {
                throw new UserServiceFault("Parameter 'jsonStr' can not be null.");
            }
            SimpleUser simpleUser = (SimpleUser)JsonUtil.toBean((String)jsonStr, SimpleUser.class);
            result = this.createUser(simpleUser);
        }
        catch (Exception e) {
            throw new UserServiceFault(e.getMessage());
        }
        return result;
    }

    public int createUserFromXML(String xmlStr) throws UserServiceFault {
        int result = -1;
        try {
            if (StringUtil.isBlank((String)xmlStr)) {
                throw new UserServiceFault("Parameter 'xmlStr' can not be null.");
            }
            SimpleUser simpleUser = (SimpleUser)XmlUtil.toOjbect((String)xmlStr);
            result = this.createUser(simpleUser);
        }
        catch (Exception e) {
            throw new UserServiceFault(e.getMessage());
        }
        return result;
    }

    public int updateUserFromJson(String jsonStr) throws UserServiceFault {
        int result = -1;
        try {
            if (StringUtil.isBlank((String)jsonStr)) {
                throw new UserServiceFault("Parameter 'jsonStr' can not be null.");
            }
            SimpleUser simpleUser = (SimpleUser)JsonUtil.toBean((String)jsonStr, SimpleUser.class);
            result = this.updateUser(simpleUser);
        }
        catch (Exception e) {
            throw new UserServiceFault(e.getMessage());
        }
        return result;
    }

    public int updateUserFromXML(String xmlStr) throws UserServiceFault {
        int result = -1;
        try {
            if (StringUtil.isBlank((String)xmlStr)) {
                throw new UserServiceFault("Parameter 'xmlStr' can not be null.");
            }
            SimpleUser simpleUser = (SimpleUser)XmlUtil.toOjbect((String)xmlStr);
            result = this.updateUser(simpleUser);
        }
        catch (Exception e) {
            throw new UserServiceFault(e.getMessage());
        }
        return result;
    }

    public String findUserFormat2Json(String pk) throws UserServiceFault {
        SimpleUser simpleUser = this.getUser(pk);
        return JsonUtil.toJson((Object)simpleUser);
    }

    public String findUserFormat2XML(String pk) throws UserServiceFault {
        SimpleUser simpleUser = this.getUser(pk);
        return XmlUtil.toXml((Object)simpleUser);
    }

    public Collection<SimpleUser> getUsersByDepId(String depId) throws UserServiceFault {
        ArrayList<SimpleUser> simpleUser = new ArrayList<SimpleUser>();
        try {
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            Collection vos = userProcess.queryByDepartment(depId);
            if (vos != null) {
                Iterator it = vos.iterator();
                while (it.hasNext()) {
                    SimpleUser sUser = UserUtil.convertToSimple((BaseUser)it.next());
                    simpleUser.add(sUser);
                }
            }
        }
        catch (Exception e) {
            throw new UserServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new UserServiceFault(e.getMessage());
            }
        }
        return simpleUser;
    }

    public Collection<SimpleUser> getUsersByRoleId(String roleId) throws UserServiceFault {
        ArrayList<SimpleUser> simpleUser = new ArrayList<SimpleUser>();
        try {
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            Collection vos = userProcess.queryByRole(roleId);
            if (vos != null) {
                Iterator it = vos.iterator();
                while (it.hasNext()) {
                    SimpleUser sUser = UserUtil.convertToSimple((BaseUser)it.next());
                    simpleUser.add(sUser);
                }
            }
        }
        catch (Exception e) {
            throw new UserServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new UserServiceFault(e.getMessage());
            }
        }
        return simpleUser;
    }

    public int addRole(String userId, String roleId) throws UserServiceFault {
        int result = -1;
        try {
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            WebServiceUtil.findUserWithValidate(userId);
            WebServiceUtil.findRoleWithValidate(roleId);
            String[] array = new String[]{userId};
            userProcess.addUserToRole(array, roleId);
            result = 0;
        }
        catch (Exception e) {
            throw new UserServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new UserServiceFault(e.getMessage());
            }
        }
        return result;
    }

    public int removeRole(String userId, String roleId) throws UserServiceFault {
        int result = -1;
        try {
            if (StringUtil.isBlank((String)roleId)) {
                throw new UserServiceFault("\u89d2\u8272id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            UserVO user = (UserVO)userProcess.doView(userId);
            if (user == null) {
                throw new UserServiceFault("\u8be5\u7528\u6237(ID=" + userId + ")\u4e0d\u5b58\u5728.");
            }
            Collection oldroles = user.getUserDepartmentRoleSets();
            HashSet<UserDepartmentRoleSet> roleSets = new HashSet<UserDepartmentRoleSet>();
            Iterator it = oldroles.iterator();
            while (oldroles != null && it.hasNext()) {
                UserDepartmentRoleSet set = (UserDepartmentRoleSet)it.next();
                if (roleId.equals(set.getRoleId())) continue;
                roleSets.add(set);
            }
            user.setUserDepartmentRoleSets(roleSets);
            userProcess.doUpdate((AuthtimeValueObject)user);
            result = 0;
        }
        catch (Exception e) {
            throw new UserServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new UserServiceFault(e.getMessage());
            }
        }
        return result;
    }

    public int addDepartment(String userId, String depId) throws UserServiceFault {
        int result = -1;
        try {
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            WebServiceUtil.findUserWithValidate(userId);
            WebServiceUtil.findDepartmentWithValidate(depId);
            String[] array = new String[]{userId};
            userProcess.addUserToDept(array, depId);
            result = 0;
        }
        catch (Exception e) {
            throw new UserServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new UserServiceFault(e.getMessage());
            }
        }
        return result;
    }

    public int removeDepartment(String userId, String depId) throws UserServiceFault {
        int result = -1;
        try {
            if (StringUtil.isBlank((String)depId)) {
                throw new UserServiceFault("\u90e8\u95e8id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            UserVO user = (UserVO)userProcess.doView(userId);
            if (user == null) {
                throw new UserServiceFault("\u8be5\u7528\u6237(ID=" + userId + ")\u4e0d\u5b58\u5728.");
            }
            Collection userDepartmentRoleSets = user.getUserDepartmentRoleSets();
            HashSet<UserDepartmentRoleSet> newSets = new HashSet<UserDepartmentRoleSet>();
            for (UserDepartmentRoleSet set : userDepartmentRoleSets) {
                if (depId.equals(set.getDepartmentId())) continue;
                newSets.add(set);
            }
            user.setUserDepartmentRoleSets(newSets);
            userProcess.doUpdate((AuthtimeValueObject)user);
            result = 0;
        }
        catch (Exception e) {
            throw new UserServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new UserServiceFault(e.getMessage());
            }
        }
        return result;
    }

    public int createUser(String id, String name, String loginno, String loginpwd, String email, String telephone, String domainName, String defaultDepartmentName) throws UserServiceFault {
        int result = -1;
        try {
            SimpleUser simpleUser = new SimpleUser();
            simpleUser.setId(id);
            simpleUser.setName(name);
            simpleUser.setLoginno(loginno);
            simpleUser.setLoginpwd(loginpwd);
            simpleUser.setEmail(email);
            simpleUser.setTelephone(telephone);
            simpleUser.setDomainName(domainName);
            simpleUser.setDefaultDepartmentName(defaultDepartmentName);
            result = this.createUser(simpleUser);
        }
        catch (Exception e) {
            throw new UserServiceFault(e.getMessage());
        }
        return result;
    }

    public int updateUser(Map<String, String> attributes) throws UserServiceFault {
        int result = -1;
        try {
            if (attributes == null) {
                throw new UserServiceFault("\u7528\u6237Map\u4e0d\u80fd\u4e3a\u7a7a.");
            }
            SimpleUser simpleUser = new SimpleUser();
            simpleUser.setId(attributes.get("id"));
            simpleUser.setName(attributes.get("name"));
            simpleUser.setLoginno(attributes.get("loginno"));
            simpleUser.setLoginpwd(attributes.get("loginpwd"));
            simpleUser.setEmail(attributes.get("email"));
            simpleUser.setTelephone(attributes.get("telephone"));
            simpleUser.setDomainName(attributes.get("domainName"));
            simpleUser.setDefaultDepartmentName(attributes.get("defaultDepartmentName"));
            result = this.updateUser(simpleUser);
        }
        catch (Exception e) {
            throw new UserServiceFault(e.getMessage());
        }
        return result;
    }

    public static void main(String[] args) {
    }
}

