/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.webservice;

import cn.myapps.authtime.common.dao.PersistenceUtils;
import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.common.model.AuthtimeValueObject;
import cn.myapps.common.model.superuser.SuperUserVO;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.superuser.service.SuperUserDesignTimeService;
import cn.myapps.webservice.UserService;
import cn.myapps.webservice.fault.SecurityServiceFault;
import cn.myapps.webservice.model.SimpleUser;

public class SecurityService {
    public SimpleUser validateUser(String domainName, String userAccount, String userPassword, int userType) throws SecurityServiceFault {
        try {
            UserService userService = new UserService();
            return userService.validateUser(domainName, userAccount, userPassword, userType);
        }
        catch (Exception e) {
            throw new SecurityServiceFault(e.getMessage());
        }
    }

    public int doChangePassword(String domainName, String userAccount, String oldPassword, String newPassword) throws SecurityServiceFault {
        int result = -1;
        try {
            SimpleUser sUser = this.validateUser(domainName, userAccount, oldPassword, 0);
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            userProcess.changePwd(sUser.getId(), oldPassword, newPassword);
            result = 0;
        }
        catch (Exception e) {
            throw new SecurityServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new SecurityServiceFault(e.getMessage());
            }
        }
        return result;
    }

    public int activateUser(String adminAccount, String adminPw, String userId) throws SecurityServiceFault {
        int result = -1;
        try {
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            SuperUserDesignTimeService sUserProcess = DesignTimeServiceManager.superUserDesignTimeService();
            SuperUserVO vo = sUserProcess.login(adminAccount, adminPw);
            if (vo != null) {
                SuperUserVO superuser;
                UserVO user = (UserVO)userProcess.doView(userId);
                if (user != null) {
                    user.setStatus(1);
                    userProcess.doUpdate((AuthtimeValueObject)user);
                    result = 0;
                }
                if ((superuser = sUserProcess.doView(userId)) != null) {
                    superuser.setStatus(1);
                    sUserProcess.doUpdate(superuser);
                    result = 0;
                }
            }
        }
        catch (Exception e) {
            if (e.getMessage().indexOf("core.superuser.noeffectived") > 0) {
                throw new SecurityServiceFault(adminAccount + ",\u60a8\u6ca1\u6709\u6743\u9650\u6fc0\u6d3b\u7528\u6237,\u539f\u56e0\uff1a" + adminAccount + "\u672a\u6fc0\u6d3b.");
            }
            throw new SecurityServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new SecurityServiceFault(e.getMessage());
            }
        }
        return result;
    }

    public int inactiveUser(String adminAccount, String adminPw, String userId) throws SecurityServiceFault {
        int result = -1;
        try {
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            SuperUserDesignTimeService sUserProcess = DesignTimeServiceManager.superUserDesignTimeService();
            SuperUserVO vo = sUserProcess.login(adminAccount, adminPw);
            if (vo != null) {
                SuperUserVO superuser;
                UserVO user = (UserVO)userProcess.doView(userId);
                if (user != null) {
                    user.setStatus(0);
                    userProcess.doUpdate((AuthtimeValueObject)user);
                    result = 0;
                }
                if ((superuser = sUserProcess.doView(userId)) != null) {
                    superuser.setStatus(0);
                    sUserProcess.doUpdate(superuser);
                    result = 0;
                }
            }
        }
        catch (Exception e) {
            if (e.getMessage().indexOf("core.superuser.noeffectived") > 0) {
                throw new SecurityServiceFault(adminAccount + ",\u60a8\u6ca1\u6709\u6743\u9650\u7981\u7528\u7528\u6237,\u539f\u56e0\uff1a" + adminAccount + "\u672a\u6fc0\u6d3b.");
            }
            throw new SecurityServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new SecurityServiceFault(e.getMessage());
            }
        }
        return result;
    }
}

