/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.webservice;

import cn.myapps.authtime.common.dao.PersistenceUtils;
import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.user.model.UserDepartmentRoleSet;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.common.model.application.Application;
import cn.myapps.common.model.role.Role;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.role.service.RoleDesignTimeService;
import cn.myapps.util.json.JsonUtil;
import cn.myapps.util.xml.XmlUtil;
import cn.myapps.webservice.UserService;
import cn.myapps.webservice.WebServiceUtil;
import cn.myapps.webservice.fault.RoleServiceFault;
import cn.myapps.webservice.fault.UserServiceFault;
import cn.myapps.webservice.model.SimpleRole;
import cn.myapps.webservice.util.RoleUtil;
import java.util.ArrayList;
import java.util.Collection;

public class RoleService {
    public int createRole(SimpleRole role) throws RoleServiceFault {
        int result = -1;
        try {
            RoleDesignTimeService roleService = DesignTimeServiceManager.roleDesignTimeService();
            if (role == null || StringUtil.isBlank((String)role.getName())) {
                throw new NullPointerException("\u5bf9\u8c61\u4e3a\u7a7a\u6216\u5bf9\u8c61\u7684\u540d\u79f0\u4e3a\u7a7a.");
            }
            Application application = WebServiceUtil.validateApplication(role.getApplicationName());
            Role vo = new Role();
            RoleUtil.convertToVO(vo, role);
            Role temp = roleService.doViewByName(role.getName(), application.getId());
            if (temp == null) {
                roleService.save((Object)vo);
            } else if (role.getName().equalsIgnoreCase(temp.getName())) {
                throw new Exception("\u8be5\u89d2\u8272\u540d\u79f0" + role.getName() + "\u5df2\u5b58\u5728.");
            }
            result = 0;
        }
        catch (Exception e) {
            throw new RoleServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new RoleServiceFault(e.getMessage());
            }
        }
        return result;
    }

    public int updateRole(SimpleRole role) throws RoleServiceFault {
        int result = -1;
        try {
            Role temp;
            RoleDesignTimeService roleService = DesignTimeServiceManager.roleDesignTimeService();
            if (role == null || StringUtil.isBlank((String)role.getName())) {
                throw new NullPointerException("\u5bf9\u8c61\u4e3a\u7a7a\u6216\u5bf9\u8c61\u540d\u79f0\u4e3a\u7a7a!");
            }
            Application application = WebServiceUtil.validateApplication(role.getApplicationName());
            Role vo = (Role)roleService.findById(role.getId());
            if (vo == null) {
                throw new Exception("\u6570\u636e\u5e93\u4e0d\u5b58\u5728\u8be5" + role.getId() + "\u5bf9\u8c61.");
            }
            if (!vo.getName().equals(role.getName()) && (temp = roleService.doViewByName(role.getName(), application.getId())) != null) {
                throw new Exception("\u8be5\u89d2\u8272\u540d\u79f0" + role.getName() + "\u5df2\u5b58\u5728.");
            }
            RoleUtil.convertToVO(vo, role);
            roleService.update((Object)vo);
            result = 0;
        }
        catch (Exception e) {
            throw new RoleServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new RoleServiceFault(e.getMessage());
            }
        }
        return result;
    }

    public SimpleRole getRole(String pk) throws RoleServiceFault {
        SimpleRole role = null;
        try {
            RoleDesignTimeService roleService = DesignTimeServiceManager.roleDesignTimeService();
            if (pk == null) {
                throw new NullPointerException("\u4e3b\u952e\u4e3a\u7a7a.");
            }
            Role vo = (Role)roleService.findById(pk);
            if (vo != null) {
                role = new SimpleRole();
                RoleUtil.convertToSimple(role, vo);
            }
        }
        catch (Exception e) {
            throw new RoleServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new RoleServiceFault(e.getMessage());
            }
        }
        return role;
    }

    public int deleteRole(String pk) throws RoleServiceFault {
        int result = -1;
        try {
            RoleDesignTimeService roleService = DesignTimeServiceManager.roleDesignTimeService();
            if (pk == null) {
                throw new NullPointerException("\u4e3b\u952e\u4e3a\u7a7a.");
            }
            roleService.delete(pk);
            result = 0;
        }
        catch (Exception e) {
            throw new RoleServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new RoleServiceFault(e.getMessage());
            }
        }
        return result;
    }

    public int deleteRole(String[] pks) throws RoleServiceFault {
        int result = -1;
        try {
            if (pks != null) {
                for (int i = 0; i < pks.length; ++i) {
                    String pk = pks[i];
                    this.deleteRole(pk);
                }
            }
            result = 0;
        }
        catch (Exception e) {
            throw new RoleServiceFault(e.getMessage());
        }
        return result;
    }

    public int createRoleFromJson(String jsonStr) throws RoleServiceFault {
        int result = -1;
        try {
            if (StringUtil.isBlank((String)jsonStr)) {
                throw new RoleServiceFault("Parameter 'jsonStr' can not be null.");
            }
            SimpleRole simpleRole = (SimpleRole)JsonUtil.toBean((String)jsonStr, SimpleRole.class);
            result = this.createRole(simpleRole);
        }
        catch (Exception e) {
            throw new RoleServiceFault(e.getMessage());
        }
        return result;
    }

    public int createRoleFromXML(String xmlStr) throws RoleServiceFault {
        int result = -1;
        try {
            if (StringUtil.isBlank((String)xmlStr)) {
                throw new RoleServiceFault("Parameter 'xmlStr' can not be null.");
            }
            SimpleRole simpleRole = (SimpleRole)XmlUtil.toOjbect((String)xmlStr);
            result = this.createRole(simpleRole);
        }
        catch (Exception e) {
            throw new RoleServiceFault(e.getMessage());
        }
        return result;
    }

    public String findRoleFormat2Json(String pk) throws RoleServiceFault {
        SimpleRole simpleRole = this.getRole(pk);
        return JsonUtil.toJson((Object)simpleRole);
    }

    public String findRoleFormat2XML(String pk) throws RoleServiceFault {
        SimpleRole simpleRole = this.getRole(pk);
        return XmlUtil.toXml((Object)simpleRole);
    }

    public Collection<SimpleRole> getRolesByUserId(String userId) throws RoleServiceFault {
        ArrayList<SimpleRole> simpleRole = new ArrayList<SimpleRole>();
        try {
            RoleDesignTimeService roleService = DesignTimeServiceManager.roleDesignTimeService();
            Collection roles = roleService.queryByUser(userId);
            for (Role roleVO : roles) {
                SimpleRole role = new SimpleRole();
                RoleUtil.convertToSimple(role, roleVO);
                simpleRole.add(role);
            }
        }
        catch (Exception e) {
            throw new RoleServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new RoleServiceFault(e.getMessage());
            }
        }
        return simpleRole;
    }

    public int addUser(String roleId, String userId) throws RoleServiceFault {
        int result = -1;
        try {
            Role role = WebServiceUtil.findRoleWithValidate(roleId);
            UserVO vo = WebServiceUtil.findUserWithValidate(userId);
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            DomainVO domain = vo.getDomain();
            boolean flag = true;
            if (role != null) {
                for (Application temp : domain.getApplications()) {
                    if (!temp.getId().equals(role.getApplicationid())) continue;
                    flag = false;
                    break;
                }
            }
            if (flag) {
                throw new Exception("\u8be5\u89d2\u8272" + roleId + "\u5bf9\u5e94\u7684\u5e94\u7528" + role.getApplicationid() + "\u8fd8\u6ca1\u5e94\u7528\u5230\u8be5\u57df" + domain.getName());
            }
            Collection coll = vo.getUserDepartmentRoleSets();
            boolean exist = false;
            for (UserDepartmentRoleSet userRoleSet : coll) {
                if (!userRoleSet.getRoleId().equals(roleId)) continue;
                exist = true;
                break;
            }
            if (!exist) {
                String[] array = new String[]{userId};
                userProcess.addUserToRole(array, roleId);
            }
            result = 0;
        }
        catch (Exception e) {
            throw new RoleServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new RoleServiceFault(e.getMessage());
            }
        }
        return result;
    }

    public int addUsers(String roleId, String[] userIds) throws RoleServiceFault {
        int result = -1;
        try {
            if (userIds == null) {
                throw new RoleServiceFault("\u7528\u6237\u6570\u7ec4\u4e0d\u80fd\u4e3anull");
            }
            for (int i = 0; i < userIds.length; ++i) {
                this.addUser(roleId, userIds[i]);
            }
            result = 0;
        }
        catch (Exception e) {
            throw new RoleServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new RoleServiceFault(e.getMessage());
            }
        }
        return result;
    }

    public int removeUser(String id, String userId) throws RoleServiceFault {
        int result = -1;
        try {
            new UserService().removeRole(userId, id);
            result = 0;
        }
        catch (UserServiceFault e) {
            throw new RoleServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new RoleServiceFault(e.getMessage());
            }
        }
        return result;
    }

    public int createRole(String id, String name, String engname, String applicationName) throws RoleServiceFault {
        int result = -1;
        try {
            SimpleRole role = new SimpleRole();
            role.setId(id);
            role.setName(name);
            role.setEngname(engname);
            role.setApplicationName(applicationName);
            result = this.createRole(role);
        }
        catch (Exception e) {
            throw new RoleServiceFault(e.getMessage());
        }
        return result;
    }
}

