/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.webservice;

import cn.myapps.common.Environment;
import cn.myapps.common.util.StringUtil;
import cn.myapps.runtime.workflow.storage.runtime.ejb.FlowHistoryServiceImpl;
import cn.myapps.runtime.workflow.storage.runtime.ejb.FlowRuntimeServiceImpl;
import cn.myapps.runtime.workflow.storage.runtime.ejb.FlowStateRT;
import cn.myapps.util.DateUtil;
import cn.myapps.webservice.WebServiceUtil;
import cn.myapps.webservice.fault.FlowHistoryServiceFault;
import cn.myapps.webservice.model.SimpleActorHIS;
import cn.myapps.webservice.model.SimpleRelationHIS;
import cn.myapps.webservice.util.FlowHistoryUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class FlowHistoryService {
    Collection<SimpleRelationHIS> hisList = new ArrayList<SimpleRelationHIS>();
    private static final int DEFAULT_CELL_COUNT = 4;

    public SimpleRelationHIS getSimpleRelationHISInstance() {
        return new SimpleRelationHIS();
    }

    public SimpleActorHIS getSimpleActorHISInstance() {
        return new SimpleActorHIS();
    }

    private Collection<SimpleRelationHIS> initHis(String flowStateId, String applicationId) throws FlowHistoryServiceFault {
        try {
            if (!StringUtil.isBlank((String)flowStateId) && !StringUtil.isBlank((String)applicationId)) {
                WebServiceUtil.validateApplicationById(applicationId);
                FlowRuntimeServiceImpl process = new FlowRuntimeServiceImpl(applicationId);
                FlowStateRT instance = process.findFlowStateRT(flowStateId);
                if (instance != null) {
                    FlowHistoryServiceImpl hisProcess = new FlowHistoryServiceImpl(applicationId);
                    Collection colls = hisProcess.doAllQueryRelationHISByDocIdAndFlowStateId(flowStateId);
                    return FlowHistoryUtil.convertToSimpleDatas(colls);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FlowHistoryServiceFault(e.getMessage());
        }
        return null;
    }

    private void addHis(SimpleRelationHIS his) {
        this.hisList.add(his);
    }

    private void addAllHis(String flowStateId, String applicationId) throws FlowHistoryServiceFault {
        this.hisList.clear();
        this.hisList.addAll(this.initHis(flowStateId, applicationId));
    }

    public String getFlowHistroyFormat2Html(String flowStateId, String applicationId) throws FlowHistoryServiceFault {
        this.addAllHis(flowStateId, applicationId);
        try {
            return this.toTextHtml();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FlowHistoryServiceFault(e.getMessage());
        }
    }

    public String getFlowHistroyDiagram(String flowStateId, String applicationId, int cellCount) throws FlowHistoryServiceFault {
        this.addAllHis(flowStateId, applicationId);
        if (cellCount == 0) {
            return this.toDiagramHtml(4);
        }
        return this.toDiagramHtml(cellCount);
    }

    public String getFlowHistroyFormat2XML(String flowStateId, String applicationId) throws FlowHistoryServiceFault {
        this.addAllHis(flowStateId, applicationId);
        try {
            return this.toTextXml();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FlowHistoryServiceFault(e.getMessage());
        }
    }

    public String getFlowHistroyFormat2Json(String flowStateId, String applicationId) throws FlowHistoryServiceFault {
        this.addAllHis(flowStateId, applicationId);
        try {
            return this.toTextJson();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FlowHistoryServiceFault(e.getMessage());
        }
    }

    public String toDiagramHtml(int cellCount) throws FlowHistoryServiceFault {
        try {
            StringBuffer historyHtml = new StringBuffer();
            int count = 1;
            int index = 0;
            int storeIndex = 0;
            Object[] hisArray = this.hisList.toArray();
            ArrayList<SimpleRelationHIS> tmp = new ArrayList<SimpleRelationHIS>();
            historyHtml.append("<table>");
            for (int i = 0; i < hisArray.length; ++i) {
                SimpleRelationHIS relationhis = (SimpleRelationHIS)((Object)hisArray[i]);
                if (i != 0) {
                    SimpleRelationHIS preRelationhis = (SimpleRelationHIS)((Object)hisArray[i - 1]);
                    if (relationhis.getActiontime().equals(preRelationhis.getActiontime())) {
                        tmp.add(relationhis);
                        continue;
                    }
                    if (storeIndex + cellCount == index) {
                        historyHtml.append("</tr>");
                        storeIndex = index;
                    }
                    if (index % cellCount == 0) {
                        historyHtml.append("<tr>");
                    }
                    historyHtml.append(this.toDiagramCellHtml(tmp, count));
                    tmp.clear();
                    tmp.add(relationhis);
                    ++count;
                    ++index;
                    continue;
                }
                tmp.add(relationhis);
            }
            if (tmp.size() > 0) {
                if (index % cellCount == 0) {
                    historyHtml.append("</tr><tr>").append(this.toDiagramCellHtml(tmp, count)).append("</tr>");
                } else {
                    historyHtml.append(this.toDiagramCellHtml(tmp, count)).append("</tr>");
                }
            }
            historyHtml.append("</table>");
            return historyHtml.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FlowHistoryServiceFault(e.getMessage());
        }
    }

    private String toDiagramCellHtml(Collection<SimpleRelationHIS> tmp, int cellCount) throws Exception {
        String ctxpath;
        Object[] rhises = tmp.toArray();
        StringBuffer buffer = new StringBuffer();
        Date actionTime = tmp.iterator().next().getActiontime();
        String actiontimeStr = DateUtil.getDateTimeStr((Date)actionTime);
        String contextPath = Environment.getInstance().getContextPath();
        String string = ctxpath = contextPath.equals("/") ? "" : contextPath;
        if (cellCount == 1) {
            buffer.append("<td style='font-size:7px;line-height:5px' colspan='2'><table   bordercolor='#cccccc' cellspacing='0' cellpadding='3' width='100%' align='left' bgcolor='#ffffff' border='1'>");
        } else {
            buffer.append("<td><table ><tr><td><img src='" + ctxpath + "/resource/image/nextStep.gif' width='16' height='16'></td></tr></table></td>");
            buffer.append("<td style='font-size:7px'><table  bordercolor='#cccccc' cellspacing='0' cellpadding='3' width='100%' align='left' bgcolor='#ffffff' border='1'>");
        }
        buffer.append("<tr bgcolor='#DDDDDD' ><td colspan='2' style='font-size:7px'>");
        buffer.append("<span style='font-weight: bold;font-size:11px'>Step-" + cellCount + " </span>Time:" + actiontimeStr);
        buffer.append("</td></tr>");
        buffer.append("<tr >");
        buffer.append("<td style='font-size:9px;line-height:8pt;white-space:nowrap' valign='top'>");
        SimpleRelationHIS first = (SimpleRelationHIS)((Object)rhises[0]);
        Collection<SimpleActorHIS> SimpleActorHISList = first.getActorhiss();
        buffer.append("<span style='font-weight: bold;font-size:11px'>{*[From]*}:</span>");
        for (SimpleActorHIS simpleActorHIS : SimpleActorHISList) {
            String actorName = simpleActorHIS.getName();
            buffer.append(actorName + "");
        }
        buffer.append("</td>");
        buffer.append("<td style='font-size:7px;line-height:5px'>");
        buffer.append("<table cellspacing='0' style='font-size:7px;line-height:5px'>");
        buffer.append("<tr><td style='font-size:9px;line-height:8pt;white-space:nowrap'><span style='font-weight: bold;font-size:11px'>{*[To]*}:</span>");
        for (int i = 0; i < rhises.length; ++i) {
            SimpleRelationHIS his = (SimpleRelationHIS)((Object)rhises[i]);
            SimpleRelationHIS nexthis = null;
            if (rhises.length - 1 > i) {
                nexthis = (SimpleRelationHIS)((Object)rhises[i + 1]);
            }
            if (nexthis != null) {
                boolean isExist = false;
                for (String actorid : his.getUserIdList()) {
                    if (!nexthis.getUserIdList().contains(actorid)) continue;
                    isExist = true;
                    break;
                }
                if (isExist) {
                    buffer.append("" + his.getEndnodename());
                    buffer.append("</td></tr>");
                    buffer.append("<tr><td style='font-size:9px;line-height:8pt;white-space:nowrap'><span style='font-weight: bold;font-size:11px'>{*[To]*}:</span>");
                    continue;
                }
                buffer.append("" + his.getEndnodename() + "<span style='font-weight: bold;font-size:11px'>{*[To]*}:</span>");
                continue;
            }
            buffer.append("" + his.getEndnodename());
        }
        buffer.append("</td></tr>");
        buffer.append("</table>");
        buffer.append("</td>");
        buffer.append("</tr>");
        buffer.append("<tr ><td colspan='2' style='font-size:9px'><span style='font-weight: bold;font-size:11px'>{*[Remarks]*}:</span>" + (first.getAttitude() == null ? "" : first.getAttitude()) + "</td></tr>");
        buffer.append("</table></td>");
        return buffer.toString();
    }

    private String toTextHtml() {
        StringBuffer htmlBuilder = new StringBuffer();
        String contextPath = Environment.getInstance().getContextPath();
        String ctxpath = contextPath.equals("/") ? "" : contextPath;
        htmlBuilder.append("<div name='_history' class='flow-history' style='width:100%;height:95%;border:1px solid #b5b8c8;' readonly='true'>");
        htmlBuilder.append("<table style='width:98%;table-layout:fixed; word-break:break-all;'><tr>");
        htmlBuilder.append("<td width='15%'>  {*[Auditor]*}</td><td width='20%'>{*[cn.myapps.runtime.workflow.audit_time]*}</td><td width='30%'>{*[Remark]*}</td><td width='15%'>{*[Flow]*}{*[State]*}</td><td width='20%'>{*[time.consuming]*}</td>");
        htmlBuilder.append("</tr>");
        SimpleRelationHIS tempRelHis = null;
        SimpleActorHIS tempSimpleActorHIS = null;
        for (SimpleRelationHIS relHis : this.hisList) {
            if (relHis.getActorhiss().size() > 0) {
                Iterator<SimpleActorHIS> iterator = relHis.getActorhiss().iterator();
                while (iterator.hasNext()) {
                    htmlBuilder.append("<tr>");
                    SimpleActorHIS simpleActorHIS = iterator.next();
                    htmlBuilder.append("<td>");
                    if (simpleActorHIS.getAgentname() != null && simpleActorHIS.getAgentname().trim().length() > 0) {
                        htmlBuilder.append(simpleActorHIS.getAgentname() + "(" + simpleActorHIS.getName() + ")");
                    } else {
                        htmlBuilder.append(simpleActorHIS.getName());
                    }
                    htmlBuilder.append("</td>");
                    htmlBuilder.append("<td>");
                    String pocesstime = "";
                    pocesstime = simpleActorHIS.getProcesstime() != null ? DateUtil.getDateTimeStr((Date)simpleActorHIS.getProcesstime()) : DateUtil.getDateTimeStr((Date)relHis.getActiontime());
                    htmlBuilder.append(pocesstime);
                    htmlBuilder.append("</td>");
                    htmlBuilder.append("<td>");
                    String attitude = "";
                    if (simpleActorHIS.getAttitude() != null && simpleActorHIS.getAttitude().length() > 0) {
                        attitude = simpleActorHIS.getAttitude();
                    }
                    htmlBuilder.append(attitude);
                    htmlBuilder.append("</td>");
                    htmlBuilder.append("<td>");
                    htmlBuilder.append(StringUtil.dencodeHTML((String)relHis.getStartnodename()) + "<img src='" + ctxpath + "/portal/share/icon/16x16_0060/arrow_right.png' />" + StringUtil.dencodeHTML((String)relHis.getEndnodename()));
                    htmlBuilder.append("</td>");
                    htmlBuilder.append("<td>");
                    long consumeTime = 0L;
                    String consumeTimeStr = "";
                    if (simpleActorHIS.getProcesstime() != null && tempSimpleActorHIS != null) {
                        try {
                            consumeTime = DateUtil.getDiffDateTime((Date)tempSimpleActorHIS.getProcesstime(), (Date)simpleActorHIS.getProcesstime());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    long day = consumeTime / 86400000L;
                    long hour = consumeTime / 3600000L - day * 24L;
                    long min = consumeTime / 60000L - day * 24L * 60L - hour * 60L;
                    long s = consumeTime / 1000L - day * 24L * 60L * 60L - hour * 60L * 60L - min * 60L;
                    consumeTimeStr = "" + day + "{*[Days]*}" + hour + "{*[Hours]*}" + min + "{*[Minutes]*}" + s + "{*[Seconds]*}";
                    htmlBuilder.append(consumeTimeStr);
                    htmlBuilder.append("</td>");
                    htmlBuilder.append("</tr>");
                    tempSimpleActorHIS = simpleActorHIS;
                }
            } else {
                htmlBuilder.append("<tr>");
                htmlBuilder.append("<td>");
                htmlBuilder.append(relHis.getAuditor());
                htmlBuilder.append("</td>");
                htmlBuilder.append("<td>");
                String actiontimeStr = DateUtil.getDateTimeStr((Date)relHis.getActiontime());
                htmlBuilder.append(actiontimeStr);
                htmlBuilder.append("</td>");
                htmlBuilder.append("<td>");
                htmlBuilder.append(relHis.getAttitude());
                htmlBuilder.append("</td>");
                htmlBuilder.append("<td>");
                htmlBuilder.append(StringUtil.dencodeHTML((String)relHis.getStartnodename()) + "<img src='" + ctxpath + "/portal/share/icon/16x16_0060/arrow_right.png' />" + StringUtil.dencodeHTML((String)relHis.getEndnodename()));
                htmlBuilder.append("</td>");
                htmlBuilder.append("<td>");
                long consumeTime = 0L;
                String consumeTimeStr = "";
                if (relHis.getActiontime() != null && tempRelHis != null) {
                    try {
                        consumeTime = DateUtil.getDiffDateTime((Date)tempRelHis.getActiontime(), (Date)relHis.getActiontime());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                long day = consumeTime / 86400000L;
                long hour = consumeTime / 3600000L - day * 24L;
                long min = consumeTime / 60000L - day * 24L * 60L - hour * 60L;
                long s = consumeTime / 1000L - day * 24L * 60L * 60L - hour * 60L * 60L - min * 60L;
                consumeTimeStr = "" + day + "{*[Days]*}" + hour + "{*[Hours]*}" + min + "{*[Minutes]*}" + s + "{*[Seconds]*}";
                htmlBuilder.append(consumeTimeStr);
                htmlBuilder.append("</td>");
                htmlBuilder.append("</tr>");
            }
            tempRelHis = relHis;
        }
        htmlBuilder.append("</table>");
        htmlBuilder.append("</div>");
        return htmlBuilder.toString();
    }

    private String checkNull(Object object) {
        if (object == null) {
            return "";
        }
        return String.valueOf(object);
    }

    private String toTextXml() {
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("Flow-History");
        StringBuffer xmlBuilder = new StringBuffer();
        xmlBuilder.append("<").append("Flow-History").append(">");
        for (SimpleRelationHIS his : this.hisList) {
            Element relation = root.addElement("relation-history");
            Element id = relation.addElement("id");
            id.setText(his.getId());
            Element startnodeid = relation.addElement("startnodeid");
            startnodeid.setText(this.checkNull(his.getStartnodeid()));
            Element startnodename = relation.addElement("startnodename");
            startnodename.setText(this.checkNull(his.getStartnodename()));
            Element endnodeid = relation.addElement("endnodeid");
            endnodeid.setText(this.checkNull(his.getEndnodeid()));
            Element endnodename = relation.addElement("endnodename");
            endnodename.setText(this.checkNull(his.getEndnodename()));
            Element flowid = relation.addElement("flowid");
            flowid.setText(this.checkNull(his.getFlowid()));
            Element flowname = relation.addElement("flowname");
            flowname.setText(this.checkNull(his.getFlowname()));
            Element flowOperation = relation.addElement("flowOperation");
            flowOperation.setText(this.checkNull(his.getFlowOperation()));
            Element flowStateId = relation.addElement("flowStateId");
            flowStateId.setText(this.checkNull(his.getFlowStateId()));
            Element docid = relation.addElement("docid");
            docid.setText(this.checkNull(his.getDocid()));
            Element ispassed = relation.addElement("ispassed");
            ispassed.setText(this.checkNull(his.getIspassed()));
            Element auditor = relation.addElement("auditor");
            auditor.setText(this.checkNull(his.getAuditor()));
            Element actiontime = relation.addElement("actiontime");
            actiontime.setText(this.checkNull(his.getActiontime()));
            Element processtime = relation.addElement("processtime");
            processtime.setText(this.checkNull(his.getProcesstime()));
            Element attitude = relation.addElement("attitude");
            attitude.setText(this.checkNull(his.getAttitude()));
            Element ReminderCount = relation.addElement("ReminderCount");
            ReminderCount.setText(this.checkNull(his.getReminderCount()));
            Collection<SimpleActorHIS> simpleActorHISs = his.getActorhiss();
            for (SimpleActorHIS simpleActorHIS : simpleActorHISs) {
                Element actor = relation.addElement("actor-history");
                Element actorid = actor.addElement("actorid");
                actorid.setText(this.checkNull(simpleActorHIS.getActorid()));
                Element agentid = actor.addElement("agentid");
                agentid.setText(this.checkNull(simpleActorHIS.getAgentid()));
                Element agentname = actor.addElement("agentname");
                agentname.setText(this.checkNull(simpleActorHIS.getAgentname()));
                Element name = actor.addElement("name");
                name.setText(this.checkNull(simpleActorHIS.getName()));
                Element type = actor.addElement("type");
                type.setText(this.checkNull(simpleActorHIS.getType()));
                Element processtime2 = actor.addElement("processtime");
                processtime2.setText(this.checkNull(simpleActorHIS.getProcesstime()));
                Element attitude2 = actor.addElement("attitude");
                attitude2.setText(this.checkNull(simpleActorHIS.getAttitude()));
            }
            Element version = relation.addElement("version");
            version.setText(this.checkNull(his.getVersion()));
        }
        return doc.asXML();
    }

    private String toTextJson() throws FlowHistoryServiceFault {
        StringBuffer sb = new StringBuffer();
        try {
            Document document = DocumentHelper.parseText((String)this.toTextXml());
            Element root = document.getRootElement();
            Iterator it = root.elementIterator();
            sb.append("{");
            while (it.hasNext()) {
                Element element = (Element)it.next();
                String j = this.checkChildEle(element);
                if (j == "") {
                    sb.append(element.getName() + ":" + element.getText() + ",\r\n");
                    continue;
                }
                sb.append(j);
            }
            sb.append("}");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FlowHistoryServiceFault(e.getMessage());
        }
        String json = sb.toString();
        json = json.replaceAll("},}", "}}");
        json = json.replaceAll("\",}", "\"}");
        json = json.replaceAll("},}", "}}");
        return json;
    }

    public String checkChildEle(Element element) throws DocumentException {
        String json = "";
        List list = new ArrayList();
        list = element.elements();
        if (list.size() > 0) {
            for (Element ele : list) {
                json = json + ele.getName() + ":" + ele.getText() + ",\r\n" + this.checkChildEle(ele);
            }
        }
        return json;
    }

    public static void main(String[] args) {
    }
}

