/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.webservice;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.domain.service.DomainProcess;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.superuser.SuperUserVO;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.superuser.service.SuperUserDesignTimeService;
import cn.myapps.webservice.fault.DomainServiceFault;
import cn.myapps.webservice.model.SimpleDomain;
import cn.myapps.webservice.util.DomainUtil;
import java.util.Collection;

public class DomainService {
    public Collection<SimpleDomain> searchDomainsByDomainAdmin(String domainAdminId) throws DomainServiceFault {
        try {
            SuperUserDesignTimeService userProcess = DesignTimeServiceManager.superUserDesignTimeService();
            SuperUserVO superUserVO = userProcess.doView(domainAdminId);
            Collection domains = superUserVO.getDomains();
            return DomainUtil.convertToSimple(domains);
        }
        catch (Exception e) {
            throw new DomainServiceFault(e.getMessage());
        }
    }

    public SimpleDomain searchDomainByName(String name) throws DomainServiceFault {
        try {
            DomainProcess domainProcess = AuthTimeServiceManager.domainRuntimeService();
            ParamsTable params = new ParamsTable();
            params.setParameter("t_name", (Object)name);
            Collection domainList = domainProcess.doSimpleQuery(name);
            if (domainList != null && !domainList.isEmpty()) {
                DomainVO domain = (DomainVO)domainList.iterator().next();
                return DomainUtil.convertToSimple(domain);
            }
            return null;
        }
        catch (Exception e) {
            throw new DomainServiceFault(e.getMessage());
        }
    }
}

