/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.webservice;

import cn.myapps.authtime.common.dao.HibernateSQLUtils;
import cn.myapps.authtime.common.dao.PersistenceUtils;
import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.user.model.UserVO;
import cn.myapps.authtime.user.service.UserProcess;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.ValueObject;
import cn.myapps.common.model.application.Application;
import cn.myapps.common.model.workflow.BillDefiVO;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.application.service.ApplicationDesignTimeService;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.datasource.service.DataSourceDesignTimeService;
import cn.myapps.designtime.form.service.FormDesignTimeService;
import cn.myapps.designtime.workflow.definition.service.BillDefiDesignTimeService;
import cn.myapps.runtime.common.service.RunTimeServiceManager;
import cn.myapps.runtime.dynaform.document.ejb.Document;
import cn.myapps.runtime.dynaform.document.ejb.DocumentProcess;
import cn.myapps.runtime.dynaform.document.ejb.DocumentProcessBean;
import cn.myapps.runtime.dynaform.document.model.IDocument;
import cn.myapps.runtime.dynaform.form.ejb.Form;
import cn.myapps.runtime.dynaform.form.ejb.FormField;
import cn.myapps.runtime.workflow.element.FlowDiagram;
import cn.myapps.runtime.workflow.element.Node;
import cn.myapps.runtime.workflow.engine.StateMachine;
import cn.myapps.runtime.workflow.storage.runtime.ejb.NodeRT;
import cn.myapps.util.json.JsonUtil;
import cn.myapps.util.sequence.Sequence;
import cn.myapps.util.xml.XmlUtil;
import cn.myapps.webservice.WebServiceUtil;
import cn.myapps.webservice.fault.DocumentServiceFault;
import cn.myapps.webservice.model.SimpleDocument;
import cn.myapps.webservice.model.SimpleNode;
import cn.myapps.webservice.util.DocumentUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DocumentService {
    private WebUser getGuest(String applicationId) throws Exception {
        ApplicationDesignTimeService process = DesignTimeServiceManager.applicationDesignTimeService();
        Application app = (Application)process.findById(applicationId);
        UserVO uservo = new UserVO();
        uservo.setId("guest");
        uservo.setName("guest");
        uservo.setLoginno("guest");
        uservo.setDomainid("");
        uservo.setApplicationid(applicationId);
        WebUser user = new WebUser((IUser)uservo);
        user.setDefaultApplication(applicationId);
        return user;
    }

    private void unCalculateOnRefresh(Form form) throws DocumentServiceFault {
        Iterator iter = form.getAllFields().iterator();
        FormField field = null;
        while (iter.hasNext()) {
            field = (FormField)iter.next();
            if (!field.isCalculateOnRefresh()) continue;
            field.setCalculateOnRefresh(false);
        }
    }

    public int createDocumentByGuest(String formName, Map<String, Object> parameters, String applicationId) throws DocumentServiceFault {
        int result = -1;
        try {
            DocumentProcess docProcess = RunTimeServiceManager.documentProcess((String)applicationId);
            WebUser user = this.getGuest(applicationId);
            Document doc = this.createDocument(formName, parameters, user, applicationId);
            docProcess.doCreateOrUpdate((IDocument)doc, (IUser)user);
            result = 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DocumentServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new DocumentServiceFault(e.getMessage());
            }
        }
        return result;
    }

    public int createDocumentByGuest(String formName, String parameters, String applicationId) throws DocumentServiceFault {
        try {
            HashMap<String, Object> params = new HashMap();
            if (!StringUtil.isBlank((String)parameters)) {
                params = JsonUtil.toMap((String)parameters);
            }
            return this.createDocumentByGuest(formName, params, applicationId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DocumentServiceFault(e.getMessage());
        }
    }

    public int updateDocumentByGuest(String documentId, Map<String, Object> parameters, String applicationId) throws DocumentServiceFault {
        int result = -1;
        try {
            WebUser user = this.getGuest(applicationId);
            this.updateDocument(documentId, parameters, user, applicationId);
            result = 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DocumentServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new DocumentServiceFault(e.getMessage());
            }
        }
        return result;
    }

    public int updateDocumentByGuest(String documentId, String parameters, String applicationId) throws DocumentServiceFault {
        try {
            HashMap<String, Object> params = new HashMap();
            if (!StringUtil.isBlank((String)parameters)) {
                params = JsonUtil.toMap((String)parameters);
            }
            return this.updateDocumentByGuest(documentId, params, applicationId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DocumentServiceFault(e.getMessage());
        }
    }

    public int createDocumentByDomainUser(String formName, Map<String, Object> parameters, String domainUserId, String applicationId) throws DocumentServiceFault {
        int result = -1;
        try {
            DocumentProcess docProcess = RunTimeServiceManager.documentProcess((String)applicationId);
            UserVO userVO = WebServiceUtil.findUserWithValidate(domainUserId);
            WebUser user = new WebUser((IUser)userVO);
            Document doc = this.createDocument(formName, parameters, user, applicationId);
            docProcess.doCreateOrUpdate((IDocument)doc, (IUser)user);
            result = 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DocumentServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new DocumentServiceFault(e.getMessage());
            }
        }
        return result;
    }

    public int createDocumentByDomainUser(String formName, String parameters, String domainUserId, String applicationId) throws DocumentServiceFault {
        try {
            HashMap<String, Object> params = new HashMap();
            if (!StringUtil.isBlank((String)parameters)) {
                params = JsonUtil.toMap((String)parameters);
            }
            return this.createDocumentByDomainUser(formName, params, domainUserId, applicationId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DocumentServiceFault(e.getMessage());
        }
    }

    public int createDocumentWithChildsByDomainUser(String mainFormName, Map<String, Object> mainParameters, String[] subFormNames, Map<String, Map<String, Object>> subParameters, String domainUserId, String applicationId) throws DocumentServiceFault {
        int result = -1;
        try {
            WebServiceUtil.validateApplicationById(applicationId);
            ArrayList<Document> vos = new ArrayList<Document>();
            UserVO userVO = WebServiceUtil.findUserWithValidate(domainUserId);
            WebUser user = new WebUser((IUser)userVO);
            Document mainDoc = this.createDocument(mainFormName, mainParameters, user, applicationId);
            mainDoc.setId(Sequence.getUUID());
            vos.add(mainDoc);
            String[] stringArray = subFormNames;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String subFormNameObject;
                String subFormNameString = subFormNameObject = stringArray[i];
                Map<String, Object> subParameter = subParameters.get(subFormNameObject);
                Document subDoc = this.createDocument(subFormNameString, subParameter, user, applicationId);
                subDoc.setParent(mainDoc);
                vos.add(subDoc);
            }
            DocumentProcess docProcess = RunTimeServiceManager.documentProcess((String)applicationId);
            docProcess.doCreate(vos);
            result = 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DocumentServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new DocumentServiceFault(e.getMessage());
            }
        }
        return result;
    }

    public int createDocumentWithChildsByDomainUser4Json(String mainFormName, String mainParameters, String subFormNames, String subParameters, String domainUserId, String applicationId) throws DocumentServiceFault {
        int result = -1;
        try {
            WebServiceUtil.validateApplicationById(applicationId);
            HashMap<String, Object> mainParams = new HashMap();
            if (!StringUtil.isBlank((String)mainParameters)) {
                mainParams = JsonUtil.toMap((String)mainParameters);
            }
            Collection subFormNamesCollection = new ArrayList();
            if (!StringUtil.isBlank((String)subFormNames)) {
                subFormNamesCollection = JsonUtil.toCollection((String)subFormNames);
            }
            Map subParametersMap = new HashMap();
            if (!StringUtil.isBlank((String)subParameters)) {
                subParametersMap = JsonUtil.toMap((String)subParameters);
            }
            HashMap<String, Map<String, Object>> subParameterMaps = new HashMap<String, Map<String, Object>>();
            for (Object subFormNameObject : subFormNamesCollection) {
                String subFormNameString = (String)subFormNameObject;
                Map subParameterString = (Map)subParametersMap.get(subFormNameObject);
                subParameterMaps.put(subFormNameString, subParameterString);
            }
            String[] subFormNamesArray = new String[]{};
            subFormNamesArray = subParameterMaps.keySet().toArray(subFormNamesArray);
            result = this.createDocumentWithChildsByDomainUser(mainFormName, mainParams, subFormNamesArray, subParameterMaps, domainUserId, applicationId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DocumentServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new DocumentServiceFault(e.getMessage());
            }
        }
        return result;
    }

    public int createDocumentAndStartFlowByDomainUser(String formName, Map<String, Object> parameters, String domainUserId, String applicationId) throws DocumentServiceFault {
        int result = -1;
        try {
            UserVO user = WebServiceUtil.findUserWithValidate(domainUserId);
            this.createDocumentAndStartFlow(formName, parameters, new WebUser((IUser)user), applicationId);
            result = 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DocumentServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new DocumentServiceFault(e.getMessage());
            }
        }
        return result;
    }

    public int createDocumentAndStartFlowByDomainUser(String formName, String parameters, String domainUserId, String applicationId) throws DocumentServiceFault {
        try {
            HashMap<String, Object> params = new HashMap();
            if (!StringUtil.isBlank((String)parameters)) {
                params = JsonUtil.toMap((String)parameters);
            }
            return this.createDocumentAndStartFlowByDomainUser(formName, params, domainUserId, applicationId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DocumentServiceFault(e.getMessage());
        }
    }

    public int updateDocumentByDomainUser(String documentId, Map<String, Object> parameters, String domainUserId, String applicationId) throws DocumentServiceFault {
        int result = -1;
        try {
            UserVO user = WebServiceUtil.findUserWithValidate(domainUserId);
            this.updateDocument(documentId, parameters, new WebUser((IUser)user), applicationId);
            result = 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DocumentServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new DocumentServiceFault(e.getMessage());
            }
        }
        return result;
    }

    public int updateDocumentByDomainUser(String documentId, String parameters, String domainUserId, String applicationId) throws DocumentServiceFault {
        try {
            HashMap<String, Object> params = new HashMap();
            if (!StringUtil.isBlank((String)parameters)) {
                params = JsonUtil.toMap((String)parameters);
            }
            return this.updateDocumentByDomainUser(documentId, params, domainUserId, applicationId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DocumentServiceFault(e.getMessage());
        }
    }

    private Document createDocument(String formName, Map<String, Object> parameters, WebUser user, String applicationId) throws DocumentServiceFault {
        try {
            FormDesignTimeService formService = DesignTimeServiceManager.formDesignTimeService();
            WebServiceUtil.validateApplicationById(applicationId);
            Form form = formService.doViewByFormName(formName, applicationId);
            if (form == null) {
                throw new DocumentServiceFault("\u8868\u5355[" + formName + "]\u4e0d\u5b58\u5728\u8f6f\u4ef6[id=" + applicationId + "]\u4e0b.");
            }
            this.unCalculateOnRefresh(form);
            ParamsTable params = new ParamsTable();
            params.putAll(parameters);
            Document doc = form.createDocument(params, (IUser)user, false);
            doc.setIstmp((Object)false);
            WebServiceUtil.validateDocument(doc, params, user, applicationId);
            Document document = doc;
            return document;
        }
        catch (DocumentServiceFault e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DocumentServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new DocumentServiceFault(e.getMessage());
            }
        }
    }

    public String createDocumentAndStartFlow(String formName, String parameters, String domainUserId, String applicationId) throws DocumentServiceFault {
        try {
            HashMap<String, Object> params = new HashMap();
            if (!StringUtil.isBlank((String)parameters)) {
                params = JsonUtil.toMap((String)parameters);
            }
            UserVO user = WebServiceUtil.findUserWithValidate(domainUserId);
            return this.createDocumentAndStartFlow(formName, params, new WebUser((IUser)user), applicationId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DocumentServiceFault(e.getMessage());
        }
    }

    private String createDocumentAndStartFlow(String formName, Map<String, Object> parameters, WebUser user, String applicationId) throws DocumentServiceFault {
        try {
            FormDesignTimeService formService = DesignTimeServiceManager.formDesignTimeService();
            WebServiceUtil.validateApplicationById(applicationId);
            DocumentProcess docProcess = RunTimeServiceManager.documentProcess((String)applicationId);
            Form form = formService.doViewByFormName(formName, applicationId);
            if (form == null) {
                throw new DocumentServiceFault("\u8868\u5355[" + formName + "]\u4e0d\u5b58\u5728\u8f6f\u4ef6[id=" + applicationId + "]\u4e0b.");
            }
            this.unCalculateOnRefresh(form);
            ParamsTable params = new ParamsTable();
            params.putAll(parameters);
            Document doc = form.createDocument(params, (IUser)user, false);
            this.setParameter(form, doc, user, params, applicationId);
            if (doc != null) {
                WebServiceUtil.validateDocument(doc, params, user, applicationId);
                doc.setIstmp((Object)false);
                docProcess.doStartFlowOrUpdate((IDocument)doc, params, (IUser)user);
                String string = doc.getId();
                return string;
            }
            String string = null;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DocumentServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new DocumentServiceFault(e.getMessage());
            }
        }
    }

    private void setParameter(Form form, Document doc, WebUser user, ParamsTable params, String applicationId) throws Exception {
        BillDefiDesignTimeService flowProcess = DesignTimeServiceManager.billDefiDesignTimeService();
        String flowName = params.getParameterAsString("flowname");
        String flowid = null;
        if (!StringUtil.isBlank((String)flowName)) {
            BillDefiVO flowVO = flowProcess.doViewBySubject(flowName, applicationId);
            if (flowVO != null) {
                flowid = flowVO.getId();
            }
        } else {
            flowid = form.getOnActionFlow();
        }
        params.setParameter("_flowid", (Object)flowid);
    }

    private void updateDocument(String documentId, Map<String, Object> parameters, WebUser user, String applicationId) throws DocumentServiceFault {
        try {
            FormDesignTimeService formService = DesignTimeServiceManager.formDesignTimeService();
            WebServiceUtil.validateApplicationById(applicationId);
            DocumentProcessBean docProcess = new DocumentProcessBean(applicationId);
            Document doc = (Document)docProcess.doView(documentId);
            if (doc == null) {
                throw new DocumentServiceFault("\u6587\u6863[id=" + documentId + "]\u4e0d\u5b58\u5728\u8f6f\u4ef6[id=" + applicationId + "]\u4e0b.");
            }
            Form form = formService.doView(doc.getFormid());
            if (form == null) {
                throw new DocumentServiceFault("\u6587\u6863[id=" + documentId + "]\u5bf9\u5e94\u7684\u8868\u5355[id=" + doc.getFormid() + "]\u4e0d\u5b58\u5728.");
            }
            this.unCalculateOnRefresh(form);
            ParamsTable params = new ParamsTable();
            params.putAll(parameters);
            doc = form.createDocument(doc, params, false, (IUser)user);
            WebServiceUtil.validateDocument(doc, params, user, applicationId);
            docProcess.doUpdate((ValueObject)doc);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DocumentServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new DocumentServiceFault(e.getMessage());
            }
        }
    }

    public int removeDocument(String documentId, String applicationId) throws DocumentServiceFault {
        int result = -1;
        try {
            WebServiceUtil.validateApplicationById(applicationId);
            DocumentProcessBean docProcess = new DocumentProcessBean(applicationId);
            Document doc = (Document)docProcess.doView(documentId);
            if (doc != null) {
                docProcess.doRemove(documentId);
            }
            result = 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DocumentServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new DocumentServiceFault(e.getMessage());
            }
        }
        return result;
    }

    public int removeDocumentByUser(String documentId, String applicationId, String userId) throws DocumentServiceFault {
        int result = -1;
        try {
            WebServiceUtil.validateApplicationById(applicationId);
            DocumentProcessBean docProcess = new DocumentProcessBean(applicationId);
            Document doc = (Document)docProcess.doView(documentId);
            if (doc != null && (StringUtil.isBlank((String)doc.getStateid()) || !StringUtil.isBlank((String)doc.getAuditorList()) && doc.getAuditorList().indexOf(userId) > 0)) {
                docProcess.doRemove(documentId);
                result = 0;
            }
        }
        catch (Exception e) {
            throw new DocumentServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new DocumentServiceFault(e.getMessage());
            }
        }
        return result;
    }

    public Collection<SimpleDocument> searchDocumentsByFilter(String formName, Map<String, Object> parameters, String applicationId) throws DocumentServiceFault {
        try {
            Collection<SimpleDocument> collection = this.searchDocumentsByFilter(formName, parameters, applicationId, this.getGuest(applicationId));
            return collection;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DocumentServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new DocumentServiceFault(e.getMessage());
            }
        }
    }

    public Collection<SimpleDocument> searchDocumentsByFilter(String formName, String parameters, String applicationId) throws DocumentServiceFault {
        try {
            HashMap<String, Object> params = new HashMap();
            if (!StringUtil.isBlank((String)parameters)) {
                params = JsonUtil.toMap((String)parameters);
            }
            return this.searchDocumentsByFilter(formName, params, applicationId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DocumentServiceFault(e.getMessage());
        }
    }

    private Collection<SimpleDocument> searchDocumentsByFilter(String formName, Map<String, Object> parameters, String applicationId, WebUser webUser) throws DocumentServiceFault {
        try {
            HibernateSQLUtils sqlUtil;
            String whereClause;
            WebServiceUtil.validateApplicationById(applicationId);
            DocumentProcessBean docProcess = new DocumentProcessBean(applicationId);
            FormDesignTimeService formService = DesignTimeServiceManager.formDesignTimeService();
            Form form = formService.doViewByFormName(formName, applicationId);
            if (form == null) {
                throw new DocumentServiceFault("\u8868\u5355[" + formName + "]\u4e0d\u5b58\u5728\u8f6f\u4ef6[id=" + applicationId + "]\u4e0b.");
            }
            String dql = "$formname='" + formName + "'";
            ParamsTable params = new ParamsTable();
            params.putAll(parameters);
            if (params != null && (whereClause = (sqlUtil = new HibernateSQLUtils()).createJdbcWhere(params)) != null && whereClause.trim().length() > 0) {
                dql = dql + " AND " + whereClause;
            }
            String _currpage = params.getParameterAsString("_currpage");
            String _pagelines = params.getParameterAsString("_pagelines");
            int page = _currpage != null && _currpage.length() > 0 ? Integer.parseInt(_currpage) : 1;
            int lines = _pagelines != null && _pagelines.length() > 0 ? Integer.parseInt(_pagelines) : Integer.MAX_VALUE;
            DataPackage dataPackage = docProcess.queryByDQLPage(dql, params, page, lines, webUser.getDomainid());
            Collection<SimpleDocument> collection = DocumentUtil.convertToSimpleDatas((DataPackage<Document>)dataPackage);
            return collection;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DocumentServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new DocumentServiceFault(e.getMessage());
            }
        }
    }

    public Collection<SimpleDocument> searchDocumentsByFilter(String formName, Map<String, Object> parameters, String applicationId, String domainUserId) throws DocumentServiceFault {
        try {
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            UserVO user = (UserVO)userProcess.doView(domainUserId);
            if (user != null) {
                Collection<SimpleDocument> collection = this.searchDocumentsByFilter(formName, parameters, applicationId, new WebUser((IUser)user));
                return collection;
            }
            ArrayList<SimpleDocument> arrayList = new ArrayList<SimpleDocument>();
            return arrayList;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DocumentServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new DocumentServiceFault(e.getMessage());
            }
        }
    }

    public Collection<SimpleDocument> searchDocumentsByFilter(String formName, String parameters, String applicationId, String domainUserId) throws DocumentServiceFault {
        try {
            HashMap<String, Object> params = new HashMap();
            if (!StringUtil.isBlank((String)parameters)) {
                params = JsonUtil.toMap((String)parameters);
            }
            return this.searchDocumentsByFilter(formName, params, applicationId, domainUserId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DocumentServiceFault(e.getMessage());
        }
    }

    public SimpleDocument searchDocumentByFilter(String formName, Map<String, Object> parameters, String applicationId, String domainUserId) throws DocumentServiceFault {
        try {
            Collection<SimpleDocument> docList;
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            UserVO user = (UserVO)userProcess.doView(domainUserId);
            if (user != null && (docList = this.searchDocumentsByFilter(formName, parameters, applicationId, new WebUser((IUser)user))) != null && !docList.isEmpty()) {
                SimpleDocument simpleDocument = docList.iterator().next();
                return simpleDocument;
            }
            SimpleDocument simpleDocument = null;
            return simpleDocument;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DocumentServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new DocumentServiceFault(e.getMessage());
            }
        }
    }

    public SimpleDocument searchDocumentByFilter(String formName, String parameters, String applicationId, String domainUserId) throws DocumentServiceFault {
        try {
            HashMap<String, Object> params = new HashMap();
            if (!StringUtil.isBlank((String)parameters)) {
                params = JsonUtil.toMap((String)parameters);
            }
            return this.searchDocumentByFilter(formName, params, applicationId, domainUserId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DocumentServiceFault(e.getMessage());
        }
    }

    public String searchDocumentsByFilterFormat2XML(String formName, Map<String, Object> parameters, String applicationId) throws DocumentServiceFault {
        Collection<SimpleDocument> datas = this.searchDocumentsByFilter(formName, parameters, applicationId);
        return XmlUtil.toXml(datas);
    }

    public String searchDocumentsByFilterFormat2XML(String formName, String parameters, String applicationId) throws DocumentServiceFault {
        Collection<SimpleDocument> datas = this.searchDocumentsByFilter(formName, parameters, applicationId);
        return XmlUtil.toXml(datas);
    }

    public String searchDocumentsByFilterFormat2XML(String formName, Map<String, Object> parameters, String applicationId, String domainUserId) throws DocumentServiceFault {
        Collection<SimpleDocument> datas = this.searchDocumentsByFilter(formName, parameters, applicationId, domainUserId);
        return XmlUtil.toXml(datas);
    }

    public String searchDocumentsByFilterFormat2XML(String formName, String parameters, String applicationId, String domainUserId) throws DocumentServiceFault {
        Collection<SimpleDocument> datas = this.searchDocumentsByFilter(formName, parameters, applicationId, domainUserId);
        return XmlUtil.toXml(datas);
    }

    public String searchSimpleDocumentByFilterFormat2XML(String formName, Map<String, Object> parameters, String applicationId, String domainUserId) throws DocumentServiceFault {
        SimpleDocument data = this.searchDocumentByFilter(formName, parameters, applicationId, domainUserId);
        return XmlUtil.toXml((Object)data);
    }

    public String searchSimpleDocumentByFilterFormat2XML(String formName, String parameters, String applicationId, String domainUserId) throws DocumentServiceFault {
        SimpleDocument data = this.searchDocumentByFilter(formName, parameters, applicationId, domainUserId);
        return XmlUtil.toXml((Object)data);
    }

    public String searchDocumentsByFilterFormat2Json(String formName, Map<String, Object> parameters, String applicationId) throws DocumentServiceFault {
        Collection<SimpleDocument> datas = this.searchDocumentsByFilter(formName, parameters, applicationId);
        return JsonUtil.collection2Json(datas);
    }

    public String searchDocumentsByFilterFormat2Json(String formName, String parameters, String applicationId) throws DocumentServiceFault {
        Collection<SimpleDocument> datas = this.searchDocumentsByFilter(formName, parameters, applicationId);
        return JsonUtil.collection2Json(datas);
    }

    public String searchDocumentsByFilterFormat2Json(String formName, Map<String, Object> parameters, String applicationId, String domainUserId) throws DocumentServiceFault {
        Collection<SimpleDocument> datas = this.searchDocumentsByFilter(formName, parameters, applicationId, domainUserId);
        return JsonUtil.collection2Json(datas);
    }

    public String searchDocumentsByFilterFormat2Json(String formName, String parameters, String applicationId, String domainUserId) throws DocumentServiceFault {
        Collection<SimpleDocument> datas = this.searchDocumentsByFilter(formName, parameters, applicationId, domainUserId);
        return JsonUtil.collection2Json(datas);
    }

    public String searchSimpleDocumentByFilterFormat2Json(String formName, Map<String, Object> parameters, String applicationId, String domainUserId) throws DocumentServiceFault {
        SimpleDocument data = this.searchDocumentByFilter(formName, parameters, applicationId, domainUserId);
        return JsonUtil.toJson((Object)data);
    }

    public String searchSimpleDocumentByFilterFormat2Json(String formName, String parameters, String applicationId, String domainUserId) throws DocumentServiceFault {
        SimpleDocument data = this.searchDocumentByFilter(formName, parameters, applicationId, domainUserId);
        return JsonUtil.toJson((Object)data);
    }

    private Collection<SimpleDocument> searchDocumentsBySQL(String sql, String applicationId, WebUser webUser) throws DocumentServiceFault {
        try {
            WebServiceUtil.validateApplicationById(applicationId);
            DocumentProcessBean docProcess = new DocumentProcessBean(applicationId);
            DataPackage dataPackage = docProcess.queryBySQL(sql, webUser.getDomainid());
            Collection<SimpleDocument> collection = DocumentUtil.convertToSimpleDatas((DataPackage<Document>)dataPackage);
            return collection;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DocumentServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new DocumentServiceFault(e.getMessage());
            }
        }
    }

    public Collection<SimpleDocument> searchDocumentsBySQL(String sql, String applicationId) throws DocumentServiceFault {
        try {
            return this.searchDocumentsBySQL(sql, applicationId, this.getGuest(applicationId));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DocumentServiceFault(e.getMessage());
        }
    }

    public Collection<SimpleDocument> searchDocumentsBySQL(String sql, String applicationId, String domainUserId) throws DocumentServiceFault {
        try {
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            UserVO user = (UserVO)userProcess.doView(domainUserId);
            if (user != null) {
                Collection<SimpleDocument> collection = this.searchDocumentsBySQL(sql, applicationId, new WebUser((IUser)user));
                return collection;
            }
            ArrayList<SimpleDocument> arrayList = new ArrayList<SimpleDocument>();
            return arrayList;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DocumentServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new DocumentServiceFault(e.getMessage());
            }
        }
    }

    public SimpleDocument searchDocumentBySQL(String sql, String applicationId, String domainUserId) throws DocumentServiceFault {
        try {
            Collection<SimpleDocument> docList;
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            UserVO user = (UserVO)userProcess.doView(domainUserId);
            if (user != null && (docList = this.searchDocumentsBySQL(sql, applicationId, new WebUser((IUser)user))) != null && !docList.isEmpty()) {
                SimpleDocument simpleDocument = docList.iterator().next();
                return simpleDocument;
            }
            SimpleDocument simpleDocument = null;
            return simpleDocument;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DocumentServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new DocumentServiceFault(e.getMessage());
            }
        }
    }

    public String searchDocumentsBySQLFormat2XML(String sql, String applicationId) throws DocumentServiceFault {
        Collection<SimpleDocument> datas = this.searchDocumentsBySQL(sql, applicationId);
        return XmlUtil.toXml(datas);
    }

    public String searchDocumentsBySQLFormat2XML(String sql, String applicationId, String domainUserId) throws DocumentServiceFault {
        Collection<SimpleDocument> datas = this.searchDocumentsBySQL(sql, applicationId, domainUserId);
        return XmlUtil.toXml(datas);
    }

    public String searchSimpleDocumentBySQLFormat2XML(String sql, String applicationId, String domainUserId) throws DocumentServiceFault {
        SimpleDocument data = this.searchDocumentBySQL(sql, applicationId, domainUserId);
        return XmlUtil.toXml((Object)data);
    }

    public String searchDocumentsBySQLFormat2Json(String sql, String applicationId) throws DocumentServiceFault {
        Collection<SimpleDocument> datas = this.searchDocumentsBySQL(sql, applicationId);
        return JsonUtil.collection2Json(datas);
    }

    public String searchDocumentsBySQLFormat2Json(String sql, String applicationId, String domainUserId) throws DocumentServiceFault {
        Collection<SimpleDocument> datas = this.searchDocumentsBySQL(sql, applicationId, domainUserId);
        return JsonUtil.collection2Json(datas);
    }

    public String searchSimpleDocumentBySQLFormat2Json(String sql, String applicationId, String domainUserId) throws DocumentServiceFault {
        SimpleDocument data = this.searchDocumentBySQL(sql, applicationId, domainUserId);
        return JsonUtil.toJson((Object)data);
    }

    private Collection<SimpleDocument> searchDocumentsByDQL(String dql, String applicationId, WebUser webUser) throws DocumentServiceFault {
        try {
            WebServiceUtil.validateApplicationById(applicationId);
            DocumentProcessBean docProcess = new DocumentProcessBean(applicationId);
            DataPackage dataPackage = docProcess.queryByDQL(dql, webUser.getDomainid());
            Collection<SimpleDocument> collection = DocumentUtil.convertToSimpleDatas((DataPackage<Document>)dataPackage);
            return collection;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DocumentServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new DocumentServiceFault(e.getMessage());
            }
        }
    }

    public Collection<SimpleDocument> searchDocumentsByDQL(String dql, String applicationId) throws DocumentServiceFault {
        try {
            Collection<SimpleDocument> collection = this.searchDocumentsByDQL(dql, applicationId, this.getGuest(applicationId));
            return collection;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DocumentServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new DocumentServiceFault(e.getMessage());
            }
        }
    }

    public Collection<SimpleDocument> searchDocumentsByDQL(String dql, String applicationId, String domainUserId) throws DocumentServiceFault {
        try {
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            UserVO user = (UserVO)userProcess.doView(domainUserId);
            if (user != null) {
                Collection<SimpleDocument> collection = this.searchDocumentsByDQL(dql, applicationId, new WebUser((IUser)user));
                return collection;
            }
            ArrayList<SimpleDocument> arrayList = new ArrayList<SimpleDocument>();
            return arrayList;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DocumentServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new DocumentServiceFault(e.getMessage());
            }
        }
    }

    public SimpleDocument searchDocumentByDQL(String dql, String applicationId, String domainUserId) throws DocumentServiceFault {
        try {
            Collection<SimpleDocument> docList;
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            UserVO user = (UserVO)userProcess.doView(domainUserId);
            if (user != null && (docList = this.searchDocumentsByDQL(dql, applicationId, new WebUser((IUser)user))) != null && !docList.isEmpty()) {
                SimpleDocument simpleDocument = docList.iterator().next();
                return simpleDocument;
            }
            SimpleDocument simpleDocument = null;
            return simpleDocument;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DocumentServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new DocumentServiceFault(e.getMessage());
            }
        }
    }

    public String searchDocumentsByDQLFormat2XML(String dql, String applicationId) throws DocumentServiceFault {
        Collection<SimpleDocument> datas = this.searchDocumentsByDQL(dql, applicationId);
        return XmlUtil.toXml(datas);
    }

    public String searchDocumentsByDQLFormat2XML(String dql, String applicationId, String domainUserId) throws DocumentServiceFault {
        Collection<SimpleDocument> datas = this.searchDocumentsByDQL(dql, applicationId, domainUserId);
        return XmlUtil.toXml(datas);
    }

    public String searchSimpleDocumentByDQLFormat2XML(String dql, String applicationId, String domainUserId) throws DocumentServiceFault {
        SimpleDocument data = this.searchDocumentByDQL(dql, applicationId, domainUserId);
        return XmlUtil.toXml((Object)data);
    }

    public String searchDocumentsByDQLFormat2Json(String dql, String applicationId) throws DocumentServiceFault {
        Collection<SimpleDocument> datas = this.searchDocumentsByDQL(dql, applicationId);
        return JsonUtil.collection2Json(datas);
    }

    public String searchDocumentsByDQLFormat2Json(String dql, String applicationId, String domainUserId) throws DocumentServiceFault {
        Collection<SimpleDocument> datas = this.searchDocumentsByDQL(dql, applicationId, domainUserId);
        return JsonUtil.collection2Json(datas);
    }

    public String searchSimpleDocumentByDQLFormat2Json(String dql, String applicationId, String domainUserId) throws DocumentServiceFault {
        SimpleDocument data = this.searchDocumentByDQL(dql, applicationId, domainUserId);
        return JsonUtil.toJson((Object)data);
    }

    public Collection<?> doQuery(String sql, String dataSourceName, String applicationId, String domainUserId) throws DocumentServiceFault {
        try {
            DataSourceDesignTimeService process = DesignTimeServiceManager.dataSourceDesignTimeService();
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            UserVO user = (UserVO)userProcess.doView(domainUserId);
            if (user != null) {
                Collection collection = process.queryDataSourceSQL(dataSourceName, sql, applicationId);
                return collection;
            }
            Collection<?> collection = null;
            return collection;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DocumentServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new DocumentServiceFault(e.getMessage());
            }
        }
    }

    public int doUpdate(String sql, String dataSourceName, String applicationId, String domainUserId) throws DocumentServiceFault {
        int result = 0;
        try {
            DataSourceDesignTimeService process = DesignTimeServiceManager.dataSourceDesignTimeService();
            UserProcess userProcess = AuthTimeServiceManager.userRuntimeService();
            UserVO user = (UserVO)userProcess.doView(domainUserId);
            if (user != null) {
                process.createOrUpdate(dataSourceName, sql, applicationId);
                result = 1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DocumentServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new DocumentServiceFault(e.getMessage());
            }
        }
        return result;
    }

    public String[] getNextNodeIdByCurrNode(String currNodeId, String docId, String applicationId) throws Exception {
        Document doc = null;
        try {
            DocumentProcess documentProcess = RunTimeServiceManager.documentProcess((String)applicationId);
            doc = (Document)documentProcess.doView(docId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String[] nodeStrings = null;
        if (doc.getState() != null) {
            BillDefiVO flowVO = doc.getState().getFlowVO();
            FlowDiagram fd = flowVO.toFlowDiagram();
            Node currnode = (Node)fd.getElementByID(currNodeId);
            Collection nextNodeList = fd.getNextNodeList(currnode.id, (IDocument)doc, null, null);
            nodeStrings = new String[nextNodeList.size()];
            int i = 0;
            for (Node node : nextNodeList) {
                nodeStrings[i++] = node.id;
            }
        }
        return nodeStrings;
    }

    public String[] getNextNodeId(String docId, String userId, String applicationId) throws Exception {
        WebUser user = null;
        Document doc = null;
        try {
            user = WebUser.getWebUserInstance((String)userId);
            DocumentProcess documentProcess = RunTimeServiceManager.documentProcess((String)applicationId);
            doc = (Document)documentProcess.doView(docId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String[] nodeStrings = null;
        if (doc.getState() != null) {
            BillDefiVO flowVO = doc.getState().getFlowVO();
            FlowDiagram fd = flowVO.toFlowDiagram();
            NodeRT nodert = StateMachine.getCurrUserNodeRT((IDocument)doc, (IUser)user);
            String currNodeId = nodert.getNodeid();
            Node currnode = (Node)fd.getElementByID(currNodeId);
            Collection nextNodeList = fd.getNextNodeList(currnode.id, (IDocument)doc, null, (IUser)user);
            nodeStrings = new String[nextNodeList.size()];
            int i = 0;
            for (Node node : nextNodeList) {
                nodeStrings[i++] = node.id;
            }
        }
        return nodeStrings;
    }

    public Collection<SimpleNode> getNextNode(String docId, String userId, String applicationId) throws Exception {
        WebUser user = null;
        Document doc = null;
        ArrayList<SimpleNode> datas = new ArrayList<SimpleNode>();
        try {
            user = WebUser.getWebUserInstance((String)userId);
            DocumentProcess documentProcess = RunTimeServiceManager.documentProcess((String)applicationId);
            doc = (Document)documentProcess.doView(docId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (doc.getState() != null) {
            BillDefiVO flowVO = doc.getState().getFlowVO();
            FlowDiagram fd = flowVO.toFlowDiagram();
            NodeRT nodert = StateMachine.getCurrUserNodeRT((IDocument)doc, (IUser)user);
            String currNodeId = nodert.getNodeid();
            Node currnode = (Node)fd.getElementByID(currNodeId);
            Collection nextNodeList = fd.getNextNodeList(currnode.id, (IDocument)doc, null, (IUser)user);
            for (Node node : nextNodeList) {
                SimpleNode simpleNode = new SimpleNode();
                simpleNode.setId(node.id);
                simpleNode.setName(node.name);
                datas.add(simpleNode);
            }
        }
        return datas;
    }

    public Collection<SimpleNode> getNextNodeByCurrNode(String currNodeId, String docId, String applicationId) throws Exception {
        Document doc = null;
        ArrayList<SimpleNode> datas = new ArrayList<SimpleNode>();
        try {
            DocumentProcess documentProcess = RunTimeServiceManager.documentProcess((String)applicationId);
            doc = (Document)documentProcess.doView(docId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (doc.getState() != null) {
            BillDefiVO flowVO = doc.getState().getFlowVO();
            FlowDiagram fd = flowVO.toFlowDiagram();
            Node currnode = (Node)fd.getElementByID(currNodeId);
            Collection nextNodeList = fd.getNextNodeList(currnode.id, (IDocument)doc, null, null);
            for (Node node : nextNodeList) {
                SimpleNode simpleNode = new SimpleNode();
                simpleNode.setId(node.id);
                simpleNode.setName(node.name);
                datas.add(simpleNode);
            }
        }
        return datas;
    }

    public String getNextNodeJSONByCurrNode(String currNodeId, String docId, String applicationId) throws Exception {
        Document doc = null;
        ArrayList<SimpleNode> datas = new ArrayList<SimpleNode>();
        try {
            DocumentProcess documentProcess = RunTimeServiceManager.documentProcess((String)applicationId);
            doc = (Document)documentProcess.doView(docId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (doc.getState() != null) {
            BillDefiVO flowVO = doc.getState().getFlowVO();
            FlowDiagram fd = flowVO.toFlowDiagram();
            Node currnode = (Node)fd.getElementByID(currNodeId);
            Collection nextNodeList = fd.getNextNodeList(currnode.id, (IDocument)doc, null, null);
            for (Node node : nextNodeList) {
                SimpleNode simpleNode = new SimpleNode();
                simpleNode.setId(node.id);
                simpleNode.setName(node.name);
                datas.add(simpleNode);
            }
        }
        return JsonUtil.collection2Json(datas);
    }

    public String getNextNodeJSON(String docId, String userId, String applicationId) throws Exception {
        WebUser user = null;
        Document doc = null;
        ArrayList<SimpleNode> datas = new ArrayList<SimpleNode>();
        try {
            DocumentProcess documentProcess = RunTimeServiceManager.documentProcess((String)applicationId);
            doc = (Document)documentProcess.doView(docId);
            user = WebUser.getWebUserInstance((String)userId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (doc.getState() != null) {
            BillDefiVO flowVO = doc.getState().getFlowVO();
            FlowDiagram fd = flowVO.toFlowDiagram();
            NodeRT nodert = StateMachine.getCurrUserNodeRT((IDocument)doc, (IUser)user);
            String currNodeId = nodert.getNodeid();
            Node currnode = (Node)fd.getElementByID(currNodeId);
            Collection nextNodeList = fd.getNextNodeList(currnode.id, (IDocument)doc, null, (IUser)user);
            for (Node node : nextNodeList) {
                SimpleNode simpleNode = new SimpleNode();
                simpleNode.setId(node.id);
                simpleNode.setName(node.name);
                datas.add(simpleNode);
            }
        }
        return JsonUtil.collection2Json(datas);
    }
}

