/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.webservice;

import cn.myapps.authtime.common.dao.PersistenceUtils;
import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.department.model.DepartmentVO;
import cn.myapps.authtime.department.service.DepartmentProcess;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.common.model.AuthtimeValueObject;
import cn.myapps.common.util.StringUtil;
import cn.myapps.util.json.JsonUtil;
import cn.myapps.util.xml.XmlUtil;
import cn.myapps.webservice.WebServiceUtil;
import cn.myapps.webservice.fault.DepartmentServiceFault;
import cn.myapps.webservice.model.SimpleDepartment;
import cn.myapps.webservice.util.DepartmentUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class DepartmentService {
    public int createDepartment(SimpleDepartment dep) throws DepartmentServiceFault {
        int result = -1;
        try {
            DepartmentProcess process = AuthTimeServiceManager.departmentRuntimeService();
            if (dep == null || StringUtil.isBlank((String)dep.getDomainName()) || StringUtil.isBlank((String)dep.getName())) {
                throw new NullPointerException("\u90e8\u95e8\u5bf9\u8c61\u4e3a\u7a7a\u6216\u90e8\u95e8\u7684domainName\u4e3a\u7a7a\u6216\u90e8\u95e8\u7684name\u4e3a\u7a7a.");
            }
            DomainVO domain = WebServiceUtil.validateDomain(dep.getDomainName());
            DepartmentVO vo = new DepartmentVO();
            DepartmentUtil.convert(vo, dep);
            DepartmentVO temp = (DepartmentVO)process.doViewByName(dep.getName(), domain.getId());
            if (temp != null && dep.getName().equalsIgnoreCase(temp.getName()) && vo.getSuperior().getId().equals(temp.getSuperior().getId())) {
                throw new Exception("\u8be5\u90e8\u95e8" + temp.getName() + "\u5df2\u7ecf\u5b58\u5728.");
            }
            process.doCreate((AuthtimeValueObject)vo);
            result = 0;
        }
        catch (Exception e) {
            throw new DepartmentServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new DepartmentServiceFault(e.getMessage());
            }
        }
        return result;
    }

    public int updateDepartment(SimpleDepartment dep) throws DepartmentServiceFault {
        int result = -1;
        try {
            DepartmentVO temp;
            DepartmentProcess process = AuthTimeServiceManager.departmentRuntimeService();
            if (dep == null || StringUtil.isBlank((String)dep.getId())) {
                throw new NullPointerException("\u90e8\u95e8\u5bf9\u8c61\u4e3a\u7a7a\u6216\u90e8\u95e8\u7684ID\u4e3a\u7a7a.");
            }
            DepartmentVO vo = (DepartmentVO)process.doView(dep.getId());
            if (vo == null) {
                throw new Exception("\u8be5\u90e8\u95e8" + dep.getId() + "\u4e0d\u5b58\u5728.");
            }
            if (dep.getDomainName() == null) {
                dep.setDomainName(vo.getDomain().getName());
            }
            DomainVO domain = WebServiceUtil.validateDomain(dep.getDomainName());
            if (!vo.getName().equals(dep.getName()) && (temp = (DepartmentVO)process.doViewByName(dep.getName(), domain.getId())) != null) {
                throw new Exception("\u8be5\u90e8\u95e8\u540d\u79f0" + temp.getName() + "\u5df2\u5b58\u5728\uff01");
            }
            boolean setDefSuperior = true;
            if (dep.getSuperiorName() == null && vo.getSuperior() == null) {
                setDefSuperior = false;
            }
            DepartmentUtil.convert(vo, dep);
            if (!setDefSuperior) {
                vo.setSuperior(null);
                vo.setLevel(0);
            }
            process.doUpdate((AuthtimeValueObject)vo);
            result = 0;
        }
        catch (Exception e) {
            throw new DepartmentServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new DepartmentServiceFault(e.getMessage());
            }
        }
        return result;
    }

    public SimpleDepartment getDepartment(String pk) throws DepartmentServiceFault {
        SimpleDepartment dep = null;
        try {
            DepartmentProcess process = AuthTimeServiceManager.departmentRuntimeService();
            if (StringUtil.isBlank((String)pk)) {
                throw new NullPointerException("\u4e3b\u952e\u4e3a\u7a7a.");
            }
            DepartmentVO vo = (DepartmentVO)process.doView(pk);
            if (vo != null) {
                dep = new SimpleDepartment();
                DepartmentUtil.convert(dep, vo);
            }
        }
        catch (Exception e) {
            throw new DepartmentServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new DepartmentServiceFault(e.getMessage());
            }
        }
        return dep;
    }

    public int deleteDepartment(String pk) throws DepartmentServiceFault {
        int result = -1;
        try {
            DepartmentProcess process = AuthTimeServiceManager.departmentRuntimeService();
            if (StringUtil.isBlank((String)pk)) {
                throw new NullPointerException("\u4e3b\u952e\u4e3a\u7a7a.");
            }
            process.doRemove(pk);
            result = 0;
        }
        catch (Exception e) {
            throw new DepartmentServiceFault(e.getMessage());
        }
        return result;
    }

    public int deleteDepartment(String[] pks) throws DepartmentServiceFault {
        int result = -1;
        try {
            if (pks != null) {
                for (int i = 0; i < pks.length; ++i) {
                    this.deleteDepartment(pks[i]);
                }
            }
            result = 0;
        }
        catch (Exception e) {
            throw new DepartmentServiceFault(e.getMessage());
        }
        return result;
    }

    public int upateSuperior(SimpleDepartment dep, SimpleDepartment superDep) throws DepartmentServiceFault {
        int result = -1;
        try {
            DepartmentProcess process = AuthTimeServiceManager.departmentRuntimeService();
            if (dep == null || StringUtil.isBlank((String)dep.getId()) || superDep == null || StringUtil.isBlank((String)superDep.getId())) {
                throw new NullPointerException("\u5bf9\u8c61\u4e3a\u7a7a\u6216\u5bf9\u8c61\u7684ID\u4e3a\u7a7a.");
            }
            DomainVO domain = WebServiceUtil.validateDomain(dep.getDomainName());
            DomainVO superiorDomain = WebServiceUtil.validateDomain(superDep.getDomainName());
            if (!domain.getId().equals(superiorDomain.getId())) {
                throw new Exception("\u4e24\u4e2a\u90e8\u95e8\u4e0d\u5728\u540c\u4e00\u4e2a\u57df.");
            }
            DepartmentVO vo = (DepartmentVO)process.doViewByName(dep.getName(), domain.getId());
            if (vo == null) {
                throw new Exception("\u5f53\u524d\u90e8\u95e8" + dep.getName() + "\u4e0d\u5b58\u5728.");
            }
            DepartmentVO sp = (DepartmentVO)process.doViewByName(superDep.getName(), superiorDomain.getId());
            if (sp == null) {
                throw new Exception("\u4e0a\u7ea7\u90e8\u95e8" + superDep.getName() + "\u4e0d\u5b58\u5728.");
            }
            vo.setSuperior(sp);
            vo.setLevel(sp.getLevel() + 1);
            PersistenceUtils.currentSession().clear();
            process.doUpdate((AuthtimeValueObject)vo);
            result = 0;
        }
        catch (Exception e) {
            throw new DepartmentServiceFault(e.getMessage());
        }
        return result;
    }

    public Collection<SimpleDepartment> getDepartmentsByDomainName(String domainName) throws DepartmentServiceFault {
        ArrayList<SimpleDepartment> cols = new ArrayList<SimpleDepartment>();
        try {
            DepartmentProcess process = AuthTimeServiceManager.departmentRuntimeService();
            DomainVO domain = WebServiceUtil.validateDomain(domainName);
            Collection vos = process.queryByDomain(domain.getId());
            Iterator it = vos.iterator();
            while (it.hasNext()) {
                SimpleDepartment dep = new SimpleDepartment();
                DepartmentUtil.convert(dep, (DepartmentVO)it.next());
                cols.add(dep);
            }
        }
        catch (Exception e) {
            throw new DepartmentServiceFault(e.getMessage());
        }
        finally {
            try {
                PersistenceUtils.closeSessionAndConnection();
            }
            catch (Exception e) {
                throw new DepartmentServiceFault(e.getMessage());
            }
        }
        return cols;
    }

    public int createDepartment(String id, String name, String code, String superiorName, String domainName) throws DepartmentServiceFault {
        int result = -1;
        try {
            SimpleDepartment dep = new SimpleDepartment();
            dep.setId(id);
            dep.setName(name);
            dep.setCode(code);
            dep.setSuperiorName(superiorName);
            dep.setDomainName(domainName);
            result = this.createDepartment(dep);
        }
        catch (Exception e) {
            throw new DepartmentServiceFault(e.getMessage());
        }
        return result;
    }

    public int updateDepartment(Map<String, String> attributes) throws DepartmentServiceFault {
        int result = -1;
        try {
            if (attributes == null) {
                throw new DepartmentServiceFault("\u90e8\u95e8Map\u4e0d\u80fd\u4e3a\u7a7a.");
            }
            SimpleDepartment dep = new SimpleDepartment();
            dep.setId(attributes.get("id"));
            dep.setName(attributes.get("name"));
            dep.setCode(attributes.get("code"));
            dep.setSuperiorName(attributes.get("superiorName"));
            dep.setDomainName(attributes.get("domainName"));
            result = this.updateDepartment(dep);
        }
        catch (Exception e) {
            throw new DepartmentServiceFault(e.getMessage());
        }
        return result;
    }

    public int createDepartmentFromJson(String jsonStr) throws DepartmentServiceFault {
        int result = -1;
        try {
            if (StringUtil.isBlank((String)jsonStr)) {
                throw new DepartmentServiceFault("Parameter 'jsonStr' can not be null.");
            }
            SimpleDepartment dep = (SimpleDepartment)JsonUtil.toBean((String)jsonStr, SimpleDepartment.class);
            result = this.createDepartment(dep);
        }
        catch (Exception e) {
            throw new DepartmentServiceFault(e.getMessage());
        }
        return result;
    }

    public int updateDepartmentFromJson(String jsonStr) throws DepartmentServiceFault {
        int result = -1;
        try {
            if (StringUtil.isBlank((String)jsonStr)) {
                throw new DepartmentServiceFault("Parameter 'jsonStr' can not be null.");
            }
            SimpleDepartment dep = (SimpleDepartment)JsonUtil.toBean((String)jsonStr, SimpleDepartment.class);
            result = this.updateDepartment(dep);
        }
        catch (Exception e) {
            throw new DepartmentServiceFault(e.getMessage());
        }
        return result;
    }

    public int createDepartmentFromXML(String xmlStr) throws DepartmentServiceFault {
        int result = -1;
        try {
            if (StringUtil.isBlank((String)xmlStr)) {
                throw new DepartmentServiceFault("Parameter 'xmlStr' can not be null.");
            }
            SimpleDepartment dep = (SimpleDepartment)XmlUtil.toOjbect((String)xmlStr);
            result = this.createDepartment(dep);
        }
        catch (Exception e) {
            throw new DepartmentServiceFault(e.getMessage());
        }
        return result;
    }

    public int updateDepartmentFromXML(String xmlStr) throws DepartmentServiceFault {
        int result = -1;
        try {
            if (StringUtil.isBlank((String)xmlStr)) {
                throw new DepartmentServiceFault("Parameter 'xmlStr' can not be null.");
            }
            SimpleDepartment dep = (SimpleDepartment)XmlUtil.toOjbect((String)xmlStr);
            result = this.updateDepartment(dep);
        }
        catch (Exception e) {
            throw new DepartmentServiceFault(e.getMessage());
        }
        return result;
    }

    public String findDepartmentFormat2Json(String pk) throws DepartmentServiceFault {
        SimpleDepartment dep = this.getDepartment(pk);
        return JsonUtil.toJson((Object)dep);
    }

    public String findDepartmentFormat2XML(String pk) throws DepartmentServiceFault {
        SimpleDepartment dep = this.getDepartment(pk);
        return XmlUtil.toXml((Object)dep);
    }

    public String getDepartmentsByDomainNameFormat2Json(String domainName) throws DepartmentServiceFault {
        Collection<SimpleDepartment> cols = this.getDepartmentsByDomainName(domainName);
        return JsonUtil.collection2Json(cols);
    }

    public String getDepartmentsByDomainNameFormat2XML(String domainName) throws DepartmentServiceFault {
        Collection<SimpleDepartment> cols = this.getDepartmentsByDomainName(domainName);
        return XmlUtil.toXml(cols);
    }
}

