/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.webservice;

import cn.myapps.authtime.common.service.AuthTimeServiceManager;
import cn.myapps.authtime.domain.model.DomainVO;
import cn.myapps.authtime.domain.service.DomainProcess;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.AuthtimeValueObject;
import cn.myapps.common.model.application.Application;
import cn.myapps.common.model.superuser.SuperUserVO;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.application.service.ApplicationDesignTimeService;
import cn.myapps.designtime.common.service.DesignTimeServiceManager;
import cn.myapps.designtime.superuser.service.SuperUserDesignTimeService;
import cn.myapps.util.json.JsonUtil;
import cn.myapps.webservice.fault.ApplicationServiceFault;
import cn.myapps.webservice.model.SimpleApplication;
import cn.myapps.webservice.util.ApplicationUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ApplicationService {
    public Collection<SimpleApplication> searchApplicationsByName(String name) throws ApplicationServiceFault {
        try {
            ApplicationDesignTimeService applicationProcess = DesignTimeServiceManager.applicationDesignTimeService();
            ParamsTable params = new ParamsTable();
            params.setParameter("t_name", (Object)name);
            List appList = applicationProcess.list(null, name);
            if (appList != null && !appList.isEmpty()) {
                return ApplicationUtil.convertToSimple(appList);
            }
        }
        catch (Exception e) {
            throw new ApplicationServiceFault(e.getMessage());
        }
        return new ArrayList<SimpleApplication>();
    }

    public SimpleApplication searchApplicationByName(String name) throws ApplicationServiceFault {
        try {
            ApplicationDesignTimeService applicationProcess = DesignTimeServiceManager.applicationDesignTimeService();
            List apps = applicationProcess.list(null, name);
            if (!apps.isEmpty()) {
                return ApplicationUtil.convertToSimple((Application)apps.get(0));
            }
        }
        catch (Exception e) {
            throw new ApplicationServiceFault(e.getMessage());
        }
        return null;
    }

    public Collection<SimpleApplication> searchApplicationsByFilter(Map<String, Object> parameters) throws ApplicationServiceFault {
        try {
            ApplicationDesignTimeService applicationProcess = DesignTimeServiceManager.applicationDesignTimeService();
            ParamsTable params = new ParamsTable();
            params.putAll(parameters);
            DataPackage appPackage = applicationProcess.query(null, null, 1, Integer.MAX_VALUE);
            if (appPackage != null && appPackage.datas != null && !appPackage.datas.isEmpty()) {
                return ApplicationUtil.convertToSimple(appPackage.datas);
            }
        }
        catch (Exception e) {
            throw new ApplicationServiceFault(e.getMessage());
        }
        return new ArrayList<SimpleApplication>();
    }

    public Collection<SimpleApplication> searchApplicationsByFilter(String parameters) throws ApplicationServiceFault {
        try {
            Map<String, Object> params = new HashMap<String, Object>();
            if (!StringUtil.isBlank((String)parameters)) {
                params = JsonUtil.toMap((String)parameters);
            }
            return this.searchApplicationsByFilter(params);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ApplicationServiceFault(e.getMessage());
        }
    }

    public Collection<SimpleApplication> searchApplicationsByDomainAdmin(String domainAdminId) throws ApplicationServiceFault {
        try {
            Collection appList = null;
            if (appList != null && !appList.isEmpty()) {
                return ApplicationUtil.convertToSimple(appList);
            }
        }
        catch (Exception e) {
            throw new ApplicationServiceFault(e.getMessage());
        }
        return new ArrayList<SimpleApplication>();
    }

    public Collection<SimpleApplication> searchApplicationsByDeveloper(String developerId) throws ApplicationServiceFault {
        try {
            Collection appList = null;
            if (appList != null && !appList.isEmpty()) {
                return ApplicationUtil.convertToSimple(appList);
            }
        }
        catch (Exception e) {
            throw new ApplicationServiceFault(e.getMessage());
        }
        return new ArrayList<SimpleApplication>();
    }

    public boolean addApplication(String userAccount, String domainName, String applicationId) throws ApplicationServiceFault {
        boolean isVaild = false;
        try {
            DomainVO domain;
            SuperUserDesignTimeService sUserProcess = DesignTimeServiceManager.superUserDesignTimeService();
            ApplicationDesignTimeService applicationProcess = DesignTimeServiceManager.applicationDesignTimeService();
            DomainProcess domainProcess = AuthTimeServiceManager.domainRuntimeService();
            SuperUserVO superUser = sUserProcess.getSuperUserByLoginno(userAccount);
            if (superUser != null && (domain = superUser.getDomainByName(domainName)) != null) {
                Application application = (Application)applicationProcess.findById(applicationId);
                HashSet<Application> appSet = new HashSet<Application>();
                appSet.add(application);
                domainProcess.doUpdate((AuthtimeValueObject)domain);
                isVaild = true;
            }
        }
        catch (Exception e) {
            throw new ApplicationServiceFault(e.getMessage());
        }
        return isVaild;
    }

    public static void main(String[] args) throws ApplicationServiceFault {
        ApplicationService service = new ApplicationService();
        HashMap<String, Object> params = new HashMap<String, Object>();
        Collection<SimpleApplication> appList = service.searchApplicationsByFilter(params);
        Iterator<SimpleApplication> iterator = appList.iterator();
        while (iterator.hasNext()) {
        }
    }
}

