/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.util.serial.number;

import cn.myapps.common.util.SpringApplicationContextUtil;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.support.atomic.RedisAtomicLong;

public class GenerateSerialNumber {
    StringRedisTemplate redisTemplate = (StringRedisTemplate)SpringApplicationContextUtil.getBean(StringRedisTemplate.class);

    public String getSerialNumber(String ywlx) {
        if (!"bapx".equals(ywlx) && !"bapxjyz".equals(ywlx)) {
            return null;
        }
        long sequence = this.incr(ywlx);
        String seq = GenerateSerialNumber.getSequence(sequence, 6);
        return seq;
    }

    public String getSerialNumberByPrefix(String headText, Boolean isYear, Boolean isMonth, Boolean isDay, int digit) {
        StringBuilder keyBuilder = new StringBuilder(headText);
        if (isYear.booleanValue()) {
            keyBuilder.append(new SimpleDateFormat("yyyy").format(new Date()));
        }
        if (isMonth.booleanValue()) {
            keyBuilder.append(new SimpleDateFormat("MM").format(new Date()));
        }
        if (isDay.booleanValue()) {
            keyBuilder.append(new SimpleDateFormat("dd").format(new Date()));
        }
        String redisKey = keyBuilder.toString();
        long serialNumber = this.redisTemplate.opsForValue().increment((Object)redisKey, 1L);
        String formattedSerialNumber = String.format("%0" + digit + "d", serialNumber);
        return redisKey + formattedSerialNumber;
    }

    public long incr(String redisKey) {
        RedisAtomicLong redisAtomicLong = new RedisAtomicLong(redisKey, this.redisTemplate.getConnectionFactory());
        return redisAtomicLong.getAndIncrement();
    }

    public static String getSequence(long seq, int length) {
        StringBuilder sb = new StringBuilder();
        Calendar date = Calendar.getInstance();
        String year = String.valueOf(date.get(1));
        sb.append(year);
        String str = String.valueOf(seq);
        int len = str.length();
        if (len >= length) {
            return sb.append(str).toString();
        }
        int rest = length - len;
        for (int i = 0; i < rest; ++i) {
            sb.append('0');
        }
        sb.append(str);
        return sb.toString();
    }
}

