/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.util.cache;

import cn.myapps.base.web.WebUser;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.common.util.SpringApplicationContextUtil;
import cn.myapps.common.util.cache.ICacheProvider;
import cn.myapps.common.util.cache.IMyCache;
import cn.myapps.common.util.cache.IMyElement;
import cn.myapps.common.util.cache.MethodCacheCleaner;
import cn.myapps.common.util.cache.MyCacheManager;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.data.redis.core.StringRedisTemplate;

public class RedisProvider
implements ICacheProvider {
    CacheManager manager = null;
    StringRedisTemplate redisTemplate;
    HashMap<String, MethodCacheCleaner> clearedNames = new HashMap();

    public RedisProvider() {
        this.manager = (CacheManager)SpringApplicationContextUtil.getBean(CacheManager.class);
        this.redisTemplate = (StringRedisTemplate)SpringApplicationContextUtil.getBean(StringRedisTemplate.class);
    }

    public IMyCache createCache(String name, int maxElementsInMemory, boolean overflowToDisk, boolean eternal, long timeToLiveSeconds, long timeToIdleSeconds) {
        Cache cache = this.manager.getCache(name);
        MyCache mycache = new MyCache(cache);
        return mycache;
    }

    public IMyCache getDefaultCache() {
        return this.getCache("DEFAULT_CACHE");
    }

    public IMyCache getCache(String name) {
        Cache c = this.manager.getCache(name);
        if (c != null) {
            MyCache mycache = new MyCache(c);
            return mycache;
        }
        return null;
    }

    public void clearCache(String name) {
        Cache cache = this.manager.getCache(name);
        if (cache != null) {
            cache.clear();
        }
    }

    public String[] getCacheNames() {
        Collection names = this.manager.getCacheNames();
        String[] rtns = new String[names.size()];
        int i = 0;
        Iterator iterator = names.iterator();
        while (iterator.hasNext()) {
            String name;
            rtns[i] = name = (String)iterator.next();
            ++i;
        }
        return rtns;
    }

    public String[] getClearedNames() {
        return this.clearedNames.keySet().toArray(new String[this.clearedNames.keySet().size()]);
    }

    public void clearAll() {
        String[] cacheNames = this.getCacheNames();
        for (int i = 0; i < cacheNames.length; ++i) {
            String name = cacheNames[i];
            this.clearCache(cacheNames[i]);
        }
    }

    public void remove(String key) {
        this.redisTemplate.delete((Object)key);
    }

    public Set getKeys(String cacheName) {
        Set keys = this.redisTemplate.keys((Object)(cacheName + "*"));
        return keys;
    }

    public boolean clearByCacheName(String cacheName) {
        MethodCacheCleaner cleaner = this.clearedNames.get(cacheName);
        if (cleaner != null && cleaner.isClearAll()) {
            this.clearAll();
            return true;
        }
        return false;
    }

    public void setClearedNames(HashMap<String, MethodCacheCleaner> clearedNames) {
        this.clearedNames = clearedNames;
    }

    static class MyElement
    implements IMyElement {
        Object key;
        Object value;

        MyElement(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        public Object getKey() {
            return this.key;
        }
    }

    static class MyCache
    implements IMyCache {
        private static final Logger logger = LoggerFactory.getLogger(MyCache.class);
        private static final boolean IS_NETWORK = PropertyUtil.IsNetworkEnvironment();
        private static final int EXPIRED_IN_SECONDS = 600;
        private static final CopyOnWriteArrayList<Object> _removedKeys = new CopyOnWriteArrayList();
        private static final com.github.benmanes.caffeine.cache.Cache<Object, Object> _caffineLocalCache;
        private static ICacheProvider cacheProvider;
        Cache cache;

        MyCache(Cache cache) {
            this.cache = cache;
        }

        public IMyElement get(Object key) {
            if (key == null) {
                return null;
            }
            try {
                Object value = _caffineLocalCache.getIfPresent(key);
                if (value == null) {
                    Cache.ValueWrapper element = this.cache.get(key);
                    if (element == null) {
                        return null;
                    }
                    if (element.get() instanceof WebUser) {
                        _caffineLocalCache.put(key, element.get());
                    }
                    return new MyElement(key, element.get());
                }
                return new MyElement(key, value);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }

        public void put(IMyElement element) {
            block3: {
                if (element.getValue() instanceof WebUser) {
                    try {
                        _caffineLocalCache.put(element.getKey(), element.getValue());
                    }
                    catch (Exception ex) {
                        if (element.getKey() == null) break block3;
                        _caffineLocalCache.invalidate(element.getKey());
                    }
                }
            }
            this.cache.put(element.getKey(), element.getValue());
        }

        public void put(Object key, Object value) {
            MyElement element = new MyElement(key, value);
            this.put(element);
        }

        public void remove(Object key) {
            _caffineLocalCache.invalidate(key);
            this.cache.evict(key);
        }

        public void clear() {
            _caffineLocalCache.invalidateAll();
            this.cache.clear();
        }

        static {
            if (!IS_NETWORK) {
                _caffineLocalCache = Caffeine.newBuilder().maximumSize(2000L).expireAfterWrite(600L, TimeUnit.SECONDS).evictionListener((key, value, cause) -> {
                    if (value instanceof WebUser) {
                        _removedKeys.add(key);
                    }
                }).softValues().build();
                cacheProvider = MyCacheManager.getProviderInstance((String)"cn.myapps.util.cache.RedisProvider");
            } else {
                _caffineLocalCache = Caffeine.newBuilder().maximumSize(2000L).softValues().build();
            }
            Executors.newScheduledThreadPool(1).scheduleAtFixedRate(() -> {
                IMyCache iMyCache;
                Object[] keys = _removedKeys.toArray();
                if (keys != null && (iMyCache = cacheProvider.getCache("WEBUSER")) != null) {
                    for (int index = 0; index < keys.length; ++index) {
                        Object selectedKey = keys[index];
                        try {
                            if (selectedKey == null) continue;
                            iMyCache.remove(selectedKey);
                            _removedKeys.remove(selectedKey);
                            continue;
                        }
                        catch (Exception ex) {
                            logger.error("\u5b9a\u65f6\u6e05\u9664\u6570\u636e:{}", selectedKey);
                        }
                    }
                }
            }, 1L, 600L, TimeUnit.SECONDS);
        }
    }
}

